/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui.tools;

import com.cisco.dcbu.lib.ui.Util;
import java.awt.Component;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;

class IntegerRangerVerifier
extends InputVerifier {
    Integer _maxValue = 100;
    Integer _minValue = 0;
    Component _parent;

    public IntegerRangerVerifier(Component parent, int min, int max) {
        this._parent = parent;
        this._maxValue = new Integer(max);
        this._minValue = new Integer(min);
    }

    @Override
    public boolean verify(JComponent input) {
        JTextField tf = (JTextField)input;
        String text = tf.getText();
        try {
            if (text.trim().length() == 0) {
                return true;
            }
            Integer intValue = Integer.parseInt(text);
            if (intValue <= this._maxValue) {
                if (intValue >= this._minValue) {
                    return true;
                }
                Util.errorMessage(this._parent, "Minimum value allowed is " + this._minValue);
            } else {
                Util.errorMessage(this._parent, "Maximum value allowed is " + this._maxValue);
            }
        }
        catch (NumberFormatException ne) {
            Util.errorMessage(this._parent, "Value must be a number between " + this._minValue + " and " + this._maxValue);
        }
        return false;
    }
}

