/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.gui.tools;

import org.apache.log4j.Logger;

public class LoadBalancing {
    public static final int MAX_PHY_PER_PCM = 16;
    public static final int MAX_FSPF_LINKS = 16;
    public static final int VEGAS_1 = 0;
    public static final int ISOLA_MODE_0 = 0;
    public static final int ISOLA_MODE_1 = 1;
    public static final int ISOLA_MODE_2 = 2;
    public static final int ISOLA_MODE_3 = 3;
    public static final int ISOLA_MODE_4 = 4;
    private static final Logger _Logger = Logger.getLogger(LoadBalancing.class);
    private int[] _linkFlowCount;
    private int[] _bundleMembers;

    private int fcidDomainGet(int fcid) {
        return fcid >> 16 & 0xFF;
    }

    private int fcidAreaGet(int fcid) {
        return fcid >> 8 & 0xFF;
    }

    private int fcidPortGet(int fcid) {
        return fcid & 0xFF;
    }

    private int fcidGetBits(int id) {
        return (this.fcidDomainGet(id) << 16) + (this.fcidAreaGet(id) << 8) + this.fcidPortGet(id);
    }

    private int getBit(long x, int n) {
        return (int)(x >> n & 1L);
    }

    private int getBit(int x, int n) {
        return x >> n & 1;
    }

    private int cumul(int[] a, int n) {
        int s = 0;
        for (int i = 0; i < n; ++i) {
            s += a[i] & 0xFF;
        }
        return s;
    }

    private void dataAllocAndInit(int num_physical_links) {
        this._linkFlowCount = new int[num_physical_links];
        this._bundleMembers = new int[num_physical_links];
        for (int i = 0; i < num_physical_links; ++i) {
            this._linkFlowCount[i] = 0;
            this._bundleMembers[i] = 0;
        }
    }

    private void initLinkFlowCnt(int num_physical_links) {
        for (int i = 0; i < num_physical_links; ++i) {
            this._linkFlowCount[i] = 0;
        }
    }

    private int hashFunc0(long indata) {
        int result = 255;
        int next_result = 0;
        for (int i = 39; i >= 0; --i) {
            int bit = this.getBit(indata, i) ^ this.getBit(result, 1) ^ this.getBit(result, 2) ^ this.getBit(result, 3) ^ this.getBit(result, 7);
            result = next_result = (result << 1) + bit;
        }
        return result & 0xFF;
    }

    private int lxrHashAdj(int sid, int did, int oxid, int mod) {
        _Logger.debug((Object)("lxrHashAdj:  sid=" + sid + ", did=" + did + oxid + ", mod=" + mod));
        long ox_id = oxid;
        long x = (long)((sid ^ did) & 0xFFFFFF) | ox_id << 24 & 0xFFFFFFFFFFL;
        int hash = this.hashFunc0(x);
        int modHash = hash % mod & 0xFF;
        _Logger.debug((Object)("lxrHashAdj:  hash=" + hash));
        _Logger.debug((Object)("lxrlaHashAdj:  hash%mod=" + modHash));
        return modHash;
    }

    private int hashFunc1(long indata) {
        int result = 511;
        int next_result = 0;
        for (int i = 39; i >= 0; --i) {
            int bit = this.getBit(indata, i) ^ this.getBit(result, 3) ^ this.getBit(result, 8);
            result = next_result = ((result & 0xFF) << 1) + bit;
        }
        return result & 0xFF;
    }

    private int isolaHashFunc1(long indata) {
        int next_result = 0;
        int result = 255;
        for (int i = 63; i >= 0; --i) {
            int bit = this.getBit(indata, i) ^ this.getBit(result, 1) ^ this.getBit(result, 4) ^ this.getBit(result, 5) ^ this.getBit(result, 7);
            result = next_result = (result << 1) + bit;
        }
        return result & 0xFF;
    }

    private int lxrHashBundle(int sid, int did, int oxid, int mod) {
        _Logger.debug((Object)("lxrHashBundle:  sid=" + sid + ", did=" + did + oxid + ", mod=" + mod));
        long ox_id = oxid;
        long x = (long)((sid ^ did) & 0xFFFFFF) | ox_id << 24 & 0xFFFFFFFFFFL;
        int hash = this.hashFunc1(x);
        int modHash = hash % mod & 0xFF;
        _Logger.debug((Object)("lxrHashBundle:  hash=" + hash));
        _Logger.debug((Object)("lxrlaHashBundle:  hash%mod=" + modHash));
        return modHash;
    }

    public int isola_vegas1_hash_func0_80key(int indata1, long indata2) {
        int j;
        int i;
        int[] data_in = new int[80];
        int[] data_in_swap = new int[80];
        int[] data = new int[80];
        int[] CRC2 = new int[8];
        int[] state = new int[8];
        _Logger.debug((Object)("isola_vegas1_hash_func0_80key:  indata1=" + indata1 + ", indata2=" + indata2));
        for (i = 0; i < 64; ++i) {
            data_in[i] = this.getBit(indata2, i);
        }
        for (i = 64; i < 80; ++i) {
            data_in[i] = this.getBit(indata1, i - 64);
        }
        for (i = 0; i < 8; ++i) {
            state[i] = 0;
            CRC2[i] = 0;
        }
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 8; ++j) {
                data_in_swap[i * 8 + j] = data_in[i * 8 + 7 - j];
            }
        }
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 8; ++j) {
                data[8 * (9 - i) + (7 - j)] = data_in_swap[8 * i + (7 - j)];
            }
        }
        CRC2[0] = state[7] ^ data[0] ^ (data[51] ^ state[6]) ^ (data[1] ^ data[62] ^ (data[44] ^ data[41])) ^ (data[27] ^ data[69] ^ (state[4] ^ data[3]) ^ (data[40] ^ data[37] ^ (data[23] ^ data[19]))) ^ (data[15] ^ data[75] ^ (data[79] ^ (state[3] ^ data[4])) ^ (data[55] ^ state[2] ^ (data[5] ^ data[66]) ^ (data[54] ^ data[29] ^ (data[48] ^ data[42]))) ^ (state[1] ^ data[6] ^ (data[12] ^ data[45]) ^ (data[63] ^ data[31] ^ (data[73] ^ data[24])) ^ (state[0] ^ data[7] ^ (data[26] ^ data[21]) ^ (data[13] ^ data[64] ^ (data[18] ^ data[74])))));
        CRC2[1] = data[12] ^ data[63] ^ (data[17] ^ data[73]) ^ (data[50] ^ state[7] ^ (data[0] ^ data[61])) ^ (data[43] ^ data[40] ^ (data[26] ^ data[68]) ^ (state[5] ^ data[2] ^ (data[39] ^ data[36]))) ^ (data[22] ^ data[18] ^ (data[14] ^ data[74]) ^ (data[78] ^ (state[4] ^ data[3]) ^ (data[54] ^ state[3] ^ (data[4] ^ data[65]))) ^ (data[53] ^ data[28] ^ (data[47] ^ data[41]) ^ (state[2] ^ data[5] ^ (data[11] ^ data[44])) ^ (data[62] ^ data[30] ^ (data[72] ^ data[23]) ^ (state[1] ^ data[6] ^ (data[25] ^ data[20])))));
        CRC2[2] = state[0] ^ data[7] ^ (data[26] ^ data[18]) ^ (data[74] ^ state[7] ^ (data[0] ^ data[51])) ^ (data[44] ^ data[41] ^ (data[69] ^ data[37]) ^ (data[23] ^ data[15] ^ (data[75] ^ data[79]))) ^ (state[5] ^ data[2] ^ (data[53] ^ data[52]) ^ (data[46] ^ data[10] ^ (data[43] ^ data[61])) ^ (data[71] ^ data[22] ^ (data[11] ^ data[16]) ^ (data[72] ^ data[49] ^ (data[60] ^ data[39]))) ^ (data[25] ^ data[67] ^ (data[38] ^ data[35]) ^ (data[17] ^ data[77] ^ (data[55] ^ data[66])) ^ (data[54] ^ data[48] ^ (state[1] ^ data[6]) ^ (data[12] ^ data[45] ^ (data[63] ^ data[31])))));
        CRC2[3] = data[26] ^ data[13] ^ (data[64] ^ data[18]) ^ (state[7] ^ data[0] ^ (data[41] ^ data[27])) ^ (data[69] ^ state[4] ^ (data[3] ^ data[23]) ^ (data[19] ^ data[75] ^ (data[79] ^ (data[52] ^ data[9])))) ^ (data[60] ^ data[70] ^ (data[10] ^ data[71]) ^ (data[59] ^ data[38] ^ (data[34] ^ data[16])) ^ (data[76] ^ data[65] ^ (data[53] ^ data[47]) ^ (data[11] ^ data[30] ^ (data[25] ^ data[17]))) ^ (data[50] ^ data[43] ^ (data[68] ^ data[36]) ^ (data[22] ^ data[14] ^ (data[78] ^ state[3])) ^ (data[4] ^ data[55] ^ (data[29] ^ data[12]) ^ (data[63] ^ data[31] ^ (state[0] ^ data[7])))));
        CRC2[4] = data[5] ^ data[66] ^ (data[48] ^ data[45]) ^ (data[31] ^ data[73] ^ (state[0] ^ data[7])) ^ (state[7] ^ data[0] ^ (state[6] ^ data[1]) ^ (data[44] ^ data[41] ^ (data[27] ^ data[23]))) ^ (data[19] ^ data[79] ^ (data[8] ^ data[59] ^ (data[9] ^ data[70])) ^ (data[58] ^ data[33] ^ (data[52] ^ data[46]) ^ (data[10] ^ data[16] ^ (data[49] ^ data[67]))) ^ (data[35] ^ data[77] ^ (data[28] ^ data[11]) ^ (data[30] ^ data[25] ^ (data[17] ^ data[68])) ^ (state[5] ^ data[2] ^ (data[22] ^ data[78]) ^ (state[3] ^ data[4] ^ (data[55] ^ state[2])))));
        CRC2[5] = data[3] ^ data[54] ^ (state[3] ^ data[4]) ^ (data[65] ^ data[47] ^ (data[44] ^ data[30])) ^ (data[72] ^ state[1] ^ (data[6] ^ state[7]) ^ (data[0] ^ data[43] ^ (data[40] ^ data[26]))) ^ (data[22] ^ data[18] ^ (data[78] ^ (state[0] ^ data[7])) ^ (data[58] ^ data[8] ^ (data[69] ^ data[57]) ^ (data[32] ^ data[51] ^ (data[45] ^ data[9]))) ^ (data[15] ^ data[48] ^ (data[66] ^ data[34]) ^ (data[76] ^ data[27] ^ (data[10] ^ data[29])) ^ (data[24] ^ data[16] ^ (data[67] ^ state[6]) ^ (data[1] ^ data[21] ^ (data[77] ^ state[4])))));
        CRC2[6] = data[20] ^ data[76] ^ (state[5] ^ data[2]) ^ (data[53] ^ state[4] ^ (data[3] ^ data[64])) ^ (data[46] ^ data[43] ^ (data[29] ^ data[71]) ^ (state[2] ^ data[5] ^ (data[42] ^ data[39]))) ^ (data[25] ^ data[21] ^ (data[17] ^ data[77]) ^ (state[1] ^ data[6] ^ (data[57] ^ state[0]) ^ (data[7] ^ data[68] ^ (data[56] ^ data[31]))) ^ (data[50] ^ data[44] ^ (data[8] ^ data[14]) ^ (data[47] ^ data[65] ^ (data[33] ^ data[75])) ^ (data[26] ^ data[9] ^ (data[28] ^ data[23]) ^ (data[15] ^ data[66] ^ (state[7] ^ data[0])))));
        CRC2[7] = data[65] ^ data[19] ^ (data[75] ^ state[6]) ^ (data[1] ^ data[52] ^ (state[5] ^ data[2])) ^ (data[63] ^ data[45] ^ (data[42] ^ data[28]) ^ (data[70] ^ state[3] ^ (data[4] ^ data[41]))) ^ (data[38] ^ data[24] ^ (data[20] ^ data[16]) ^ (data[76] ^ (state[2] ^ data[5]) ^ (data[56] ^ state[1] ^ (data[6] ^ data[67]))) ^ (data[55] ^ data[30] ^ (data[49] ^ data[43]) ^ (state[0] ^ data[7] ^ (data[13] ^ data[46])) ^ (data[64] ^ data[32] ^ (data[74] ^ data[25]) ^ (data[8] ^ data[27] ^ (data[22] ^ data[14])))));
        int result = 0;
        result = CRC2[7] << 7 | CRC2[6] << 6 | CRC2[5] << 5 | CRC2[4] << 4 | CRC2[3] << 3 | CRC2[2] << 2 | CRC2[1] << 1 | CRC2[0];
        _Logger.debug((Object)("isola_vegas1_hash_func0_80key: result =" + (result &= 0xFF)));
        return result;
    }

    public int isola_hash_func1_80key(int indata1, long indata2) {
        int j;
        int i;
        int[] data_in = new int[80];
        int[] data_in_swap = new int[80];
        int[] data = new int[80];
        int[] CRC2 = new int[8];
        int[] state = new int[8];
        _Logger.debug((Object)("isola_hash_func1_80key:  indata1=" + indata1 + ", indata2=" + indata2));
        for (i = 0; i < 64; ++i) {
            data_in[i] = this.getBit(indata2, i);
        }
        for (i = 64; i < 80; ++i) {
            data_in[i] = this.getBit(indata1, i - 64);
        }
        for (i = 0; i < 8; ++i) {
            state[i] = 0;
            CRC2[i] = 0;
        }
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 8; ++j) {
                data_in_swap[i * 8 + j] = data_in[i * 8 + 7 - j];
            }
        }
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 8; ++j) {
                data[8 * (9 - i) + (7 - j)] = data_in_swap[8 * i + (7 - j)];
            }
        }
        CRC2[0] = data[40] ^ data[38] ^ (data[36] ^ data[34]) ^ (data[32] ^ data[71] ^ (data[73] ^ data[75])) ^ (data[77] ^ data[79] ^ (state[2] ^ data[5] ^ (data[25] ^ data[12])) ^ (data[63] ^ state[1] ^ (data[6] ^ data[16]) ^ (data[22] ^ data[13] ^ (data[43] ^ data[64])))) ^ (data[51] ^ data[26] ^ (state[6] ^ data[1]) ^ (data[17] ^ data[46] ^ (data[67] ^ data[54])) ^ (data[33] ^ data[29] ^ (data[72] ^ data[76]) ^ (data[23] ^ data[10] ^ (data[61] ^ state[3]))) ^ (data[4] ^ data[20] ^ (data[62] ^ data[49]) ^ (data[44] ^ data[52] ^ (data[70] ^ data[59])) ^ (state[5] ^ data[2] ^ (data[60] ^ data[47]) ^ (data[42] ^ data[68] ^ (data[57] ^ data[58])))));
        CRC2[1] = data[39] ^ data[37] ^ (data[35] ^ data[33]) ^ (data[31] ^ data[70] ^ (data[72] ^ data[74])) ^ (data[76] ^ data[78] ^ (state[3] ^ data[4] ^ (data[24] ^ data[11])) ^ (data[62] ^ state[2] ^ (data[5] ^ data[15]) ^ (data[21] ^ data[12] ^ (data[42] ^ data[63])))) ^ (data[50] ^ data[25] ^ (state[7] ^ data[0]) ^ (data[16] ^ data[45] ^ (data[66] ^ data[53])) ^ (data[32] ^ data[28] ^ (data[71] ^ data[75]) ^ (data[22] ^ data[9] ^ (data[60] ^ state[4]))) ^ (data[3] ^ data[19] ^ (data[61] ^ data[48]) ^ (data[43] ^ data[51] ^ (data[69] ^ data[58])) ^ (state[6] ^ data[1] ^ (data[59] ^ data[46]) ^ (data[41] ^ data[67] ^ (data[56] ^ data[57])))));
        CRC2[2] = data[13] ^ data[43] ^ (data[64] ^ data[51]) ^ (data[26] ^ state[6] ^ (data[1] ^ data[17])) ^ (data[46] ^ data[67] ^ (data[54] ^ data[33]) ^ (data[29] ^ data[72] ^ (data[76] ^ data[79]))) ^ (state[4] ^ data[3] ^ (data[14] ^ data[11]) ^ (data[41] ^ data[24] ^ (data[15] ^ data[65])) ^ (data[31] ^ data[27] ^ (data[74] ^ data[21]) ^ (data[8] ^ data[18] ^ (data[50] ^ state[7]))) ^ (data[0] ^ data[45] ^ (data[66] ^ data[55]) ^ (data[56] ^ data[30] ^ (data[69] ^ state[2])) ^ (data[5] ^ data[25] ^ (data[12] ^ data[63]) ^ (state[1] ^ data[6] ^ (data[16] ^ data[22])))));
        CRC2[3] = data[21] ^ data[12] ^ (data[42] ^ data[63]) ^ (data[50] ^ data[25] ^ (state[7] ^ data[0])) ^ (data[16] ^ data[45] ^ (data[66] ^ data[53]) ^ (data[32] ^ data[28] ^ (data[71] ^ data[75]))) ^ (data[78] ^ (state[5] ^ data[2]) ^ (data[13] ^ data[10] ^ (data[40] ^ data[23])) ^ (data[14] ^ data[64] ^ (data[30] ^ data[26]) ^ (data[73] ^ data[20] ^ (state[0] ^ data[7]))) ^ (data[17] ^ data[49] ^ (data[44] ^ data[65]) ^ (data[54] ^ data[55] ^ (data[29] ^ data[68])) ^ (state[3] ^ data[4] ^ (data[24] ^ data[11]) ^ (data[62] ^ state[2] ^ (data[5] ^ data[15])))));
        CRC2[4] = data[61] ^ state[3] ^ (data[4] ^ data[14]) ^ (data[20] ^ data[11] ^ (data[41] ^ data[62])) ^ (data[49] ^ data[24] ^ (data[15] ^ data[44]) ^ (data[65] ^ data[52] ^ (data[31] ^ data[27]))) ^ (data[70] ^ data[74] ^ (data[77] ^ (state[6] ^ data[1])) ^ (data[12] ^ data[9] ^ (data[39] ^ data[22]) ^ (data[13] ^ data[63] ^ (data[29] ^ data[25]))) ^ (data[72] ^ data[19] ^ (state[1] ^ data[6]) ^ (data[16] ^ data[48] ^ (data[43] ^ data[64])) ^ (data[53] ^ data[54] ^ (data[28] ^ data[67]) ^ (state[4] ^ data[3] ^ (data[23] ^ data[10])))));
        CRC2[5] = data[4] ^ data[20] ^ (data[49] ^ data[44]) ^ (data[70] ^ data[59] ^ (data[68] ^ data[57])) ^ (data[58] ^ data[36] ^ (data[34] ^ data[32]) ^ (data[75] ^ data[77] ^ (data[79] ^ (state[7] ^ data[0])))) ^ (data[11] ^ data[8] ^ (data[21] ^ data[28]) ^ (data[24] ^ data[18] ^ (data[15] ^ data[53])) ^ (data[27] ^ data[66] ^ (data[9] ^ state[4]) ^ (data[3] ^ data[19] ^ (data[48] ^ data[14]))) ^ (data[30] ^ data[69] ^ (data[25] ^ state[1]) ^ (data[6] ^ data[16] ^ (state[6] ^ data[1])) ^ (data[17] ^ data[46] ^ (data[67] ^ data[54]) ^ (data[33] ^ data[29] ^ (data[72] ^ state[3])))));
        CRC2[6] = data[40] ^ data[38] ^ (data[36] ^ data[34]) ^ (data[73] ^ data[75] ^ (data[77] ^ data[79])) ^ (state[0] ^ data[7] ^ (data[27] ^ data[14]) ^ (data[65] ^ data[8] ^ (data[18] ^ data[24])) ^ (data[15] ^ state[7] ^ (data[0] ^ data[45]) ^ (data[66] ^ data[53] ^ (data[28] ^ state[4])))) ^ (data[3] ^ data[19] ^ (data[48] ^ data[69]) ^ (data[56] ^ data[35] ^ (data[31] ^ data[74])) ^ (data[78] ^ data[25] ^ (data[12] ^ data[63]) ^ (state[1] ^ data[6] ^ (data[22] ^ data[64]))) ^ (data[51] ^ state[6] ^ (data[1] ^ data[46]) ^ (data[54] ^ data[72] ^ (data[61] ^ state[3])) ^ (data[4] ^ data[62] ^ (data[49] ^ data[44]) ^ (data[70] ^ data[59] ^ (data[60] ^ data[42])))));
        CRC2[7] = data[41] ^ data[39] ^ (data[37] ^ data[35]) ^ (data[33] ^ data[72] ^ (data[74] ^ data[76])) ^ (data[78] ^ (state[1] ^ data[6]) ^ (data[26] ^ data[13] ^ (data[64] ^ state[0])) ^ (data[7] ^ data[17] ^ (data[23] ^ data[14]) ^ (data[44] ^ data[65] ^ (data[52] ^ data[27])))) ^ (state[5] ^ data[2] ^ (data[18] ^ data[47]) ^ (data[68] ^ data[55] ^ (data[34] ^ data[30])) ^ (data[73] ^ data[77] ^ (data[24] ^ data[11]) ^ (data[62] ^ state[2] ^ (data[5] ^ data[21]))) ^ (data[63] ^ data[50] ^ (state[7] ^ data[0]) ^ (data[45] ^ data[53] ^ (data[71] ^ data[60])) ^ (state[4] ^ data[3] ^ (data[61] ^ data[48]) ^ (data[43] ^ data[69] ^ (data[58] ^ data[59])))));
        int result = 0;
        result = CRC2[7] << 7 | CRC2[6] << 6 | CRC2[5] << 5 | CRC2[4] << 4 | CRC2[3] << 3 | CRC2[2] << 2 | CRC2[1] << 1 | CRC2[0];
        _Logger.debug((Object)("isola_hash_func1_80key: result =" + (result &= 0xFF)));
        return result;
    }

    private int isolaHashAdj(int cfgMode, int sid, int did, int oxid, int mod, int vsan) {
        long hash_in3 = 0L;
        long hash_in2 = 0L;
        long hash_in1 = 0L;
        _Logger.debug((Object)("isolaHashAdj:  sid=" + sid + ", did=" + did + oxid + ", mod=" + mod + ", vsan=" + vsan));
        switch (cfgMode) {
            case 0: {
                if (sid > did) {
                    hash_in2 = this.fcidGetBits(sid);
                    hash_in3 = this.fcidGetBits(did);
                    break;
                }
                hash_in2 = this.fcidGetBits(did);
                hash_in3 = this.fcidGetBits(sid);
                break;
            }
        }
        hash_in1 = oxid;
        long indata2 = hash_in3 << 40 | hash_in2 << 16 | hash_in1;
        int indata1 = vsan;
        int hash = this.isola_vegas1_hash_func0_80key(indata1, indata2);
        int modHash = hash % mod & 0xFF;
        _Logger.debug((Object)("isolaHashAdj:  hash=" + hash));
        _Logger.debug((Object)("isolaHashAdj:  hash%mod=" + modHash));
        return modHash;
    }

    private int isolaHashBundle(int cfgMode, int sid, int did, int oxid, int mod, int vsan) {
        long hash_in3 = 0L;
        long hash_in2 = 0L;
        long hash_in1 = 0L;
        _Logger.debug((Object)("isolaHashBundle:  sid=" + sid + ", did=" + did + oxid + ", mod=" + mod + ", vsan=" + vsan));
        switch (cfgMode) {
            case 0: {
                if (sid > did) {
                    hash_in2 = this.fcidGetBits(sid);
                    hash_in3 = this.fcidGetBits(did);
                    break;
                }
                hash_in2 = this.fcidGetBits(did);
                hash_in3 = this.fcidGetBits(sid);
                break;
            }
        }
        hash_in1 = oxid;
        long indata2 = hash_in3 << 40 | hash_in2 << 16 | hash_in1;
        int indata1 = vsan;
        int hash = this.isola_hash_func1_80key(indata1, indata2);
        int modHash = hash % mod & 0xFF;
        _Logger.debug((Object)("isolaHashBundle:  hash=" + hash));
        _Logger.debug((Object)("isolaHashBundle:  hash%mod=" + modHash));
        return modHash;
    }

    private void computeBundleMembers(int num_physical_links, int num_fspf_paths) {
        int i;
        int divisor = num_physical_links / num_fspf_paths;
        for (i = 0; i < num_fspf_paths; ++i) {
            this._bundleMembers[i] = divisor;
        }
        int leftover_links = num_physical_links - divisor * num_fspf_paths;
        for (i = 0; i < num_fspf_paths; ++i) {
            if (leftover_links-- <= 0) continue;
            int n = i;
            this._bundleMembers[n] = this._bundleMembers[n] + 1;
        }
    }

    private int computeFlowDistribution(int platformType, int isolaConfigMode, int n_fspf, int[][] flow_array, int n_links, int oxId, int vsan) {
        int i;
        int n_zeros = 0;
        this.computeBundleMembers(n_links, n_fspf);
        for (i = 0; i < flow_array.length; ++i) {
            int fspf_path_id = platformType == 0 ? this.lxrHashAdj(flow_array[i][0], flow_array[i][1], oxId, n_fspf) : this.isolaHashAdj(isolaConfigMode, flow_array[i][0], flow_array[i][1], oxId, n_fspf, vsan);
            int link_number = this._bundleMembers[fspf_path_id] > 1 ? (platformType == 0 ? this.lxrHashBundle(flow_array[i][0], flow_array[i][1], oxId, this._bundleMembers[fspf_path_id]) : this.isolaHashBundle(isolaConfigMode, flow_array[i][0], flow_array[i][1], oxId, this._bundleMembers[fspf_path_id], vsan)) : 0;
            int n = this.cumul(this._bundleMembers, fspf_path_id) + link_number;
            this._linkFlowCount[n] = this._linkFlowCount[n] + 1;
        }
        for (i = 0; i < n_links; ++i) {
            if (this._linkFlowCount[i] != 0) continue;
            ++n_zeros;
        }
        return n_zeros;
    }

    private void printBestDistribution(int best_fspf, StringBuffer sb) {
        for (int i = 0; i < best_fspf; ++i) {
            sb.append("# " + (i + 1));
            if (this._bundleMembers[i] > 1) {
                sb.append(": Port Channel with " + this._bundleMembers[i] + " ISL members\n");
                for (int j = 0; j < this._bundleMembers[i]; ++j) {
                    sb.append("\tISL member " + (j + 1) + " has " + this._linkFlowCount[this.cumul(this._bundleMembers, i) + j] + " flows\n");
                }
                continue;
            }
            sb.append(": ISL has " + this._linkFlowCount[this.cumul(this._bundleMembers, i)] + " flows\n");
        }
    }

    void computeBestTopology(int platformType, int isolaConfigMode, int[][] flowArray, int numPhysicalLinks, int oxid, StringBuffer sb, int vsan) {
        int bestFspf = -1;
        int minZeros = numPhysicalLinks;
        this.dataAllocAndInit(numPhysicalLinks);
        int minFspf = (numPhysicalLinks + 16 - 1) / 16;
        int max_fspf = numPhysicalLinks > 16 ? 16 : numPhysicalLinks;
        for (int fspf = minFspf; fspf <= max_fspf; ++fspf) {
            int nZeros = this.computeFlowDistribution(platformType, isolaConfigMode, fspf, flowArray, numPhysicalLinks, oxid, vsan);
            if (nZeros < minZeros) {
                minZeros = nZeros;
                bestFspf = fspf;
            }
            this.initLinkFlowCnt(numPhysicalLinks);
        }
        this.initLinkFlowCnt(numPhysicalLinks);
        this.computeFlowDistribution(platformType, isolaConfigMode, bestFspf, flowArray, numPhysicalLinks, oxid, vsan);
        this.printBestDistribution(bestFspf, sb);
    }
}

