/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.hostcom;

import com.cisco.dcbu.lib.jnm.VshBase;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.CfsActionCommitter;
import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.mds.zm.ZoneAction;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.tools.FlowConfigWizard;
import com.cisco.dcbu.sm.client.hostcom.HSZoneSetPanel;
import com.cisco.dcbu.sm.client.hostcom.SelectHostPanel;
import com.cisco.dcbu.sm.client.hostcom.StoragePortsPanel;
import com.cisco.dcbu.sm.client.hostcom.VshActionHandlerPanel;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.SmZoneAction;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import com.cisco.dcbu.sm.common.type.SwitchIntKey;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class HostCommisioningWizard
extends JWizard
implements StatusIf {
    static ImageIcon _ImagePc = Util.loadIcon("icons/HostProvisioning.gif");
    static final String SELECTED_HS_VSAN = "VSAN";
    static final String SELECTED_HS_ORI_VSAN = "ORI_VSAN";
    static final String CONFIGED_HS_VSAN = "CONFIGED_VSAN";
    public static final String SELECTED_HS_ZONE_SWITCH = "ZONE_PEER";
    static final String SELECTED_DEVICE_ALIAS_NAME = "DEVICE_ALIAS_NAME";
    static final String CONFIGED_DEVICE_ALIAS_NAME = "CONFIGED_DEVICE_ALIAS_NAME";
    static final String SELECTED_HOST_PORT = "HOST_PORT";
    static final String COMMISSION_HOST = "COMMISSION_HOST";
    static final String SKIP_ZONING = "SKIP_ZONING";
    static final String CHANGE_VSAN = "CHANGE_VSAN";
    static final String SKIP_DPVM = "SKIP_DPVM";
    static final String SELECTED_HS_END_PORTS = "SELECTED_HS_END_PORTS";
    static final String ZONE_MEMBERS_TOADD = "ZONE_MEMBERS_TOADD";
    static final String SEL_EXISTING_ZONE = "SEL_EXISTING_ZONE";
    public static final String ZONE_DATA_CONTROLLER = "ZONE_DATA";
    public static final String HS_ZONESET = "ZONESET";
    public static final String HS_ZONE = "ZONE";
    static final String ZONE_HS_DATA_CONTROLLER = "ZONE_DATA";
    private ZoneAction zoneAction;

    public HostCommisioningWizard(JFrame parent, Vsan vv) throws SnmpException {
        super(parent);
        this.setTitle("Host Provisioning Wizard" + ClientController.getInstance().getDialogFabricTitlePostfix());
        this.setSize(550, 550);
        this.setZoneAction();
        this.createPanels("Configure Host", vv);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(this.getParent());
    }

    private void setZoneAction() {
        this.zoneAction = new SmZoneAction(this, null, -1);
        this.setModelValue("ZONE_DATA", this.zoneAction);
    }

    void createPanels(String title, Vsan vv) throws SnmpException {
        if (vv == null) {
            throw new SnmpException("Please select a VSAN");
        }
        this.setModelValue(SELECTED_HS_VSAN, vv);
        this.addPanel("select host port", new SelectHostPanel(this, title, vv));
        this.addPanel("select storage ports", new StoragePortsPanel(this));
        this.addPanel("select zone, zoneset", new HSZoneSetPanel(this, "3 of 3: Select Zone", _ImagePc));
        this.getNavigator().getCancel().setText("Close");
        this.first();
    }

    @Override
    public void handleError(Exception[] ex) {
        Util.errorMessage((Component)this, SmZoneUtil.buildErrorMessage(ex).toString());
        try {
            this.getNavigator().getNextBtn().setEnabled(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionFinished() {
        try {
            this.getNavigator().getNextBtn().setText("Finish");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setStatus(String status) {
        if (status.equals("Success")) {
            try {
                this.getNavigator().getNextBtn().setEnabled(false);
                this.getNavigator().getBackBtn().setEnabled(false);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            super.setStatus(status);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void buildDACommandStructure(JWizard wiz, StringBuffer actions, ArrayList cliActions) {
        Boolean commission = (Boolean)wiz.getModelValue(COMMISSION_HOST);
        String selHostStr = (String)wiz.getModelValue(SELECTED_HOST_PORT);
        String userDa = (String)wiz.getModelValue(SELECTED_DEVICE_ALIAS_NAME);
        String configDa = (String)wiz.getModelValue(CONFIGED_DEVICE_ALIAS_NAME);
        if (!HostCommisioningWizard.isDAConfigNeeded(wiz)) {
            actions.append(configDa == null ? "No device alias configured\n" : "Device Alias already configured\n");
        } else {
            actions.append((commission != false ? "Set " : "Remove ") + "Device Alias for WWN " + selHostStr + " to " + userDa + "\n");
            cliActions.add(new String[]{"conf t\n", "(config)#"});
            cliActions.add(new String[]{"device-alias database\n", "(config-device-alias-db)#"});
            cliActions.add(new String[]{commission != false ? "device-alias name " + userDa + " pwwn " + selHostStr + "\n" : "no device-alias name " + configDa + "\n", "(config-device-alias-db)#"});
            cliActions.add(new String[]{"exit\n", "(config)#"});
            cliActions.add(new String[]{"device-alias commit\n", "(config)#"});
            cliActions.add(new String[]{"end\n", "#"});
            cliActions.add(new String[]{"# Poll for Status\n", null});
        }
    }

    public static void buildDPVMCommandStructure(JWizard wiz, StringBuffer actions, ArrayList cliActions) {
        Boolean commission = (Boolean)wiz.getModelValue(COMMISSION_HOST);
        Vsan cacheVsan = (Vsan)wiz.getModelValue(SELECTED_HS_VSAN);
        String selHostStr = (String)wiz.getModelValue(SELECTED_HOST_PORT);
        String configVsanID = (String)wiz.getModelValue(CONFIGED_HS_VSAN);
        if (!HostCommisioningWizard.isDPVMConfigNeeded(wiz)) {
            actions.append(commission == false ? "No DPVM configured\n" : "DPVM already configured\n");
        } else {
            actions.append((commission != false ? "Set " : "Remove ") + "DPVM for WWN " + selHostStr + " to " + cacheVsan.getVsanId() + "\n");
            cliActions.add(new String[]{"conf t\n", "(config)#"});
            cliActions.add(new String[]{"dpvm database\n", "(config-dpvm-db)#"});
            cliActions.add(new String[]{(commission != false ? "" : "no ") + "pwwn " + selHostStr + " vsan " + (commission != false ? Integer.toString(cacheVsan.getVsanId()) : configVsanID) + "\n", "(config-dpvm-db)#"});
            cliActions.add(new String[]{"exit\n", "(config)#"});
            cliActions.add(new String[]{"dpvm activate force\n", "(config)#"});
            cliActions.add(new String[]{"dpvm commit\n", "(config)#"});
            cliActions.add(new String[]{"end\n", "#"});
            cliActions.add(new String[]{"# Poll for Status\n", null});
        }
    }

    public static boolean commitCFSPollResult(JWizard wiz, Switch cacheSw, StringBuffer buf, int[] commitPoll) throws SnmpException {
        int pollRes = 4;
        VarBindList response = null;
        while (pollRes == 4) {
            wiz.setStatus(cacheSw + ":checking commit status for Device Alias");
            VarBindList vb = new VarBindList();
            vb.add(CfsActionCommitter.CFS_ACTION_RESULT, commitPoll);
            vb.add(CfsActionCommitter.CFS_ACTION_REASON, commitPoll);
            response = SnmpFetch.get(cacheSw.getSnmpPeer(), vb).getVariables();
            pollRes = response.intValue(0);
        }
        if (pollRes != 2) {
            wiz.setStatus(cacheSw + ":Device Alias commit failed.");
            buf.append(response != null ? response.stringValue(1) : "");
            return false;
        }
        wiz.setStatus(cacheSw + ":Device Alias commit Success.");
        return true;
    }

    public void runCLIActions(JTextArea txtArea, int[] cfsActionIndex, ArrayList cliActions, StringBuffer actions, VshBase vsh, boolean showOnly) throws SnmpException, IOException {
        Switch cacheSw = (Switch)this.getModelValue(SELECTED_HS_ZONE_SWITCH);
        StringBuffer result = new StringBuffer();
        try {
            if (txtArea != null) {
                txtArea.append(actions.toString());
            }
            if (cliActions.size() > 0) {
                SnmpPeer prr = cacheSw.getSnmpPeer();
                String defPrompt = "";
                if (!showOnly) {
                    if (vsh == null) {
                        throw new IOException("unable to open session to switch " + cacheSw);
                    }
                    defPrompt = vsh.getPrompt();
                    defPrompt = defPrompt.substring(0, defPrompt.indexOf("#"));
                    vsh.send("end \n");
                    DefaultLogger._DefLogger.debug((Object)"end \n");
                    vsh.expect(defPrompt + "#", result);
                    if (txtArea != null) {
                        txtArea.append("Result:" + result + "\n");
                    }
                    result.setLength(0);
                }
                for (int i = 0; i < cliActions.size(); ++i) {
                    String[] cliCmd = (String[])cliActions.get(i);
                    if (!this.isVisible()) {
                        return;
                    }
                    DefaultLogger._DefLogger.info((Object)("Command:" + cliCmd[0]));
                    if (txtArea != null) {
                        txtArea.append("Command:" + cliCmd[0]);
                    }
                    if (showOnly) continue;
                    result.setLength(0);
                    if (cliCmd[0].trim().startsWith("#")) continue;
                    vsh.send(cliCmd[0]);
                    vsh.expect(defPrompt + (cliCmd[1] == null ? "" : cliCmd[1]), result);
                    if (result.indexOf("^") != -1) {
                        DefaultLogger._DefLogger.info((Object)("Invalid command length. Command:" + cliCmd[0]));
                        throw new SnmpException("Invalid command length. Command:" + cliCmd[0]);
                    }
                    if (txtArea != null) {
                        txtArea.append("Result:" + result + "\n");
                    }
                    DefaultLogger._DefLogger.info((Object)(result + "\n"));
                }
                StringBuffer buf = new StringBuffer();
                if (!showOnly && !HostCommisioningWizard.commitCFSPollResult(this, cacheSw, buf, cfsActionIndex)) {
                    throw new SnmpException(buf.toString());
                }
                if (txtArea != null) {
                    txtArea.append(showOnly ? "Snmp:Issue CFS commit\n" : "Commit Success\n");
                }
            }
        }
        catch (IOException ex) {
            if (txtArea != null && result != null) {
                txtArea.append("Result:" + result);
            }
            throw ex;
        }
        catch (SnmpException ex) {
            if (txtArea != null && result != null) {
                txtArea.append("Result:" + result);
            }
            throw ex;
        }
    }

    public void runCLIActions(JTextArea txtArea, VshBase vsh) throws SnmpException, IOException {
        this.runCLIActions(txtArea, vsh, false);
    }

    public void runCLIActions(JTextArea txtArea, VshBase vsh, boolean showOnly) throws SnmpException, IOException {
        StringBuffer actions = new StringBuffer();
        ArrayList cliActions = new ArrayList();
        HostCommisioningWizard.buildDACommandStructure(this, actions, cliActions);
        this.runCLIActions(txtArea, CfsActionCommitter.DEVICE_ALIAS_INDEX, cliActions, actions, vsh, showOnly);
        if (actions.length() > 0) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException exx) {
                // empty catch block
            }
        }
        actions.setLength(0);
        cliActions.clear();
        Boolean skipDpvm = (Boolean)this.getModelValue(SKIP_DPVM);
        if (!skipDpvm.booleanValue()) {
            HostCommisioningWizard.buildDPVMCommandStructure(this, actions, cliActions);
            this.runCLIActions(txtArea, CfsActionCommitter.DPVM_INDEX, cliActions, actions, vsh, showOnly);
        } else {
            this.setStatus("skipping DPVM configuration.");
        }
    }

    static boolean isDAConfigNeeded(JWizard wiz) {
        Boolean commission = (Boolean)wiz.getModelValue(COMMISSION_HOST);
        String userDa = (String)wiz.getModelValue(SELECTED_DEVICE_ALIAS_NAME);
        String configDa = (String)wiz.getModelValue(CONFIGED_DEVICE_ALIAS_NAME);
        return (commission != false || configDa != null && configDa.length() != 0) && (commission == false || configDa == null || !configDa.equals(userDa));
    }

    static boolean isDPVMConfigNeeded(JWizard wiz) {
        Boolean commission = (Boolean)wiz.getModelValue(COMMISSION_HOST);
        Vsan cacheVsan = (Vsan)wiz.getModelValue(SELECTED_HS_VSAN);
        String configVsanID = (String)wiz.getModelValue(CONFIGED_HS_VSAN);
        return (commission != false || configVsanID != null && configVsanID.length() != 0) && (commission == false || configVsanID == null || !configVsanID.equals(Integer.toString(cacheVsan.getVsanId())));
    }

    public boolean isVsanSwitchChanged() {
        Vsan selVsan = (Vsan)this.getModelValue(SELECTED_HS_VSAN);
        Switch sw = (Switch)this.getModelValue(SELECTED_HS_ZONE_SWITCH);
        SmZoneAction zoneAction = (SmZoneAction)this.getModelValue("ZONE_DATA");
        return zoneAction == null || zoneAction.getVsan() == null || zoneAction.getSwitch() == null || selVsan == null || sw == null || !zoneAction.getVsan().equals(selVsan) || !zoneAction.getSwitch().equals(sw);
    }

    public boolean isVsanChanged() {
        Vsan selVsan = (Vsan)this.getModelValue(SELECTED_HS_VSAN);
        SmZoneAction zoneAction = (SmZoneAction)this.getModelValue("ZONE_DATA");
        return zoneAction == null || zoneAction.getVsan() == null || selVsan == null || !zoneAction.getVsan().equals(selVsan);
    }

    public void changeHostVsan(boolean onlyShowDetails, JTextArea zoneMemDetails) throws SnmpException {
        Vsan cachVsan = (Vsan)this.getModelValue(SELECTED_HS_VSAN);
        Vsan oriVsan = (Vsan)this.getModelValue(SELECTED_HS_ORI_VSAN);
        Boolean commissionHost = (Boolean)this.getModelValue(COMMISSION_HOST);
        Boolean changeVsan = (Boolean)this.getModelValue(CHANGE_VSAN);
        if (changeVsan != null && changeVsan.booleanValue() && commissionHost.booleanValue() && oriVsan != null && !oriVsan.equals(cachVsan)) {
            String selHostStr = (String)this.getModelValue(SELECTED_HOST_PORT);
            boolean hasColon = selHostStr.indexOf(":") != -1;
            Wwn wwnHs = new Wwn(selHostStr, hasColon);
            ClientController.getInstance();
            EndPort epH = ClientController.findFabricEndPortByWwn(wwnHs);
            if (epH != null && epH.getSwitch().isManageable()) {
                SwitchIntKey swInt = epH.getSwitchIntKey();
                Switch swepH = epH.getSwitch(oriVsan.getVsanId());
                if (zoneMemDetails != null) {
                    zoneMemDetails.append("Changing Port VSAN for " + epH + " on Switch " + swepH + " interface " + swepH.ifIndexToName(swInt.getIfindex()) + " from " + oriVsan + " to " + cachVsan + "\n");
                }
                if (!onlyShowDetails) {
                    VarBindList vbl = new VarBindList();
                    vbl.add(MibNode.get("vsanIfVsan").getOid(), swInt.getIfindex(), (SnmpVar)new SnmpInt(cachVsan.getVsanId()));
                    SnmpFetch.set(swepH.getPeer(), new SnmpPDU(-93, vbl));
                }
            } else if (zoneMemDetails != null) {
                zoneMemDetails.append("Skipping Vsan Change: " + (epH != null ? selHostStr + " is attached to unmanageble switch " + epH.getSwitch() + "\n" : "No End Device associated with " + selHostStr + "\n"));
            }
        } else if (commissionHost.booleanValue() && zoneMemDetails != null) {
            zoneMemDetails.append(oriVsan != null ? "VSANs identical, no VSAN Change \n" : "No VSAN Change \n");
        }
    }

    public void verifyChangedVsanExists(boolean showOnly, JTextArea zoneMemDetails) throws SnmpException {
        Vsan cachVsan = (Vsan)this.getModelValue(SELECTED_HS_VSAN);
        String selHostStr = (String)this.getModelValue(SELECTED_HOST_PORT);
        Vsan oriVsan = (Vsan)this.getModelValue(SELECTED_HS_ORI_VSAN);
        Boolean commissionHost = (Boolean)this.getModelValue(COMMISSION_HOST);
        Boolean changeVsan = (Boolean)this.getModelValue(CHANGE_VSAN);
        if (changeVsan != null && changeVsan.booleanValue() && commissionHost.booleanValue() && oriVsan != null && !oriVsan.equals(cachVsan)) {
            boolean hasColon = selHostStr.indexOf(":") != -1;
            Wwn wwnHs = new Wwn(selHostStr, hasColon);
            ClientController.getInstance();
            EndPort epH = ClientController.findFabricEndPortByWwn(wwnHs);
            if (epH != null && epH.getSwitch().isManageable()) {
                SwitchIntKey swInt = epH.getSwitchIntKey();
                Switch swepH = epH.getSwitch(oriVsan.getVsanId());
                SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
                pdu.addNull(new SnmpOID(MibNode.get("vsanName").getOid(), cachVsan.getVsanId()));
                SnmpPDU resp = swepH.getSnmpPeer().send(pdu);
                VarBindList vbnds = resp.getVariables();
                SnmpVar theVar = vbnds.getVb(0).getVar();
                if (theVar.getType() == 5) {
                    if (showOnly && zoneMemDetails != null) {
                        zoneMemDetails.append("VSAN " + cachVsan + " does not exist on switch " + swepH + ".\n");
                    } else {
                        throw new SnmpException("VSAN " + cachVsan + " does not exist on switch " + swepH);
                    }
                }
            }
        }
    }

    static boolean doesFlowExist(JWizard wiz, Array flows) {
        if (flows == null) {
            return false;
        }
        String hsPort = (String)wiz.getModelValue(SELECTED_HOST_PORT);
        Vsan vv = (Vsan)wiz.getModelValue(SELECTED_HS_VSAN);
        boolean hasColon = hsPort.indexOf(":") != -1;
        Wwn hsWwn = new Wwn(hsPort, hasColon);
        ClientController.getInstance();
        EndPort hsEp = ClientController.findFabricEndPortByWwn(hsWwn, vv.getVsanId());
        boolean flowExists = true;
        if (hsEp != null) {
            int srcId = hsEp.getFcIdNum(vv.getVsanId());
            Switch realSw = FlowConfigWizard.getRealSwitch(hsEp, vv);
            int[] modules = null;
            try {
                modules = FlowConfigWizard.getSrcModules(realSw, hsEp);
            }
            catch (SnmpException ex) {
                DefaultLogger._DefLogger.warn((Object)"Error getting source modules: ", (Throwable)ex);
            }
            Array portsToZone = (Array)wiz.getModelValue(SELECTED_HS_END_PORTS);
            if (modules == null || modules.length == 0 || portsToZone == null || portsToZone.size() == 0) {
                flowExists = false;
            } else {
                for (int p = 0; p < portsToZone.size(); ++p) {
                    EndPort dstEp = (EndPort)portsToZone.elementAt(p);
                    int dstId = dstEp.getFcIdNum(vv.getVsanId());
                    for (int m = 0; m < modules.length; ++m) {
                        if (FlowConfigWizard.doesFlowExist(flows, modules[m] - 21, srcId, dstId)) continue;
                        flowExists = false;
                        break;
                    }
                    if (flowExists) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            flowExists = false;
        }
        return flowExists;
    }

    @Override
    public void dispose() {
        VshActionHandlerPanel pnl;
        if (this.isVisible() && (pnl = (VshActionHandlerPanel)this.getCurrent()) != null && pnl.isProcessing() && JOptionPane.showConfirmDialog((JFrame)SwingUtilities.windowForComponent(this), "Configuration operation is in progress.  Stopping it can leave Fabric in unknown state. \nContinue?", this.getTitle(), 0, 2) != 0) {
            return;
        }
        super.dispose();
    }
}

