/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.hostcom;

import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.jnm.VshBase;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.TextOutputDialog;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.cfs.CfsSwitchPeer;
import com.cisco.dcbu.sm.client.gui.tools.FlowConfigWizard;
import com.cisco.dcbu.sm.client.hostcom.DecommisionZone;
import com.cisco.dcbu.sm.client.hostcom.HSZoneSetPanel;
import com.cisco.dcbu.sm.client.hostcom.HostCommisioningWizard;
import com.cisco.dcbu.sm.client.hostcom.StoragePortsPanel;
import com.cisco.dcbu.sm.client.hostcom.VshActionHandlerPanel;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.EndPortSelector;
import com.cisco.dcbu.sm.common.type.SwitchIntKey;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class SelectHostPanel
extends VshActionHandlerPanel
implements ActionListener,
ItemListener {
    protected static final String[] names = new String[]{"Host Provisioning", "Host WWN:", "In Vsan:", "On Switch:", null, "With Name:", null, "For VSAN:", null, null, null};
    protected static final String CONFIGURE_DPVM = "Add to DPVM DB";
    protected static final String REMOVE_DPVM = "Remove from DPVM DB";
    protected static final String CONFIGURE_DEVICE_ALIAS = "Create Device Alias";
    protected static final String REMOVE_DEVICE_ALIAS = "Remove Device Alias";
    static final String[] Selector = new String[]{"Commission", "Decommission"};
    protected JComponent[] labels;
    protected JComboBox switchCb;
    protected JComboBox vsanCb;
    protected DialogSeparator devAliasSeparator;
    protected DialogSeparator dpvmSeparator;
    protected FieldPanel endPortField;
    protected FieldPanel deviceAliasField;
    protected JButton portEllipsis;
    protected Vsan vsan;
    protected RadioButtonPanel select;
    protected SnmpPeer[] all313Peers;
    private TextOutputDialog _logDialog;
    JCheckBox _skipZoningChkBox;
    JCheckBox _changeVsanChkBox;
    JCheckBox _skipDpvmChkBox;
    JLabel _inVsan;
    private Vsan oriHostVsan;
    static final int DPVM_FEATURE_ID = 18;
    static final int DEV_ALIAS_LABEL = 5;
    static final int IN_VSAN = 2;
    static final int[] DPVM_INDEX = new int[]{4, 100, 112, 118, 109};
    static final int[] DPVM_CFS_INDEX = new int[]{4, 100, 112, 118, 109, 1};
    static final int[] DEVALIAS_INDEX = new int[]{12, 100, 101, 118, 105, 99, 101, 45, 97, 108, 105, 97, 115};
    static final int[] DEVALIAS_CFS_INDEX = new int[]{12, 100, 101, 118, 105, 99, 101, 45, 97, 108, 105, 97, 115, 1};

    public SelectHostPanel(JWizard wiz, String title, Vsan vv) {
        super("1 of 3: Select Host", "Please select a Host WWN & VSAN to configure Device Alias and DPVM.  \nIf Decommission radio button is selected the Device Alias and DPVM configuration will be removed for selected Host WWN.", wiz, HostCommisioningWizard._ImagePc);
        this.vsan = vv;
        this._inVsan = DialogUtil.buildLabels(new String[]{" "})[0];
        this._inVsan.setHorizontalAlignment(2);
        this.labels = DialogUtil.buildLabels(names);
        JComponent[] values = new JComponent[this.labels.length];
        this.select = new RadioButtonPanel(Selector, 2, this);
        values[0] = this.select;
        this._skipZoningChkBox = new JCheckBox("Skip Zoning", false);
        this._skipZoningChkBox.setActionCommand("Zoning");
        this._skipZoningChkBox.addActionListener(this);
        this._skipDpvmChkBox = new JCheckBox("Skip DPVM", false);
        this._skipDpvmChkBox.setActionCommand("DPVM");
        this._skipDpvmChkBox.addActionListener(this);
        this.portEllipsis = new JButton("...");
        this.portEllipsis.setToolTipText("Select End Device");
        this.portEllipsis.setActionCommand("EndPorts");
        this.portEllipsis.setMargin(Util.getNoBorder());
        this.portEllipsis.addActionListener(this);
        this.endPortField = new FieldPanel(21, (JComponent)this.portEllipsis);
        this.deviceAliasField = new FieldPanel(21);
        this.devAliasSeparator = new DialogSeparator();
        this.devAliasSeparator.setVisible(false);
        this.dpvmSeparator = new DialogSeparator();
        this.dpvmSeparator.setVisible(false);
        JPanel pnl = new JPanel(new BorderLayout());
        JPanel devAliasComp = DialogUtil.buildPanel(DialogUtil.buildLabels(new String[]{"   With Name:"}), new JComponent[]{this.deviceAliasField});
        pnl.add((Component)devAliasComp, "Center");
        JPanel pnl1 = new JPanel(new BorderLayout());
        Object[] vSs = ClientController.getInstance().getFabric().getVsans();
        Arrays.sort(vSs);
        this.vsanCb = new JComboBox<Object>(vSs);
        if (vv != null) {
            this.vsanCb.setSelectedItem(vv);
        }
        Switch[] swLst = ((Vsan)this.vsanCb.getSelectedItem()).getSwitches(false);
        ArrayList<Switch> swAList = new ArrayList<Switch>();
        if (swLst != null) {
            for (int i = 0; i < swLst.length; ++i) {
                if (swLst == null || !swLst[i].isMDS() || swLst[i].isNpvEnabled() || !swLst[i].isVersionGreaterThanEqual("3.1(0)") || swLst[i].getSnmpPeer() == null) continue;
                swAList.add(swLst[i]);
            }
        }
        this._changeVsanChkBox = new JCheckBox("Change Host VSAN", false);
        this.switchCb = new JComboBox<Switch>(swAList.toArray(new Switch[swAList.size()]));
        pnl1.add((Component)this.vsanCb, "Center");
        values[1] = this.endPortField;
        values[2] = this._inVsan;
        values[3] = this.switchCb;
        values[4] = this.devAliasSeparator;
        values[5] = this.deviceAliasField;
        values[6] = this.dpvmSeparator;
        values[7] = this.vsanCb;
        values[8] = this._changeVsanChkBox;
        values[9] = new DialogSeparator();
        JPanel chkBoxPnl = new JPanel(new FlowLayout(0, 6, 3));
        chkBoxPnl.add(this._skipZoningChkBox);
        chkBoxPnl.add(this._skipDpvmChkBox);
        values[10] = chkBoxPnl;
        JPanel pnlAll = new JPanel(new BorderLayout());
        pnlAll.add((Component)DialogUtil.buildPanel(this.labels, values), "Center");
        JPanel dtlBtnPnl = this.buildShowDetailsButtonPnl(this);
        pnlAll.add((Component)dtlBtnPnl, "South");
        this.add((Component)pnlAll, "Center");
        this.detailBtn[0].setVisible(false);
        this.detailBtn[1].setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.portEllipsis) {
            EndPortSelector end = new EndPortSelector((JFrame)SwingUtilities.windowForComponent(this.getWizard()), this.vsan, null, 4, false, null, this.vsan.getFabric().getVsans());
            end.setSelectionMode(0);
            end.setVisible(true);
            EndPort[] ep = end.getSelectedEndPort();
            if (ep != null && ep.length > 0) {
                String da = ep[0].getDeviceAliasAsString();
                this.deviceAliasField.setText(da != null ? da : "");
                this.endPortField.setText(SnmpString.toHexString(ep[0].getPortWwn().getValue()));
                this.switchCb.setSelectedItem(FlowConfigWizard.getRealSwitch(ep[0], this.vsan));
                this.oriHostVsan = end.getSelectedVsan();
                this._inVsan.setText(this.oriHostVsan.getName());
            } else {
                this.oriHostVsan = null;
            }
        } else if (e.getSource() == this._skipZoningChkBox) {
            this.adjustPanels();
        } else if (e.getSource() != this._skipDpvmChkBox) {
            char ch = e.getActionCommand().charAt(0);
            switch (ch) {
                case 'S': {
                    this.initLogDialog();
                    this._logDialog.getTextArea().setText("Action Details (NO CONFIGURATION WILL BE CHANGED): \n");
                    this.unCacheData();
                    this.nextAction(true);
                    break;
                }
                case 'C': {
                    if (this._logDialog == null || !this._logDialog.isVisible()) break;
                    this._logDialog.getTextArea().setText("");
                }
            }
        }
    }

    public void nextAction(boolean showOnly) {
        String wwnData = this.endPortField.getText().trim();
        boolean hasColon = wwnData.indexOf(":") != -1;
        try {
            Wwn wwnHs = new Wwn(wwnData, hasColon);
            byte[] bt = wwnHs.getValue();
            if (bt.length != 8) {
                throw new Exception("Please enter a valid port WWN.");
            }
            ClientController.getInstance();
            EndPort epH = ClientController.findFabricEndPortByWwn(wwnHs);
            this.oriHostVsan = epH != null ? (epH.isMemberOfVsan(this.oriHostVsan != null ? this.oriHostVsan : this.vsan) ? this.vsan : epH.getFirstVsan()) : null;
            this._inVsan.setText(this.oriHostVsan != null ? this.oriHostVsan.getName() : " ");
            Vsan selVsan = (Vsan)this.vsanCb.getSelectedItem();
            this.getWizard().setModelValue("ORI_VSAN", this.oriHostVsan);
            if (this._changeVsanChkBox.isEnabled() && epH != null && !epH.getSwitch().isManageable()) {
                Util.errorMessage((Component)this.getWizard(), "The selected Host is attached to a Switch which cannot be managed by DCNM-SAN.\nThe VSAN for select Host cannot be changed.");
                return;
            }
            if (this._changeVsanChkBox.isEnabled() && this._changeVsanChkBox.isSelected() && this.oriHostVsan != null && !this.oriHostVsan.equals(selVsan)) {
                SwitchIntKey swIntKey = epH.getSwitchIntKey();
                Switch swEh = epH.getSwitch();
                ArrayList<EndPort> eports = swEh.getFabric().findEndPortsBySwitchIfIndex(swEh, swIntKey.getIfindex());
                if (eports.size() > 1 && JOptionPane.showConfirmDialog((JFrame)SwingUtilities.windowForComponent(this.getWizard()), "Changing VSAN of selected End Device changes VSAN of all \nEnd Devices which are connected to same Switch Port.\nContinue? ", this.getWizard().getTitle(), 0, 2) != 0) {
                    return;
                }
            }
            if (this._changeVsanChkBox.isEnabled() && this._changeVsanChkBox.isSelected() && this.oriHostVsan == null) {
                Util.errorMessage((Component)this.getWizard(), "Please uncheck Change Host VSAN check box or select a port WWN from different VSAN.");
                return;
            }
        }
        catch (Exception exx) {
            Util.errorMessage((Component)this.getWizard(), exx.getMessage());
            return;
        }
        if (this.select.getSelected() == 0 && this.deviceAliasField.getText().trim().length() == 0) {
            Util.errorMessage((Component)this.getWizard(), "Please specify a Device Alias Name.");
            return;
        }
        Switch[] sw = ClientController.getInstance().getFabric().getSwitches();
        ArrayList<SnmpPeer> snmpPrs = new ArrayList<SnmpPeer>();
        if (sw != null) {
            for (int i = 0; i < sw.length; ++i) {
                if (!sw[i].isMDS() || sw[i].isNpvEnabled() || !sw[i].isVersionGreaterThanEqual("3.1(0)") || sw[i].getSnmpPeer() == null) continue;
                snmpPrs.add(sw[i].getSnmpPeer());
            }
            this.all313Peers = snmpPrs.toArray(new SnmpPeer[snmpPrs.size()]);
        }
        if (!this.isDataChangedFromCache()) {
            this.runFinished();
            return;
        }
        if (!this.preRunValidate(showOnly)) {
            return;
        }
        VshActionHandlerPanel.VshAction act = new VshActionHandlerPanel.VshAction((VshActionHandlerPanel)this, (VshActionHandlerPanel)this, showOnly);
        Thread th = new Thread(act);
        this.getWizard().setStatus("Verifying current configuration...");
        if (!showOnly && this.getWizard().isVisible() && this.getWizard().getPanelCount() == 1) {
            this.setProcessing(true);
        }
        th.start();
        this.getWizard().getNavigator().getNextBtn().setEnabled(false);
    }

    @Override
    public void doNext() {
        Vsan cachVsan;
        if (this.isDataValid() && ((cachVsan = (Vsan)this.getModelValue("VSAN")) == null || !cachVsan.equals((Vsan)this.vsanCb.getSelectedItem()))) {
            this.setDataValid(false);
        }
        this.unCacheData();
        this.nextAction(false);
    }

    private void initLogDialog() {
        if (this._logDialog == null || !this._logDialog.isVisible()) {
            this._logDialog = new TextOutputDialog(this.getWizard(), "Commission/Decommission Host Log" + ClientController.getInstance().getDialogFabricTitlePostfix());
            this._logDialog.setVisible(true);
        }
    }

    @Override
    public void doFinish() {
        this.initLogDialog();
        this.doNext();
    }

    private boolean isDataChangedFromCache() {
        Switch selSw = (Switch)this.switchCb.getSelectedItem();
        Vsan selVsan = (Vsan)this.vsanCb.getSelectedItem();
        String selEp = this.endPortField.getText().trim();
        String selDA = this.deviceAliasField.getText().trim();
        Boolean commission = this.select.getSelected() == 0;
        Switch cacheSw = (Switch)this.getWizard().getModelValue("ZONE_PEER");
        Vsan cacheVsan = (Vsan)this.getWizard().getModelValue("VSAN");
        String cacheEp = (String)this.getWizard().getModelValue("HOST_PORT");
        String cacheDA = (String)this.getWizard().getModelValue("DEVICE_ALIAS_NAME");
        Boolean cacheCommission = (Boolean)this.getWizard().getModelValue("COMMISSION_HOST");
        Boolean skipZoning = (Boolean)this.getModelValue("SKIP_ZONING");
        Boolean changeHostVsan = (Boolean)this.getModelValue("CHANGE_VSAN");
        Boolean skipDpvm = (Boolean)this.getModelValue("SKIP_DPVM");
        if (cacheCommission == null || cacheSw == null || cacheVsan == null || cacheEp == null || cacheDA == null || skipZoning == null || skipDpvm == null) {
            return true;
        }
        return !cacheCommission.equals(commission) || !cacheSw.equals(selSw) || !cacheVsan.equals(selVsan) || !cacheEp.equals(selEp) || !cacheDA.equals(selDA) || !skipZoning.equals(this._skipZoningChkBox.isSelected() && changeHostVsan.equals(this._changeVsanChkBox.isSelected())) || !skipDpvm.equals(this._skipDpvmChkBox.isSelected());
    }

    private void cacheData() {
        Switch selSw = (Switch)this.switchCb.getSelectedItem();
        Vsan selVsan = (Vsan)this.vsanCb.getSelectedItem();
        String selEp = this.endPortField.getText().trim();
        String selDA = this.deviceAliasField.getText().trim();
        Boolean commission = this.select.getSelected() == 0;
        this.getWizard().setModelValue("ZONE_PEER", selSw);
        this.getWizard().setModelValue("VSAN", selVsan);
        this.getWizard().setModelValue("HOST_PORT", selEp);
        this.getWizard().setModelValue("DEVICE_ALIAS_NAME", selDA);
        this.getWizard().setModelValue("COMMISSION_HOST", commission);
        this.getWizard().setModelValue("SKIP_ZONING", this._skipZoningChkBox.isSelected());
        this.getWizard().setModelValue("CHANGE_VSAN", this._changeVsanChkBox.isSelected());
        this.getWizard().setModelValue("SKIP_DPVM", this._skipDpvmChkBox.isSelected());
    }

    private void unCacheData() {
        this.getWizard().setModelValue("ZONE_PEER", null);
        this.getWizard().setModelValue("VSAN", null);
        this.getWizard().setModelValue("HOST_PORT", null);
        this.getWizard().setModelValue("DEVICE_ALIAS_NAME", null);
        this.getWizard().setModelValue("COMMISSION_HOST", null);
        this.getWizard().setModelValue("CONFIGED_DEVICE_ALIAS_NAME", null);
        this.getWizard().setModelValue("CONFIGED_VSAN", null);
        this.getWizard().setModelValue("SKIP_ZONING", null);
        this.getWizard().setModelValue("CHANGE_VSAN", null);
        this.getWizard().setModelValue("SKIP_DPVM", null);
    }

    @Override
    protected void runFinished() {
        this.getWizard().setStatus("");
        int count = this.getWizard().getPanelCount();
        if (count > 1) {
            super.doNext();
        } else {
            super.doFinish();
        }
    }

    private ArrayList buildDAFeatureList(SnmpPeer[] peers) throws SnmpException {
        ArrayList<Object[]> featureList = new ArrayList<Object[]>();
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("cfdaConfigMode").getOid(), 0);
        vbl.add(MibNode.get("cfsFeatureOpStatus").getOid(), DEVALIAS_INDEX);
        vbl.add(MibNode.get("cfsPendingConfOwnerID").getOid(), DEVALIAS_CFS_INDEX);
        vbl.add(MibNode.get("cfsPendingConfOwnerIDType").getOid(), DEVALIAS_CFS_INDEX);
        vbl.add(MibNode.get("cfsPendingConfOwnerAddr").getOid(), DEVALIAS_CFS_INDEX);
        vbl.add(MibNode.get("cfsMergeStatusValue").getOid(), DEVALIAS_CFS_INDEX);
        vbl.add(MibNode.get("cfsDistCtrl").getOid(), 0);
        SnmpPDU[] pdus = new SnmpAggregrate().get(peers, vbl);
        for (int i = 0; i < pdus.length; ++i) {
            if (pdus[i].getError() != 0) {
                throw new SnmpException(pdus[i].getAddress().getHostName() + ": " + SnmpException.toError(pdus[i].getError()));
            }
            VarBindList response = pdus[i].getVariables();
            if (response == null) continue;
            Object[] obb = new Object[3];
            obb[0] = ClientController.findFabricSwitchByIpAddress(pdus[i].getAddress()).getPeer();
            obb[1] = new int[]{response.intValue(0)};
            CfsSwitchPeer swPr = new CfsSwitchPeer();
            swPr._peer = (SnmpPeer)obb[0];
            swPr._sw = ClientController.findFabricSwitchByIpAddress(swPr._peer.getAddress());
            swPr._featureName = "DEVICE ALIAS";
            int[] feature = (int[])obb[1];
            swPr._featureState = feature[0] != 1;
            swPr._cfs = response.intValue(1) == 2;
            swPr._lockedBy = response.stringValue(2);
            swPr._lockIdType = response.intValue(3);
            swPr._lockedOn = response.byteValue(4);
            swPr._isMergeFailed = response.intValue(5) == 3;
            swPr._globalCfsState = response.intValue(6) == 1;
            obb[2] = swPr;
            featureList.add(obb);
        }
        return featureList;
    }

    private ArrayList buildDpvmFeatureList(SnmpPeer[] peers) throws SnmpException {
        ArrayList<Object[]> featureList = new ArrayList<Object[]>();
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("cfcFeatureCtrlOpStatus").getOid(), new int[]{18});
        vbl.add(MibNode.get("cfsFeatureOpStatus").getOid(), DPVM_INDEX);
        vbl.add(MibNode.get("cfsPendingConfOwnerID").getOid(), DPVM_CFS_INDEX);
        vbl.add(MibNode.get("cfsPendingConfOwnerIDType").getOid(), DPVM_CFS_INDEX);
        vbl.add(MibNode.get("cfsPendingConfOwnerAddr").getOid(), DPVM_CFS_INDEX);
        vbl.add(MibNode.get("cfsMergeStatusValue").getOid(), DPVM_CFS_INDEX);
        SnmpPDU[] pdus = new SnmpAggregrate().get(peers, vbl);
        for (int i = 0; i < pdus.length; ++i) {
            if (pdus[i].getError() != 0) {
                throw new SnmpException(pdus[i].getAddress().getHostName() + ": " + SnmpException.toError(pdus[i].getError()));
            }
            VarBindList response = pdus[i].getVariables();
            if (response == null) continue;
            Object[] obb = new Object[3];
            obb[0] = ClientController.findFabricSwitchByIpAddress(pdus[i].getAddress()).getPeer();
            obb[1] = new int[]{response.intValue(0) != 2 ? 1 : 2};
            CfsSwitchPeer swPr = new CfsSwitchPeer();
            swPr._peer = (SnmpPeer)obb[0];
            swPr._sw = ClientController.findFabricSwitchByIpAddress(swPr._peer.getAddress());
            swPr._featureName = "DPVM";
            int[] feature = (int[])obb[1];
            swPr._featureState = feature[0] != 1;
            swPr._cfs = response.intValue(1) == 2;
            swPr._lockedBy = response.stringValue(2);
            swPr._lockIdType = response.intValue(3);
            swPr._lockedOn = response.byteValue(4);
            swPr._isMergeFailed = response.intValue(5) == 3;
            obb[2] = swPr;
            featureList.add(obb);
        }
        return featureList;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        if (e.getSource() == this.select.getButton(0)) {
            this.adjustControls(true);
        } else if (e.getSource() == this.select.getButton(1)) {
            this.adjustControls(false);
        }
    }

    private void adjustControls(boolean commission) {
        this.deviceAliasField.setEnabled(commission);
        this._changeVsanChkBox.setEnabled(commission);
        if (this.labels != null) {
            this.labels[5].setEnabled(commission);
        }
        this.adjustPanels();
    }

    private void adjustPanels() {
        int count;
        for (count = this.getWizard().getPanelCount(); count > 1; --count) {
            this.getWizard().removePanelAt(count);
        }
        if (!this._skipZoningChkBox.isSelected()) {
            if (this.select.getSelected() == 0) {
                this.getWizard().addPanel("select storage ports", new StoragePortsPanel(this.getWizard()));
                this.getWizard().addPanel("select zone, zoneset", new HSZoneSetPanel(this.getWizard(), "3 of 3: Select Zone", HostCommisioningWizard._ImagePc));
                this.setTitle("1 of 3: Select Host");
            } else if (this.select.getSelected() == 1) {
                this.setTitle("1 of 2: Select Host");
                this.getWizard().addPanel("select storage ports", new DecommisionZone(this.getWizard(), "2 of 2: Decommission Zones", HostCommisioningWizard._ImagePc));
            }
            this.getWizard().getNavigator().setButtonAttr(false, false);
            this.detailBtn[0].setVisible(false);
            this.detailBtn[1].setVisible(false);
        } else if (count == 1) {
            this.setTitle("1 of 1: Select Host");
            this.getWizard().getNavigator().setButtonAttr(false, true);
            this.detailBtn[0].setVisible(true);
            this.detailBtn[1].setVisible(true);
        }
    }

    public boolean preRunValidate(boolean showDetails) {
        try {
            JTextArea zoneDetails;
            ArrayList daFtrLst = this.buildDAFeatureList(this.all313Peers);
            StringBuffer errBuf = new StringBuffer();
            boolean allEnhancedMode = true;
            for (int i = 0; i < daFtrLst.size(); ++i) {
                StringBuffer errSw = new StringBuffer();
                Object[] data = (Object[])daFtrLst.get(i);
                int[] dataState = (int[])data[1];
                if (i == 0) {
                    boolean bl = allEnhancedMode = dataState[0] == 2;
                }
                if (allEnhancedMode && dataState[0] != 2 || !allEnhancedMode && dataState[0] != 1) {
                    errSw.append("All Switches Device Alias should be either Basic or Enhanced. ");
                }
                CfsSwitchPeer swPr = (CfsSwitchPeer)data[2];
                if (!swPr._cfs) {
                    errSw.append((errSw.length() > 0 ? ",CFS" : "CFS for Device Alias") + " not enabled. ");
                } else {
                    if (swPr.isLocked()) {
                        errSw.append((errSw.length() > 0 ? "," : "Device Alias ") + "Locked by" + swPr._lockedBy);
                    }
                    if (swPr._isMergeFailed) {
                        errSw.append((errSw.length() > 0 ? "," : "Device Alias ") + "Merge failed");
                    }
                }
                if (swPr._cfs && !swPr._globalCfsState) {
                    errSw.append((errSw.length() > 0 ? "," : "") + " Global CFS for Device Alias not enabled. ");
                }
                if (errSw.length() <= 0) continue;
                errSw.insert(0, "\n" + data[0] + ":");
                errBuf.append(errSw.toString());
            }
            if (!this.getWizard().isVisible()) {
                return false;
            }
            this.getWizard().setStatus(this._skipDpvmChkBox.isSelected() ? "Skipping DPVM switch status" : "Fetching DPVM switch status...");
            DefaultLogger._DefLogger.info((Object)(this._skipDpvmChkBox.isSelected() ? "Skipping DPVM switch status" : "Fetching DPVM switch status..."));
            JTextArea jTextArea = zoneDetails = this._logDialog != null && this._logDialog.isVisible() ? this._logDialog.getTextArea() : null;
            if (zoneDetails != null) {
                zoneDetails.append(this._skipDpvmChkBox.isSelected() ? "Skipping DPVM switch status\n" : "Fetching DPVM switch status...\n");
            }
            if (!this._skipDpvmChkBox.isSelected()) {
                ArrayList dpvmFtrLst = this.buildDpvmFeatureList(this.all313Peers);
                for (int i = 0; i < daFtrLst.size(); ++i) {
                    StringBuffer errSw = new StringBuffer();
                    Object[] data = (Object[])dpvmFtrLst.get(i);
                    int[] dataState = (int[])data[1];
                    if (dataState[0] == 1) {
                        errSw.append("DPVM");
                    }
                    CfsSwitchPeer swPr = (CfsSwitchPeer)data[2];
                    if (!swPr._cfs) {
                        errSw.append((errSw.length() > 0 ? ",CFS" : "CFS for DPVM") + " not enabled. ");
                    } else {
                        if (swPr.isLocked()) {
                            errSw.append((errSw.length() > 0 ? "," : "DPVM ") + "Locked by" + swPr._lockedBy);
                        }
                        if (swPr._isMergeFailed) {
                            errSw.append((errSw.length() > 0 ? "," : "DPVM ") + "Merge failed");
                        }
                    }
                    if (errSw.length() <= 0) continue;
                    errSw.insert(0, "\n" + data[0] + ":");
                    errBuf.append(errSw.toString());
                }
            }
            if (errBuf.length() > 0) {
                if (zoneDetails != null) {
                    zoneDetails.append(errBuf.toString() + "\n");
                }
                if (!showDetails && JOptionPane.showConfirmDialog(this.getWizard(), errBuf.toString() + "\n\nIt is recommended to have all switches in consistent state.\n" + "Host Provisioning may not succeed. Continue?", "Feature Error", 0) != 0) {
                    return false;
                }
            }
        }
        catch (SnmpException exx) {
            Util.errorMessage((Component)this, exx.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runAction(boolean showDetails) throws SnmpException, IOException {
        JTextArea zoneDetails;
        this.getWizard().setCursor(Cursor.getPredefinedCursor(3));
        Vsan selVsan = (Vsan)this.vsanCb.getSelectedItem();
        SnmpPeer pr1 = ((Switch)this.switchCb.getSelectedItem()).getSnmpPeer();
        this.getWizard().setStatus("Fetching Device Alias mode...");
        StringBuffer errBuf = new StringBuffer();
        boolean commission = this.select.getSelected() == 0;
        JTextArea jTextArea = zoneDetails = this._logDialog != null && this._logDialog.isVisible() ? this._logDialog.getTextArea() : null;
        if (!this.getWizard().isVisible()) {
            return;
        }
        VshBase vsh = null;
        try {
            vsh = Vsh.getNew(null, pr1.getAddress().getHostAddress(), pr1.getUserName(), pr1.getAuthPassword(), ExternalTools._UseSSH, null);
            if (vsh == null) {
                throw new IOException("Unable to open connection to " + pr1);
            }
            this.getWizard().setStatus("Verify existing Device Alias for Host WWN...");
            if (!this.getWizard().isVisible()) {
                return;
            }
            String daData = "";
            int pwwnId = -1;
            if (this.select.getSelected() == 0) {
                daData = this.executeAndLogCLICmd("show device-alias name " + this.deviceAliasField.getText().trim() + "\n", vsh, false);
                pwwnId = daData.indexOf("pwwn");
                if (pwwnId != -1 && !daData.substring(pwwnId + 4).trim().equals(this.endPortField.getText().trim())) {
                    errBuf.append("Wwn " + daData.substring(pwwnId + 4).trim() + " is associated with selected Device Alias. \n");
                } else if (pwwnId == -1 && daData.indexOf("^") != -1) {
                    errBuf.append("Invalid Device Alias name length. Error:" + daData);
                }
            }
            this.getWizard().setStatus("Verify existing WWN for suggested Device Alias...");
            if (!this.getWizard().isVisible()) {
                return;
            }
            daData = this.executeAndLogCLICmd("show device-alias pwwn " + this.endPortField.getText().trim() + "\n", vsh, false);
            int nameId = daData.indexOf("name");
            if (nameId != -1) {
                pwwnId = daData.indexOf("pwwn");
                String configDA = daData.substring(nameId + 5, pwwnId).trim();
                if (commission && !configDA.equals(this.deviceAliasField.getText().trim())) {
                    errBuf.append("Selected WWN already associated with Alias '" + configDA + "'.\n");
                } else {
                    this.deviceAliasField.setText(configDA != null ? configDA.trim() : "");
                    this.getWizard().setModelValue("CONFIGED_DEVICE_ALIAS_NAME", configDA);
                }
            }
            if (errBuf.length() > 0) {
                throw new SnmpException(errBuf.toString());
            }
            this.getWizard().setStatus(this._skipDpvmChkBox.isSelected() ? "Skipping DPVM check" : "Verify existing DPVM config for Host WWN...");
            DefaultLogger._DefLogger.info((Object)(this._skipDpvmChkBox.isSelected() ? "Skipping DPVM check" : "Verify existing DPVM config for Host WWN..."));
            if (zoneDetails != null) {
                zoneDetails.append(this._skipDpvmChkBox.isSelected() ? "Skipping DPVM check\n" : "Verify existing DPVM config for Host WWN...\n");
            }
            if (!this.getWizard().isVisible()) {
                return;
            }
            if (!this._skipDpvmChkBox.isSelected()) {
                if (!this.getWizard().isVisible()) {
                    return;
                }
                daData = this.executeAndLogCLICmd("show dpvm databas active  | inc " + this.endPortField.getText().trim() + "\n", vsh, false);
                int vsanInd = daData.indexOf("vsan");
                if (vsanInd != -1) {
                    String vsaIdConfig = daData.substring(vsanInd + 5).trim();
                    if (commission && !vsaIdConfig.equals(new Integer(selVsan.getVsanId()).toString())) {
                        errBuf.append("Selected wwn already configured for different VSAN ID:" + vsaIdConfig + ".\n");
                    } else {
                        try {
                            this.vsanCb.setSelectedItem(((Switch)this.switchCb.getSelectedItem()).getVsan(Short.parseShort(vsaIdConfig)));
                        }
                        catch (NumberFormatException exN) {
                            // empty catch block
                        }
                        this.getWizard().setModelValue("CONFIGED_VSAN", vsaIdConfig);
                    }
                }
            }
            if (!this._skipZoningChkBox.isSelected()) {
                boolean enhancedMode;
                if (!this.getWizard().isVisible()) {
                    return;
                }
                daData = this.executeAndLogCLICmd("show zone status vsan " + selVsan.getVsanId() + " | inc mode\n", vsh, false);
                boolean bl = enhancedMode = daData.indexOf("enhanced") != -1;
                if (enhancedMode) {
                    int ssnId;
                    if (!this.getWizard().isVisible()) {
                        return;
                    }
                    daData = this.executeAndLogCLICmd("show zone status vsan " + selVsan.getVsanId() + " | inc session\n", vsh, false);
                    if (daData.indexOf("none") == -1 && (ssnId = daData.indexOf(":")) != -1) {
                        int promptId = daData.indexOf(vsh.getPrompt());
                        errBuf.append("Zone database for VSAN " + selVsan + " is locked by " + (promptId > ssnId ? daData.substring(ssnId, promptId - 1) : daData.substring(ssnId)) + "Please clear pending changes to zones and restart the wizard.");
                    }
                }
            }
            if (errBuf.length() > 0) {
                throw new SnmpException(errBuf.toString());
            }
            this.cacheData();
            ((HostCommisioningWizard)this.getWizard()).verifyChangedVsanExists(showDetails, zoneDetails);
            if (this.getWizard().getNavigator().getNextBtn().getMnemonic() == 70) {
                ((HostCommisioningWizard)this.getWizard()).changeHostVsan(showDetails, zoneDetails);
                this.runCommDecommissionCommands(vsh, showDetails);
            }
        }
        finally {
            if (vsh != null) {
                vsh.disconnect();
                vsh = null;
            }
            this.setProcessing(false);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectHostPanel.this.getWizard().getNavigator().getNextBtn().setEnabled(true);
                SelectHostPanel.this.getWizard().setCursor(Cursor.getDefaultCursor());
            }
        });
        if (!showDetails) {
            this.runFinished();
        }
    }

    private String executeAndLogCLICmd(String cliCommand, VshBase vsh, boolean showOnly) throws IOException {
        JTextArea zoneDetails;
        JTextArea jTextArea = zoneDetails = this._logDialog != null && this._logDialog.isVisible() ? this._logDialog.getTextArea() : null;
        if (!showOnly) {
            DefaultLogger._DefLogger.info((Object)("Command:" + cliCommand));
            vsh.send(cliCommand);
            String daData = vsh.readPrompt();
            DefaultLogger._DefLogger.info((Object)("Output:" + daData));
            if (zoneDetails != null) {
                zoneDetails.append(daData);
            }
            return daData.substring(cliCommand.length(), daData.indexOf(vsh.getPrompt()));
        }
        if (zoneDetails != null) {
            zoneDetails.append(cliCommand);
        }
        return null;
    }

    private void runCommDecommissionCommands(VshBase vsh, boolean showOnly) throws SnmpException, IOException {
        JTextArea zoneDetails = this._logDialog != null && this._logDialog.isVisible() ? this._logDialog.getTextArea() : null;
        ((HostCommisioningWizard)this.getWizard()).runCLIActions(zoneDetails, vsh, showOnly);
    }
}

