/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.ioa;

import com.cisco.dcbu.sm.client.ioa.IOATableModel;
import com.cisco.dcbu.sm.common.model.ioa.Flow;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import java.util.ArrayList;

public class FlowTableModel
extends IOATableModel
implements ContextSensitiveTableModel {
    private static final long serialVersionUID = 1L;
    private boolean isCandidate;
    static final String[] ACTIVE_LABELS = new String[]{"Vsan", "Initiator", "Target", "FlowGroup", "Compression", "WA", "TA", "Status"};
    static final String[] CANDIDATE_LABELS = new String[]{"Vsan", "Initiator", "Target"};
    static final int VSAN = 0;
    static final int INITIATOR = 1;
    static final int TARGET = 2;
    static final int FLOWGROUP = 3;
    static final int COMPRESSION = 4;
    static final int WA = 5;
    static final int TA = 6;
    static final int STATUS = 7;
    static final int THEOBJECT = 8;
    static final int MODIFIED = 9;

    FlowTableModel() {
        this.setHeaders(ACTIVE_LABELS);
    }

    FlowTableModel(boolean candidate) {
        this.isCandidate = candidate;
        if (this.isCandidate) {
            this.setHeaders(CANDIDATE_LABELS);
        } else {
            this.setHeaders(ACTIVE_LABELS);
        }
    }

    @Override
    public int getObjectIndex() {
        return 8;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Class<?> getCellClassAt(int row, int column) {
        if (column == 4 || column == 5 || column == 6) {
            return Boolean.class;
        }
        return null;
    }

    public ConverterContext getConverterContextAt(int row, int column) {
        return null;
    }

    public EditorContext getEditorContextAt(int row, int column) {
        return null;
    }

    @Override
    public void updateData(ArrayList memberList) {
        ArrayList<Object[]> theData = new ArrayList<Object[]>();
        if (memberList != null) {
            for (Object theMember : memberList) {
                Flow theFlow = (Flow)theMember;
                Object[] o = new Object[10];
                boolean isSpecial = false;
                if (theFlow.getInitiator().isBoth() && theFlow.getTarget().isBoth()) {
                    isSpecial = true;
                }
                o[0] = theFlow.getVsanId() == -1 ? "IVR(" + theFlow.getInitiator().getVsan().toString() + ":" + theFlow.getTarget().getVsan().toString() + ")" : "VSAN" + theFlow.getVsanId();
                o[1] = theFlow.getInitiator().getDisplayString();
                o[2] = theFlow.getTarget().getDisplayString();
                if (this.isCandidate) {
                    if (isSpecial) {
                        o[1] = "* " + o[1];
                    }
                } else {
                    o[3] = theFlow.getFlowGroupName();
                    o[4] = theFlow.isUseCompression();
                    o[5] = theFlow.isUseWA();
                    o[6] = theFlow.isUseTA();
                    o[7] = theFlow.getStatus();
                }
                o[8] = theFlow;
                o[9] = false;
                theData.add(o);
            }
        }
        this.setData(theData);
    }
}

