/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.ioa;

import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.ioa.OperationStatus;
import com.cisco.dcbu.sm.client.ioa.OperationStatusEnum;
import com.cisco.dcbu.sm.common.model.ioa.Cluster;
import com.cisco.dcbu.sm.common.model.ioa.Flow;
import com.cisco.dcbu.sm.common.model.ioa.IOAInterface;
import com.cisco.dcbu.sm.common.model.ioa.InterfaceStats;
import com.cisco.dcbu.sm.common.model.ioa.Site;
import com.cisco.dcbu.sm.common.model.ioa.Switch;
import com.cisco.dcbu.sm.common.rif.IOARif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.server.ioa.common.IOAContext;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class IOACache {
    private IOARif ioa = null;
    private IOAContext context;
    private ArrayList<FabricPK> fabricList;
    private FabricPK activeFabric;
    private ArrayList<Site> siteList;
    private ArrayList<Cluster> clusterList;
    private ArrayList<Switch> assignedSwitchList;
    private ArrayList<Switch> unassignedSwitchList;
    private Object lastSelectedNode;
    private TreePath lastSelectedPath;
    private Cluster activeCluster;
    private ArrayList<Flow> candidateFlowList;
    private ArrayList<Flow> flowList;
    private ArrayList<IOAInterface> candidateInterfaceList;
    private Site activeSite;
    private boolean needsApply = false;
    private boolean showAllFlows = false;
    private OperationStatus swingWorkerStatus;
    private boolean customDescription = false;
    private String swingWorkerSiteName;
    private String swingWorkerClusterName;
    private Switch swingWorkerSwitch;
    private ArrayList<OperationStatus> swingWorkerOps;
    public static Logger _Logger = Logger.getLogger((String)"IOA");

    public IOACache() {
        this.context = new IOAContext();
        ClientController cc = ClientController.getInstance();
        if (cc != null) {
            this.context.username = "" + cc.getFMUsername();
            if (cc.getFMPassword() != null) {
                this.context.password = new String(cc.getFMPassword());
            }
        }
    }

    public IOACache(IOAContext context) {
        this.context = context;
    }

    public String toString() {
        return "IOA";
    }

    public IOAContext getContext() {
        return this.context;
    }

    public void setContext(IOAContext context) {
        this.context = context;
    }

    public IOARif getIoa() {
        if (this.ioa == null) {
            try {
                this.ioa = ClientController.getInstance().assertIOA();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.ioa;
    }

    public void setIoa(IOARif ioa) {
        this.ioa = ioa;
    }

    public Cluster getActiveCluster() {
        return this.activeCluster;
    }

    public void setActiveCluster(Cluster activeCluster) {
        this.activeCluster = activeCluster;
        this.setShowAllFlows(false);
    }

    public FabricPK getActiveFabric() {
        return this.activeFabric;
    }

    public void setActiveFabric(FabricPK activeFabric) {
        if (activeFabric != this.context.fabric) {
            this.context.clusterName = null;
            this.context.masterSwitch = null;
            this.activeCluster = null;
        }
        this.context.fabric = activeFabric;
        this.activeFabric = activeFabric;
    }

    public Object getLastSelectedNode() {
        return this.lastSelectedNode;
    }

    public void setLastSelectedNode(Object lastSelectedNode) {
        this.lastSelectedNode = lastSelectedNode;
    }

    public Site getActiveSite() {
        return this.activeSite;
    }

    public void setActiveSite(Site activeSite) {
        this.activeSite = activeSite;
    }

    public ArrayList<Site> getSitesList() {
        if (this.siteList == null) {
            return new ArrayList<Site>();
        }
        return this.siteList;
    }

    public void setSitesList(ArrayList<Site> siteList) {
        this.siteList = siteList;
        if (this.activeSite != null && siteList != null) {
            for (Site s : siteList) {
                if (!this.activeSite.equals(s)) continue;
                this.activeSite.setMemberList(s.getMemberList());
            }
        }
    }

    public Site getSite(String name) {
        for (Site s : this.siteList) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public ArrayList<Cluster> getClusterList() {
        if (this.clusterList == null) {
            return new ArrayList<Cluster>();
        }
        return this.clusterList;
    }

    public void setClusterList(ArrayList<Cluster> clusterList) {
        this.clusterList = clusterList;
        boolean found = false;
        if (this.activeCluster != null && clusterList != null) {
            for (Cluster c : clusterList) {
                if (!this.activeCluster.equals(c)) continue;
                this.activeCluster.update(c);
                found = true;
            }
        }
        if (!found) {
            this.activeCluster = null;
            this.context.clusterName = "";
        }
    }

    public Cluster getCluster(String clusterName) {
        if (this.clusterList == null) {
            return null;
        }
        for (Cluster c : this.clusterList) {
            if (!c.getName().equals(clusterName)) continue;
            return c;
        }
        return null;
    }

    public ArrayList<Switch> getUnassignedSwitchList() {
        return this.unassignedSwitchList;
    }

    public void setUnassignedSwitchList(ArrayList<Switch> unassignedSwitchList) {
        this.unassignedSwitchList = unassignedSwitchList;
    }

    public ArrayList<Switch> getAssignedSwitchList() {
        return this.assignedSwitchList;
    }

    public void setAssignedSwitchList(ArrayList<Switch> assignedSwitchList) {
        this.assignedSwitchList = assignedSwitchList;
    }

    public ArrayList<Flow> getCandidateFlowList() {
        return this.candidateFlowList;
    }

    public void setCandidateFlowList(ArrayList<Flow> candidateFlowList) {
        this.candidateFlowList = candidateFlowList;
        if (candidateFlowList != null && !candidateFlowList.isEmpty()) {
            for (Flow f : this.flowList) {
                Iterator<Flow> iter = candidateFlowList.iterator();
                while (iter.hasNext()) {
                    Flow cf = iter.next();
                    if (!f.getInitiator().getWwnBrief().equals(cf.getInitiator().getWwnBrief()) || !f.getTarget().getWwnBrief().equals(cf.getTarget().getWwnBrief())) continue;
                    iter.remove();
                }
            }
        }
    }

    public ArrayList<FabricPK> getFabricList() {
        return this.fabricList;
    }

    public void setFabricList(ArrayList<FabricPK> fabricList) {
        this.fabricList = fabricList;
    }

    public ArrayList<Flow> getFlowList() {
        return this.flowList;
    }

    public void setFlowList(ArrayList<Flow> flowList) {
        this.flowList = flowList;
    }

    public ArrayList<IOAInterface> getCandidateInterfaceList() {
        return this.candidateInterfaceList;
    }

    public void setCandidateInterfaceList(ArrayList<IOAInterface> candidateInterfaceList) {
        this.candidateInterfaceList = candidateInterfaceList;
    }

    public OperationStatus createCluster(String clusterName, Switch masterSwitch) {
        OperationStatus oper = new OperationStatus();
        this.context.clusterName = clusterName;
        this.context.masterSwitch = masterSwitch;
        try {
            this.ioa.createCluster(this.context);
            oper.setStatus(OperationStatusEnum.Success);
        }
        catch (RemoteException e) {
            _Logger.error((Object)"Exception", (Throwable)e);
            String msg = e.getMessage();
            if (e.detail != null) {
                msg = e.detail.getMessage();
            }
            oper.setStatus(OperationStatusEnum.Failure);
            oper.setDescription(msg);
        }
        return oper;
    }

    public OperationStatus deleteCluster(String clusterName) {
        OperationStatus oper = new OperationStatus();
        try {
            this.context.clusterName = clusterName;
            this.ioa.deleteCluster(this.context);
            oper.setStatus(OperationStatusEnum.Success);
            this.context.clusterName = null;
            this.activeCluster = null;
        }
        catch (RemoteException e) {
            _Logger.error((Object)"Exception", (Throwable)e);
            String msg = e.getMessage();
            if (e.detail != null) {
                msg = e.detail.getMessage();
            }
            oper.setStatus(OperationStatusEnum.Failure);
            oper.setDescription(msg);
        }
        return oper;
    }

    public OperationStatus addClusterSite(Switch sw) {
        OperationStatus oper = new OperationStatus();
        String siteName = sw.getSiteName();
        if (siteName == null) {
            oper.setStatus(OperationStatusEnum.Failure);
            oper.setDescription("Site name is null");
            return oper;
        }
        try {
            this.ioa.addClusterSite(this.context, siteName, sw);
            oper.setStatus(OperationStatusEnum.Success);
        }
        catch (RemoteException e) {
            _Logger.error((Object)"Exception", (Throwable)e);
            String msg = e.getMessage();
            if (e.detail != null) {
                msg = e.detail.getMessage();
            }
            oper.setStatus(OperationStatusEnum.Failure);
            oper.setDescription(msg);
        }
        return oper;
    }

    public OperationStatus addSiteToSwitch(String siteName, Switch sw) {
        OperationStatus oper = new OperationStatus();
        try {
            this.ioa.addSwitchToSite(this.activeFabric, sw, siteName);
            oper.setStatus(OperationStatusEnum.Success);
            Site s = this.getSite(siteName);
            if (s == null) {
                s = new Site(siteName, null);
                this.siteList.add(s);
                sw.setSiteName(siteName);
                s.getMemberList().add(sw);
                this.unassignedSwitchList.remove(sw);
            }
        }
        catch (RemoteException e) {
            _Logger.error((Object)"Exception", (Throwable)e);
            String msg = e.getMessage();
            if (e.detail != null) {
                msg = e.detail.getMessage();
            }
            oper.setStatus(OperationStatusEnum.Failure);
            oper.setDescription(msg);
        }
        return oper;
    }

    public OperationStatus removeSiteFromSwitch(Switch sw) {
        OperationStatus oper = new OperationStatus();
        try {
            this.ioa.removeSwitchFromSite(this.activeFabric, sw);
            oper.setStatus(OperationStatusEnum.Success);
            Site s = this.getSite(sw.getSiteName());
            if (s != null) {
                s.getMemberList().remove(sw);
            }
            sw.setSiteName("");
            if (!this.unassignedSwitchList.contains(sw)) {
                this.unassignedSwitchList.add(sw);
            }
        }
        catch (RemoteException e) {
            _Logger.error((Object)"Exception", (Throwable)e);
            String msg = e.getMessage();
            if (e.detail != null) {
                msg = e.detail.getMessage();
            }
            oper.setStatus(OperationStatusEnum.Failure);
            oper.setDescription(msg);
        }
        return oper;
    }

    public OperationStatus removeSite(Site site) {
        OperationStatus oper = new OperationStatus();
        ArrayList<Switch> switches = site.getMemberList();
        boolean errors = false;
        Iterator<Switch> iter = switches.iterator();
        while (iter.hasNext()) {
            Switch s = iter.next();
            try {
                this.ioa.removeSwitchFromSite(this.activeFabric, s);
                oper.setStatus(OperationStatusEnum.Success);
                iter.remove();
                s.setSiteName("");
                this.unassignedSwitchList.add(s);
            }
            catch (RemoteException e) {
                _Logger.error((Object)"Exception", (Throwable)e);
                errors = true;
            }
        }
        if (errors) {
            oper.setStatus(OperationStatusEnum.Failure);
            oper.setDescription("Removing site label failed for one or more switches");
        } else {
            this.siteList.remove(site);
        }
        return oper;
    }

    public OperationStatus addClusterInterface(IOAInterface intf) {
        ArrayList<Switch> members;
        Switch sw;
        OperationStatus oper = new OperationStatus();
        boolean addedNode = false;
        boolean removeNode = false;
        Cluster c = this.activeCluster;
        try {
            this.context.clusterName = this.activeCluster.getName();
            sw = intf.getSwitchInfo();
            members = c.getMembers();
            if (!members.contains(sw)) {
                this.ioa.addClusterNode(this.context, sw, sw.getSiteName());
                members.add(sw);
                addedNode = true;
            } else {
                for (Switch s : members) {
                    if (!s.equals(sw)) continue;
                    intf.setSwitchInfo(s);
                }
            }
        }
        catch (RemoteException e) {
            _Logger.error((Object)"error adding cluster node", (Throwable)e);
            String msg = e.getMessage();
            if (e.detail != null) {
                msg = e.detail.getMessage();
            }
            oper.setStatus(OperationStatusEnum.Failure);
            oper.setDescription(msg);
            return oper;
        }
        try {
            this.ioa.addClusterInterface(this.context, intf);
            oper.setStatus(OperationStatusEnum.Success);
            c.getInterfaceList().add(intf);
        }
        catch (RemoteException e) {
            _Logger.error((Object)"error adding cluster interface", (Throwable)e);
            String msg = e.getMessage();
            if (e.detail != null) {
                msg = e.detail.getMessage();
            }
            oper.setStatus(OperationStatusEnum.Failure);
            oper.setDescription(msg);
            removeNode = true;
        }
        if (removeNode) {
            sw = intf.getSwitchInfo();
            try {
                this.ioa.deleteClusterNode(this.context, sw);
                members = c.getMembers();
                members.remove(sw);
            }
            catch (RemoteException e) {
                _Logger.error((Object)"after error adding cluster interface, failed to remove cluster node", (Throwable)e);
            }
        }
        return oper;
    }

    public OperationStatus removeClusterInterface(IOAInterface intf) {
        OperationStatus oper = new OperationStatus();
        oper = this.ioaInterfaceAdminShut(intf);
        boolean shutFailed = false;
        if (!oper.status.equals(OperationStatusEnum.Success)) {
            shutFailed = true;
        }
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException e1) {
            // empty catch block
        }
        try {
            this.ioa.deleteClusterInterface(this.context, intf);
            oper.setStatus(OperationStatusEnum.Success);
        }
        catch (RemoteException e) {
            _Logger.error((Object)"Exception", (Throwable)e);
            if (!shutFailed) {
                String msg = e.getMessage();
                if (e.detail != null) {
                    msg = e.detail.getMessage();
                }
                oper.setStatus(OperationStatusEnum.Failure);
                oper.setDescription(msg);
            }
            return oper;
        }
        Switch sw = intf.getSwitchInfo();
        Cluster c = this.activeCluster;
        c.getInterfaceList().remove(intf);
        boolean found = false;
        for (IOAInterface ioaIntf : c.getInterfaceList()) {
            if (ioaIntf.equals(intf) || !sw.equals(ioaIntf.getSwitchInfo())) continue;
            found = true;
        }
        if (!found && !intf.getSwitchInfo().isMaster()) {
            try {
                this.ioa.deleteClusterNode(this.context, sw);
            }
            catch (RemoteException e) {
                oper.setDescription("Interface removed but cluster node removal failed");
            }
        }
        return oper;
    }

    public OperationStatus ioaInterfaceAdminShut(IOAInterface intf) {
        OperationStatus oper = new OperationStatus();
        try {
            this.ioa.ioaInterfaceAdminShut(this.context, intf);
            oper.setStatus(OperationStatusEnum.Success);
        }
        catch (RemoteException e) {
            _Logger.error((Object)"Exception", (Throwable)e);
            String msg = e.getMessage();
            if (e.detail != null) {
                msg = e.detail.getMessage();
            }
            oper.setStatus(OperationStatusEnum.Failure);
            oper.setDescription(msg);
        }
        return oper;
    }

    public OperationStatus ioaInterfaceAdminNoShut(IOAInterface intf) {
        OperationStatus oper = new OperationStatus();
        try {
            this.ioa.ioaInterfaceAdminNoShut(this.context, intf);
            oper.setStatus(OperationStatusEnum.Success);
        }
        catch (RemoteException e) {
            _Logger.error((Object)"Exception", (Throwable)e);
            String msg = e.getMessage();
            if (e.detail != null) {
                msg = e.detail.getMessage();
            }
            oper.setStatus(OperationStatusEnum.Failure);
            oper.setDescription(msg);
        }
        return oper;
    }

    public OperationStatus addFlow(Flow flow) {
        OperationStatus oper = new OperationStatus();
        try {
            this.ioa.manageFlow(this.context, flow);
            oper.setStatus(OperationStatusEnum.Success);
        }
        catch (RemoteException e) {
            _Logger.error((Object)"Exception", (Throwable)e);
            String msg = e.getMessage();
            if (e.detail != null) {
                msg = e.detail.getMessage();
            }
            oper.setStatus(OperationStatusEnum.Failure);
            oper.setDescription(msg);
        }
        return oper;
    }

    public OperationStatus removeFlow(Flow flow) {
        OperationStatus oper = new OperationStatus();
        try {
            this.ioa.removeFlow(this.context, flow);
            oper.setStatus(OperationStatusEnum.Success);
        }
        catch (RemoteException e) {
            _Logger.error((Object)"remove flow Exception", (Throwable)e);
            String msg = e.getMessage();
            if (e.detail != null) {
                msg = e.detail.getMessage();
            }
            oper.setStatus(OperationStatusEnum.Failure);
            oper.setDescription(msg);
        }
        return oper;
    }

    public OperationStatus modifyFlow(Flow flow) {
        OperationStatus oper = new OperationStatus();
        try {
            this.ioa.modifyFlow(this.context, flow);
            oper.setStatus(OperationStatusEnum.Success);
        }
        catch (RemoteException e) {
            _Logger.error((Object)"modify flow Exception", (Throwable)e);
            String msg = e.getMessage();
            if (e.detail != null) {
                msg = e.detail.getMessage();
            }
            oper.setStatus(OperationStatusEnum.Failure);
            oper.setDescription(msg);
        }
        return oper;
    }

    public InterfaceStats getStatsForInterface(String ipAddress, int ifIndex) {
        InterfaceStats stats = null;
        try {
            stats = this.ioa.getStatsForInterface(this.context, ipAddress, ifIndex);
        }
        catch (RemoteException e) {
            stats = new InterfaceStats();
        }
        if (stats == null) {
            stats = new InterfaceStats();
        }
        return stats;
    }

    public void setNeedsApply(boolean applyState) {
        this.needsApply = applyState;
    }

    public boolean getNeedsApply() {
        return this.needsApply;
    }

    public TreePath getLastSelectedPath() {
        return this.lastSelectedPath;
    }

    public void setLastSelectedPath(TreePath lastSelectedPath) {
        this.lastSelectedPath = lastSelectedPath;
    }

    public OperationStatus getSwingWorkerStatus() {
        return this.swingWorkerStatus;
    }

    public void setSwingWorkerStatus(OperationStatus swingWorkerStatus) {
        this.swingWorkerStatus = swingWorkerStatus;
    }

    public boolean isCustomDescription() {
        return this.customDescription;
    }

    public void setCustomDescription(boolean customDescription) {
        this.customDescription = customDescription;
    }

    public String getSwingWorkerSiteName() {
        return this.swingWorkerSiteName;
    }

    public void setSwingWorkerSiteName(String swingWorkerSiteName) {
        this.swingWorkerSiteName = swingWorkerSiteName;
    }

    public Switch getSwingWorkerSwitch() {
        return this.swingWorkerSwitch;
    }

    public void setSwingWorkerSwitch(Switch swingWorkerSwitch) {
        this.swingWorkerSwitch = swingWorkerSwitch;
    }

    public ArrayList<OperationStatus> getSwingWorkerOps() {
        return this.swingWorkerOps;
    }

    public void setSwingWorkerOps(ArrayList<OperationStatus> swingWorkerOps) {
        this.swingWorkerOps = swingWorkerOps;
    }

    public String getSwingWorkerClusterName() {
        return this.swingWorkerClusterName;
    }

    public void setSwingWorkerClusterName(String swingWorkerClusterName) {
        this.swingWorkerClusterName = swingWorkerClusterName;
    }

    public boolean isShowAllFlows() {
        return this.showAllFlows;
    }

    public void setShowAllFlows(boolean showAllFlows) {
        this.showAllFlows = showAllFlows;
    }
}

