/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.ioa;

import com.cisco.dcbu.sm.common.model.ioa.InterfaceStats;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Observable;
import java.util.Vector;
import jclass.chart.Chartable;

public class IOAChartModel
extends Observable
implements Chartable {
    int _maxElements = 20;
    Vector _data = new Vector(3);
    String[] _labels;
    String[] _xAxisLabels;
    long _startTime;
    InterfaceStats _previousStats;

    public IOAChartModel(int type) throws Exception {
        int maxElements = this._maxElements;
        this._data.add(new Vector(maxElements));
        this._data.add(new Vector(maxElements));
        this._data.add(new Vector(maxElements));
        this._labels = new String[2];
        this._labels[0] = "Device Bytes In";
        this._labels[1] = "Device Bytes Out";
        this._startTime = System.currentTimeMillis();
    }

    public void addRow(int type, InterfaceStats stats) throws Exception {
        Vector time = (Vector)this._data.get(0);
        while (time.size() > this._maxElements) {
            for (int i = 0; i < this._data.size(); ++i) {
                Vector row = (Vector)this._data.get(i);
                row.remove(0);
            }
        }
        time.add(new Long((System.currentTimeMillis() - this._startTime) / 1000L));
        if (this._previousStats != null) {
            BigInteger previousDbi = this._previousStats.getDeviceBytesIn();
            BigInteger previousDbo = this._previousStats.getDeviceBytesOut();
            BigInteger actualDbi = stats.getDeviceBytesIn().subtract(previousDbi);
            BigInteger actualDbo = stats.getDeviceBytesOut().subtract(previousDbo);
            if (actualDbi.intValue() < 0) {
                actualDbi = new BigInteger("0");
            }
            if (actualDbo.intValue() < 0) {
                actualDbo = new BigInteger("0");
            }
            ((Vector)this._data.get(1)).add(actualDbi);
            ((Vector)this._data.get(2)).add(actualDbo);
        } else {
            ((Vector)this._data.get(1)).add(new BigInteger("0"));
            ((Vector)this._data.get(2)).add(new BigInteger("0"));
        }
        this._previousStats = stats;
        this.setChanged();
    }

    public Object getDataItem(int row, int column) {
        return ((Vector)this._data.get(row)).get(column);
    }

    public Vector getRow(int row) {
        return (Vector)this._data.get(row);
    }

    public int getNumRows() {
        return this._data == null ? 0 : this._data.size();
    }

    public int getDataInterpretation() {
        return 0;
    }

    public String[] getPointLabels() {
        return this._xAxisLabels;
    }

    public String getSeriesName(int row) {
        return null;
    }

    public String getSeriesLabel(int row) {
        return this._labels[row];
    }

    public String getName() {
        return "";
    }

    String formatTime(Long d) {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        return sdf.format(date);
    }
}

