/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.ioa;

import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.ioa.IOACache;
import com.cisco.dcbu.sm.client.ioa.IOADialog;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.common.model.ioa.Cluster;
import com.cisco.dcbu.sm.common.model.ioa.Flow;
import com.cisco.dcbu.sm.common.model.ioa.IOAInterface;
import com.cisco.dcbu.sm.common.model.ioa.InterfaceStats;
import com.cisco.dcbu.sm.common.rif.IOARif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.server.ioa.common.IOAContext;
import com.jidesoft.utils.SwingWorker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class IOAWorkerCacheUpdate
extends SwingWorker<IOACache, String>
implements ActionListener {
    private IOACache cache;
    private int currentProgress;
    private IOADialog parent;
    public static Logger _Logger = Logger.getLogger((String)"IOA");

    public IOAWorkerCacheUpdate() {
    }

    public IOAWorkerCacheUpdate(IOADialog parent, IOACache cache) {
        this.cache = cache;
        this.currentProgress = 0;
        this.parent = parent;
    }

    protected IOACache doInBackground() throws Exception {
        _Logger.info((Object)"IOAWorkerCacheUpdate::doInBackground() - entering...");
        try {
            IOARif ioa = this.cache.getIoa();
            if (ioa == null) {
                this.currentProgress = 90;
                this.updateStatus("Unable to reach DCNM-SAN Server");
                return this.cache;
            }
            if (this.isCancelled()) {
                return this.cache;
            }
            try {
                this.updateStatus("Updating fabric list...");
                _Logger.info((Object)"Updating fabric list...");
                ArrayList<FabricPK> fabricPKList = new ArrayList<FabricPK>();
                ClientController ctrl = ClientController.getInstance();
                Fabric[] fabrics = ctrl.getFabrics();
                if (fabrics != null && fabrics.length > 0) {
                    for (int i = 0; i < fabrics.length; ++i) {
                        fabricPKList.add((FabricPK)fabrics[i].getPK());
                    }
                }
                this.cache.setFabricList(fabricPKList);
                if (this.isCancelled()) {
                    return this.cache;
                }
                this.updateStatus("Updating site list...");
                _Logger.info((Object)"Updating site list...");
                this.cache.setSitesList(ioa.getSiteList(this.cache.getActiveFabric()));
                if (this.isCancelled()) {
                    return this.cache;
                }
                this.updateStatus("Updating unassigned switch list...");
                _Logger.info((Object)"Updating unassigned switch list...");
                this.cache.setUnassignedSwitchList(ioa.getUnassignedSwitchList(this.cache.getActiveFabric()));
                if (this.isCancelled()) {
                    return this.cache;
                }
                this.updateStatus("Updating cluster list...");
                _Logger.info((Object)"Updating cluster list...");
                ArrayList<Cluster> clusterList = ioa.getClusterList(this.cache.getContext());
                this.cache.setClusterList(clusterList);
                if (this.isCancelled()) {
                    return this.cache;
                }
                if (this.cache.getActiveCluster() == null) {
                    this.currentProgress = 90;
                } else {
                    Cluster activeCluster = this.cache.getActiveCluster();
                    IOAContext context = this.cache.getContext();
                    context.clusterName = activeCluster.getName();
                    context.masterSwitch = activeCluster.getMasterSwitch();
                    ArrayList<InterfaceStats> statsList = new ArrayList<InterfaceStats>();
                    if (this.isCancelled()) {
                        return this.cache;
                    }
                    for (IOAInterface ioaInterface : activeCluster.getInterfaceList()) {
                        if (this.isCancelled()) {
                            return this.cache;
                        }
                        try {
                            InterfaceStats stats = ioa.getStatsForInterface(context, ioaInterface.getSwitchInfo().getIpAddress(), ioaInterface.getIfIndex());
                            if (stats == null) continue;
                            statsList.add(stats);
                        }
                        catch (RemoteException e) {
                            _Logger.warn((Object)("RemoteException caught: " + e.getMessage()));
                            if (ioaInterface == null || ioaInterface.getSwitchInfo() == null) continue;
                            InterfaceStats stats = new InterfaceStats();
                            stats.setHostname(ioaInterface.getSwitchInfo().getName());
                            stats.setIpAddress(ioaInterface.getSwitchInfo().getIpAddress());
                            stats.setIfName(ioaInterface.getInterfaceId());
                            stats.setIfIndex(ioaInterface.getIfIndex());
                            statsList.add(stats);
                        }
                    }
                    this.updateStatus("Updating interfaces for cluster " + activeCluster.getName() + "...");
                    _Logger.info((Object)("Updating interfaces for cluster " + activeCluster.getName() + "..."));
                    activeCluster.setInterfaceStatsList(statsList);
                    if (this.isCancelled()) {
                        return this.cache;
                    }
                    this.updateStatus("Updating candidate interfaces for cluster " + activeCluster.getName() + "...");
                    _Logger.info((Object)("Updating candidate interfaces for cluster " + activeCluster.getName() + "..."));
                    this.cache.setCandidateInterfaceList(ioa.getCandidateInterfacesForCluster(context));
                    if (this.isCancelled()) {
                        return this.cache;
                    }
                    this.updateStatus("Updating flows for cluster " + activeCluster.getName() + "...");
                    _Logger.info((Object)("Updating flows for cluster " + activeCluster.getName() + "..."));
                    ArrayList<Flow> flowList = ioa.getFlowsForCluster(context);
                    this.cache.setFlowList(flowList);
                    if (this.isCancelled()) {
                        return this.cache;
                    }
                    this.updateStatus("Updating candidate flows for cluster " + activeCluster.getName() + "...");
                    _Logger.info((Object)("Updating candidate flows for cluster " + activeCluster.getName() + "..."));
                    String a = activeCluster.getFirstSiteName();
                    String b = activeCluster.getSecondSiteName();
                    if (a != null && b != null) {
                        ArrayList<Flow> candidateFlowList = ioa.getCandidateFlows(context, a, b, this.cache.isShowAllFlows());
                        this.trimConfiguredFlows(candidateFlowList, flowList);
                        if (clusterList.size() > 1) {
                            for (Cluster c : clusterList) {
                                if (c.equals(activeCluster)) continue;
                                String x = c.getFirstSiteName();
                                String y = c.getSecondSiteName();
                                if (!a.equals(x) && !a.equals(y) || !b.equals(x) && !b.equals(y)) continue;
                                IOAContext refCtx = this.cache.getContext();
                                IOAContext ctx = new IOAContext();
                                ctx.fabric = refCtx.fabric;
                                ctx.password = refCtx.password;
                                ctx.username = refCtx.username;
                                ctx.clusterName = c.getName();
                                ctx.masterSwitch = c.getMasterSwitch();
                                ArrayList<Flow> moreFlows = ioa.getFlowsForCluster(ctx);
                                this.trimConfiguredFlows(candidateFlowList, moreFlows);
                            }
                        }
                        this.cache.setCandidateFlowList(candidateFlowList);
                    } else {
                        this.cache.setCandidateFlowList(new ArrayList<Flow>());
                    }
                    if (this.isCancelled()) {
                        return this.cache;
                    }
                }
            }
            catch (RemoteException e) {
                String err = e.getMessage();
                if (e.detail != null) {
                    err = e.detail.getMessage();
                }
                _Logger.error((Object)"Failed to update cache", (Throwable)e);
                throw new RemoteException("Failed to update cache " + err);
            }
            this.updateStatus("Done");
            _Logger.info((Object)"IOAWorkerCacheUpdate::doInBackground() - exiting...");
            return this.cache;
        }
        catch (RemoteException e) {
            JOptionPane.showMessageDialog(this.parent.progressDialog, e.getMessage());
            return this.cache;
        }
        catch (Exception e) {
            _Logger.error((Object)"IOAWorkerCacheUpdate: unexpected exception", (Throwable)e);
            JOptionPane.showMessageDialog(this.parent.progressDialog, "An unexpected error occurred, see log for details.");
            return this.cache;
        }
    }

    private void trimConfiguredFlows(ArrayList<Flow> candidateFlowList, ArrayList<Flow> flowList) {
        if (candidateFlowList != null && !candidateFlowList.isEmpty()) {
            for (Flow f : flowList) {
                Iterator<Flow> iter = candidateFlowList.iterator();
                while (iter.hasNext()) {
                    Flow cf = iter.next();
                    if (!f.getInitiator().getWwnBrief().equals(cf.getInitiator().getWwnBrief()) || !f.getTarget().getWwnBrief().equals(cf.getTarget().getWwnBrief())) continue;
                    iter.remove();
                }
            }
        }
    }

    private void updateStatus(String message) {
        this.currentProgress += 10;
        if (this.currentProgress >= 100) {
            this.currentProgress = 100;
            _Logger.debug((Object)("IOAWorkerCacheUpdate: 100% " + message));
        }
        this.setProgress(this.currentProgress);
        this.publish(new String[]{message});
    }

    protected void process(List<String> chunks) {
        int sz = chunks.size();
        String last = chunks.get(sz - 1);
        this.parent.progressDialog._label.setText(last);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        _Logger.info((Object)("IOAWorkerCacheUpdate::actionPerformed() - command=" + e.getActionCommand()));
        this.cancel(true);
        _Logger.info((Object)"IOAWorkerCacheUpdate::actionPerformed() - exiting...");
    }

    protected void done() {
        _Logger.info((Object)"IOAWorkerCacheUpdate::done()");
        super.done();
    }
}

