/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.ioa;

import com.cisco.dcbu.sm.client.ioa.IOATableModel;
import com.cisco.dcbu.sm.common.model.ioa.Switch;
import java.util.ArrayList;

public class SwitchTableModel
extends IOATableModel {
    private static final long serialVersionUID = 1L;
    static final String[] LABELS = new String[]{"Name", "IP Address", "WWN", "Sw Version", "IOA License"};
    static final int NAME = 0;
    static final int IP = 1;
    static final int WWN = 2;
    static final int VERSION = 3;
    static final int LICENSE = 4;
    static final int THEOBJECT = 5;
    static final int MODIFIED = 6;

    SwitchTableModel() {
        this.setHeaders(LABELS);
    }

    @Override
    public int getObjectIndex() {
        return 5;
    }

    @Override
    public void updateData(ArrayList memberList) {
        ArrayList<Object[]> theData = new ArrayList<Object[]>();
        if (memberList != null) {
            for (Object theMember : memberList) {
                Switch theSwitch = (Switch)theMember;
                Object[] o = new Object[this.getObjectArraySize()];
                o[0] = theSwitch.getName();
                o[1] = theSwitch.getIpAddress();
                o[2] = theSwitch.getWwn();
                o[3] = theSwitch.getVersion();
                if (theSwitch.getVersion() == null) {
                    o[3] = "unknown";
                }
                o[4] = Switch.getLicenseString(theSwitch.getDiplayLicense());
                o[5] = theSwitch;
                o[6] = false;
                theData.add(o);
            }
        }
        this.setData(theData);
    }
}

