/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.iscsi;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.mds.PortInterfaceUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.iscsi.IscsiDevice;
import com.cisco.dcbu.sm.client.zm.common.IscsiProxy;
import java.net.InetAddress;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public class IscsiController {
    static final ImageIcon ISCSI_ZONE = Util.loadIcon("icons/iSCSI_Zone.gif");
    static final ImageIcon ISCSI_STORAGE = Util.loadIcon("icons/iSCSI_Storage.gif");
    static final ImageIcon ISCSI_HOST = Util.loadIcon("icons/iSCSI_Host.gif");
    static final String SELECTED_FABRIC_PEER = "SEED_PEER";
    static final String SELECTED_ZONE_SWITCH = "ZONE_PEER";
    static final String SELECTED_VSAN = "VSAN";
    static final String SELECTED_END_PORTS = "NXPORTS";
    static final String ZONESET = "ZONESET";
    static final String ZONE = "ZONE";
    static final String ZONE_MODE = "ZONE_MODE";
    static final String SAVE_CONFIG = "SAVE_CONFIG";
    static final String SAVE_CONFIG_FILE = "SAVE_CONFIG_FILE";
    static final String CONFIG_FILE = "CONFIG_FILE";
    static final String ZONE_DATA_CONTROLLER = "ZONE_DATA";
    static final String INITIATOR = "INITIATOR";
    static final String INITIATOR_LIST = "INITIATOR_LIST";
    static final String INITIATOR_SWITCH = "INITIATOR_SWITCH";
    static final String NEW_INITIATOR = "NEW_INITIATOR";
    static final String ISCSI_CONTROLLER = "ISCSI_CONTROLLER";
    private ArrayList _fcAddressList;

    void clearCachedData() {
        this._fcAddressList = null;
    }

    ArrayList getInitiators(SnmpPeer[] peers) throws SnmpException {
        if (this._fcAddressList == null) {
            this._fcAddressList = this.getFcAddressList(peers);
        }
        return this.getInitiators(peers, this._fcAddressList);
    }

    ArrayList getTargets(SnmpPeer[] peers) throws SnmpException {
        if (this._fcAddressList == null) {
            this._fcAddressList = this.getFcAddressList(peers);
        }
        return this.getTargets(peers, this._fcAddressList);
    }

    ArrayList getFcAddressList(SnmpPeer[] peers) throws SnmpException {
        return this.getCallBackPDUs(peers, new String[]{"fcAddress"});
    }

    private ArrayList getCallBackPDUs(SnmpPeer[] peer, String[] mibObjects) throws SnmpException {
        ArrayList<SnmpPDU> pdus = new ArrayList<SnmpPDU>();
        VarBindList vblOper = new VarBindList();
        for (int i = 0; i < mibObjects.length; ++i) {
            vblOper.add(MibNode.get(mibObjects[i]).getOid());
        }
        SnmpPDU[] pdu = new SnmpAggregrate().getBulk(peer, vblOper);
        if (pdu != null) {
            for (int i = 0; i < pdu.length; ++i) {
                if (pdu[i].getVariables() == null) continue;
                pdus.add(pdu[i]);
            }
        }
        return pdus;
    }

    private ArrayList getInitiators(SnmpPeer[] peers, ArrayList ifPdus) throws SnmpException {
        ArrayList<IscsiDevice> list = new ArrayList<IscsiDevice>();
        if (peers == null || peers.length == 0) {
            return list;
        }
        ArrayList if2Pdus = this.getCallBackPDUs(peers, new String[]{"iscsi2FcNodeName", "iscsi2FcNodeVsanList2k", "iscsi2FcNodeVsanList4k", "iscsi2FcPortFCAddrListIndex", "iscsi2FcNodeLoadBalancing"});
        int[] iscsi2FcNodeLoadBalancingOid = MibNode.get("iscsi2FcNodeLoadBalancing").getOid();
        for (int i = 0; i < if2Pdus.size(); ++i) {
            SnmpPDU pdu = (SnmpPDU)if2Pdus.get(i);
            VarBindList response = pdu.getVariables();
            InetAddress swAdd = pdu.getAddress();
            block1: for (int k = 0; k < response.size(); k += 5) {
                int[] initOid = response.getVb(k).getOid().getValue();
                for (int j = 0; j < ifPdus.size(); ++j) {
                    int[] lastOid;
                    SnmpPDU pdu2 = (SnmpPDU)ifPdus.get(j);
                    InetAddress swAdd2 = pdu2.getAddress();
                    VarBindList response2 = pdu2.getVariables();
                    if (!swAdd.equals(swAdd2) || SnmpOID.startsWith(lastOid = response.get(k + 4).getOid().getValue(), iscsi2FcNodeLoadBalancingOid) && response.intValue(k + 4) == 1) continue;
                    if (response2.size() == 0 || response.intValue(k + 3) == 0) {
                        IscsiDevice initA = this.buildIscsiInitiator(response.stringValue(k), null, swAdd, initOid[initOid.length - 2], initOid[initOid.length - 1], response.byteValue(k + 1), response.byteValue(k + 2));
                        list.add(initA);
                        continue;
                    }
                    for (int l = 0; l < response2.size(); ++l) {
                        int[] oid = response2.getVb(l).getOid().getValue();
                        IscsiDevice init = null;
                        if (oid[oid.length - 2] != response.intValue(k + 3)) continue;
                        init = this.buildIscsiInitiator(response.stringValue(k), response2.byteValue(l), swAdd, initOid[initOid.length - 2], initOid[initOid.length - 1], response.byteValue(k + 1), response.byteValue(k + 2));
                        list.add(init);
                    }
                    continue block1;
                }
            }
        }
        return list;
    }

    public ArrayList getIscsiProxy(SnmpPeer[] peers) throws SnmpException {
        ArrayList<IscsiProxy> list = new ArrayList<IscsiProxy>();
        if (peers == null || peers.length == 0) {
            return list;
        }
        ArrayList if2Pdus = this.getCallBackPDUs(peers, new String[]{"iscsiIfIntrProxyModePortFcAddr", "iscsiIfIntrProxyMode"});
        for (int i = 0; i < if2Pdus.size(); ++i) {
            SnmpPDU pdu = (SnmpPDU)if2Pdus.get(i);
            VarBindList response = pdu.getVariables();
            InetAddress swAdd = pdu.getAddress();
            for (int k = 0; k < response.size(); k += 2) {
                if (response.intValue(k + 1) != 1) continue;
                int[] initOid = response.getVb(k).getOid().getValue();
                IscsiProxy initA = new IscsiProxy();
                initA._switchAdd = swAdd;
                initA._pWWN = response.byteValue(k);
                initA._ifIndex = initOid[initOid.length - 1];
                list.add(initA);
            }
        }
        return list;
    }

    private ArrayList getTargets(SnmpPeer[] peers, ArrayList ifPdus) throws SnmpException {
        ArrayList<IscsiDevice> list = new ArrayList<IscsiDevice>();
        if (peers == null || peers.length == 0) {
            return list;
        }
        ArrayList if2Pdus = this.getCallBackPDUs(peers, new String[]{"fc2IscsiNodeName", "fc2IscsiPortFCAddrListIndex", "fc2IscsiNodeLoadBalancing"});
        int[] fc2IscsiNodeLoadBalancingOid = MibNode.get("fc2IscsiNodeLoadBalancing").getOid();
        for (int i = 0; i < if2Pdus.size(); ++i) {
            SnmpPDU pdu = (SnmpPDU)if2Pdus.get(i);
            VarBindList response = pdu.getVariables();
            InetAddress swAdd = pdu.getAddress();
            block1: for (int k = 0; k < response.size(); k += 3) {
                int[] initOid = response.getVb(k).getOid().getValue();
                block2: for (int j = 0; j < ifPdus.size(); ++j) {
                    int[] lastOid;
                    SnmpPDU pdu2 = (SnmpPDU)ifPdus.get(j);
                    InetAddress swAdd2 = pdu2.getAddress();
                    VarBindList response2 = pdu2.getVariables();
                    if (!swAdd.equals(swAdd2) || response2.size() == 0 || SnmpOID.startsWith(lastOid = response.get(k + 2).getOid().getValue(), fc2IscsiNodeLoadBalancingOid) && response.intValue(k + 2) == 1) continue;
                    if (response2.size() == 0 || response.intValue(k + 1) == 0) {
                        IscsiDevice initA = this.buildIscsiInitiator(response.stringValue(k), null, swAdd, initOid[initOid.length - 2], initOid[initOid.length - 1], null, null);
                        list.add(initA);
                        continue block1;
                    }
                    for (int l = 0; l < response2.size(); ++l) {
                        int[] oid = response2.getVb(l).getOid().getValue();
                        IscsiDevice init = null;
                        if (oid[oid.length - 2] != response.intValue(k + 1)) continue;
                        init = this.buildIscsiInitiator(response.stringValue(k), response2.byteValue(l), swAdd, initOid[initOid.length - 2], initOid[initOid.length - 1], null, null);
                        list.add(init);
                        continue block2;
                    }
                }
            }
        }
        return list;
    }

    private IscsiDevice buildIscsiInitiator(String name, byte[] pWWN, InetAddress swAdd, int instanceIndex, int index, byte[] vsan2K, byte[] vsan4K) {
        IscsiDevice init = new IscsiDevice();
        init._name = name;
        init._pWWN = pWWN;
        if (vsan2K != null && vsan4K != null) {
            init._vsanList = PortInterfaceUtil.getInstance(2).getVsan(new SnmpString(vsan2K), new SnmpString(vsan4K), true).getValue();
        }
        ClientController.getInstance();
        init._ep = ClientController.findFabricEndPortByIscsiName(init._name);
        if (init._ep == null && init._pWWN != null && init._pWWN.length == 8) {
            ClientController.getInstance();
            init._ep = ClientController.findFabricEndPortByWwn(new Wwn(init._pWWN));
        }
        init._switchAdd = swAdd;
        String address = "";
        if (init._ep != null) {
            address = init._ep.getNodeIpAddress();
        }
        if (address == null || address.length() == 0) {
            try {
                SnmpIpAddress.parse(init._name);
                address = init._name;
            }
            catch (SnmpException ex) {
                // empty catch block
            }
        }
        init._address = address;
        init._instanceIndex = instanceIndex;
        init._index = index;
        return init;
    }

    void createInitiator(SnmpPeer peer, boolean existing, IscsiDevice device, ArrayList existingDevices) throws SnmpException {
        int[] nArray;
        if (existing) {
            int[] nArray2 = new int[2];
            nArray2[0] = device._instanceIndex;
            nArray = nArray2;
            nArray2[1] = device._index;
        } else {
            nArray = this.getNextIndex(existingDevices, peer);
        }
        int[] index = nArray;
        device._instanceIndex = index[0];
        device._index = index[1];
        VarBindList vbl = new VarBindList();
        if (!existing) {
            vbl.add(MibNode.get("iscsi2FcNodeRowStatus").getOid(), index, (SnmpVar)new SnmpInt(4));
            if (device._name.length() < 16) {
                char[] ch = new char[16 - device._name.length()];
                for (int i = 0; i < ch.length; ++i) {
                    ch[i] = 32;
                }
                device._name = device._name + String.valueOf(ch);
            }
            vbl.add(MibNode.get("iscsi2FcNodeName").getOid(), index, (SnmpVar)new SnmpString(device._name));
            vbl.add(MibNode.get("iscsi2FcNodeRole").getOid(), index, (SnmpVar)new SnmpString(new byte[]{64}));
        }
        PortInterfaceUtil pIntf = PortInterfaceUtil.getInstance(2);
        vbl.add(MibNode.get("iscsi2FcNodeVsanList2k").getOid(), index, (SnmpVar)pIntf.get2KString(device._vsanList));
        vbl.add(MibNode.get("iscsi2FcNodeVsanList4k").getOid(), index, (SnmpVar)pIntf.get4KString(device._vsanList));
        vbl.add(MibNode.get("iscsi2FcNodePersistentFCAddr").getOid(), index, (SnmpVar)new SnmpInt(1));
        vbl.add(MibNode.get("iscsi2FcNodeFcAddrAssignment").getOid(), index, (SnmpVar)new SnmpInt(1));
        vbl.add(MibNode.get("iscsi2FcPortPersistentFCAddr").getOid(), index, (SnmpVar)new SnmpInt(1));
        if (!existing) {
            vbl.add(MibNode.get("iscsi2FcPortNumFCAddr").getOid(), index, (SnmpVar)new SnmpUnsignedInt(1L));
        }
        vbl.add(MibNode.get("iscsiImprtExprtTgtsConfImport").getOid(), 1, (SnmpVar)new SnmpString(new byte[]{-128}));
        peer.set(new SnmpPDU(-93, vbl));
    }

    byte[] getInitiatorPwwn(SnmpPeer peer, int[] index) throws SnmpException {
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("iscsi2FcPortFCAddrListIndex").getOid(), index);
        vbl = peer.set(new SnmpPDU(-96, vbl)).getVariables();
        if (vbl.size() > 0) {
            int pwwnIndex = vbl.intValue(0);
            vbl.clear();
            vbl.add(MibNode.get("fcAddress").getOid(), new int[]{pwwnIndex, 1});
            vbl = peer.set(new SnmpPDU(-96, vbl)).getVariables();
            if (vbl.size() > 0) {
                return vbl.byteValue(0);
            }
        }
        return null;
    }

    private int[] getNextIndex(ArrayList existingDevices, SnmpPeer peer) {
        int[] index = new int[]{1, 1};
        for (int i = 0; i < existingDevices.size(); ++i) {
            IscsiDevice dev = (IscsiDevice)existingDevices.get(i);
            if (!dev._switchAdd.equals(peer.getAddress())) continue;
            if (index[1] == dev._index) {
                index[1] = dev._index + 1;
                continue;
            }
            if (index[1] < dev._index) break;
        }
        return index;
    }
}

