/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.lic;

import com.cisco.dcbu.sm.client.lic.Logger;
import org.restlet.Client;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public class RestRequestHelper {
    long timeout = 15000L;
    Client client = null;
    Response res = null;
    Object lock = new Object();

    public RestRequestHelper(Client client) {
        this.client = client;
    }

    public Response handle(Request req) throws Exception {
        if (this.timeout <= 0L) {
            return this.client.handle(req);
        }
        RequestThread t = new RequestThread(req);
        t.start();
        try {
            this.pauseAndWait(this.timeout);
        }
        catch (Exception ex) {
            // empty catch block
        }
        t.interrupt();
        if (t.hasException()) {
            throw t.getException();
        }
        if (t.isDone()) {
            return t.getResponse();
        }
        if (!this.client.isStopped()) {
            try {
                this.client.stop();
            }
            catch (Exception e) {
                Logger.error("Unable to stop request: " + e.getMessage());
            }
        }
        Response response = new Response(req);
        response.setStatus(Status.CLIENT_ERROR_REQUEST_TIMEOUT);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseAndWait(long timeout) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.lock.wait(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeAndGo() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    private class RequestThread
    extends Thread {
        boolean done;
        Request request;
        Response response;
        Exception exception;
        boolean throwed;

        RequestThread(Request req) {
            super(RequestThread.class.getName() + "-" + System.currentTimeMillis());
            this.done = false;
            this.request = null;
            this.response = null;
            this.exception = null;
            this.throwed = false;
            this.request = req;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.response = RestRequestHelper.this.client.handle(this.request);
                this.done = true;
            }
            catch (Exception ex) {
                this.exception = ex;
                this.throwed = true;
            }
            finally {
                RestRequestHelper.this.resumeAndGo();
            }
        }

        @Override
        public void interrupt() {
            if (!RestRequestHelper.this.client.isStopped()) {
                try {
                    RestRequestHelper.this.client.stop();
                    if (!RestRequestHelper.this.client.isStopped()) {
                        Logger.warn(this.getName() + " is unable to stop request");
                    }
                }
                catch (Exception e) {
                    Logger.error("Unable to interrupt request handled by " + this.getName() + ": " + e.getMessage());
                }
            }
            super.interrupt();
        }

        boolean isDone() {
            return this.done;
        }

        public Response getResponse() {
            return this.response;
        }

        public boolean hasException() {
            return this.throwed;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

