/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.lic.rep;

import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.client.Launcher;
import com.cisco.dcbu.sm.client.lic.Logger;
import com.cisco.dcbu.sm.client.lic.auth.TokenProvider;
import com.cisco.dcbu.sm.client.lic.auth.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.DomRepresentation;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class LoginResource
extends Resource {
    private String passphrase;
    private String username;
    private String password;

    public LoginResource(Context context, Request request, Response response) {
        super(context, request, response);
        this.setModifiable(true);
        this.getVariants().add(new Variant(MediaType.TEXT_XML));
    }

    public LoginResource(String passphrase, String username, String password) {
        this.passphrase = passphrase;
        this.username = username;
        this.password = password;
        this.getVariants().add(new Variant(MediaType.TEXT_XML));
    }

    public Response getResponse() {
        return super.getResponse();
    }

    public void acceptRepresentation(Representation entity) throws ResourceException {
        if (entity.getMediaType() != MediaType.TEXT_XML) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE);
            return;
        }
        Document dom = null;
        try {
            DocumentBuilder bldr = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            dom = bldr.parse(new ByteArrayInputStream(entity.getText().getBytes()));
            Element root = dom.getDocumentElement();
            this.username = dom.getElementsByTagName("username").item(0).getTextContent();
            this.passphrase = dom.getElementsByTagName("passphrase").item(0).getTextContent();
            Logger.debug("username:  " + this.username);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            Logger.error(e.getMessage());
            this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL, e.getMessage());
            return;
        }
        catch (SAXException e) {
            e.printStackTrace();
            Logger.error(e.getMessage());
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST, e.getMessage());
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            Logger.error(e.getMessage());
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST, e.getMessage());
            return;
        }
        if (this.passphrase == null) {
            Logger.warn("Passphrase is empty.");
            this.getResponse().setStatus(Status.CLIENT_ERROR_UNAUTHORIZED, "Passphrase is empty.");
            return;
        }
        try {
            String decrypted = StringEncrypter.DESedeDecrypt(this.passphrase);
            String[] pClear = Util.unpad(decrypted);
            Launcher.login(pClear[1], pClear[2]);
            String token = TokenProvider.getInstance().createToken();
            this.getResponse().setEntity(token, MediaType.TEXT_PLAIN);
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Logger.error(ex.getMessage());
            this.getResponse().setStatus(Status.CLIENT_ERROR_UNAUTHORIZED, ex.getMessage());
            return;
        }
    }

    public Representation represent(Variant variant) throws ResourceException {
        if (MediaType.TEXT_XML.equals((Object)variant.getMediaType())) {
            try {
                DomRepresentation representation = new DomRepresentation(MediaType.TEXT_XML);
                Document d = representation.getDocument();
                d.appendChild(this.createElement(d));
                d.normalizeDocument();
                return representation;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Element createElement(Document d) {
        Element loginEl = d.createElement("login");
        Element passphraseEl = d.createElement("passphrase");
        passphraseEl.appendChild(d.createTextNode(this.getPassphrase()));
        loginEl.appendChild(passphraseEl);
        Element userEl = d.createElement("username");
        userEl.appendChild(d.createTextNode(this.getPassphrase()));
        loginEl.appendChild(userEl);
        Element passEl = d.createElement("password");
        passEl.appendChild(d.createTextNode(this.getPassphrase()));
        loginEl.appendChild(passEl);
        return loginEl;
    }

    public void setPassphrase(String p) {
        this.passphrase = p;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

