/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.linksecurity;

import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.script.AbstractWorker;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.linksecurity.ESPSetTask;
import com.cisco.dcbu.sm.client.linksecurity.LinkSecurityWizard;
import com.cisco.dcbu.sm.client.linksecurity.SaSetTask;
import com.cisco.dcbu.sm.client.linksecurity.SaveRSTask;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.wizardTask.BulkActionTable;
import com.cisco.dcbu.sm.client.wizardTask.BulkActionTableModel;
import com.cisco.dcbu.sm.client.wizardTask.IslRenderer;
import com.cisco.dcbu.sm.client.wizardTask.ObjectActionTracker;
import com.cisco.dcbu.sm.client.wizardTask.ProgressPanel;
import com.cisco.dcbu.sm.client.wizardTask.SwitchRenderer;
import com.cisco.dcbu.sm.client.wizardTask.TaskRenderer;
import com.cisco.dcbu.sm.client.wizardTask.TextAreaRenderer;
import com.cisco.dcbu.sm.common.dto.ESPDto;
import com.cisco.dcbu.sm.common.dto.SecurityAssociationDto;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class LinkSecurityCompleteStep
extends WizardPanel {
    public static final Logger _Logger = Logger.getLogger(LinkSecurityCompleteStep.class);
    public static final String StepTitle = "Step 4 of 4:Complete ESP Setup";
    public static final String StepDesp = "Please review your configuration and click Finish to apply changes.\nUpon clicking finish the status column will begin to populate with Success or Failure,  you can then double click on the cell for more information.";
    private JPanel mp;
    private ProgressPanel progressPanel;
    private JLabel finalStatus;
    private BulkActionTable saActionTable;
    private BulkActionTable espActionTable;
    private CardLayout card;
    private JPanel bottomPanel;
    private boolean runApply = false;
    private boolean isCanceled = false;
    private boolean isSATableVisible = true;
    private JPanel tableView = null;

    public LinkSecurityCompleteStep(LinkSecurityWizard wizard) {
        super(StepTitle, StepDesp, wizard, LinkSecurityWizard.WIZARD_ICON);
        this.initialize();
    }

    public ProgressPanel getProgressPanel() {
        return this.progressPanel;
    }

    @Override
    public void dispose() {
        this.progressPanel = null;
        this.finalStatus = null;
        this.saActionTable = null;
        this.espActionTable = null;
        this.card = null;
        this.tableView = null;
        super.dispose();
    }

    @Override
    public boolean refresh() {
        try {
            List<ObjectActionTracker> actions = ((LinkSecurityWizard)this.getWizard()).createSaTaskActions();
            this.saActionTable.getBulkActionModel().setActionData(actions);
            if (actions.isEmpty()) {
                if (this.isSATableVisible) {
                    this.mp.remove(this.tableView);
                    this.createAppropriateTables(false);
                    this.mp.add((Component)this.tableView, "Center");
                    this.isSATableVisible = false;
                }
            } else if (!this.isSATableVisible) {
                this.mp.remove(this.tableView);
                this.createAppropriateTables(true);
                this.mp.add((Component)this.tableView, "Center");
                this.isSATableVisible = true;
            }
            List<ObjectActionTracker> espActions = ((LinkSecurityWizard)this.getWizard()).createEspTaskActions();
            this.espActionTable.getBulkActionModel().setActionData(espActions);
            this.card.last(this.bottomPanel);
            return super.refresh();
        }
        catch (Exception e) {
            Util.errorMessage((Component)this.getWizard(), e);
            return false;
        }
    }

    private void createAppropriateTables(boolean saVisible) {
        this.tableView = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        Component[] tables = saVisible ? new Component[]{new JScrollPane(this.saActionTable), new JScrollPane(this.espActionTable)} : new Component[]{new JScrollPane(this.espActionTable)};
        for (int i = 0; i < tables.length; ++i) {
            DialogUtil.constrain(this.tableView, tables[i], gbc, 0, i, 1, 18);
        }
    }

    @Override
    public void doPrevious() {
        this.setDataValid(false);
        super.doPrevious();
    }

    @Override
    public String getTitle() {
        return StepTitle;
    }

    @Override
    public void doFinish() {
        try {
            super.doFinish();
            this.getWizard().getNavigator().getBackBtn().setEnabled(false);
            int actionCnt = this.saActionTable.getBulkActionModel().getActionCount() + this.espActionTable.getBulkActionModel().getActionCount();
            this.card.next(this.bottomPanel);
            this.progressPanel.setMaximum(actionCnt * 2);
            this.progressPanel.start();
            this.runSetupApply(this);
        }
        catch (Exception e) {
            Util.errorMessage((Component)this.getWizard(), e);
        }
    }

    @Override
    public void actionFinished(boolean success) {
        try {
            if (success) {
                this.finalStatus.setText("All configurations have successfully applied");
            } else {
                this.finalStatus.setText("Cannot apply all configurations");
            }
            if (this.getWizard() != null && this.getWizard().isVisible()) {
                this.getWizard().getNavigator().getNextBtn().setVisible(false);
                this.getWizard().getNavigator().getBackBtn().setVisible(false);
                this.getWizard().getNavigator().getCancel().setText("Close");
                this.progressPanel.stop();
                if (!success) {
                    this.finalStatus.setForeground(Color.red);
                }
                this.card.last(this.bottomPanel);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void doCancel() {
        if (this.isRunApply()) {
            String msg = "Wizard is applying new settings. Cancelling will stop making further changes but \nwill not roll back already applied configuration. \n\n\n Do you want to continue?";
            int option = JOptionPane.showConfirmDialog(this.getWizard(), msg, "Warning", 2, 3);
            if (option != 0) {
                return;
            }
            this.setCanceled(true);
            _Logger.info((Object)"User interrupted Traffic Map Wizard from applying new configurations.");
        }
        super.doCancel();
    }

    private void initialize() {
        BulkActionTableModel swActionTm = new BulkActionTableModel(new String[]{"Switch", "Action", "Status"});
        this.saActionTable = new BulkActionTable(swActionTm, true);
        this.saActionTable.setColumnWidth(new int[]{12, 50, 5});
        BulkActionTableModel islActionTm = new BulkActionTableModel(new String[]{"Isl", "Action", "Status"});
        this.espActionTable = new BulkActionTable(islActionTm, true);
        this.espActionTable.setColumnWidth(new int[]{20, 50, 5});
        TextAreaRenderer strRenderer = new TextAreaRenderer();
        this.saActionTable.setDefaultRenderer(String.class, strRenderer);
        this.espActionTable.setDefaultRenderer(String.class, strRenderer);
        TaskRenderer tRenderer = new TaskRenderer();
        this.saActionTable.setDefaultRenderer(BulkActionTableModel.Task.class, tRenderer);
        this.espActionTable.setDefaultRenderer(BulkActionTableModel.Task.class, tRenderer);
        SwitchRenderer sRenderer = new SwitchRenderer();
        this.saActionTable.setDefaultRenderer(SwitchBase.class, sRenderer);
        IslRenderer islRenderer = new IslRenderer();
        islRenderer.setHorizontalAlignment(0);
        this.espActionTable.setDefaultRenderer(Isl.class, islRenderer);
        this.tableView = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        Component[] tables = new Component[]{new JScrollPane(this.saActionTable), new JScrollPane(this.espActionTable)};
        for (int i = 0; i < tables.length; ++i) {
            DialogUtil.constrain(this.tableView, tables[i], gbc, 0, i, 1, 18);
        }
        this.progressPanel = new ProgressPanel("process");
        this.progressPanel.setBorder(new EmptyBorder(8, 1, 1, 1));
        this.finalStatus = new JLabel("", 0);
        Font lfont = this.finalStatus.getFont();
        lfont = new Font(lfont.getName(), 1, lfont.getSize() + 1);
        this.finalStatus.setFont(lfont);
        JPanel labelPanel = new JPanel(new FlowLayout(0));
        labelPanel.add(this.finalStatus);
        JPanel viewp = new JPanel(new GridLayout(2, 1));
        viewp.add(labelPanel);
        this.card = new CardLayout();
        this.bottomPanel = new JPanel(this.card);
        this.bottomPanel.add("progress", this.progressPanel);
        this.bottomPanel.add("buttonpanel", viewp);
        this.card.last(this.bottomPanel);
        this.mp = new JPanel(new BorderLayout());
        this.mp.setBorder(DialogUtil._Margin);
        this.mp.add((Component)this.tableView, "Center");
        this.mp.add((Component)this.bottomPanel, "South");
        this.add((Component)this.mp, "Center");
    }

    private synchronized boolean isRunApply() {
        return this.runApply;
    }

    private synchronized void setCanceled(boolean b) {
        this.isCanceled = b;
    }

    private synchronized void setRunApply(boolean runApply) {
        this.runApply = runApply;
    }

    public void runSetupApply(final LinkSecurityCompleteStep step) {
        AbstractWorker worker = new AbstractWorker(){

            public void checkCanceled() throws Exception {
                if (LinkSecurityCompleteStep.this.isCanceled) {
                    throw new Exception("Operations canceled by user");
                }
            }

            @Override
            public Object construct() {
                try {
                    List<Isl> isls;
                    Map<Isl, ESPDto> espData;
                    LinkSecurityCompleteStep.this.setRunApply(true);
                    _Logger.debug((Object)"runSetupApply start to apply setup");
                    boolean hasError = false;
                    Map<SwitchBase, List<SecurityAssociationDto>> swSa = ((LinkSecurityWizard)LinkSecurityCompleteStep.this.getWizard()).getSwitchSAToSet();
                    if (swSa != null && !swSa.isEmpty()) {
                        this.checkCanceled();
                        SaSetTask saTask = new SaSetTask(LinkSecurityWizard.ActionType.CreateSA.ordinal(), LinkSecurityWizard.ActionType.CreateSA.getName(), swSa, (BulkActionTableModel)LinkSecurityCompleteStep.this.saActionTable.getModel(), LinkSecurityCompleteStep.this.progressPanel);
                        int swCnt = swSa.size();
                        int runs = Math.max(Math.round(swCnt / 10), 5);
                        saTask.setTaskTimeout((long)runs * saTask.getMessageTimeout());
                        _Logger.info((Object)("run task " + saTask.getTypeDisplayString() + " on switches: " + saTask.getObjList()));
                        saTask.run();
                        if (!saTask.isTaskSuccess()) {
                            _Logger.warn((Object)("run task " + saTask.getType() + " with failed switches:" + saTask.getFailedSet()));
                            saTask.closeTask();
                            this.checkCanceled();
                            Util.errorMessage((Component)LinkSecurityCompleteStep.this.getWizard(), "Setting SA for one of the switches failed.\n Unable to continue on to setting ESP data tasks.");
                            hasError = true;
                            return hasError;
                        }
                        _Logger.info((Object)("run task " + saTask.getType() + " successful"));
                        saTask.closeTask();
                    }
                    if ((espData = ((LinkSecurityWizard)LinkSecurityCompleteStep.this.getWizard()).getESPData()) != null && !espData.isEmpty()) {
                        this.checkCanceled();
                        ESPSetTask espTask = new ESPSetTask(LinkSecurityWizard.ActionType.SetESP.ordinal(), LinkSecurityWizard.ActionType.SetESP.getName(), espData, (BulkActionTableModel)LinkSecurityCompleteStep.this.espActionTable.getModel(), LinkSecurityCompleteStep.this.progressPanel);
                        int swCnt = espData.size();
                        int runs = Math.max(Math.round(swCnt / 10), 5);
                        espTask.setTaskTimeout((long)runs * espTask.getMessageTimeout());
                        _Logger.info((Object)("run task " + espTask.getTypeDisplayString() + " on isls: " + espTask.getObjList()));
                        espTask.run();
                        if (!espTask.isTaskSuccess()) {
                            _Logger.warn((Object)("run task " + espTask.getType() + " with failed isls:" + espTask.getFailedSet()));
                            hasError = true;
                        } else {
                            _Logger.info((Object)("run task " + espTask.getType() + " successful"));
                        }
                        espTask.closeTask();
                    }
                    this.checkCanceled();
                    List<SwitchBase> switchesSRS = ((LinkSecurityWizard)LinkSecurityCompleteStep.this.getWizard()).getSwitchesForSaveRS();
                    if (switchesSRS.size() > 0) {
                        SaveRSTask saveCfgTask = new SaveRSTask(LinkSecurityWizard.ActionType.SaveRS.ordinal(), LinkSecurityWizard.ActionType.SaveRS.getName(), switchesSRS, null, step.getProgressPanel());
                        int swCnt = switchesSRS.size();
                        int runs = Math.max(Math.round(swCnt / 10), 5);
                        saveCfgTask.setTaskTimeout((long)runs * saveCfgTask.getMessageTimeout());
                        _Logger.info((Object)("run task " + saveCfgTask.getType() + " on switches: " + saveCfgTask.getObjList()));
                        saveCfgTask.run();
                        if (!saveCfgTask.isTaskSuccess()) {
                            _Logger.warn((Object)("run task " + saveCfgTask.getType() + " with failed switches:" + saveCfgTask.getFailedSet()));
                            Object[] msgAndList = new Object[2];
                            msgAndList[0] = new String("Saving Running Configuration failed for the following switches:");
                            JList<Object> displayList = new JList<Object>(saveCfgTask.getFailedSet().toArray());
                            JScrollPane scrPan = new JScrollPane(displayList);
                            msgAndList[1] = scrPan;
                            JOptionPane.showMessageDialog(LinkSecurityCompleteStep.this.getWizard(), msgAndList, "Error :FC-SP ESP Setup Wizard", 0);
                            hasError = true;
                        } else {
                            _Logger.info((Object)("run task " + saveCfgTask.getType() + " successful"));
                        }
                        saveCfgTask.closeTask();
                    }
                    if ((isls = ((LinkSecurityWizard)LinkSecurityCompleteStep.this.getWizard()).getSelectedIslList()).size() > 0) {
                        Fabric fab = isls.get(0).getSwitch1().getFabric();
                        try {
                            ClientController.getInstance().rediscover(fab, false);
                        }
                        catch (Exception ex) {
                            _Logger.error((Object)ex.getMessage());
                        }
                    }
                    return new Boolean(hasError);
                }
                catch (Exception e) {
                    if (LinkSecurityCompleteStep.this.isCanceled) {
                        _Logger.warn((Object)(e.getMessage() + ".  Cancel pressed."));
                        return false;
                    }
                    _Logger.warn((Object)"Got exceptions from apply settings:", (Throwable)e);
                    return e;
                }
            }

            @Override
            public void finished() {
                Object ret = this.getValue();
                LinkSecurityCompleteStep.this.setRunApply(false);
                if (ret instanceof Exception) {
                    step.actionFinished(false);
                    Util.errorMessage((Component)step.getWizard(), (Exception)ret);
                } else if (ret instanceof Boolean) {
                    step.actionFinished((Boolean)ret == false);
                }
            }
        };
        worker.start();
    }
}

