/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.linksecurity;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.linksecurity.ISLChooserTable;
import com.cisco.dcbu.sm.client.linksecurity.IslChooserTableModel;
import com.cisco.dcbu.sm.client.linksecurity.LinkSecurityWizard;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.npv.view.ProgressWindow;
import com.cisco.dcbu.sm.client.wizardTask.IslRenderer;
import com.cisco.dcbu.sm.common.dto.ESPDto;
import com.cisco.dcbu.sm.common.dto.SecurityAssociationDto;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.IslBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class LinkSecuritySelectIslStep
extends WizardPanel {
    public static final String StepTitle = "Step 1 of 4: Select ISLs To Secure";
    public static final String StepDesp = "Select one or more ISLs to secure and/or edit security on.Only ISLs on ESP capable blades/switches with their FC-SP port mode turned to \"on\" are shown.";
    public static final String MIN_VERSION = "4.2(0)";
    public static final String BOGOTA_VERSION = "5.0(0)";
    Logger _logger = LogManager.getLogger((String)"esp");
    private JScrollPane _scrPanel;
    ISLChooserTable _islTable;
    IslChooserTableModel _islTableModel;
    List<Isl> _allIsls = new ArrayList<Isl>();
    boolean _retrieveSAFailed = false;
    boolean _retrieveSecureISLFailed = false;
    private int _instanceID;

    public LinkSecuritySelectIslStep(LinkSecurityWizard wizard, List<Isl> selIsls, int instanceID) {
        super(StepTitle, StepDesp, wizard, LinkSecurityWizard.WIZARD_ICON);
        this._instanceID = instanceID;
        this._allIsls.clear();
        if (selIsls == null) {
            MgmtDomainIf selDomain = ClientController.getInstance().getSelectedDomain();
            ArrayList<Isl> isls = selDomain.getIsls(null);
            this._allIsls.addAll(this.filterNonValidISLs(isls));
        } else {
            this._allIsls.addAll(this.filterNonValidISLs(selIsls));
        }
        if (this._allIsls.isEmpty()) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), "None of the ISLs are found to be ESP capable.\nTo be ESP capable the following must be true for the ISL:\n- both ports are on ESP capable blades/switches running the minimum supported OS version. \n- both switches have FC-SP feature enabled.\n- both ports have FC-SP mode set to \"On\".\n- link is not an FCIP link.\n- link is up.\nNOTE: For FC-SP feature enable or mode set issues, run DCNM-SAN \"Enable FC-SP\" wizard for proper configuration.");
            this.getWizard().dispose();
        }
        this.initialize();
    }

    private List<Isl> filterNonValidISLs(List<Isl> isls) {
        ArrayList<Isl> resultIsls = new ArrayList<Isl>();
        if (isls == null) {
            return resultIsls;
        }
        for (Isl nextIsl : isls) {
            Switch sw2;
            Switch sw1;
            if (nextIsl.isPresent() && nextIsl.isPortChannel()) {
                sw1 = nextIsl.getSwitch1();
                sw2 = nextIsl.getSwitch2();
                if (!sw1.isVersionGreaterThanEqual(BOGOTA_VERSION) && !sw2.isVersionGreaterThanEqual(BOGOTA_VERSION)) {
                    resultIsls.addAll(this.filterNonValidISLs(nextIsl.getPCMemberLinksAsIsls()));
                    continue;
                }
            }
            if (!nextIsl.isPresent() || nextIsl.isNpvLink() || !nextIsl.getIslBase().getEspReady() || nextIsl.isFCIP()) continue;
            sw1 = nextIsl.getSwitch1();
            sw2 = nextIsl.getSwitch2();
            if (!sw1.isVersionGreaterThanEqual(MIN_VERSION) && !sw2.isVersionGreaterThanEqual(MIN_VERSION)) continue;
            if (nextIsl.isPortChannel()) {
                List<Isl> members = nextIsl.getPCMemberLinksAsIsls();
                if (members == null || members.size() == 0) continue;
                boolean allMembersCapable = true;
                for (Isl nextMembrIsl : members) {
                    if (this.areIslCardsCorrectType(nextMembrIsl)) continue;
                    allMembersCapable = false;
                    break;
                }
                if (!allMembersCapable) continue;
                resultIsls.add(nextIsl);
                continue;
            }
            if (!this.areIslCardsCorrectType(nextIsl)) continue;
            resultIsls.add(nextIsl);
        }
        return resultIsls;
    }

    private boolean areIslCardsCorrectType(Isl isl) {
        int slot1 = IfIndexUtil.getIfIndexCard(isl.getIfIndex1());
        int slot2 = IfIndexUtil.getIfIndexCard(isl.getIfIndex2());
        Switch sw1 = isl.getSwitch1();
        Switch sw2 = isl.getSwitch2();
        Card card1 = sw1.getCard(slot1);
        Card card2 = sw2.getCard(slot2);
        int cardType1 = card1.getType();
        int cardType2 = card2.getType();
        return FRUConstants.isFCSP_ESPCapableCardType(cardType1) && FRUConstants.isFCSP_ESPCapableCardType(cardType2);
    }

    @Override
    public String getTitle() {
        return StepTitle;
    }

    @Override
    public void doNext() {
        this.getWizard().getNavigator().getNextBtn().setEnabled(false);
        boolean oldNewListsEqual = false;
        List<Isl> oldSelectedIsls = ((LinkSecurityWizard)this.getWizard()).getSelectedIslList();
        List<Isl> selectedIsls = this._islTableModel.getSelectedIsls();
        if (selectedIsls != null && selectedIsls.size() > 0) {
            if (oldSelectedIsls != null && oldSelectedIsls.size() > 0) {
                int result;
                if (!selectedIsls.containsAll(oldSelectedIsls) && (result = JOptionPane.showConfirmDialog(this, "Previously selected Isls have been removed.  \nAny configuration changes you made earlier related to these ISls will be lost. \nDo you wish to continue?", "WARNING: FC-SP ESP Setup Wizard", 0, 2)) == 1) {
                    this.getWizard().getNavigator().getNextBtn().setEnabled(true);
                    return;
                }
                if (selectedIsls.equals(oldSelectedIsls)) {
                    oldNewListsEqual = true;
                }
            }
            if (!oldNewListsEqual || this._retrieveSAFailed || this._retrieveSecureISLFailed) {
                ((LinkSecurityWizard)this.getWizard()).setSelectedIslList(selectedIsls);
                DoNextThread doNextThread = new DoNextThread(this, selectedIsls);
                doNextThread.start();
            } else {
                this.setDataValid(false);
                super.doNext();
                this.getWizard().getNavigator().getNextBtn().setEnabled(true);
            }
        } else {
            this.getWizard().getNavigator().getNextBtn().setEnabled(true);
            Util.errorMessage((Component)this.getWizard(), new Exception("There are no Isls selected."));
        }
    }

    protected void doNextNoChecking() {
        if (!((LinkSecurityWizard)this.getWizard()).isDisposed(this._instanceID)) {
            this.setDataValid(false);
            super.doNext();
            this.getWizard().getNavigator().getNextBtn().setEnabled(true);
        }
    }

    private boolean getStoreAndVerifySecureIsl(List<Isl> selectedIsls, ProgressWindow progressWindow) {
        progressWindow.setStatus("Checking for Secured ISLs");
        ArrayList<IslBase> securedIsls = new ArrayList<IslBase>();
        for (Isl nextIsl : selectedIsls) {
            if (!nextIsl.getIslBase().getEspSecure()) continue;
            securedIsls.add((IslBase)nextIsl.getBaseModelObject());
        }
        if (securedIsls.size() > 0) {
            progressWindow.setStatus("Retrieving existing ESP data for Secured ISLs");
            try {
                Map<IslBase, List<ESPDto>> secIslData = ClientController.getInstance().assertESP().getFcspEsp(securedIsls);
                ((LinkSecurityWizard)this.getWizard()).setSecuredIslData(secIslData);
                Set<IslBase> isls = secIslData.keySet();
                for (IslBase nextIsl : isls) {
                    List<ESPDto> dtos = secIslData.get(nextIsl);
                    ESPDto dto1 = null;
                    ESPDto dto2 = null;
                    for (ESPDto nextDto : dtos) {
                        if (nextDto.getSw().getWwn().equals(nextIsl.getSwitch1PK()._wwn) && nextDto.getIfIndex().equals(nextIsl.getIfIndex1())) {
                            dto1 = nextDto;
                            continue;
                        }
                        if (!nextDto.getSw().getWwn().equals(nextIsl.getSwitch2PK()._wwn) || !nextDto.getIfIndex().equals(nextIsl.getIfIndex2())) continue;
                        dto2 = nextDto;
                    }
                    if (dto1 == null || dto2 == null) {
                        Util.errorMessage((Component)this.getWizard(), "ESP not found on both ends of already secured ISL -" + nextIsl + ". \nUnable to continue at this time.\nPlease remove this isl from selection to continue.");
                        return true;
                    }
                    if ((dto1.getIngress1().equals(dto2.getEgress()) || dto1.getIngress2().equals(dto2.getEgress())) && (dto2.getIngress1().equals(dto1.getEgress()) || dto2.getIngress2().equals(dto1.getEgress()))) continue;
                    Util.errorMessage((Component)this.getWizard(), "ESP configuraton shows Neither Ingress SA1 nor Ingress SA2 match the Egress of the connected ISLs port,\nto modify a link the Egress has to match either Ingress SA1 or Ingress SA2 on the connected port.");
                    return true;
                }
                progressWindow.setStatus("ESP retrieval complete.");
            }
            catch (Exception e) {
                Util.errorMessage((Component)this.getWizard(), "Unable to retrieve existing ESP configuration from all secured ISLs selected.\nUnable to continue at this time.\nError received: " + e.getMessage());
                return true;
            }
        }
        return false;
    }

    private boolean getAndStoreExistingSA(ProgressWindow progressWindow) {
        progressWindow.setStatus("Checking for Existing SA data.");
        List<SwitchBase> switchesToGetSAFor = ((LinkSecurityWizard)this.getWizard()).getSwitchesFromSwitchPairsWithNoSA();
        try {
            if (switchesToGetSAFor != null && !switchesToGetSAFor.isEmpty()) {
                progressWindow.setStatus("Retrieving existing SA data for switches.");
                Map<SwitchBase, List<SecurityAssociationDto>> swSa = ClientController.getInstance().assertESP().getFcspSA(switchesToGetSAFor);
                ((LinkSecurityWizard)this.getWizard()).setDiscoveredSaData(swSa);
                progressWindow.setStatus("SA retrieval complete.");
            }
        }
        catch (Exception e) {
            Util.errorMessage((Component)this.getWizard(), "Unable to retrieve Security Associations from all switches belonging to the ISLs selected.\nUnable to continue at this time.\nError received: " + e.getMessage());
            return true;
        }
        return false;
    }

    private void initialize() {
        this._islTableModel = new IslChooserTableModel(new ArrayList<Isl>(), new String[]{"Select", "ISLs", "Link Security"});
        this._islTableModel.setEditable(new boolean[]{true, false, false});
        this._islTable = new ISLChooserTable(this._islTableModel);
        this._islTable.setColumnWidth(new int[]{6, 25, 6});
        IslRenderer islRenderer = new IslRenderer();
        islRenderer.setHorizontalAlignment(2);
        this._islTable.setDefaultRenderer(Isl.class, islRenderer);
        this._scrPanel = new JScrollPane(this._islTable);
        this._islTableModel.updateIslList(this._allIsls);
        this.add((Component)this._scrPanel, "Center");
    }

    class DoNextThread
    extends Thread {
        LinkSecuritySelectIslStep parent;
        ProgressWindow progressWindow = null;
        List<Isl> selectedIsls;

        public DoNextThread(LinkSecuritySelectIslStep step, List<Isl> isls) {
            this.parent = step;
            this.selectedIsls = isls;
            this.progressWindow = new ProgressWindow(LinkSecuritySelectIslStep.this.getWizard(), LinkSecuritySelectIslStep.this.getWizard().getTitle(), "Loading existing SA and ESP data.");
            this.progressWindow.setIndeterminate(true);
            this.progressWindow.start();
        }

        @Override
        public void run() {
            LinkSecuritySelectIslStep.this._retrieveSecureISLFailed = LinkSecuritySelectIslStep.this.getStoreAndVerifySecureIsl(this.selectedIsls, this.progressWindow);
            if (LinkSecuritySelectIslStep.this._retrieveSecureISLFailed) {
                this.progressWindow.stop();
                LinkSecuritySelectIslStep.this.getWizard().getNavigator().getNextBtn().setEnabled(true);
                return;
            }
            LinkSecuritySelectIslStep.this._retrieveSAFailed = LinkSecuritySelectIslStep.this.getAndStoreExistingSA(this.progressWindow);
            if (LinkSecuritySelectIslStep.this._retrieveSAFailed) {
                this.progressWindow.stop();
                LinkSecuritySelectIslStep.this.getWizard().getNavigator().getNextBtn().setEnabled(true);
                return;
            }
            this.progressWindow.stop();
            this.parent.doNextNoChecking();
        }
    }
}

