/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.linksecurity;

import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.sm.client.linksecurity.SASwitchPair;
import com.cisco.dcbu.sm.client.linksecurity.SATable;
import com.cisco.dcbu.sm.client.linksecurity.SATableModel;
import com.cisco.dcbu.sm.client.wizardTask.IntegerAsStringRenderer;
import com.cisco.dcbu.sm.client.wizardTask.LongAsStringRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class SAViewDialog
extends JDialog
implements ActionListener {
    SATable _saTableSw1;
    SATable _saTableSw2;
    SATableModel _saTableModelSw1;
    SATableModel _saTableModelSw2;
    JScrollPane _scrPanel1;
    JScrollPane _scrPanel2;
    SASwitchPair _swPair;

    public SAViewDialog(JDialog parent, SASwitchPair pair) {
        super((Dialog)parent, "Existing Security Associations");
        this.setModal(true);
        this.setSize(600, 600);
        this.setResizable(false);
        this._swPair = pair;
        this.setLocationRelativeTo(parent);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SAViewDialog.this.dispose();
            }
        });
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        JPanel textPanel = new JPanel();
        JTextArea summaryText = new JTextArea("Each of the switches contained in the switch pair are listed here along with the Security Associations that already exist on the respective switch.");
        summaryText.setWrapStyleWord(true);
        summaryText.setEditable(false);
        summaryText.setLineWrap(true);
        summaryText.setOpaque(false);
        summaryText.setFont((Font)UIManager.getDefaults().get("Table.font"));
        summaryText.setPreferredSize(new Dimension(550, 50));
        textPanel.add(summaryText);
        textPanel.add(new DialogSeparator());
        this.add((Component)textPanel, "North");
        JPanel mainPanel = new JPanel(new GridLayout(2, 1));
        mainPanel.setBorder(new EmptyBorder(8, 8, 8, 8));
        JLabel[] labels = DialogUtil.buildLabels(new String[]{"Switch: " + this._swPair.getSw1().toString(), "Switch: " + this._swPair.getSw2().toString()});
        JPanel top = new JPanel(new BorderLayout());
        top.setBorder(BorderFactory.createEtchedBorder(1));
        JPanel labelPanel = new JPanel(new FlowLayout(0));
        labelPanel.add(labels[0]);
        top.add((Component)labelPanel, "North");
        this._saTableModelSw1 = new SATableModel(new String[]{"SPI", "Salt", "Key"});
        this._saTableModelSw1.setEditable(new boolean[]{false, false, false});
        this._saTableModelSw1.updateSAList(this._swPair.getSaListSw1().values());
        this._saTableSw1 = new SATable(this._saTableModelSw1);
        this._saTableSw1.setColumnWidth(new int[]{6, 6, 25});
        IntegerAsStringRenderer intAsStringRenderer = new IntegerAsStringRenderer();
        this._saTableSw1.setDefaultRenderer(Integer.class, intAsStringRenderer);
        LongAsStringRenderer longAsStringRenderer = new LongAsStringRenderer();
        this._saTableSw1.setDefaultRenderer(Long.class, longAsStringRenderer);
        this._scrPanel1 = new JScrollPane(this._saTableSw1);
        top.add((Component)this._scrPanel1, "Center");
        JPanel bottom = new JPanel(new BorderLayout());
        JPanel labelPanel2 = new JPanel(new FlowLayout(0));
        labelPanel2.add(labels[1]);
        bottom.add((Component)labelPanel2, "North");
        bottom.setBorder(BorderFactory.createEtchedBorder(1));
        this._saTableModelSw2 = new SATableModel(new String[]{"SPI", "Salt", "Key"});
        this._saTableModelSw2.setEditable(new boolean[]{false, false, false});
        this._saTableModelSw2.updateSAList(this._swPair.getSaListSw2().values());
        this._saTableSw2 = new SATable(this._saTableModelSw2);
        this._saTableSw2.setColumnWidth(new int[]{6, 6, 25});
        this._saTableSw2.setDefaultRenderer(Integer.class, intAsStringRenderer);
        this._saTableSw2.setDefaultRenderer(Long.class, longAsStringRenderer);
        this._scrPanel2 = new JScrollPane(this._saTableSw2);
        bottom.add((Component)this._scrPanel2, "Center");
        mainPanel.add(top);
        mainPanel.add(bottom);
        this.add((Component)mainPanel, "Center");
        JButton b = new JButton("Close");
        b.setActionCommand("C");
        b.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(b);
        this.add((Component)buttonPanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("C")) {
            this.dispose();
        }
    }
}

