/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.logicaltree;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.ui.tree.DynamicTreeNode;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.logicaltree.VsanTreeCommand;
import com.cisco.dcbu.sm.client.logicaltree.ZoneTreeNode;
import com.cisco.dcbu.sm.client.model.EnforcedZone;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.awt.Cursor;
import java.util.Arrays;

public class ZoneSetTreeNode
extends DynamicTreeNode {
    Vsan _vsan;
    Fabric _fabric;
    int _regionId = -1;

    public int getRegionId() {
        return this._regionId;
    }

    public ZoneSetTreeNode(VsanTreeCommand userObject, Vsan vsan) {
        super(userObject);
        this._vsan = vsan;
    }

    public ZoneSetTreeNode(VsanTreeCommand userObject, Fabric f, int region) {
        super(userObject);
        this._fabric = f;
        this._regionId = region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadChildren() {
        BrowserFrame.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        try {
            Object[] zones;
            Object[] objectArray = zones = this._vsan != null ? this._vsan.getEnforcedZones() : this._fabric.getIvrEnforcedZones(this._regionId);
            if (zones != null) {
                Arrays.sort(zones);
                for (int i = 0; i < zones.length; ++i) {
                    ZoneTreeNode znNd = this._vsan != null ? new ZoneTreeNode(new VsanTreeCommand(this._vsan, null, "zoneMemberReport"), (EnforcedZone)zones[i], this._regionId) : new ZoneTreeNode(new VsanTreeCommand(this._fabric, null, "enforcedIvrZoneReport"), (EnforcedZone)zones[i], this._regionId);
                    this.insert(znNd, i);
                }
            }
        }
        catch (Exception ex) {
            DefaultLogger._DefLogger.error((Object)ex);
        }
        finally {
            BrowserFrame.getInstance().setCursor(Cursor.getDefaultCursor());
        }
        return false;
    }

    @Override
    public void setUserObject(Object userObject) {
        try {
            VsanTreeCommand vtc = (VsanTreeCommand)this.getUserObject();
            if (vtc != null) {
                vtc._vsan = null;
                vtc._method = null;
                vtc._label = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.setUserObject(userObject);
    }

    @Override
    public String toString() {
        if (this._vsan != null) {
            return this._vsan.getEnforcedZoneSetName();
        }
        return this._fabric.getIvrEnforcedZoneSetName(this._regionId) + (this._regionId > 0 ? "(Region ID:" + this._regionId + ")" : "");
    }
}

