/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map;

import com.cisco.dcbu.sm.client.map.PlatformNode;
import com.cisco.dcbu.sm.client.model.AbstractModelObject;
import com.cisco.dcbu.sm.client.model.Enclosure;
import com.cisco.dcbu.sm.client.model.EndPort;
import java.util.ArrayList;

public class HostNode
extends PlatformNode {
    private static final String ICON_NAME = "16x16-end_station.gif";
    private static final String KUBRICK_ICON_NAME = "Device_pc_3045_";
    private static final String VIRTUAL_ICON_NAME = "16x16-end_station-virtual.gif";
    private static final String DEVICE_TYPE = "Host";

    public HostNode(EndPort plat) {
        super(plat);
    }

    public String getDeviceType() {
        return DEVICE_TYPE;
    }

    @Override
    public String getIconName() {
        AbstractModelObject model = (AbstractModelObject)this.getModel();
        if (model != null) {
            try {
                if (model instanceof Enclosure) {
                    ArrayList<EndPort> eplist = ((Enclosure)model).getMembers();
                    if (eplist != null) {
                        for (int i = 0; i < eplist.size(); ++i) {
                            EndPort ep = eplist.get(i);
                            if (ep == null || ep.getBaseModelObject() == null || !ep.isVirtualized()) continue;
                            return VIRTUAL_ICON_NAME;
                        }
                    }
                } else if (((EndPort)model).isVirtualized()) {
                    return VIRTUAL_ICON_NAME;
                }
            }
            catch (Exception e) {
                _Logger.trace((Object)"logEmptyCatch", (Throwable)e);
            }
        }
        return ICON_NAME;
    }

    @Override
    public String getKubrickIconName() {
        return KUBRICK_ICON_NAME;
    }
}

