/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.FMStandalone;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.map.MapFactory;
import com.cisco.dcbu.sm.client.map.MapFactoryIf;
import com.cisco.dcbu.sm.client.map.MapLink;
import com.cisco.dcbu.sm.client.map.MapNode;
import com.cisco.dcbu.sm.client.map.actions.AttributesAction;
import com.cisco.dcbu.sm.client.map.actions.DMMapAction;
import com.cisco.dcbu.sm.client.map.actions.MiscMapActions;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.common.type.IslPK;
import javax.swing.JMenuItem;

public class ISLMapLink
extends MapLink {
    public ISLMapLink(Isl link) {
        super(MapFactory.getInstance().getNode(link.getSwitch1()), MapFactory.getInstance().getNode(link.getSwitch2()), link.hashCode());
        this.setModel(link);
        link.setUserObject(this);
    }

    public ISLMapLink(Isl link, MapFactoryIf mapFactory) {
        super(mapFactory.getNode(link.getSwitch1()), mapFactory.getNode(link.getSwitch2()), link.hashCode());
        this.setModel(link);
        link.setUserObject(this);
    }

    public ISLMapLink(MapNode n1, MapNode n2, Isl model) {
        super(n1, n2, model.hashCode());
        this.setModel(model);
        model.setUserObject(this);
    }

    @Override
    public boolean isDashed() {
        Isl isl = (Isl)this.getModel();
        return isl.isTunnel();
    }

    @Override
    public boolean isDotted() {
        Isl isl = (Isl)this.getModel();
        return isl.isDWDM();
    }

    @Override
    public boolean isDotDotDashed() {
        Isl isl = (Isl)this.getModel();
        return isl.isFCoE();
    }

    @Override
    public int getStrokeWidth() {
        Isl isl = (Isl)this.getModel();
        if (isl.isFCoE()) {
            if (IfIndexUtil.getType(isl.getIfIndex1()) == 30 && IfIndexUtil.getType(isl.getIfIndex2()) == 30 && (IfIndexUtil.getSubType(isl.getIfIndex1()) == 1 || IfIndexUtil.getSubType(isl.getIfIndex2()) == 1)) {
                return 2;
            }
            return 1;
        }
        return 1;
    }

    @Override
    public boolean showSecuredOnLinks() {
        return true;
    }

    @Override
    public boolean isSecured() {
        return false;
    }

    @Override
    public boolean isSecuredEncrypted() {
        Isl isl = (Isl)this.getModel();
        if (isl != null) {
            return isl.isEspSecured();
        }
        return false;
    }

    @Override
    public String getClassName() {
        return "ISL";
    }

    @Override
    public boolean purge() throws Exception {
        Isl isl = (Isl)this.getModel();
        if (isl == null || isl.isPresent()) {
            return false;
        }
        ClientController.getInstance().assertModelFacade().purgeIsl((IslPK)isl.getPK());
        return true;
    }

    @Override
    public long getSpeed() {
        Isl isl = (Isl)this.getModel();
        return isl.getSpeed();
    }

    public static JMenuItem[] getMenuItems(JMenuItem[] _menuItems) {
        if (_menuItems != null) {
            return _menuItems;
        }
        JMenuItem[] mi = MapLink.getMenuItems(_menuItems);
        int number = 13;
        _menuItems = new JMenuItem[mi.length + ++number];
        int l = mi.length;
        try {
            System.arraycopy(mi, 0, _menuItems, 0, l);
        }
        catch (Exception e) {
            l = 0;
        }
        _menuItems[l++] = Util.createMenuItem("Element Manager", "linkElementManager", "Element Manager", DMMapAction.getInstance());
        _menuItems[l++] = Util.createMenuItem("FCIP Tunnel Attributes", "fcipAttribute", "FCIP Tunnel Attributes", AttributesAction.getInstance());
        _menuItems[l++] = null;
        _menuItems[l++] = Util.createMenuItem("Create Port Channel...", "createPortChannel", "Create Port Channel...", AttributesAction.getInstance());
        _menuItems[l++] = null;
        _menuItems[l++] = Util.createMenuItem("Re-enable", "reenableIsl", "Re-enable", AttributesAction.getInstance());
        _menuItems[l++] = Util.createMenuItem("Enable FC-SP...", "enableFSCP", "Enable FC-SP", AttributesAction.getInstance());
        _menuItems[l++] = Util.createMenuItem("Enable FC-SP ESP Link Security...", "launchESPLinkSecurityWizard", "Enable FC-SP ESP", AttributesAction.getInstance());
        _menuItems[l++] = Util.createMenuItem("Port Guard", "portGuard", "Port Guard", AttributesAction.getInstance());
        _menuItems[l++] = Util.createMenuItem("SAN Extension Tuner...", "sanExtTuner", "SAN Extension Tuner...", AttributesAction.getInstance());
        _menuItems[l++] = null;
        if (!FMStandalone.isStandAlone()) {
            _menuItems[l++] = Util.createMenuItem("Show Statistics", "showStatistics", "Show Statistics", AttributesAction.getInstance());
            _menuItems[l++] = null;
        }
        _menuItems[l++] = Util.createMenuItem("Purge", "purge", "Purge", MiscMapActions.getInstance());
        return _menuItems;
    }
}

