/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map;

import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.map.CloudLoopNode;
import com.cisco.dcbu.sm.client.map.EdgeMapLink;
import com.cisco.dcbu.sm.client.map.FCLoopNode;
import com.cisco.dcbu.sm.client.map.FCoEEdgeMapLink;
import com.cisco.dcbu.sm.client.map.FCoEVdcSwitchNode;
import com.cisco.dcbu.sm.client.map.FabricNode;
import com.cisco.dcbu.sm.client.map.FiconCUP;
import com.cisco.dcbu.sm.client.map.HostNode;
import com.cisco.dcbu.sm.client.map.ISCSIHostNode;
import com.cisco.dcbu.sm.client.map.ISLMapLink;
import com.cisco.dcbu.sm.client.map.LoopLink;
import com.cisco.dcbu.sm.client.map.MDS9216SwitchNode;
import com.cisco.dcbu.sm.client.map.MDS95xxSwitchNode;
import com.cisco.dcbu.sm.client.map.MDSN7KSwitchNode;
import com.cisco.dcbu.sm.client.map.MDSSwitchNode;
import com.cisco.dcbu.sm.client.map.MainFrame;
import com.cisco.dcbu.sm.client.map.MapFactoryIf;
import com.cisco.dcbu.sm.client.map.MapLink;
import com.cisco.dcbu.sm.client.map.MapNode;
import com.cisco.dcbu.sm.client.map.N5KSwitchNode;
import com.cisco.dcbu.sm.client.map.NpvMapLink;
import com.cisco.dcbu.sm.client.map.PCMapLink;
import com.cisco.dcbu.sm.client.map.PCNpvMapLink;
import com.cisco.dcbu.sm.client.map.SN5428SwitchNode;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.StorageNode;
import com.cisco.dcbu.sm.client.map.SwitchNode;
import com.cisco.dcbu.sm.client.map.WarningNode;
import com.cisco.dcbu.sm.client.map.actions.AttributesAction;
import com.cisco.dcbu.sm.client.map.actions.ExpandMultipleLinksMapAction;
import com.cisco.dcbu.sm.client.model.AbstractFcLink;
import com.cisco.dcbu.sm.client.model.AbstractModelObject;
import com.cisco.dcbu.sm.client.model.Enclosure;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Hub;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.UserDefinedGroup;
import com.cisco.dcbu.sm.client.model.UserDefinedGroupManager;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.GroupPK;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

public class MapFactory
implements MapFactoryIf {
    static HashMap _FabricMaps = new HashMap();
    private static MapFactory _Instance = null;
    public static Logger _Logger = Logger.getLogger(MapFactory.class);

    public MapNode createNode(Switch dev) {
        SwitchNode node = null;
        node = dev.isN7K() ? (dev.isVdc() ? new FCoEVdcSwitchNode(dev) : new MDSN7KSwitchNode(dev)) : (dev.isMDS() || dev.isQuail() ? (dev.isMdsDirector() ? new MDS95xxSwitchNode(dev) : (dev.getModelType() == 380 ? new MDS9216SwitchNode(dev) : (FRUConstants.isN5K(dev.getModelType()) ? new N5KSwitchNode(dev) : new MDSSwitchNode(dev)))) : (dev.isSN5428() ? new SN5428SwitchNode(dev) : new SwitchNode(dev)));
        return node;
    }

    public MapLink createLink(Isl isl) {
        if (isl.isPortChannel()) {
            return new PCMapLink(isl, this);
        }
        return new ISLMapLink(isl, this);
    }

    public MapLink createLink(NpvLink link) {
        if (link.isPortChannel()) {
            return new PCNpvMapLink(link, this);
        }
        return new NpvMapLink(link, this);
    }

    public static MapFactory getInstance() {
        if (_Instance == null) {
            _Instance = new MapFactory();
        }
        return _Instance;
    }

    private MapFactory() {
    }

    void resetFabric(Fabric fabric) {
        block31: {
            int i;
            block30: {
                block29: {
                    block28: {
                        block27: {
                            block26: {
                                if (fabric == null) {
                                    Fabric[] fs = San.getInstance().getFabrics();
                                    if (fs != null && fs.length > 0) {
                                        for (int i2 = 0; i2 < fs.length; ++i2) {
                                            fs[i2].setUserObject(null);
                                        }
                                    }
                                    return;
                                }
                                try {
                                    this.getMap((Fabric)fabric)._enclosureNodes.clear();
                                }
                                catch (Exception ex1) {
                                    if (!_Logger.isTraceEnabled()) break block26;
                                    _Logger.trace((Object)"logEmptyCatch - _enclosureNodes", (Throwable)ex1);
                                }
                            }
                            try {
                                Switch[] switches = fabric.getSwitches();
                                if (switches != null) {
                                    for (i = 0; i < switches.length; ++i) {
                                        switches[i].setUserObject(null);
                                    }
                                }
                            }
                            catch (Exception ex) {
                                if (!_Logger.isTraceEnabled()) break block27;
                                _Logger.trace((Object)"logEmptyCatch - switches", (Throwable)ex);
                            }
                        }
                        try {
                            EndPort[] eps = fabric.getEndPorts();
                            if (eps != null) {
                                for (i = 0; i < eps.length; ++i) {
                                    Enclosure enclosure = eps[i].getEnclosure();
                                    if (enclosure != null) {
                                        enclosure.setUserObject(null);
                                    }
                                    eps[i].setUserObject(null);
                                }
                            }
                        }
                        catch (Exception ex) {
                            if (!_Logger.isTraceEnabled()) break block28;
                            _Logger.trace((Object)"logEmptyCatch - EndPort", (Throwable)ex);
                        }
                    }
                    try {
                        Enclosure[] encls = fabric.getEnclosures();
                        if (encls != null) {
                            for (i = 0; i < encls.length; ++i) {
                                encls[i].setUserObject(null);
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (!_Logger.isTraceEnabled()) break block29;
                        _Logger.trace((Object)"logEmptyCatch - Enclosure", (Throwable)ex);
                    }
                }
                try {
                    Isl[] isls = fabric.getIsls();
                    if (isls != null) {
                        for (i = 0; i < isls.length; ++i) {
                            isls[i].setUserObject(null);
                        }
                    }
                }
                catch (Exception ex) {
                    if (!_Logger.isTraceEnabled()) break block30;
                    _Logger.trace((Object)"logEmptyCatch - Isls", (Throwable)ex);
                }
            }
            try {
                Hub[] hubs = fabric.getHubs();
                if (hubs != null) {
                    for (i = 0; i < hubs.length; ++i) {
                        hubs[i].setUserObject(null);
                    }
                }
            }
            catch (Exception ex) {
                if (!_Logger.isTraceEnabled()) break block31;
                _Logger.trace((Object)"logEmptyCatch - Hubs", (Throwable)ex);
            }
        }
    }

    public void reset() {
        Fabric[] fs = San.getInstance().getFabrics();
        if (fs == null) {
            return;
        }
        for (int i = 0; i < fs.length; ++i) {
            this.resetFabric(fs[i]);
        }
    }

    public SmMap createGraph(Fabric fabric) {
        SmMap g = this.getGraph(fabric, true);
        this.populateGraph(fabric, g);
        return g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void populateGraph(Fabric fabric, SmMap g) {
        if (g == null) {
            return;
        }
        if (fabric != null) {
            try {
                g.setBulkAdding(true);
                long lastTime = 0L;
                lastTime = System.currentTimeMillis();
                this.populateSwitches(fabric, g);
                if (_Logger.isInfoEnabled()) {
                    _Logger.info((Object)("time to populateSwitches " + (System.currentTimeMillis() - lastTime) + " millisecs " + g.getText()));
                }
                lastTime = System.currentTimeMillis();
                this.populateHubs(fabric, g);
                if (_Logger.isInfoEnabled()) {
                    _Logger.info((Object)("time to populateHubs " + (System.currentTimeMillis() - lastTime) + " millisecs " + g.getText()));
                }
                lastTime = System.currentTimeMillis();
                this.populateEndNodes(fabric, g);
                if (_Logger.isInfoEnabled()) {
                    _Logger.info((Object)("time to populateEndNodes " + (System.currentTimeMillis() - lastTime) + " millisecs " + g.getText()));
                }
                lastTime = System.currentTimeMillis();
                this.populateISLs(fabric, g);
                if (_Logger.isInfoEnabled()) {
                    _Logger.info((Object)("time to populateISLs " + (System.currentTimeMillis() - lastTime) + " millisecs " + g.getText()));
                }
                lastTime = System.currentTimeMillis();
                this.populateEdgeLinks(fabric, g);
                if (_Logger.isInfoEnabled()) {
                    _Logger.info((Object)("time to populateEdgeLinks " + (System.currentTimeMillis() - lastTime) + " millisecs " + g.getText()));
                }
                lastTime = System.currentTimeMillis();
                this.populateNpvLinks(fabric, g);
                if (_Logger.isInfoEnabled()) {
                    _Logger.info((Object)("time to populateNpvLinks " + (System.currentTimeMillis() - lastTime) + " millisecs " + g.getText()));
                }
                lastTime = System.currentTimeMillis();
                g.setPreferences();
                if (_Logger.isInfoEnabled()) {
                    _Logger.info((Object)("time to g.setPreferences() " + (System.currentTimeMillis() - lastTime) + " millisecs " + g.getText()));
                }
                lastTime = System.currentTimeMillis();
                g.setBulkAdding(false);
                g.load();
                if (!_Logger.isInfoEnabled()) return;
                _Logger.info((Object)("time to g.load() " + (System.currentTimeMillis() - lastTime) + " millisecs " + g.getText()));
                return;
            }
            finally {
                g.setBulkAdding(false);
            }
        } else {
            if (!g.isSanMap()) return;
            g.resetData();
            if (!ClientController.getInstance().isRestrictedTopology()) return;
            this.populateAllSansForRestrictedTopology(g);
            return;
        }
    }

    private void populateAllSans(SmMap g) {
        Enclosure[] enclosures;
        MapNode node;
        g.clear();
        Fabric[] fabrics = San.getInstance().getFabrics();
        if (fabrics != null && fabrics.length > 0) {
            for (int j = 0; j < fabrics.length; ++j) {
                if (fabrics[j].getUserObject() != null) continue;
                node = new FabricNode(fabrics[j]);
                g.addNode(node);
            }
        }
        if ((enclosures = San.getInstance().getEnclosures()) != null && enclosures.length > 0) {
            for (int j = 0; j < enclosures.length; ++j) {
                if (!enclosures[j].isMemberOfMultiFabrics()) continue;
                node = (MapNode)SmMap.getInstance()._enclosureNodes.get(enclosures[j].getEnclosureName());
                if (node == null) {
                    if (enclosures[j] == null || enclosures[j].getMembers() == null || enclosures[j].getMembers().size() == 0) continue;
                    EndPort ep = enclosures[j].getMembers().get(0);
                    node = ep.isFiconCH() ? new MainFrame(ep) : (ep.isTarget() || ep.isFiconCU() ? new StorageNode(ep) : (ep.isISCSI() ? new ISCSIHostNode(ep) : (ep.isFiconCup() ? new FiconCUP(ep) : new HostNode(ep))));
                    g.addNode(node);
                    ep.setUserObject(null);
                    SmMap.getInstance()._enclosureNodes.put(enclosures[j].getEnclosureName(), node);
                }
                ArrayList fabricList = enclosures[j].getFabricPKs();
                for (int k = 0; k < fabricList.size(); ++k) {
                    Fabric fabric = San.getInstance().getFabric((FabricPK)fabricList.get(k));
                    if (fabric == null || fabric.getPK() == null || !enclosures[j].isMemberOf((FabricPK)fabric.getPK())) continue;
                    ArrayList eps = enclosures[j].getMembers((FabricPK)fabric.getPK());
                    for (int l = 0; l < eps.size(); ++l) {
                        if (fabric.getUserObject() == null) continue;
                        g.addLink(new EdgeMapLink((MapNode)fabric.getUserObject(), node, (EndPort)eps.get(l)));
                    }
                }
            }
        }
    }

    private void populateAllSansForRestrictedTopology(SmMap g) {
        Switch[] s;
        MapNode node;
        ArrayList<FabricNode> fabricNodes = new ArrayList<FabricNode>();
        g.clear();
        San san = San.getInstance();
        Enclosure[] enclosures = san.getEnclosures(san.getRestrictdTopologyEndPorts());
        if (enclosures.length > SmMap.getMapNodeLimit()) {
            g.addNode(new WarningNode(SmMap.getMapNodeLimit() + " limit exceeded - found " + san.getRestrictdTopologyEndPorts().size() + " zone members"));
            return;
        }
        if (san.getRestrictedTopologyPathType() == 0) {
            Switch[] switches;
            Fabric[] fabrics = san.getRestrictdTopologyFabrics();
            if (fabrics != null && fabrics.length > 0) {
                for (int j = 0; j < fabrics.length; ++j) {
                    if (fabrics[j].getUserObject() != null) continue;
                    node = new FabricNode(fabrics[j]);
                    fabrics[j].setUserObject(node);
                    g.addNode(node);
                    fabricNodes.add((FabricNode)node);
                }
            }
            if ((switches = san.getRestrictdTopologySwitches()) != null && switches.length > 0) {
                for (int i = 0; i < switches.length; ++i) {
                    if (!san.isEdgeSwitch(switches[i].getSwitchPK())) continue;
                    g.addNode(this.createNode(switches[i]));
                }
            }
            this.populateSwitchFabricLinks(san.getRestrictedTopologySourceSwitchLinks(), g);
            this.populateSwitchFabricLinks(san.getRestrictedTopologyTargetSwitchLinks(), g);
            this.populateSwitchFabricLinks(san.getRestrictedTopologySourceToTargetSwitchLinks(), g);
        } else {
            NpvLink[] npvLinks;
            Isl[] isls;
            Switch[] switches = san.getRestrictdTopologySwitches();
            if (switches != null && switches.length > 0) {
                for (int i = 0; i < switches.length; ++i) {
                    g.addNode(this.createNode(switches[i]));
                }
            }
            if ((isls = san.getRestrictdTopologyIsls()) != null && isls.length > 0) {
                Switch sw1 = null;
                Switch sw2 = null;
                for (int i = 0; i < isls.length; ++i) {
                    try {
                        sw1 = isls[i].getSwitch1();
                        sw2 = isls[i].getSwitch2();
                        if (sw1 == null && sw2 == null) continue;
                        g.addLink(this.createLink(isls[i]));
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("Link not added ISL " + isls[i].getName());
                    }
                }
            }
            if ((npvLinks = san.getRestrictdTopologyNpvLinks()) != null && npvLinks.length > 0) {
                Switch sw1 = null;
                Switch sw2 = null;
                for (int i = 0; i < npvLinks.length; ++i) {
                    try {
                        sw1 = npvLinks[i].getSwitch1();
                        sw2 = npvLinks[i].getSwitch2();
                        if (sw1 == null && sw2 == null) continue;
                        g.addLink(this.createLink(npvLinks[i]));
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("Link not added NPV " + npvLinks[i].getName());
                    }
                }
            }
        }
        if (enclosures != null && enclosures.length > 0) {
            for (int j = 0; j < enclosures.length; ++j) {
                node = (MapNode)SmMap.getInstance()._enclosureNodes.get(enclosures[j].getEnclosureName());
                node = null;
                if (node == null) {
                    if (enclosures[j] == null || enclosures[j].getMembers() == null || enclosures[j].getMembers().size() == 0) continue;
                    EndPort ep = enclosures[j].getMembers().get(0);
                    if (ep.isFiconCH()) {
                        node = new MainFrame(ep);
                        node.setRoot(true);
                    } else if (ep.isTarget() || ep.isFiconCU()) {
                        node = new StorageNode(ep);
                    } else if (ep.isISCSI()) {
                        node = new ISCSIHostNode(ep);
                        node.setRoot(true);
                    } else if (ep.isFiconCup()) {
                        node = new FiconCUP(ep);
                        node.setRoot(true);
                    } else {
                        node = new HostNode(ep);
                        node.setRoot(true);
                    }
                    if (ep.isInitiator()) {
                        node.setTextAlignment(0);
                    } else if (ep.isTarget()) {
                        node.setTextAlignment(2);
                    }
                    g.addNode(node);
                    SmMap.getInstance()._enclosureNodes.put(enclosures[j].getEnclosureName(), node);
                }
                ArrayList fabricList = enclosures[j].getFabricPKs();
                for (int k = 0; k < fabricList.size(); ++k) {
                    try {
                        Fabric fabric = san.getFabric((FabricPK)fabricList.get(k));
                        if (fabric == null || fabric.getPK() == null || !san.isMemberOfRestrictedTopology(fabric) || !enclosures[j].isMemberOf((FabricPK)fabric.getPK())) continue;
                        ArrayList<EndPort> eps = enclosures[j].getMembers((FabricPK)fabric.getPK());
                        eps = enclosures[j].getMembers();
                        for (int l = 0; l < eps.size(); ++l) {
                            try {
                                EndPort ep = eps.get(l);
                                if (!san.isMemberOfRestrictedTopology(ep)) continue;
                                ((EndPortBase)ep.getBaseModelObject()).getSwitchPK();
                                Switch sw = san.findSwitchByPKInRestrictedTopology(((EndPortBase)ep.getBaseModelObject()).getSwitchPK());
                                if (sw == null || sw.getUserObject() == null) continue;
                                if (ep.isFCoE()) {
                                    g.addLink(new FCoEEdgeMapLink((MapNode)sw.getUserObject(), node, ep));
                                    continue;
                                }
                                g.addLink(new EdgeMapLink((MapNode)sw.getUserObject(), node, ep));
                                continue;
                            }
                            catch (Exception ex) {
                                _Logger.error((Object)ex.getMessage(), (Throwable)ex);
                            }
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        _Logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }
        }
        if (fabricNodes != null && !fabricNodes.isEmpty()) {
            for (int i = 0; i < fabricNodes.size(); ++i) {
                FabricNode fabricNode = (FabricNode)fabricNodes.get(i);
                if (fabricNode == null || fabricNode.inedges().hasNext() || fabricNode.outedges().hasNext()) continue;
                g.remove(fabricNode);
            }
        }
        if ((s = San.getInstance().getRestrictdTopologySwitches()) == null || s.length == 0) {
            g.addNode(new WarningNode("No paths found."));
        }
    }

    protected void populateSwitchFabricLinks(ArrayList<AbstractFcLink> links, SmMap g) {
        San san = San.getInstance();
        if (links != null && links.size() > 0) {
            AbstractFcLink link = null;
            WwnKey sw1PK = null;
            WwnKey sw2PK = null;
            Switch sw1 = null;
            Switch sw2 = null;
            MapNode node1 = null;
            MapNode node2 = null;
            boolean isEdgeSwitch1 = false;
            boolean isEdgeSwitch2 = false;
            for (int i = 0; i < links.size(); ++i) {
                link = links.get(i);
                sw1PK = link.getSwitch1PK();
                sw2PK = link.getSwitch2PK();
                sw1 = link.getSwitch1();
                node1 = sw1 == null || sw1.getUserObject() == null ? (MapNode)link.getFabric().getUserObject() : (MapNode)sw1.getUserObject();
                sw2 = link.getSwitch2();
                node2 = sw2 == null || sw2.getUserObject() == null ? (MapNode)link.getFabric().getUserObject() : (MapNode)sw2.getUserObject();
                if (node1 == null || node2 == null) {
                    try {
                        System.out.println("FC link not added " + link.getName());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                isEdgeSwitch1 = san.isEdgeSwitch(sw1PK);
                isEdgeSwitch2 = san.isEdgeSwitch(sw2PK);
                if (isEdgeSwitch1 && isEdgeSwitch2) {
                    if (link instanceof NpvLink) {
                        g.addLink(new NpvMapLink(node1, node2, (NpvLink)link));
                        continue;
                    }
                    if (!(link instanceof Isl)) continue;
                    g.addLink(new ISLMapLink(node1, node2, (Isl)link));
                    continue;
                }
                if (isEdgeSwitch1 && sw1.getUserObject() != null) {
                    if (link instanceof NpvLink) {
                        g.addLink(new NpvMapLink(node1, node2, (NpvLink)link));
                        continue;
                    }
                    if (!(link instanceof Isl)) continue;
                    g.addLink(new ISLMapLink(node1, node2, (Isl)link));
                    continue;
                }
                if (!isEdgeSwitch2 || sw2.getUserObject() == null) continue;
                if (link instanceof NpvLink) {
                    g.addLink(new NpvMapLink(node1, node2, (NpvLink)link));
                    continue;
                }
                if (!(link instanceof Isl)) continue;
                g.addLink(new ISLMapLink(node1, node2, (Isl)link));
            }
        }
    }

    protected void populateSwitches(Fabric fabric, SmMap g) {
        Switch[] switches = fabric.getSwitches();
        if (switches == null || switches.length == 0) {
            return;
        }
        for (int i = 0; i < switches.length; ++i) {
            try {
                MapNode n = this.getNode(switches[i]);
                if (n == null) {
                    n = this.createNode(fabric, switches[i]);
                    g.addNode(n);
                }
                if (g.isVsanFilter()) {
                    Vsan vsan = fabric.getVsansByPK((VsanPK)g._filter);
                    if (vsan == null || switches[i].isMemberOfVsan(vsan)) continue;
                    n.setDimmed(true);
                    continue;
                }
                if (!g.isGroupFilter()) continue;
                UserDefinedGroupManager.getInstance();
                UserDefinedGroup group = UserDefinedGroupManager.getGroup((GroupPK)g._filter);
                if (group == null || group.switchExists(switches[i])) continue;
                n.setDimmed(true);
                continue;
            }
            catch (Exception e) {
                _Logger.error((Object)("Error in creating switch node: " + switches[i] + "\n\t" + e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateEndNodes(Fabric fabric, SmMap g) {
        EndPort[] ep = fabric.getEndPorts();
        MapNode n = null;
        if (ep == null || ep.length == 0) {
            return;
        }
        for (int i = 0; i < ep.length; ++i) {
            try {
                if (ep[i] == null) {
                    _Logger.error((Object)("MapFactory.populateEndNodes() ep[" + i + "] == null"));
                }
                if (ep[i].getBaseModelObject() == null) {
                    _Logger.error((Object)("MapFactory.populateEndNodes() ep[" + i + "].getBaseModelObject() == null"));
                }
                if ((n = this.getNode(ep[i])) == null) {
                    n = this.createNode(fabric, ep[i]);
                    if (n == null || n.getOwner() != null) continue;
                    g.addNode(n);
                }
                Enclosure enclosure = ep[i].getEnclosure();
                if (g.isVsanFilter()) {
                    Vsan vsan = fabric.getVsansByPK((VsanPK)g._filter);
                    if (vsan == null || !(enclosure == null ? !ep[i].isMemberOfVsan(vsan) : !enclosure.isMemberOfVsan(vsan))) continue;
                    n.setDimmed(true);
                    continue;
                }
                if (!g.isGroupFilter()) continue;
                UserDefinedGroupManager.getInstance();
                UserDefinedGroup group = UserDefinedGroupManager.getGroup((GroupPK)g._filter);
                if (group == null || group.exists(ep[i].getSwitch()) || !(enclosure == null ? !ep[i].isMemberOfGroup(group) : !enclosure.isMemberOfGroup(group))) continue;
                n.setDimmed(true);
            }
            catch (Exception e) {
                _Logger.error((Object)("Error in creating node: " + ep[i]), (Throwable)e);
            }
            continue;
        }
    }

    protected void populateHubs(Fabric fabric, SmMap g) {
        Hub[] hubs = fabric.getHubs();
        if (hubs == null || hubs.length == 0) {
            return;
        }
        for (int i = 0; i < hubs.length; ++i) {
            try {
                MapLink l;
                MapNode n = this.getNode(hubs[i]);
                if (n == null) {
                    n = this.createNode(fabric, hubs[i]);
                    if (n == null || n.getOwner() != null) continue;
                    g.addNode(n);
                }
                if (g.isVsanFilter()) {
                    Vsan vsan = fabric.getVsansByPK((VsanPK)g._filter);
                    l = this.getLink(hubs[i]);
                    if (l == null) continue;
                    if (vsan != null && !hubs[i].isMemberOfVsan(vsan)) {
                        n.setDimmed(true);
                        l.setDimmed(true);
                        continue;
                    }
                    n.setDimmed(false);
                    l.setDimmed(false);
                    continue;
                }
                if (!g.isGroupFilter()) continue;
                UserDefinedGroupManager.getInstance();
                UserDefinedGroup group = UserDefinedGroupManager.getGroup((GroupPK)g._filter);
                l = this.getLink(hubs[i]);
                if (l == null) continue;
                if (group != null && !group.switchExists(hubs[i].getSwitch()) && hubs[i].isMemberOfGroup(group)) {
                    n.setDimmed(true);
                    l.setDimmed(true);
                    continue;
                }
                n.setDimmed(false);
                l.setDimmed(false);
                continue;
            }
            catch (Exception e) {
                _Logger.error((Object)("Error in creating cloud node: " + hubs[i] + "\n\t" + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void populateNpvLinks(Fabric fabric, SmMap g) {
        NpvLink[] links = fabric.getNpvLinks();
        if (links == null || links.length == 0) {
            return;
        }
        for (int i = 0; i < links.length; ++i) {
            try {
                MapLink l = this.getLink(links[i]);
                if (l == null) {
                    l = this.createLink(fabric, links[i]);
                    g.addLink(l);
                }
                if (g.isVsanFilter()) {
                    Vsan vsan = fabric.getVsansByPK((VsanPK)g._filter);
                    if (vsan != null && !links[i].isMemberOfVsan(vsan)) {
                        l.setDimmed(true);
                        continue;
                    }
                    l.setDimmed(false);
                    continue;
                }
                if (!g.isGroupFilter()) continue;
                UserDefinedGroupManager.getInstance();
                UserDefinedGroup group = UserDefinedGroupManager.getGroup((GroupPK)g._filter);
                if (group != null && !group.exists(links[i].getCoreSwitch()) && !group.exists(links[i].getEdgeSwitch())) {
                    l.setDimmed(true);
                    continue;
                }
                l.setDimmed(false);
                continue;
            }
            catch (Exception e) {
                _Logger.error((Object)("Failed to create NpvLink: i=" + i), (Throwable)e);
            }
        }
    }

    protected void populateISLs(Fabric fabric, SmMap g) {
        Isl[] links = fabric.getIsls();
        if (links == null || links.length == 0) {
            return;
        }
        for (int i = 0; i < links.length; ++i) {
            try {
                MapLink l = this.getLink(links[i]);
                if (l == null) {
                    l = this.createLink(fabric, links[i]);
                    g.addLink(l);
                }
                if (g.isVsanFilter()) {
                    Vsan vsan = fabric.getVsansByPK((VsanPK)g._filter);
                    if (vsan != null && !links[i].isMemberOfVsan(vsan)) {
                        l.setDimmed(true);
                        continue;
                    }
                    l.setDimmed(false);
                    continue;
                }
                if (!g.isGroupFilter()) continue;
                UserDefinedGroupManager.getInstance();
                UserDefinedGroup group = UserDefinedGroupManager.getGroup((GroupPK)g._filter);
                if (group != null && !group.exists(links[i].getSwitch1()) && !group.exists(links[i].getSwitch2())) {
                    l.setDimmed(true);
                    continue;
                }
                l.setDimmed(false);
                continue;
            }
            catch (Exception e) {
                _Logger.error((Object)("Failed to create ISL: " + links[i]), (Throwable)e);
            }
        }
    }

    protected void populateEdgeLinks(Fabric fabric, SmMap g) {
        EndPort[] ep = fabric.getEndPorts();
        if (ep == null || ep.length == 0) {
            return;
        }
        for (int i = 0; i < ep.length; ++i) {
            try {
                MapLink l = this.getLink(ep[i]);
                if (l == null) {
                    l = this.createLink(fabric, ep[i]);
                    if (l == null) continue;
                    g.addLink(l);
                }
                if (g.isVsanFilter()) {
                    Vsan vsan = fabric.getVsansByPK((VsanPK)g._filter);
                    if (vsan != null && !ep[i].isMemberOfVsan(vsan)) {
                        l.setDimmed(true);
                        continue;
                    }
                    l.setDimmed(false);
                    continue;
                }
                if (!g.isGroupFilter()) continue;
                Enclosure enclosure = ep[i].getEnclosure();
                UserDefinedGroupManager.getInstance();
                UserDefinedGroup group = UserDefinedGroupManager.getGroup((GroupPK)g._filter);
                if (group == null || group.exists(ep[i].getSwitch()) || !(enclosure == null ? !ep[i].isMemberOfGroup(group) : !enclosure.isMemberOfGroup(group))) continue;
                l.setDimmed(true);
                continue;
            }
            catch (Exception e) {
                _Logger.error((Object)("***> Failed to create edgelink: " + ep[i].getPortWwn()), (Throwable)e);
            }
        }
    }

    public SmMap getMap(Fabric fabric) {
        return this.getGraph(fabric, false);
    }

    public static SmMap[] getMaps() {
        return _FabricMaps.values().toArray(new SmMap[_FabricMaps.size()]);
    }

    public SmMap removeGraph(FabricPK fabricPk) {
        if (fabricPk == null) {
            return null;
        }
        return (SmMap)_FabricMaps.remove(fabricPk);
    }

    public SmMap getGraph(Fabric fabric, boolean create) {
        if (fabric == null) {
            return SmMap.getInstance();
        }
        SmMap g = (SmMap)_FabricMaps.get(fabric.getPK());
        if (g != null) {
            return g;
        }
        String name = ((FabricPK)fabric.getPK()).getName();
        if (name == null) {
            name = fabric.getSeedSwitch().getIpAddress();
        }
        SmMap m = this.getGraph(g, name, fabric);
        if (create) {
            m = new SmMap(name, MapFactory.getInstance());
            m.setFabric(fabric);
            _FabricMaps.put(fabric.getPK(), m);
            JPopupMenu popup = new JPopupMenu("");
            popup.add(Util.createMenuItem("Attributes", "attributes", "SAN Attributes", AttributesAction.getInstance()));
            JMenuItem mi = new JMenuItem("Expand");
            popup.add(mi);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExpandMultipleLinksMapAction.getInstance().actionPerformed(e);
                }
            });
            m.setMultiEdgePopup(popup);
            return m;
        }
        return null;
    }

    public SmMap getGraph(SmMap g, String name, Fabric fabric) {
        if (g == null || g.graphs() == null) {
            return null;
        }
        Iterator itr = g.graphs().iterator();
        while (itr.hasNext()) {
            SmMap m = (SmMap)itr.next();
            if (name.equals(m.getText())) {
                return m;
            }
            if ((m = this.getGraph(m, name, fabric)) == null) continue;
            return m;
        }
        return null;
    }

    public MapNode getNode(Fabric obj) {
        if (obj == null) {
            return null;
        }
        return (MapNode)obj.getUserObject();
    }

    @Override
    public MapNode getNode(AbstractModelObject obj) {
        if (obj == null) {
            return null;
        }
        try {
            if (obj instanceof EndPort) {
                Enclosure enclosure = ((EndPort)obj).getEnclosure();
                if (enclosure != null) {
                    return (MapNode)this.getMap((Fabric)obj.getFabric())._enclosureNodes.get(enclosure.getEnclosureName());
                }
                return (MapNode)obj.getUserObject();
            }
            if (obj instanceof Enclosure) {
                if (((Enclosure)obj).getMemberCount() > 0) {
                    EndPort ep = ((Enclosure)obj).getMembers().get(0);
                    SmMap map = this.getMap(ep.getFabric());
                    if (map == null) {
                        return null;
                    }
                    return (MapNode)map._enclosureNodes.get(((Enclosure)obj).getEnclosureName());
                }
                return (MapNode)SmMap.getInstance()._enclosureNodes.get(((Enclosure)obj).getEnclosureName());
            }
            return (MapNode)obj.getUserObject();
        }
        catch (ClassCastException cce) {
            _Logger.error((Object)cce.getMessage(), (Throwable)cce);
            return null;
        }
        catch (Exception ex) {
            return (MapNode)obj.getUserObject();
        }
    }

    public MapNode getNode(SmMap map, Enclosure encl) {
        return map.getEnclosureNode(encl);
    }

    @Override
    public MapNode[] getNodes(Enclosure encl) {
        if (encl == null) {
            return null;
        }
        HashedArrayList<MapNode> nodes = new HashedArrayList<MapNode>();
        MapNode n = SmMap.getInstance().getEnclosureNode(encl);
        if (n != null && !((ArrayList)nodes).contains(n)) {
            ((ArrayList)nodes).add(n);
        }
        if (encl.getMemberCount() > 0) {
            for (EndPort ep : encl.getMembers()) {
                SmMap map = this.getMap(ep.getFabric());
                if (map == null || (n = map.getEnclosureNode(encl)) == null || ((ArrayList)nodes).contains(n)) continue;
                ((ArrayList)nodes).add(n);
            }
        }
        return nodes.toArray(new MapNode[nodes.size()]);
    }

    public MapLink getLink(Isl link) {
        return this.getMap(link.getFabric()).getLink(link);
    }

    public MapLink getLink(NpvLink link) {
        return this.getMap(link.getFabric()).getLink(link);
    }

    public MapLink getLink(EndPort link) {
        SmMap graph;
        Fabric fabric;
        if (link != null && (fabric = link.getFabric()) != null && (graph = this.getMap(fabric)) != null) {
            return graph.getLink(link);
        }
        return null;
    }

    public MapLink getLink(Hub hub) {
        SmMap graph;
        Fabric fabric;
        if (hub != null && (fabric = hub.getFabric()) != null && (graph = this.getMap(fabric)) != null) {
            return graph.getLink(hub);
        }
        return null;
    }

    public MapNode createNewNode(Fabric fabric, Switch dev) {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)("\tSwitch: " + dev.toString()));
        }
        SwitchNode node = null;
        node = dev.isN7K() ? (dev.isVdc() ? new FCoEVdcSwitchNode(dev) : new MDSN7KSwitchNode(dev)) : (dev.isMDS() || dev.isQuail() ? (dev.isMdsDirector() ? new MDS95xxSwitchNode(dev) : (dev.getModelType() == 380 ? new MDS9216SwitchNode(dev) : (FRUConstants.isN5K(dev.getModelType()) ? new N5KSwitchNode(dev) : new MDSSwitchNode(dev)))) : (dev.isSN5428() ? new SN5428SwitchNode(dev) : new SwitchNode(dev)));
        return node;
    }

    public MapNode createNode(Fabric fabric, Switch dev) {
        MapNode node = this.getNode(dev);
        if (node != null) {
            return node;
        }
        return this.createNewNode(fabric, dev);
    }

    public MapNode createNode(Fabric fabric, EndPort ep) {
        MapNode node;
        MapNode n1;
        SmMap map;
        block34: {
            map = this.getMap(fabric);
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)("\tEnd Node: " + ep.toString()));
            }
            n1 = null;
            if (ep.getSwitch() == null) {
                if (_Logger.isTraceEnabled()) {
                    _Logger.trace((Object)("\t\tEndPort ignored: " + ep.toString() + " doesn't have switch information"));
                }
                return null;
            }
            node = this.getNode(ep);
            if (node != null) {
                return node;
            }
            if (ep.getHub() != null) {
                try {
                    MapLink l;
                    SmMap g = this.getMap(fabric);
                    if (g == null) {
                        return null;
                    }
                    n1 = this.getNode(ep.getHub());
                    if (n1 == null) {
                        n1 = this.createNode(fabric, ep.getHub());
                        g.addNode(n1);
                    }
                    if (g.isVsanFilter()) {
                        Vsan vsan = fabric.getVsansByPK((VsanPK)g._filter);
                        l = this.getLink(ep.getHub());
                        if (vsan != null && !ep.getHub().isMemberOfVsan(vsan)) {
                            n1.setDimmed(true);
                            l.setDimmed(true);
                        } else {
                            n1.setDimmed(false);
                            l.setDimmed(false);
                        }
                    } else if (g.isGroupFilter()) {
                        UserDefinedGroupManager.getInstance();
                        UserDefinedGroup group = UserDefinedGroupManager.getGroup((GroupPK)g._filter);
                        l = this.getLink(ep.getHub());
                        if (group != null && !group.switchExists(ep.getSwitch()) && !ep.getHub().isMemberOfGroup(group)) {
                            n1.setDimmed(true);
                            l.setDimmed(true);
                        } else {
                            n1.setDimmed(false);
                            l.setDimmed(false);
                        }
                    }
                    n1.setExpanded(!map.isCollapseLoops());
                }
                catch (Exception ex) {
                    if (!_Logger.isTraceEnabled()) break block34;
                    _Logger.trace((Object)"logEmptyCatch - createNode 1", (Throwable)ex);
                }
            }
        }
        node = null;
        if (ep.getEnclosure() != null) {
            if (!ep.isTarget() && ep.isFiconCH()) {
                node = new MainFrame(ep);
            } else if (ep.isTarget()) {
                node = new StorageNode(ep);
            }
        } else if (ep.isTarget()) {
            node = new StorageNode(ep);
        }
        if (node == null) {
            node = ep.isFiconCH() ? new MainFrame(ep) : (ep.isISCSI() ? new ISCSIHostNode(ep) : (ep.isFiconCup() ? new FiconCUP(ep) : new HostNode(ep)));
        }
        if (n1 == null) {
            ArrayList snodes;
            ArrayList arrayList;
            if (ep.getEnclosure() == null) {
                arrayList = null;
            } else {
                this.getMap(fabric);
                arrayList = snodes = SmMap.getSwitchNodes(node);
            }
            if (snodes == null || snodes.size() == 0) {
                n1 = this.getNode(ep.getSwitch());
                if (n1 == null) {
                    try {
                        n1 = this.createNode(fabric, ep.getSwitch());
                        this.getMap(fabric).addNode(n1);
                    }
                    catch (Exception ex) {
                        _Logger.trace((Object)"logEmptyCatch - createNode 2", (Throwable)ex);
                    }
                }
            } else {
                for (int i = 0; i < snodes.size() && !(n1 = (MapNode)snodes.get(i)).isExpanded(); ++i) {
                }
            }
        }
        if (!SmMap.isDisplayNodeLabels()) {
            node.setNodeLabelDisplayed(false);
        }
        if (ep != null && ep.getEnclosure() != null) {
            map._enclosureNodes.put(ep.getEnclosure().getEnclosureName(), node);
        }
        return node;
    }

    public MapNode createNode(Fabric fabric, Hub hub) {
        MapNode sn = this.getNode(hub.getSwitch());
        MapNode node = this.getNode(hub);
        if (node != null) {
            return node;
        }
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)("\tLoop: " + hub.toString()));
        }
        node = hub.isCloud() ? new CloudLoopNode(hub) : new FCLoopNode(hub);
        SmMap g = this.getMap(fabric);
        if (g == null) {
            return null;
        }
        if (sn == null) {
            sn = this.createNode(fabric, hub.getSwitch());
            g.addNode(sn);
        }
        g.addLink(new LoopLink(sn, node, hub));
        node.setExpanded(!g.isCollapseLoops());
        return node;
    }

    public MapLink createLink(Fabric fabric, Isl link) {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)("\tISL: " + link.toString()));
        }
        if (link.isPortChannel()) {
            return new PCMapLink(link);
        }
        return new ISLMapLink(link);
    }

    public MapLink createLink(Fabric fabric, NpvLink link) {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)("\tNpvLink: " + link.toString()));
        }
        if (link.isPortChannel()) {
            return new PCNpvMapLink(link);
        }
        return new NpvMapLink(link);
    }

    public MapLink createLink(Fabric fabric, EndPort ep) {
        MapNode sn = null;
        MapNode n = null;
        SmMap g = this.getMap(fabric);
        if (g == null) {
            return null;
        }
        if (ep.getHub() == null) {
            sn = (MapNode)ep.getSwitch().getUserObject();
            if (sn == null && (sn = this.createNode(fabric, ep.getSwitch())) != null && sn.getOwner() == null) {
                g.addNode(sn);
            }
        } else {
            sn = this.getNode(ep.getHub());
            if (sn == null && (sn = this.createNode(fabric, ep.getHub())) != null && sn.getOwner() == null) {
                g.addNode(sn);
            }
            if (g.isVsanFilter()) {
                Vsan vsan = fabric.getVsansByPK((VsanPK)g._filter);
                MapLink l = this.getLink(ep.getHub());
                if (vsan != null && !ep.getHub().isMemberOfVsan(vsan)) {
                    sn.setDimmed(true);
                    if (l != null) {
                        l.setDimmed(true);
                    }
                } else {
                    sn.setDimmed(false);
                    if (l != null) {
                        l.setDimmed(false);
                    }
                }
            } else if (g.isGroupFilter()) {
                UserDefinedGroupManager.getInstance();
                UserDefinedGroup group = UserDefinedGroupManager.getGroup((GroupPK)g._filter);
                MapLink l = this.getLink(ep.getHub());
                if (group != null && !group.switchExists(ep.getSwitch()) && !ep.getHub().isMemberOfGroup(group)) {
                    sn.setDimmed(true);
                    if (l != null) {
                        l.setDimmed(true);
                    }
                } else {
                    sn.setDimmed(false);
                    if (l != null) {
                        l.setDimmed(false);
                    }
                }
            }
        }
        if ((n = this.getNode(ep)) == null && (n = this.createNode(fabric, ep)) != null && n.getOwner() == null) {
            g.addNode(n);
        }
        EdgeMapLink l = null;
        l = ep.isFCoE() ? new FCoEEdgeMapLink(ep) : new EdgeMapLink(ep);
        return l;
    }

    public static void removeAllMaps() {
        _FabricMaps.clear();
    }
}

