/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map;

import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Filter;
import com.cisco.dcbu.lib.ui.IconManager;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.map.SmMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;

public class SmMapLegendDialog
extends JDialog
implements ActionListener {
    private static SmMapLegendDialog _Instance = null;
    private static boolean instanceIsKubrick = false;
    static final String[] _BUTTONS = new String[]{"Close"};
    static final String[][] _LEGEND_NODE_CELLS = new String[][]{{"vegas.gif", "w", "Director Class MDS FC Switch"}, {"mds9200.gif", "w", "Non-Director Class MDS FC Switch"}, {"n7k.gif", "w", "Nexus 7000 Switch"}, {"n5k.gif", "w", "Nexus FCoE/FC Switch"}, {"dc3.gif", "w", "Catalyst LAN Switch"}, {"ucs_switch.gif", "w", "UCS Switch"}, {"switch.gif", "w", "3rd Party/Unknown Device"}, {"16x16-end_station.gif", "h", "FC Host or Enclosure"}, {"16x16-end_station-iscsi.gif", "h", "iSCSI Host"}, {"16x16-end_station-virtual.gif", "h", "Virtual Host"}, {"FiconCUP.gif", "w", "FICON CUP"}, {"MainFrame.gif", "h", "Mainframe"}, {"database26.gif", "h", "FC Target or Enclosure"}, {"database26-virtual.gif", "h", "Virtual FC Storage"}, {"Cloud.gif", "w", "IP Cloud or FC Fabric"}, {"box.gif", "w", "A device or cloud with a box around it has<br>hidden links attached."}};
    static final String[][] _KUBRICK_LEGEND_NODE_CELLS = new String[][]{{"Device_fibre_channel_director_3027_default_24.png", "w", "Director Class MDS FC Switch"}, {"Device_fibre_channel_fabric_switch_3029_default_24.png", "w", "Non-Director Class MDS FC Switch"}, {"Device_nexus7000_3035_default_24.png", "w", "Nexus 7000 Switch"}, {"Device_virtual_nexus7000_3150_default_24.png", "w", "Nexus 7000 VDC Switch"}, {"Device_nexus5000_3034_default_24.png", "w", "Nexus FCoE/FC Switch"}, {"Device_nexus2000_3033_default_24.png", "w", "Nexus 2000 Switch"}, {"Device_nexus1000_3032_default_24.png", "w", "Nexus 1000 Switch"}, {"Device_route_switch_processor_3037_default_24.png", "w", "Catalyst 7000/6000/5000/4000 LAN Switch"}, {"Device_switch_3062_default_24.png", "w", "Catalyst 3000/2000 LAN Switch"}, {"Device_UCS_switch_3106_default_24.png", "w", "UCS Switch"}, {"Device_generic_3048_default_24.png", "w", "3rd Party/Unknown Device"}, {"Device_pc_3045_default_24.png", "h", "FC Host or Enclosure"}, {"Device_server_3156_default_24.png", "w", "FICON CUP"}, {"Device_ibm_mainframe_3042_default_24.png", "h", "Mainframe"}, {"Device_fibre_channel_disk_subsystem_3028_default_24.png", "h", "FC Target or Enclosure"}, {"Device_cloud_white_3041_default_24.png", "w", "IP Cloud or FC Fabric"}, {"box.gif", "w", "A device or cloud with a box around it has<br>hidden links attached."}};
    static final String[][] _LEGEND_LINK_CELLS = new String[][]{{"line.gif", "w", "FC ISL or Edge Connection"}, {"thickLine.gif", "w", "FC ISL Port Channel"}, {"lineBrown.gif", "w", "Ethernet ISL Connection (brown)"}, {"dashDotDotLine.gif", "w", "FCoE Connnection"}, {"dashedLine.gif", "w", "FCIP, ISL or iSCSI Connection"}, {"thickDashedLine.gif", "w", "FCIP Port Channel"}, {"dottedLine.gif", "w", "DWDM Link"}, {"dashedDottedLine.gif", "w", "NP Link"}, {"thickDashedDottedLine.gif", "w", "FC F/TF/TNP-port Port Channel"}, {"loop.gif", "w", "FC Arbitrated Loop"}, {"loopCollapsed.gif", "w", "FC Arbitrated Loop with Hidden Edge Connections"}};
    static final String[][] _LEGEND_ALARM_STATUS_CELLS = new String[][]{{"dashedOrangeX.gif", "w", "An orange X through a device or link indicates<br>that the device or ISL is not working properly."}, {"redSlash.gif", "w", "A red line through a device indicates that the<br>device is not manageable."}, {"redX.gif", "w", "A red X through a device or link indicates that<br>the device is down or that the ISL is down."}};
    static final String[][] _KUBRICK_LEGEND_ALARM_STATUS_CELLS = new String[][]{{"Device_fibre_channel_director_3027_default_24.png", "w", "A dark grey device indicates<br>that the device is working properly."}, {"Device_fibre_channel_director_3027_minor_24.png", "w", "An orange device indicates<br>that the device is not working properly."}, {"dashedOrangeX.gif", "w", "An orange X through a link indicates<br>that the ISL is not working properly."}, {"Device_fibre_channel_director_3027_unmanaged_redSlash_24.png", "w", "A red line through a device indicates that the<br>device is not manageable."}, {"Device_fibre_channel_director_3027_unreachable_redX_24.png", "w", "A red X through a device indicates that<br>the device is down."}, {"redX.gif", "w", "A red X through a link indicates that<br>the ISL is down."}};
    private JButton _closeButton = null;

    public SmMapLegendDialog(Object object) {
        super((Frame)BrowserFrame.getInstance(), "DCNM-SAN - Map Legend");
        instanceIsKubrick = SmMap.isClassUseKubrickIcons();
        JTabbedPane legendPanel = this.buildTabbedPane();
        AbstractButton[] b = DialogUtil.buildButtons(_BUTTONS, (ActionListener)this);
        this._closeButton = DialogUtil.getButton(_BUTTONS[0], (JButton[])b);
        this._closeButton.setEnabled(true);
        DialogUtil.buildDialog((JDialog)this, (Container)BrowserFrame.getInstance(), (Container)legendPanel, b);
        this.pack();
        this.setResizable(false);
    }

    public static SmMapLegendDialog getInstance() {
        if (_Instance != null && SmMap.isClassUseKubrickIcons() == instanceIsKubrick) {
            return _Instance;
        }
        _Instance = null;
        JPanel legendPanel = new JPanel();
        int insets = Filter._IsMetal ? 3 : 5;
        legendPanel.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        legendPanel.setLayout(new BorderLayout(insets, insets));
        _Instance = new SmMapLegendDialog((Object)null);
        return _Instance;
    }

    public JTabbedPane buildTabbedPane() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Links", this.buildLegendPanel(_LEGEND_LINK_CELLS));
        if (SmMap.isClassUseKubrickIcons()) {
            tabbedPane.addTab("Switches & End Devices", this.buildLegendPanel(_KUBRICK_LEGEND_NODE_CELLS));
            tabbedPane.addTab("Alarms & Status", this.buildLegendPanel(_KUBRICK_LEGEND_ALARM_STATUS_CELLS));
        } else {
            tabbedPane.addTab("Switches & End Devices", this.buildLegendPanel(_LEGEND_NODE_CELLS));
            tabbedPane.addTab("Alarms & Status", this.buildLegendPanel(_LEGEND_ALARM_STATUS_CELLS));
        }
        return tabbedPane;
    }

    public JPanel buildLegendPanel(String[][] legend_cells) {
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        JPanel legendPanel = new JPanel(gbl);
        Color backgroundColor = this.getBackground();
        if (backgroundColor != null && !backgroundColor.equals(Color.BLACK)) {
            legendPanel.setBackground(Color.WHITE);
        }
        JLabel iconLabel = null;
        JLabel descriptionLabel = null;
        int i = 0;
        while (i < legend_cells.length) {
            iconLabel = SmMap.isClassUseKubrickIcons() ? new JLabel(new ImageIcon(IconManager.getIcon(legend_cells[i][0]).getImage())) : ("w".equalsIgnoreCase(legend_cells[i][1]) ? new JLabel(new ImageIcon(IconManager.getIcon(legend_cells[i][0]).getImage().getScaledInstance(24, -24, 1))) : new JLabel(new ImageIcon(IconManager.getIcon(legend_cells[i][0]).getImage().getScaledInstance(-24, 24, 1))));
            descriptionLabel = new JLabel("<html>" + legend_cells[i][2]);
            gbc.gridx = 0;
            gbc.gridy = i;
            gbc.anchor = 10;
            gbc.insets = new Insets(2, 10, 2, 10);
            legendPanel.add((Component)iconLabel, gbc);
            gbc.gridx = 1;
            gbc.gridy = i++;
            gbc.anchor = 10;
            gbc.fill = 1;
            legendPanel.add((Component)descriptionLabel, gbc);
        }
        return legendPanel;
    }

    @Override
    public void setVisible(boolean isVisible) {
        super.setVisible(isVisible);
        if (isVisible) {
            this.setTitle("Map Legend ");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        char ch;
        if (e.getSource() instanceof JButton && (ch = ((JButton)e.getSource()).getText().charAt(0)) == 'C') {
            this.setVisible(false);
            return;
        }
    }
}

