/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map.actions;

import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.actions.MapActionAdapter;
import com.cisco.nm.esper.GraphComponent;
import com.cisco.nm.esper.action.JOverviewAction;
import com.cisco.nm.lib.winkit.BasicContainer;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class OverViewMapAction
extends MapActionAdapter {
    private static OverViewMapAction _Instance = null;
    private boolean _detach = false;
    public static Logger _Logger = Logger.getLogger(OverViewMapAction.class);

    public static OverViewMapAction getInstance() {
        if (_Instance == null) {
            _Instance = new OverViewMapAction();
        }
        return _Instance;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.toggleOverView();
    }

    public void toggleOverView() {
        SmMap map = SmMap.getSelectedMap();
        if (map == null) {
            map = SmMap.getInstance();
        }
        this.toggleOverView(map);
    }

    public boolean isDetached() {
        return this._detach;
    }

    public void setDetached(boolean detach) {
        this._detach = detach;
    }

    public void setDetached(SmMap map, boolean detach) {
        boolean oldDetach = this._detach;
        this._detach = !this._detach;
        this.toggleOverView(map);
        JOverviewAction _overviewAction = map.getWindow().getOverviewAction();
        _overviewAction.setDetached(detach);
        this._detach = oldDetach;
        this.toggleOverView(map);
    }

    public void toggleOverView(SmMap map) {
        JOverviewAction _overviewAction = map.getWindow().getOverviewAction();
        _overviewAction.setDetached(this._detach);
        if (this._detach) {
            _overviewAction.setOverviewTitle("Overview - " + map.getText());
        }
        ActionEvent e = new ActionEvent(BrowserFrame.getInstance(), 0, "overview");
        _overviewAction.actionPerformed(e);
        map.repaint(false);
    }

    public static boolean isOverViewDisplayed() {
        SmMap map = SmMap.getSelectedMap();
        if (map == null) {
            map = SmMap.getInstance();
        }
        return OverViewMapAction.isOverViewDisplayed(map);
    }

    public static boolean isOverViewDisplayed(SmMap map) {
        boolean displayed;
        block5: {
            JOverviewAction overviewAction = map.getWindow().getOverviewAction();
            if (overviewAction.getOverviewDialog() != null && overviewAction.getOverviewDialog().isVisible()) {
                return true;
            }
            GraphComponent gc = map.getGraphComponent();
            displayed = false;
            try {
                Container con = gc.asContainer().getParent();
                Component[] comps = con.getComponents();
                if (comps == null) break block5;
                for (int j = 0; j < comps.length; ++j) {
                    if (!(comps[j] instanceof BasicContainer)) continue;
                    if (comps[j].isVisible()) {
                        displayed = true;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                _Logger.trace((Object)"logEmptyCatch", (Throwable)ex);
            }
        }
        return displayed;
    }

    @Override
    public void validate(JMenuItem menuitem, TopologyGraph g) {
        menuitem.setEnabled(true);
        try {
            ((JCheckBoxMenuItem)menuitem).setState(OverViewMapAction.isOverViewDisplayed());
        }
        catch (Exception e) {
            _Logger.trace((Object)"logEmptyCatch", (Throwable)e);
        }
    }
}

