/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map.actions;

import com.cisco.dcbu.sm.client.map.MapFactory;
import com.cisco.dcbu.sm.client.map.MapLink;
import com.cisco.dcbu.sm.client.map.MapNode;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.actions.MapActionAdapter;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Hub;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.UserDefinedGroup;
import com.cisco.dcbu.sm.client.model.UserDefinedGroupUnion;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class UserDefinedGroupHighlightAction
extends MapActionAdapter {
    private static UserDefinedGroupHighlightAction _Instance = null;
    private MgmtDomainIf _group = null;
    public static Logger _Logger = Logger.getLogger(UserDefinedGroupHighlightAction.class);

    public static UserDefinedGroupHighlightAction getSharedInstance() {
        return UserDefinedGroupHighlightAction.getInstance();
    }

    public static UserDefinedGroupHighlightAction getInstance() {
        if (_Instance == null) {
            _Instance = new UserDefinedGroupHighlightAction();
        }
        return _Instance;
    }

    public void clear() {
        if (this._group == null) {
            return;
        }
        SmMap map = SmMap.getSelectedMap();
        map.setDimmed(false);
        map.updateBounds();
    }

    @Override
    public void execute() {
        if (this._group == null) {
            return;
        }
        SmMap g = SmMap.getSelectedMap();
        if (g == null) {
            return;
        }
        this.execute(g);
        g.repaint();
    }

    private void execute(SmMap g) {
        EndPort[] eps;
        ArrayList<NpvLink> npvLinks;
        ArrayList<Isl> isls;
        if (this._group == null) {
            return;
        }
        g.setDimmed(true);
        Switch[] sws = this._group.getSwitches();
        if (sws != null && sws.length > 0) {
            for (int i = 0; i < sws.length; ++i) {
                try {
                    MapNode n = MapFactory.getInstance().getNode(sws[i]);
                    n.setDimmed(false);
                    continue;
                }
                catch (Exception ex) {
                    _Logger.trace((Object)"logEmptyCatch - Switches", (Throwable)ex);
                }
            }
        }
        if ((isls = this._group.getIsls(null)) != null && isls.size() > 0) {
            for (int i = 0; i < isls.size(); ++i) {
                try {
                    MapLink l = MapFactory.getInstance().getLink(isls.get(i));
                    l.setDimmed(false);
                    continue;
                }
                catch (Exception ex) {
                    _Logger.trace((Object)"logEmptyCatch - Isls", (Throwable)ex);
                }
            }
        }
        if ((npvLinks = this._group.getNpvLinks(null)) != null && npvLinks.size() > 0) {
            for (int i = 0; i < npvLinks.size(); ++i) {
                try {
                    MapLink l = MapFactory.getInstance().getLink(npvLinks.get(i));
                    l.setDimmed(false);
                    continue;
                }
                catch (Exception ex) {
                    _Logger.trace((Object)"logEmptyCatch - npvLinks", (Throwable)ex);
                }
            }
        }
        if ((eps = this._group.getEndPorts()) != null && eps.length > 0) {
            Hub hub = null;
            for (int i = 0; i < eps.length; ++i) {
                try {
                    MapNode n = MapFactory.getInstance().getNode(eps[i]);
                    MapLink l = MapFactory.getInstance().getLink(eps[i]);
                    l.setDimmed(false);
                    n.setDimmed(false);
                    hub = eps[i].getHub();
                    if (hub == null) continue;
                    n = MapFactory.getInstance().getNode(hub);
                    n.setDimmed(false);
                    l = MapFactory.getInstance().getLink(hub);
                    l.setDimmed(false);
                    continue;
                }
                catch (Exception ex) {
                    _Logger.trace((Object)"logEmptyCatch - EndPorts", (Throwable)ex);
                }
            }
        }
        if (g.graphs() != null) {
            Iterator iter = g.graphs().iterator();
            while (iter.hasNext()) {
                SmMap tg = (SmMap)iter.next();
                this.execute(tg);
            }
        }
        g.updateBounds();
    }

    public UserDefinedGroup getUserDefinedGroup() {
        if (this._group instanceof UserDefinedGroup) {
            return (UserDefinedGroup)this._group;
        }
        return null;
    }

    public void setUserDefinedGroup(UserDefinedGroup group) {
        this._group = group;
    }

    public void setUserDefinedGroup(UserDefinedGroupUnion group) {
        this._group = group;
    }
}

