/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.model;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.lib.util.IntArray;
import com.cisco.dcbu.lib.util.IntHashMap;
import com.cisco.dcbu.sm.client.model.AbstractLink;
import com.cisco.dcbu.sm.client.model.AbstractModelObject;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.client.model.DefaultZoneMembers;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EnforcedZone;
import com.cisco.dcbu.sm.client.model.EnforcedZoneMember;
import com.cisco.dcbu.sm.client.model.EthIsl;
import com.cisco.dcbu.sm.client.model.EthSwitch;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Hub;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.VsanMgmtDomain;
import com.cisco.dcbu.sm.common.dto.FcPortAlias;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.model.ZoneBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Vsan
extends AbstractModelObject
implements MgmtDomainIf {
    private Fabric _fabric;
    protected ArrayList<SmFilter> _filters = null;
    private VsanMgmtDomain _mgmtDomain;
    private ArrayList<EnforcedZone> lnkEnforcedZone;

    public Vsan(VsanBase vsanBase, Fabric fabric) {
        super(vsanBase);
        this._fabric = fabric;
        this.setBaseEnforcedZones(vsanBase.getEnforcedZones());
        this._mgmtDomain = new VsanMgmtDomain(this);
    }

    public boolean equalsByVsanPK(Object x) {
        if (x == this) {
            return true;
        }
        if (x == null || !(x instanceof Vsan)) {
            return false;
        }
        Vsan xVsan = (Vsan)x;
        return this.getPK().equals(xVsan.getPK());
    }

    @Override
    public Fabric getFabric() {
        return this._fabric;
    }

    public San getSan() {
        return this._fabric.getSan();
    }

    @Override
    public MgmtDomainIf getParent() {
        return this._fabric;
    }

    @Override
    public String getPath(char separator) {
        return this._fabric.getPath(separator) + separator + this.getName();
    }

    @Override
    public String getPath() {
        return this.getPath('/');
    }

    @Override
    public Switch[] getSwitches() {
        if (this._fabric == null) {
            return new Switch[0];
        }
        HashedArrayList<Switch> switches = new HashedArrayList<Switch>();
        Switch[] sws = this.getFabric().getSwitches();
        if (sws == null || sws.length == 0) {
            return new Switch[0];
        }
        for (Switch sw : sws) {
            if (!sw.isMemberOfVsan(this)) continue;
            ((ArrayList)switches).add(sw);
        }
        return switches.size() > 0 ? switches.toArray(new Switch[switches.size()]) : new Switch[]{};
    }

    @Override
    public boolean isSan() {
        return false;
    }

    @Override
    public boolean isCustomDefined() {
        return false;
    }

    @Override
    public boolean isFabric() {
        return false;
    }

    @Override
    public boolean isVsan() {
        return true;
    }

    @Override
    public boolean isVlan() {
        return false;
    }

    @Override
    public boolean isZone() {
        return false;
    }

    public boolean isSegmented() {
        return ((VsanBase)this._baseModelObject).isSegmented();
    }

    public void setSegmented(boolean seg) {
        if (((VsanBase)this._baseModelObject).isSegmented() != seg) {
            ((VsanBase)this._baseModelObject).setSegmented(seg);
            if (this._fabric != null && this._fabric.inited()) {
                this._fabric.addPropertyChangeEvent(new PropertyChangeEvent(this, "vsanSegmented", !seg, seg));
            }
        }
    }

    public void setSegmentedWithNoEvent(boolean seg) {
        ((VsanBase)this._baseModelObject).setSegmented(seg);
    }

    public void setFiconState(byte state) {
        ((VsanBase)this._baseModelObject).setFiconState(state);
    }

    public boolean isFicon() {
        return ((VsanBase)this._baseModelObject).isFicon();
    }

    public void setFabricPK(FabricPK fabricPK) {
        ((VsanBase)this._baseModelObject).setFabricPK(fabricPK);
    }

    public Switch getSeedSwitch() {
        Switch seed = this.getFabric().findSwitchByPK(((VsanBase)this._baseModelObject).getSeedSwitchPK());
        if (seed != null && seed.isManageable()) {
            return seed;
        }
        Wwn prinSwwn = ((VsanBase)this._baseModelObject).getVsanPK()._prinSwwn;
        short vid = this.getId();
        Switch[] switches = this.getSwitches();
        if (switches != null && switches.length > 0) {
            for (int i = 0; i < switches.length; ++i) {
                if (!switches[i].isManageable() || seed != null && (seed.isMDS() || !switches[i].isMDS()) && !switches[i].isVersionGreaterThan(seed.getVersion()) && (prinSwwn == null || prinSwwn.equals(seed.getVsanWwn(vid)) || !prinSwwn.equals(switches[i].getVsanWwn(vid)))) continue;
                seed = switches[i];
            }
        }
        if (seed != null) {
            this.setSeedSwitchKey((WwnKey)seed.getPK());
        }
        return seed;
    }

    void setSeedSwitchKey(WwnKey swKey) {
        WwnKey oldSwitchKey = ((VsanBase)this._baseModelObject).getSeedSwitchPK();
        if (oldSwitchKey == null && swKey == null) {
            return;
        }
        if (!(oldSwitchKey == swKey || oldSwitchKey != null && swKey != null && oldSwitchKey.equals(swKey))) {
            ((VsanBase)this._baseModelObject).setSeedSwitchPK(swKey);
            Switch oldSw = this._fabric.findSwitchByPK(oldSwitchKey);
            this._fabric.addPropertyChangeEvent(new PropertyChangeEvent(this, "switch", oldSw, this.getSeedSwitch()));
        }
    }

    public void setFcAliasSeedSwitchKey(WwnKey swKey) {
        ((VsanBase)this._baseModelObject).setFcAliasSeedPK(swKey);
    }

    @Override
    public Isl[] getIsls() {
        ArrayList<Isl> isls = this.getIsls(null);
        return isls.toArray(new Isl[isls.size()]);
    }

    @Override
    public ArrayList<Isl> getIsls(ArrayList<Isl> isls) {
        if (isls == null) {
            isls = new HashedArrayList<Isl>();
        }
        Isl[] allIsls = this.getFabric().getIsls();
        for (int i = 0; i < allIsls.length; ++i) {
            if (!allIsls[i].isMemberOfVsan(this)) continue;
            isls.add(allIsls[i]);
        }
        return isls;
    }

    @Override
    public NpvLink[] getNpvLinks() {
        ArrayList<NpvLink> npvLinks = this.getNpvLinks(null);
        return npvLinks.toArray(new NpvLink[npvLinks.size()]);
    }

    @Override
    public ArrayList<NpvLink> getNpvLinks(ArrayList<NpvLink> npvLinks) {
        if (npvLinks == null) {
            npvLinks = new HashedArrayList<NpvLink>();
        }
        NpvLink[] allNpvLinks = this.getFabric().getNpvLinks();
        for (int i = 0; i < allNpvLinks.length; ++i) {
            if (!allNpvLinks[i].isMemberOfVsan(this)) continue;
            npvLinks.add(allNpvLinks[i]);
        }
        return npvLinks;
    }

    @Override
    public NpvLink[] getFilteredNpvLinks(MgmtDomainIf.NpvLinkFilter filter) {
        HashedArrayList<NpvLink> npvLinks = new HashedArrayList<NpvLink>();
        NpvLink[] allNpvLinks = this.getFabric().getFilteredNpvLinks(filter);
        for (int i = 0; i < allNpvLinks.length; ++i) {
            if (!allNpvLinks[i].isMemberOfVsan(this)) continue;
            ((ArrayList)npvLinks).add(allNpvLinks[i]);
        }
        return npvLinks.toArray(new NpvLink[npvLinks.size()]);
    }

    public ArrayList<EndPort> getEndPorts(ArrayList<EndPort> endPorts) {
        if (endPorts == null) {
            endPorts = new HashedArrayList<EndPort>();
        }
        EndPort[] eps = this.getFabric().getEndPorts();
        HashMap<PKIf, PKIf> map = new HashMap<PKIf, PKIf>();
        for (int i = 0; eps != null && i < eps.length; ++i) {
            if (!eps[i].isMemberOfVsan(this) || map.get(eps[i].getPK()) != null) continue;
            map.put(eps[i].getPK(), eps[i].getPK());
            endPorts.add(eps[i]);
        }
        map.clear();
        return endPorts;
    }

    public EndPort findEndPortByFcid(int fcid) {
        EndPort[] eps = this.getFabric().getEndPorts();
        for (int i = 0; eps != null && i < eps.length; ++i) {
            if (!eps[i].isMemberOfVsan(this) || eps[i].getFcIdNum(this.getId()) != fcid) continue;
            return eps[i];
        }
        return null;
    }

    @Override
    public ArrayList<EndPort> getEndPorts(ArrayList<EndPort> eps, boolean target) {
        if (eps == null) {
            eps = new HashedArrayList<EndPort>();
        }
        ArrayList<EndPort> endPorts = this.getFabric().getEndPorts(null, target);
        HashMap<PKIf, PKIf> map = new HashMap<PKIf, PKIf>();
        for (int i = 0; i < endPorts.size(); ++i) {
            EndPort ep = endPorts.get(i);
            if (!ep.isMemberOfVsan(this) || map.get(ep.getPK()) != null) continue;
            map.put(ep.getPK(), ep.getPK());
            eps.add(ep);
        }
        map.clear();
        return eps;
    }

    @Override
    public ArrayList<EndPort> getEndPortsAsList() {
        return this.getEndPortsAsList(false);
    }

    public ArrayList<EndPort> getEndPortsAsList(boolean ignoreSwitch) {
        HashedArrayList<EndPort> endPorts = new HashedArrayList<EndPort>();
        EndPort[] eps = this.getFabric().getEndPorts();
        HashMap<PKIf, PKIf> map = new HashMap<PKIf, PKIf>();
        for (int i = 0; eps != null && i < eps.length; ++i) {
            if (!eps[i].isMemberOfVsan(this, ignoreSwitch) || map.get(eps[i].getPK()) != null) continue;
            map.put(eps[i].getPK(), eps[i].getPK());
            ((ArrayList)endPorts).add(eps[i]);
        }
        map.clear();
        return endPorts;
    }

    public EndPort[] getEndPortsIgnoreSwitch() {
        ArrayList<EndPort> endPorts = this.getEndPortsAsList(true);
        return endPorts.toArray(new EndPort[endPorts.size()]);
    }

    @Override
    public EndPort[] getEndPorts() {
        ArrayList<EndPort> endPorts = this.getEndPortsAsList();
        return endPorts.toArray(new EndPort[endPorts.size()]);
    }

    @Override
    public EndPort[] getEndPorts(boolean target) {
        HashedArrayList<EndPort> endPorts = new HashedArrayList<EndPort>();
        ArrayList<EndPort> eps = target ? this.getFabric().getTargets() : this.getFabric().getInitiators();
        HashMap<PKIf, PKIf> map = new HashMap<PKIf, PKIf>();
        for (int i = 0; i < eps.size(); ++i) {
            EndPort ep = eps.get(i);
            if (!ep.isMemberOfVsan(this) || map.get(ep.getPK()) != null) continue;
            map.put(ep.getPK(), ep.getPK());
            ((ArrayList)endPorts).add(ep);
        }
        map.clear();
        return endPorts.toArray(new EndPort[endPorts.size()]);
    }

    public EndPort[] getNonVirtualEndPorts(boolean target) {
        HashedArrayList<EndPort> result = new HashedArrayList<EndPort>();
        EndPort[] endPorts = this.getEndPorts(target);
        for (int i = 0; i < endPorts.length; ++i) {
            EndPort e = endPorts[i];
            if (e.isVirtualized()) continue;
            ((ArrayList)result).add(e);
        }
        return result.toArray(new EndPort[result.size()]);
    }

    public ArrayList getUnzonedPorts() throws SnmpException {
        EnforcedZone zone;
        IntHashMap zonedPortsByFcId = new IntHashMap();
        if (this.lnkEnforcedZone.size() == 1 && (zone = this.lnkEnforcedZone.get(0)).getName().equals("Default Zone")) {
            try {
                new DefaultZoneMembers(zone).refresh();
            }
            catch (SnmpException ex) {
                // empty catch block
            }
        }
        for (int j = 0; j < this.lnkEnforcedZone.size(); ++j) {
            Array members = this.lnkEnforcedZone.get(j).getMembers();
            for (int k = 0; k < members.size(); ++k) {
                EnforcedZoneMember ezm = (EnforcedZoneMember)members.elementAt(k);
                EndPort ep = ezm.getEndPort(this.getFabric());
                if (ep == null) continue;
                Hub h = ep.getHub();
                if ((ezm.getType() == 4 || ezm.getType() == 6 || ezm.getType() == 7 || ezm.getType() == 2) && h != null) {
                    for (int i = 0; i < h.getMembers().size(); ++i) {
                        ep = h.getMembers().get(i);
                        for (int l = 0; l < ep.getVsanFcIds().length; ++l) {
                            zonedPortsByFcId.put(ep.getVsanFcIds()[l]._fcId, ep);
                        }
                    }
                    continue;
                }
                if (ezm.getType() == 8) {
                    ArrayList ipEpLst = ezm.getAttachedEndPorts();
                    if (ipEpLst == null) continue;
                    for (int i = 0; i < ipEpLst.size(); ++i) {
                        EndPort ipep = (EndPort)ipEpLst.get(i);
                        for (int l = 0; l < ipep.getVsanFcIds().length; ++l) {
                            zonedPortsByFcId.put(ipep.getVsanFcIds()[l]._fcId, ep);
                        }
                    }
                    continue;
                }
                for (int l = 0; l < ep.getVsanFcIds().length; ++l) {
                    zonedPortsByFcId.put(ep.getVsanFcIds()[l]._fcId, ep);
                }
            }
        }
        HashedArrayList<EndPort> unzonedPorts = new HashedArrayList<EndPort>();
        EndPort[] eps = this.getFabric().getEndPorts();
        for (int i = 0; eps != null && i < eps.length; ++i) {
            if (!eps[i].isMemberOfVsan(this) || zonedPortsByFcId.get(eps[i].getFcIdNum(this.getVsanId())) != null || ((ArrayList)unzonedPorts).contains(eps[i])) continue;
            ((ArrayList)unzonedPorts).add(eps[i]);
        }
        return unzonedPorts;
    }

    public boolean isUp() {
        return ((VsanBase)this._baseModelObject).isUp();
    }

    void setOperState(byte state) {
        if (state != ((VsanBase)this._baseModelObject).getOperState()) {
            ((VsanBase)this._baseModelObject).setOperState(state);
            boolean isUp = ((VsanBase)this._baseModelObject).isUp();
            this._fabric.addPropertyChangeEvent(new PropertyChangeEvent(this, "isUp", !isUp, isUp));
        }
    }

    void setInterOperMode(byte mode) {
        ((VsanBase)this._baseModelObject).setInterOperMode(mode);
    }

    public byte getInterOperMode() {
        return ((VsanBase)this._baseModelObject).getInterOperMode();
    }

    public boolean isDisjoint() {
        return false;
    }

    public short getId() {
        return (short)this.getVsanId();
    }

    @Override
    public int getVsanId() {
        return ((VsanBase)this._baseModelObject).getId();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        boolean needIdAfterName;
        String name = ((VsanBase)this._baseModelObject).getName();
        if (name == null || name.length() == 0) {
            name = "VSAN" + this.getId();
        }
        if (this._fabric == null) {
            return name;
        }
        boolean isDisjoint = this._fabric.getVsanCountById(this.getId()) > 1;
        boolean bl = needIdAfterName = !name.endsWith(Integer.toString(this.getId()));
        if (needIdAfterName || isDisjoint || !this.isUp()) {
            StringBuffer sb = new StringBuffer(128);
            sb.append(name);
            sb.append(" (");
            if (needIdAfterName) {
                sb.append(this.getId() + ",");
            }
            if (!this.isUp()) {
                sb.append("down,");
            }
            if (isDisjoint) {
                sb.append("segmented @ " + this.getPrincipalSwitch() + ",");
            }
            sb.setLength(sb.length() - 1);
            sb.append(')');
            return sb.toString();
        }
        return name;
    }

    public void setName(String name) {
        String oldName = this.getName();
        if (!(oldName == name || oldName != null && name != null && oldName.equals(name))) {
            ((VsanBase)this._baseModelObject).setName(name);
            this._fabric.addPropertyChangeEvent(new PropertyChangeEvent(this, "name", oldName, name));
        }
    }

    public Switch getPrincipalSwitch() {
        Wwn swPK = ((VsanBase)this._baseModelObject).getVsanPK()._prinSwwn;
        if (swPK == null) {
            return null;
        }
        return this._fabric.findSwitchByWwn(swPK, true);
    }

    public Wwn getPrincipalSwitchWwn() {
        Switch sw = this.getPrincipalSwitch();
        return sw != null ? sw.getWwn() : null;
    }

    public Wwn getPrincipalVsanWwn() {
        Switch sw = this.getPrincipalSwitch();
        return sw != null ? sw.getVsanWwn(this.getId()) : null;
    }

    public String getEnforcedZoneSetName() {
        return ((VsanBase)this._baseModelObject).getEnforcedZoneSetName();
    }

    public void setEnforcedZoneSetName(String enforcedZoneSetName) {
        String oldEnforcedZoneSetName = this.getEnforcedZoneSetName();
        if (!(oldEnforcedZoneSetName == enforcedZoneSetName || oldEnforcedZoneSetName != null && enforcedZoneSetName != null && oldEnforcedZoneSetName.equals(enforcedZoneSetName))) {
            ((VsanBase)this._baseModelObject).setEnforcedZoneSetName(enforcedZoneSetName);
            this._fabric.addPropertyChangeEvent(new PropertyChangeEvent(this, "enforcedZoneSetName", oldEnforcedZoneSetName, enforcedZoneSetName));
        }
    }

    public ArrayList<EnforcedZone> getEnforcedZones(ArrayList<EnforcedZone> list) {
        if (list == null) {
            list = new HashedArrayList<EnforcedZone>();
        }
        if (this.lnkEnforcedZone == null) {
            this.lnkEnforcedZone = new HashedArrayList<EnforcedZone>();
        } else if (this.lnkEnforcedZone.size() == 0) {
            ZoneBase defZoneBase = new ZoneBase(0, "Default Zone", false);
            EnforcedZone defEnforcedZone = new EnforcedZone(defZoneBase, this, this._fabric);
            list.add(defEnforcedZone);
            this.lnkEnforcedZone.add(defEnforcedZone);
            try {
                new DefaultZoneMembers(defEnforcedZone).refresh();
            }
            catch (SnmpException ex) {}
        } else {
            list.addAll(this.lnkEnforcedZone);
        }
        return list;
    }

    public EnforcedZone[] getEnforcedZones() {
        ArrayList<EnforcedZone> list = null;
        if (this.lnkEnforcedZone == null || this.lnkEnforcedZone.size() == 0) {
            list = this.getEnforcedZones(null);
        } else if (this.lnkEnforcedZone.size() == 1) {
            EnforcedZone zone = this.lnkEnforcedZone.get(0);
            if (zone.getName().equals("Default Zone")) {
                try {
                    new DefaultZoneMembers(zone).refresh();
                }
                catch (SnmpException snmpException) {
                    // empty catch block
                }
            }
            list = this.lnkEnforcedZone;
        } else {
            list = this.lnkEnforcedZone;
        }
        return list == null ? null : list.toArray(new EnforcedZone[list.size()]);
    }

    public void setBaseEnforcedZones(ZoneBase[] zones) {
        EnforcedZone[] oldEnforcedZones;
        EnforcedZone[] enforcedZoneArray = this._fabric.inited() ? (this.lnkEnforcedZone == null || this.lnkEnforcedZone.size() == 0 ? null : this.lnkEnforcedZone.toArray(new EnforcedZone[this.lnkEnforcedZone.size()])) : (oldEnforcedZones = null);
        if (this.lnkEnforcedZone == null) {
            this.lnkEnforcedZone = new HashedArrayList<EnforcedZone>();
        } else {
            this.lnkEnforcedZone.clear();
        }
        if (zones != null && zones.length > 0) {
            for (int i = 0; i < zones.length; ++i) {
                this.lnkEnforcedZone.add(new EnforcedZone(zones[i], this, this._fabric));
            }
        }
        ((VsanBase)this._baseModelObject).setEnforcedZones(zones);
        if (this._fabric.inited()) {
            this._fabric.addPropertyChangeEvent(new PropertyChangeEvent(this, "enforcedZones", oldEnforcedZones, this.lnkEnforcedZone.toArray(new EnforcedZone[this.lnkEnforcedZone.size()])));
        }
    }

    public void setEnforcedZones(EnforcedZone[] zones) {
        EnforcedZone[] oldEnforcedZones;
        if (zones == null && (this.lnkEnforcedZone == null || this.lnkEnforcedZone.size() == 0)) {
            return;
        }
        EnforcedZone[] enforcedZoneArray = oldEnforcedZones = this.lnkEnforcedZone == null || this.lnkEnforcedZone.size() == 0 ? null : this.lnkEnforcedZone.toArray(new EnforcedZone[this.lnkEnforcedZone.size()]);
        if (this.lnkEnforcedZone == null) {
            this.lnkEnforcedZone = new HashedArrayList<EnforcedZone>();
        } else {
            this.lnkEnforcedZone.clear();
        }
        HashedArrayList<ZoneBase> baseZones = new HashedArrayList<ZoneBase>();
        if (zones != null && zones.length > 0) {
            for (int i = 0; i < zones.length; ++i) {
                this.lnkEnforcedZone.add(zones[i]);
                ((ArrayList)baseZones).add(zones[i].getZoneBase());
            }
        }
        ((VsanBase)this._baseModelObject).setEnforcedZones(baseZones.toArray(new ZoneBase[baseZones.size()]));
        if (this._fabric.inited()) {
            this._fabric.addPropertyChangeEvent(new PropertyChangeEvent(this, "enforcedZones", oldEnforcedZones, this.lnkEnforcedZone.toArray(new EnforcedZone[this.lnkEnforcedZone.size()])));
        }
    }

    public long getEnforcedZoneSetActivateTime() {
        return ((VsanBase)this._baseModelObject).getEnforcedZoneSetActivateTime();
    }

    void setEnforcedZoneSetActivateTime(long time) {
        long old = this.getEnforcedZoneSetActivateTime();
        if (old != time) {
            ((VsanBase)this._baseModelObject).setEnforcedZoneSetActivateTime(time);
            this._fabric.addPropertyChangeEvent(new PropertyChangeEvent(this, "setEnforcedZoneSetActivateTime", new Long(old), new Long(time)));
        }
    }

    public boolean isZoneAvailable() {
        return this.lnkEnforcedZone != null && this.lnkEnforcedZone.size() != 0;
    }

    public static String getVsansAsString(short[] vsanMembership, int numVsans) {
        return VsanBase.getVsansAsString(vsanMembership, numVsans);
    }

    public static String getVsansAsString(short[] vsanMembership) {
        return VsanBase.getVsansAsString(vsanMembership);
    }

    public byte getAdminState() {
        return ((VsanBase)this._baseModelObject).getAdminState();
    }

    public void setAdminState(byte state) {
        ((VsanBase)this._baseModelObject).setAdminState(state);
    }

    public int getMtu() {
        return ((VsanBase)this._baseModelObject).getMtu();
    }

    public void setMtu(int mtu) {
        ((VsanBase)this._baseModelObject).setMtu(mtu);
    }

    public byte getLoadBalancingType() {
        return ((VsanBase)this._baseModelObject).getLoadBalancingType();
    }

    public void setLoadBalancingType(byte type) {
        ((VsanBase)this._baseModelObject).setLoadBalancingType(type);
    }

    public boolean isInorderDelivery() {
        return ((VsanBase)this._baseModelObject).isInorderDelivery();
    }

    public void setInorderDelivery(boolean b) {
        ((VsanBase)this._baseModelObject).setInorderDelivery(b);
    }

    public int getNetworkDropLatency() {
        return ((VsanBase)this._baseModelObject).getNetworkDropLatency();
    }

    public void setNetworkDropLatency(int msec) {
        ((VsanBase)this._baseModelObject).setNetworkDropLatency(msec);
    }

    public FcPortAlias findFcAliasByName(String name) {
        return ((VsanBase)this._baseModelObject).findFcAlias(name);
    }

    public String findFcAliasByWwn(Wwn wwn) {
        FcPortAlias fa = ((VsanBase)this._baseModelObject).findFcAlias(wwn);
        return fa != null ? fa.getAlias() : null;
    }

    public FcPortAlias addFcAlias(FcPortAlias alias) {
        if (alias == null || alias.getWwn() == null) {
            return null;
        }
        VsanBase base = (VsanBase)this._baseModelObject;
        FcPortAlias fa = base.findFcAlias(alias.getAlias());
        if (fa == null) {
            base.addFcAlias(alias);
            return alias;
        }
        if (!fa.getWwn().equals(alias.getWwn())) {
            base.updateFcAliasWwn(fa, alias.getWwn());
        }
        return fa;
    }

    public FcPortAlias removeFcAlias(String alias) {
        return ((VsanBase)this._baseModelObject).removeFcAlias(alias);
    }

    @Override
    public int[] getUpIfIndices(Switch sw) {
        return this.getUpIfIndices(sw, (short)4096);
    }

    @Override
    public int[] getUpIfIndices(Switch sw, short type) {
        Isl[] isls;
        int i;
        EndPort[] eps;
        IntArray indices = new IntArray();
        if ((type & 0x1000) == 4096 && (eps = this.getEndPorts()) != null && eps.length > 0) {
            for (i = 0; i < eps.length; ++i) {
                if (!sw.equals(eps[i].getSwitch()) || indices.contains(eps[i].getSwitchIntKey()._index) || eps[i].isFiconCup() || type != 4096 && (type != 4352 || eps[i].isFCoE() || eps[i].isSVC()) && (type != 4608 && type != 6144 || !eps[i].isFCoE()) && (type != 4608 && type != 6146 || !eps[i].isISCSI()) && (type != 4608 && type != 6147 || !eps[i].isSVC())) continue;
                indices.add(eps[i].getSwitchIntKey()._index);
            }
        }
        if (type != 6147 && type != 6146 && (isls = this.getFabric().getIsls()) != null && isls.length > 0) {
            for (i = 0; i < isls.length; ++i) {
                if (!isls[i].isMemberOfVsan(this) || type == 4608 && !isls[i].isPortChannel() && !isls[i].isFCIP() && !isls[i].isFCoE()) continue;
                if (type == 4352 && isls[i].isPortChannel() && !isls[i].isFCIP() && !isls[i].isFCoE()) {
                    List<Isl> members = isls[i].getPCMemberLinksAsIsls();
                    if (members == null) continue;
                    for (Isl mem : members) {
                        if (sw.equals(mem.getSwitch1()) && !indices.contains(mem.getIfIndex1())) {
                            indices.add(mem.getIfIndex1());
                        }
                        if (!sw.equals(mem.getSwitch2()) || indices.contains(mem.getIfIndex2())) continue;
                        indices.add(mem.getIfIndex2());
                    }
                    continue;
                }
                if (type == 4352 && (isls[i].isFCIP() || isls[i].isFCoE()) || type == 5136 && !isls[i].isPortChannel() || type == 6145 && !isls[i].isFCIP() || type == 6144 && !isls[i].isFCoE()) continue;
                if (sw.equals(isls[i].getSwitch1()) && !indices.contains(isls[i].getIfIndex1())) {
                    indices.add(isls[i].getIfIndex1());
                }
                if (!sw.equals(isls[i].getSwitch2()) || indices.contains(isls[i].getIfIndex2())) continue;
                indices.add(isls[i].getIfIndex2());
            }
        }
        return indices.toArray(new int[indices.size()]);
    }

    @Override
    public SmFilter[] getFilters() {
        return this._mgmtDomain.getFilters();
    }

    @Override
    public SmFilter[] getFilters(short type) {
        return this._mgmtDomain.getFilters(type);
    }

    @Override
    public SmFilter[] getFilters(short type, short addVsanId) {
        return this._mgmtDomain.getFilters(type, addVsanId);
    }

    @Override
    public ArrayList<SmFilter> getFilters(ArrayList<SmFilter> filters) {
        return this._mgmtDomain.getFilters(filters);
    }

    @Override
    public ArrayList<SmFilter> getFilters(ArrayList<SmFilter> filters, short type) {
        return this._mgmtDomain.getFilters(filters, type);
    }

    @Override
    public ArrayList<SmFilter> getFilters(ArrayList<SmFilter> filters, short type, short addVsanId) {
        return this._mgmtDomain.getFilters(filters, type, addVsanId);
    }

    @Override
    public void setFilters(ArrayList<SmFilter> filters) {
        this._mgmtDomain.setFilters(filters);
    }

    @Override
    public SnmpPeer[] getSnmpPeers() {
        return this.getSnmpPeers(false);
    }

    @Override
    public SnmpPeer[] getSnmpPeers(boolean needQuail) {
        HashedArrayList<SnmpPeer> peers = new HashedArrayList<SnmpPeer>();
        Switch[] switches = this.getSwitches();
        if (switches != null && switches.length > 0) {
            for (int i = 0; i < switches.length; ++i) {
                Switch sw = switches[i];
                if (!sw.isMDS() && (!needQuail || !sw.isQuail()) || !sw.isLocallyManageable() || sw.getPeer() == null) continue;
                ((ArrayList)peers).add(sw.getPeer());
            }
        }
        return peers.toArray(new SnmpPeer[peers.size()]);
    }

    @Override
    public SnmpPeer[] getSnmpPeers(int filter) {
        HashedArrayList<SnmpPeer> peers = new HashedArrayList<SnmpPeer>();
        int includeN7k = filter & 1;
        for (Switch sw : this.getSwitches()) {
            if (sw.isN7K() && includeN7k == 0) continue;
            ((ArrayList)peers).add(sw.getPeer());
        }
        return peers.toArray(new SnmpPeer[0]);
    }

    public SnmpPeer[] getSnmpPeers(boolean needQuail, boolean filterNPIV) {
        HashedArrayList<SnmpPeer> peers = new HashedArrayList<SnmpPeer>();
        Switch[] switches = this.getSwitches();
        if (switches != null && switches.length > 0) {
            for (int i = 0; i < switches.length; ++i) {
                Switch sw = switches[i];
                if ((!sw.isMDS() || filterNPIV && sw.isNpvEnabled()) && (!needQuail || !sw.isQuail()) || !sw.isLocallyManageable() || sw.getPeer() == null) continue;
                ((ArrayList)peers).add(sw.getPeer());
            }
        }
        return peers.toArray(new SnmpPeer[peers.size()]);
    }

    public SnmpPeer[] getSnmpPeers(boolean needQuail, boolean filterNPIV, boolean filterUcs) {
        HashedArrayList<SnmpPeer> peers = new HashedArrayList<SnmpPeer>();
        Switch[] switches = this.getSwitches();
        if (switches != null && switches.length > 0) {
            for (int i = 0; i < switches.length; ++i) {
                Switch sw = switches[i];
                if ((!sw.isMDS() || filterUcs && sw.isUCS() || filterNPIV && sw.isNpvEnabled()) && (!needQuail || !sw.isQuail()) || !sw.isLocallyManageable() || sw.getPeer() == null) continue;
                ((ArrayList)peers).add(sw.getPeer());
            }
        }
        return peers.toArray(new SnmpPeer[peers.size()]);
    }

    public ArrayList<Switch> getIVREnabledSwitches() {
        HashedArrayList<Switch> sws = new HashedArrayList<Switch>();
        Switch[] switches = this.getSwitches();
        if (switches != null && switches.length > 0) {
            for (int i = 0; i < switches.length; ++i) {
                Switch sw = switches[i];
                if (!sw.isIvrEnabled() || !sw.isLocallyManageable() || sw.getPeer() == null) continue;
                ((ArrayList)sws).add(sw);
            }
        }
        return sws;
    }

    public Switch[] getSwitches(boolean needQuail) {
        HashedArrayList<Switch> sws = new HashedArrayList<Switch>();
        Switch[] switches = this.getSwitches();
        if (switches != null && switches.length > 0) {
            for (int i = 0; i < switches.length; ++i) {
                Switch sw = switches[i];
                if (!sw.isMDS() && (!needQuail || !sw.isQuail()) || !sw.isLocallyManageable()) continue;
                ((ArrayList)sws).add(sw);
            }
        }
        return sws.toArray(new Switch[sws.size()]);
    }

    public Switch[] getSwitches(boolean needQuail, boolean isUcs) {
        HashedArrayList<Switch> sws = new HashedArrayList<Switch>();
        Switch[] switches = this.getSwitches();
        if (switches != null && switches.length > 0) {
            for (int i = 0; i < switches.length; ++i) {
                Switch sw = switches[i];
                if (!sw.isMDS() && (!needQuail || !sw.isQuail()) || !sw.isLocallyManageable()) continue;
                if (sw.isUCS()) {
                    if (!isUcs) continue;
                    ((ArrayList)sws).add(sw);
                    continue;
                }
                ((ArrayList)sws).add(sw);
            }
        }
        return sws.toArray(new Switch[sws.size()]);
    }

    public SnmpPeer getIVREnabledSwitchPeerWtLowestWWN() {
        ArrayList<Switch> switchLst = this.getIVREnabledSwitches();
        if (switchLst != null && switchLst.size() > 0) {
            Wwn wwnCache = null;
            Switch swCache = null;
            for (int i = 0; i < switchLst.size(); ++i) {
                Switch sw = switchLst.get(i);
                Wwn wwn = sw.getWwn();
                if (i != 0 && wwn.compareTo(wwnCache) >= 0) continue;
                wwnCache = wwn;
                swCache = sw;
            }
            if (swCache != null) {
                return swCache.getSnmpPeer();
            }
        }
        return null;
    }

    @Override
    public void destroy() {
        VsanBase vsanBase = (VsanBase)this._baseModelObject;
        if (this.lnkEnforcedZone != null) {
            this.lnkEnforcedZone.clear();
        }
        if (vsanBase != null) {
            vsanBase.setEnforcedZones(null);
        }
        this._fabric = null;
        this._filters = null;
        this._mgmtDomain = null;
    }

    @Override
    public EthIsl[] getEthIsls() {
        ArrayList<EthIsl> isls = this.getEthIsls(null);
        return isls.toArray(new EthIsl[isls.size()]);
    }

    @Override
    public ArrayList<EthIsl> getEthIsls(ArrayList<EthIsl> isls) {
        return new HashedArrayList<EthIsl>(0);
    }

    @Override
    public EthSwitch[] getEthSwitches() {
        return new EthSwitch[0];
    }

    @Override
    public Switch[] getFCoESwitches() {
        HashedArrayList<Switch> switches = new HashedArrayList<Switch>();
        Switch[] sws = this.getFabric().getSwitches();
        if (sws == null || sws.length == 0) {
            return new Switch[0];
        }
        for (Switch sw : sws) {
            if (!sw.isMemberOfVsan(this) || !sw.isFcoeCapable()) continue;
            ((ArrayList)switches).add(sw);
        }
        return switches.toArray(new Switch[switches.size()]);
    }

    protected boolean isFCoE(Switch sw) {
        return sw.isFcoeEnabled();
    }

    @Override
    public boolean isEthernet() {
        return false;
    }

    @Override
    public boolean isLAN() {
        return false;
    }

    @Override
    public boolean isDataCenter() {
        return false;
    }

    @Override
    public AbstractLink[] getAbstractLinks() {
        ArrayList<AbstractLink> isls = this.getAbstractLinks(null);
        return isls.toArray(new AbstractLink[isls.size()]);
    }

    @Override
    public ArrayList<AbstractLink> getAbstractLinks(ArrayList<AbstractLink> isls) {
        if (isls == null) {
            isls = new HashedArrayList<AbstractLink>();
        }
        ArrayList<Isl> islList = this.getIsls(null);
        ArrayList<NpvLink> npvLinkList = this.getNpvLinks(null);
        ArrayList<EthIsl> ethIslList = this.getEthIsls(null);
        if (islList != null) {
            isls.addAll(islList);
        }
        if (npvLinkList != null) {
            isls.addAll(npvLinkList);
        }
        if (ethIslList != null) {
            isls.addAll(ethIslList);
        }
        return isls;
    }

    @Override
    public AbstractSwitch[] getAbstractSwitches() {
        int i;
        HashedArrayList<AbstractSwitch> abstractSwitchList = new HashedArrayList<AbstractSwitch>();
        Switch[] switchList = this.getSwitches();
        EthSwitch[] ethSwitchList = this.getEthSwitches();
        if (switchList != null) {
            for (i = 0; i < switchList.length; ++i) {
                ((ArrayList)abstractSwitchList).add(switchList[i]);
            }
        }
        if (ethSwitchList != null) {
            for (i = 0; i < ethSwitchList.length; ++i) {
                ((ArrayList)abstractSwitchList).add(ethSwitchList[i]);
            }
        }
        return abstractSwitchList.toArray(new AbstractSwitch[abstractSwitchList.size()]);
    }
}

