/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.dto.FlexAtahCfg;
import com.cisco.dcbu.sm.common.dto.FlexAtahSwBaseCfg;
import com.cisco.dcbu.sm.common.dto.FlexAtahSwBaseGlobal;
import com.cisco.dcbu.sm.common.dto.FlexAtahSwBaseVPWWN;
import com.cisco.dcbu.sm.common.dto.FlexAtahSwBaseVsans;
import com.cisco.dcbu.sm.common.dto.FlexAtahVPWWN;
import com.cisco.dcbu.sm.common.dto.NpvPortPairCfg;
import com.cisco.dcbu.sm.common.dto.TrafficMap;
import com.cisco.dcbu.sm.common.dto.TrafficMapElement;
import com.cisco.dcbu.sm.common.event.PtoPEventFactory;
import com.cisco.dcbu.sm.common.event.PtoPEventHandler;
import com.cisco.dcbu.sm.common.event.QueueListener;
import com.cisco.dcbu.sm.common.model.AbstractSwitchBase;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.VsanBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class NPVUtil {
    public static final String NPV_MIN_VERSION = "3.2";
    public static final String NPIV_MIN_VERSION = "3.0(1)";
    protected static Logger _logger = LogManager.getLogger((String)"NPV");

    public static boolean isNPVCapable(Switch sw) {
        return sw.isVersionGreaterThanEqual(NPV_MIN_VERSION) && sw.isParadise();
    }

    public static List<Switch> getNPVCapableSwitches() {
        ArrayList<Switch> result = new ArrayList<Switch>();
        Switch[] allSwitches = San.getInstance().getSwitches();
        for (int i = 0; i < allSwitches.length; ++i) {
            String a;
            Switch next = allSwitches[i];
            if (!next.isVersionGreaterThanEqual(NPV_MIN_VERSION) || !next.isParadise() || !(a = next.getName()).equals("npv1") && !a.equals("npv2")) continue;
            result.add(next);
        }
        return result;
    }

    public static List<Switch> getRemoteSwitch() {
        ArrayList<Switch> result = new ArrayList<Switch>();
        Switch[] allSwitches = San.getInstance().getSwitches();
        for (int i = 0; i < allSwitches.length; ++i) {
            String a;
            Switch next = allSwitches[i];
            if (!next.isVersionGreaterThanEqual(NPV_MIN_VERSION) || !next.isParadise() || !(a = next.getName()).equals("172.22.34.215")) continue;
            result.add(next);
        }
        return result;
    }

    public static boolean isNPIVCapableCore(Switch sw) {
        return sw.isFeatureEnabled(AbstractSwitchBase.Feature.NPV.flag()) && sw.isVersionGreaterThanEqual(NPIV_MIN_VERSION);
    }

    public static List<Switch> getNPIVCapableCoreSwitches() {
        ArrayList<Switch> result = new ArrayList<Switch>();
        Switch[] allSwitches = San.getInstance().getSwitches();
        for (int i = 0; i < allSwitches.length; ++i) {
            Switch next = allSwitches[i];
            if (next.isFeatureEnabled(AbstractSwitchBase.Feature.NPV.flag()) || !next.isVersionGreaterThanEqual(NPIV_MIN_VERSION)) continue;
            result.add(next);
        }
        return result;
    }

    public static List<FcPortBase> getPorts(Switch sw) throws Exception {
        SwitchBase base = sw.getSwitchBase();
        ArrayList<SwitchBase> switches = new ArrayList<SwitchBase>();
        switches.add(base);
        try {
            Map<SwitchBase, List<FcPortBase>> results = ClientController.getInstance().assertNPV().findFcPortBase(switches);
            List<FcPortBase> swPorts = results.get(base);
            if (swPorts != null) {
                return swPorts;
            }
            return new ArrayList<FcPortBase>();
        }
        catch (Exception e) {
            _logger.error((Object)("error getting FcPortBase list for switch - " + sw), (Throwable)e);
            throw new Exception("Error retrieving ports for switch - " + sw + " : " + e.getMessage());
        }
    }

    public static Map<Switch, List<FcPortBase>> getPorts(List<Switch> switches) throws Exception {
        ArrayList<SwitchBase> swBases = new ArrayList<SwitchBase>();
        HashMap<SwitchBase, Switch> baseToSwitchMap = new HashMap<SwitchBase, Switch>();
        for (int i = 0; i < switches.size(); ++i) {
            Switch next = switches.get(i);
            SwitchBase base = next.getSwitchBase();
            swBases.add(base);
            baseToSwitchMap.put(base, next);
        }
        try {
            Map<SwitchBase, List<FcPortBase>> results = ClientController.getInstance().assertNPV().findFcPortBase(swBases);
            HashMap<Switch, List<FcPortBase>> swPorts = new HashMap<Switch, List<FcPortBase>>();
            for (SwitchBase next : results.keySet()) {
                Switch sw = (Switch)baseToSwitchMap.get(next);
                swPorts.put(sw, results.get(next));
            }
            return swPorts;
        }
        catch (Exception e) {
            _logger.error((Object)("error getting FcPortBase list for switches - " + switches), (Throwable)e);
            throw new Exception("Error retrieving ports for switches : " + e.getMessage());
        }
    }

    public static List<Switch> getConnectedSwitches(Switch sw1) {
        Switch[] switches = San.getInstance().findAttachedSwitches(sw1);
        if (switches != null) {
            return Arrays.asList(switches);
        }
        return new ArrayList<Switch>();
    }

    public static Array<Isl> findIslsBySwitch(Switch sw1) {
        Fabric fab1 = sw1.getFabric();
        return fab1.findIslsBySwitch(sw1, false);
    }

    public static Array<Isl> getIsls(Switch sw1, Switch sw2) {
        Fabric fab2;
        Fabric fab1 = sw1.getFabric();
        if (fab1.equals(fab2 = sw2.getFabric())) {
            return fab1.findIslsBySwitches(sw1, sw2);
        }
        return new Array<Isl>();
    }

    public static boolean isNPVEnabled(Switch sw) throws IllegalArgumentException {
        if (sw == null) {
            throw new IllegalArgumentException("Switch can not be null");
        }
        return sw.isFeatureEnabled(AbstractSwitchBase.Feature.NPV.flag());
    }

    public static boolean isNPIVEnabledCore(Switch sw) throws IllegalArgumentException {
        if (sw == null) {
            throw new IllegalArgumentException("Switch can not be null");
        }
        return sw.isFeatureEnabled(AbstractSwitchBase.Feature.NPIV.flag());
    }

    public static long enableNPIVCoreFeature(List<Switch> switches, List<SnmpUserOpt> creds, Object channelOrQueue) throws Exception {
        List<SwitchBase> swBases = NPVUtil.getSwitchBases(switches);
        try {
            return ClientController.getInstance().assertNPV().enableNPVCoreFeature(swBases, creds, channelOrQueue);
        }
        catch (Exception e) {
            _logger.error((Object)("error enabling NPIV feature list for switches - " + switches), (Throwable)e);
            throw new Exception("Error enabling NPIV on switches : " + e.getMessage());
        }
    }

    public static long enableNPVFeature(List<Switch> switches, List<SnmpUserOpt> creds, Object channelOrQueue) throws Exception {
        List<SwitchBase> swBases = NPVUtil.getSwitchBases(switches);
        try {
            return ClientController.getInstance().assertNPV().enableNPVFeature(swBases, creds, channelOrQueue);
        }
        catch (Exception e) {
            _logger.error((Object)("error enabling NPV feature list for switches - " + switches), (Throwable)e);
            throw new Exception("Error enabling NPV on switches : " + e.getMessage());
        }
    }

    public static long setNPPorts(List<Switch> npvSwitches, List<SnmpUserOpt> snmpUserOpts, List<List<FcPortBase>> ports, Object channelOrQueue) throws Exception {
        List<SwitchBase> swBases = NPVUtil.getSwitchBases(npvSwitches);
        try {
            return ClientController.getInstance().assertNPV().setNPPorts(swBases, snmpUserOpts, ports, channelOrQueue);
        }
        catch (Exception e) {
            _logger.error((Object)("error setting port mode to NP for switches - " + npvSwitches), (Throwable)e);
            throw new Exception("Error setting port mode to NP on switches : " + e.getMessage());
        }
    }

    public static long setPortsToAuto(List<Switch> npvSwitches, List<SnmpUserOpt> snmpUserOpts, List<List<FcPortBase>> ports, Object channelOrQueue) throws Exception {
        List<SwitchBase> swBases = NPVUtil.getSwitchBases(npvSwitches);
        try {
            return ClientController.getInstance().assertNPV().setPortsToAuto(swBases, snmpUserOpts, ports, channelOrQueue);
        }
        catch (Exception e) {
            _logger.error((Object)("error setting port mode to AUTO for switches - " + npvSwitches), (Throwable)e);
            throw new Exception("Error setting port mode to Auto on switches : " + e.getMessage());
        }
    }

    public static long setFPorts(List<Switch> npvSwitches, List<SnmpUserOpt> snmpUserOpts, List<List<FcPortBase>> ports, Object channelOrQueue) throws Exception {
        List<SwitchBase> swBases = NPVUtil.getSwitchBases(npvSwitches);
        try {
            return ClientController.getInstance().assertNPV().setFPorts(swBases, snmpUserOpts, ports, channelOrQueue);
        }
        catch (Exception e) {
            _logger.error((Object)("error setting port mode to F for switches - " + npvSwitches), (Throwable)e);
            throw new Exception("Error setting port mode to F on switches : " + e.getMessage());
        }
    }

    public static long setPortsToEnable(List<Switch> switches, List<SnmpUserOpt> snmpUserOpts, List<List<FcPortBase>> ports, Object channelOrQueue) throws Exception {
        List<SwitchBase> swBases = NPVUtil.getSwitchBases(switches);
        try {
            return ClientController.getInstance().assertNPV().setPortsToEnable(swBases, snmpUserOpts, ports, channelOrQueue);
        }
        catch (Exception e) {
            _logger.error((Object)("error enabling ports on list for switches - " + switches), (Throwable)e);
            throw new Exception("Error enabling NPV on switches : " + e.getMessage());
        }
    }

    public static long authenticateSwitch(List<Switch> npvSwitches, List<SnmpUserOpt> snmpUserOpts, Object channelOrQueue) throws Exception {
        List<SwitchBase> swBases = NPVUtil.getSwitchBases(npvSwitches);
        try {
            return ClientController.getInstance().assertNPV().authenticateSwitch(swBases, snmpUserOpts, channelOrQueue);
        }
        catch (Exception e) {
            _logger.error((Object)("error enabling NPV feature list for switches - " + npvSwitches), (Throwable)e);
            throw new Exception("Error enabling NPV on switches : " + e.getMessage());
        }
    }

    public static long copyRS(List<Switch> switches, List<SnmpUserOpt> snmpUserOpts, Object channelOrQueue) throws Exception {
        List<SwitchBase> swBases = NPVUtil.getSwitchBases(switches);
        try {
            return ClientController.getInstance().assertNPV().saveRunningConfigOnSwitch(swBases, snmpUserOpts, channelOrQueue);
        }
        catch (Exception e) {
            _logger.error((Object)("error copying running config for switches - " + switches), (Throwable)e);
            throw new Exception("Error copying running config on switches : " + e.getMessage());
        }
    }

    public static long addSwitchesToVsan(List<Switch> switches, List<SnmpUserOpt> snmpUserOpts, int vsan, VsanBase vsanBase, Object channelOrQueue) throws Exception {
        List<SwitchBase> swBases = NPVUtil.getSwitchBases(switches);
        try {
            return ClientController.getInstance().assertNPV().addSwitchesToVsan(swBases, snmpUserOpts, vsan, vsanBase, channelOrQueue);
        }
        catch (Exception e) {
            _logger.error((Object)("error enabling NPV feature list for switches - " + switches), (Throwable)e);
            throw new Exception("Error enabling NPV on switches : " + e.getMessage());
        }
    }

    public static long addPortsToVsan(List<Switch> switches, List<List<FcPortBase>> ports, List<SnmpUserOpt> snmpUserOpts, int vsan, VsanBase vsanBase, Object channelOrQueue) throws Exception {
        List<SwitchBase> swBases = NPVUtil.getSwitchBases(switches);
        try {
            return ClientController.getInstance().assertNPV().addPortsToVsan(swBases, ports, snmpUserOpts, vsan, vsanBase, channelOrQueue);
        }
        catch (Exception e) {
            _logger.error((Object)("error enabling NPV feature list for switches - " + switches), (Throwable)e);
            throw new Exception("Error enabling NPV on switches : " + e.getMessage());
        }
    }

    public static List<NpvPortPairCfg> getNpvPairPortCfg(List<NpvPortPairCfg> pairs, int numberNPPorts) throws Exception {
        try {
            return ClientController.getInstance().assertNPV().getNpvPairPortCfg(pairs, numberNPPorts);
        }
        catch (Exception e) {
            _logger.error((Object)("error enabling getting np and auto ports for pairs - " + pairs), (Throwable)e);
            throw new Exception("Error enabling NPV pair port cfg : " + e.getMessage());
        }
    }

    public static List<SwitchBase> getSwitchBases(List<Switch> switches) {
        ArrayList<SwitchBase> swBases = new ArrayList<SwitchBase>();
        for (int i = 0; i < switches.size(); ++i) {
            Switch next = switches.get(i);
            SwitchBase base = next.getSwitchBase();
            swBases.add(base);
        }
        return swBases;
    }

    public static long setTrafficMap(List<Switch> switches, List<SnmpUserOpt> snmpUserOpts, List<TrafficMap> maps, Object channelOrQueue) throws Exception {
        try {
            List<SwitchBase> swBases = NPVUtil.getSwitchBases(switches);
            return ClientController.getInstance().assertNPV().setTrafficMap(swBases, snmpUserOpts, maps, channelOrQueue);
        }
        catch (Exception e) {
            _logger.error((Object)("error setting traffic map for switches - " + switches), (Throwable)e);
            throw new Exception("Error setting traffic map for switches - " + switches + "," + e.getMessage());
        }
    }

    public static List<TrafficMap> getTrafficMap(List<Switch> switches, List<SnmpUserOpt> snmpUserOpts) throws Exception {
        try {
            List<SwitchBase> swBases = NPVUtil.getSwitchBases(switches);
            return ClientController.getInstance().assertNPV().getTrafficMap(swBases, snmpUserOpts);
        }
        catch (Exception e) {
            _logger.error((Object)("error getting traffic map from switches - " + switches), (Throwable)e);
            throw new Exception("Error getting traffic map from switches - " + switches + "," + e.getMessage());
        }
    }

    private static TrafficMap createTrafficMapFor(Switch sw) throws Exception {
        HashMap<Integer, TrafficMapElement> map = new HashMap<Integer, TrafficMapElement>();
        List<FcPortBase> ports = NPVUtil.getPorts(sw);
        if (ports.size() > 1) {
            ArrayList<Integer> listPorts = new ArrayList<Integer>();
            Integer serverPort = null;
            for (int p = 0; p < ports.size(); ++p) {
                FcPortBase nextPort = ports.get(p);
                if (serverPort == null) {
                    serverPort = nextPort.getIfIndex();
                    continue;
                }
                listPorts.add(nextPort.getIfIndex());
                if (listPorts.size() != 2) continue;
                TrafficMapElement nextElement = new TrafficMapElement(serverPort, listPorts, 0L);
                map.put(serverPort, nextElement);
                listPorts.clear();
                serverPort = null;
            }
        }
        return new TrafficMap(sw.getSwitchBase(), map, false);
    }

    public static Map<SwitchBase, FlexAtahSwBaseCfg> getFlexAtahCfg(List<Switch> switches, List<SnmpUserOpt> creds, Object channelOrQueue) throws Exception {
        List<SwitchBase> swBases = NPVUtil.getSwitchBases(switches);
        try {
            return ClientController.getInstance().assertFlexAtah().getFlexAtahCfg(swBases, creds);
        }
        catch (Exception e) {
            _logger.error((Object)("error getFlexAtahCfg for switches - " + switches), (Throwable)e);
            throw new Exception("Error getFlexAtahCfg on switches : " + e.getMessage());
        }
    }

    public static Map<SwitchBase, FlexAtahSwBaseGlobal> getFlexAtahIsAuto(List<Switch> switches, List<SnmpUserOpt> creds, Object channelOrQueue) throws Exception {
        List<SwitchBase> swBases = NPVUtil.getSwitchBases(switches);
        try {
            return ClientController.getInstance().assertFlexAtah().getFlexAtahIsAuto(swBases, creds);
        }
        catch (Exception e) {
            _logger.error((Object)("error getFlexAtahIsAuto for switches - " + switches), (Throwable)e);
            throw new Exception("Error getFlexAtahIsAuto on switches : " + e.getMessage());
        }
    }

    public static long setFlexAtahCfg(List<Switch> switches, List<SnmpUserOpt> snmpUserOpts, Object channelOrQueue) throws Exception {
        List<SwitchBase> swBases = NPVUtil.getSwitchBases(switches);
        try {
            ArrayList<List<FlexAtahCfg>> portList = new ArrayList<List<FlexAtahCfg>>();
            for (int i = 0; i < swBases.size(); ++i) {
                FlexAtahCfg a;
                ArrayList<FlexAtahCfg> ports;
                if (swBases.get(i).getIpAddress().equals("172.22.34.214")) {
                    ports = new ArrayList<FlexAtahCfg>();
                    a = new FlexAtahCfg(IfIndexUtil.nameToIfIndex("fc1/9"), 16, "fatest", 2, -1, 2, false, new Wwn(new byte[]{38, 69, 0, 13, -20, 47, -90, 76}), false, new Wwn(new byte[]{38, 52, 0, 13, -20, 47, -90, 76}));
                    ports.add(a);
                    a = new FlexAtahCfg(IfIndexUtil.nameToIfIndex("fc1/10"), 16, "fatest", 2, -1, 2, false, new Wwn(new byte[]{38, 70, 0, 13, -20, 47, -90, 76}), false, new Wwn(new byte[]{38, 53, 0, 13, -20, 47, -90, 76}));
                    ports.add(a);
                    portList.add(ports);
                    continue;
                }
                if (swBases.get(i).getIpAddress().equals("172.22.34.215")) {
                    ports = new ArrayList();
                    a = new FlexAtahCfg(IfIndexUtil.nameToIfIndex("fc1/9"), 16, "fatest", 2, -1, 2, false, new Wwn(new byte[]{33, 48, 0, 13, -20, 77, 106, -53}), false, new Wwn(new byte[]{33, 10, 0, 13, -20, 77, 106, -53}));
                    ports.add(a);
                    a = new FlexAtahCfg(IfIndexUtil.nameToIfIndex("fc1/10"), 16, "fatest", 2, -1, 2, false, new Wwn(new byte[]{33, 49, 0, 13, -20, 77, 106, -53}), false, new Wwn(new byte[]{33, 11, 0, 13, -20, 77, 106, -53}));
                    ports.add(a);
                    portList.add(ports);
                    continue;
                }
                ports = new ArrayList();
                a = new FlexAtahCfg(IfIndexUtil.nameToIfIndex("fc1/1"), 16, "fatest", 2, -1, 2, false, new Wwn(new byte[]{33, 91, 0, 13, -20, 61, 43, -62}), false, new Wwn(new byte[]{0, 0, 0, 0, 0, 0, 0, 0}));
                ports.add(a);
                portList.add(ports);
            }
            return ClientController.getInstance().assertFlexAtah().setFlexAtahCfg(swBases, portList, snmpUserOpts, channelOrQueue);
        }
        catch (Exception e) {
            _logger.error((Object)("error setFlexAtahCfg for switches - " + switches), (Throwable)e);
            throw new Exception("Error setFlexAtahCfg on switches : " + e.getMessage());
        }
    }

    public static Map<SwitchBase, FlexAtahSwBaseVPWWN> getFlexAtahVPWWN(List<Switch> switches, List<SnmpUserOpt> creds, Object channelOrQueue) throws Exception {
        List<SwitchBase> swBases = NPVUtil.getSwitchBases(switches);
        try {
            return ClientController.getInstance().assertFlexAtah().getFlexAtahVPWWN(swBases, creds);
        }
        catch (Exception e) {
            _logger.error((Object)("error getFlexAtahVPWWN for switches - " + switches), (Throwable)e);
            throw new Exception("Error getFlexAtahVPWWN on switches : " + e.getMessage());
        }
    }

    public static long setFlexAtahVPWWN(List<Switch> switches, List<SnmpUserOpt> snmpUserOpts, Object channelOrQueue) throws Exception {
        List<SwitchBase> swBases = NPVUtil.getSwitchBases(switches);
        try {
            ArrayList<List<FlexAtahVPWWN>> list = new ArrayList<List<FlexAtahVPWWN>>();
            for (int i = 0; i < swBases.size(); ++i) {
                ArrayList<FlexAtahVPWWN> vpwwnL = new ArrayList<FlexAtahVPWWN>();
                FlexAtahVPWWN a = new FlexAtahVPWWN(new Wwn(new byte[]{17, 34, 51, 68, 85, 102, 119, -103}), new Wwn(new byte[]{1, 2, 3, 4, 5, 6, 7, 1}));
                vpwwnL.add(a);
                a = new FlexAtahVPWWN(new Wwn(new byte[]{2, 3, 4, 5, 6, 7, 8, 9}), new Wwn(new byte[]{12, 13, 14, 15, 16, 17, 18, 19}));
                vpwwnL.add(a);
                a = new FlexAtahVPWWN(new Wwn(new byte[]{3, 4, 5, 6, 7, 8, 9, 10}), new Wwn(new byte[]{13, 14, 15, 16, 17, 18, 19, 100}));
                vpwwnL.add(a);
                a = new FlexAtahVPWWN(new Wwn(new byte[]{4, 5, 6, 7, 8, 9, 10, 11}), new Wwn(new byte[]{13, 14, 15, 16, 17, 18, 19, 110}));
                vpwwnL.add(a);
                list.add(vpwwnL);
            }
            return ClientController.getInstance().assertFlexAtah().setFlexAtahVPWWN(swBases, list, snmpUserOpts, channelOrQueue);
        }
        catch (Exception e) {
            _logger.error((Object)("error setFlexAtahVPWWN for switches - " + switches), (Throwable)e);
            throw new Exception("Error setFlexAtahVPWWN on switches : " + e.getMessage());
        }
    }

    public static long verifyFlexAtahReplaceSamePort(Switch sw, SnmpUserOpt snmpUserOpt, Object channelOrQueue) throws Exception {
        try {
            int fromIfIndex = IfIndexUtil.nameToIfIndex("fc1/1");
            Wwn serverVPWWN = null;
            Wwn sparePortPWWN = new Wwn("c1:e6:00:11:0d:0f:00:00", true);
            return ClientController.getInstance().assertFlexAtah().verifyFlexAtahReplaceSamePort(sw.getSwitchBase(), fromIfIndex, serverVPWWN, sparePortPWWN, snmpUserOpt, channelOrQueue);
        }
        catch (Exception e) {
            _logger.error((Object)("error verifyFlexAtahReplaceSamePort for switch - " + sw), (Throwable)e);
            throw new Exception("Error verifyFlexAtahReplaceSamePort on switches : " + e.getMessage());
        }
    }

    public static long replaceFlexAtahToSpare(Switch sw, SnmpUserOpt snmpUserOpt, Object channelOrQueue) throws Exception {
        try {
            int fromIfIndex = IfIndexUtil.nameToIfIndex("fc1/31");
            int toIfIndex = IfIndexUtil.nameToIfIndex("fc1/17");
            Wwn serverVPWWN = new Wwn("21:33:00:02:6b:aa:29:03", true);
            Switch remoteSwitch = sw;
            Wwn sparePortPWWN = new Wwn("c1:e6:00:11:0d:0f:00:00", true);
            return ClientController.getInstance().assertFlexAtah().replaceFlexAtahToSpare(sw.getSwitchBase(), fromIfIndex, remoteSwitch.getSwitchBase(), toIfIndex, serverVPWWN, sparePortPWWN, false, snmpUserOpt, remoteSwitch.getFabric().getSnmpUserOpt(), channelOrQueue);
        }
        catch (Exception e) {
            _logger.error((Object)("error replaceFlexAtahToSpare for switch - " + sw), (Throwable)e);
            throw new Exception("Error replaceFlexAtahToSpare on switches : " + e.getMessage());
        }
    }

    public static long moveFlexAttachToEmptyPort(Switch sw, SnmpUserOpt snmpUserOpt, Object channelOrQueue) throws Exception {
        try {
            int fromIfIndex = IfIndexUtil.nameToIfIndex("fc1/10");
            int toIfIndex = IfIndexUtil.nameToIfIndex("fc1/12");
            Wwn serverVPWWN = new Wwn("21:33:00:02:6b:aa:29:02", true);
            Switch remoteSwitch = NPVUtil.getRemoteSwitch().get(0);
            return ClientController.getInstance().assertFlexAtah().moveFlexAttachToEmptyPort(sw.getSwitchBase(), fromIfIndex, remoteSwitch.getSwitchBase(), toIfIndex, serverVPWWN, snmpUserOpt, remoteSwitch.getFabric().getSnmpUserOpt(), channelOrQueue);
        }
        catch (Exception e) {
            _logger.error((Object)("error moveFlexAttachToEmptyPort for switch - " + sw), (Throwable)e);
            throw new Exception("Error moveFlexAttachToEmptyPort on switches : " + e.getMessage());
        }
    }

    public static long verifyFlexAttachUp(Switch sw, SnmpUserOpt snmpUserOpt, Object channelOrQueue) throws Exception {
        try {
            int toIfIndex = IfIndexUtil.nameToIfIndex("fc1/17");
            Wwn serverVPWWN = new Wwn("21:33:00:02:6b:aa:29:03", true);
            return ClientController.getInstance().assertFlexAtah().verifyFlexAttachUp(sw.getSwitchBase(), toIfIndex, serverVPWWN, snmpUserOpt, channelOrQueue);
        }
        catch (Exception e) {
            _logger.error((Object)("error verifyFlexAttachUp for switch - " + sw), (Throwable)e);
            throw new Exception("Error verifyFlexAttachUp on switches : " + e.getMessage());
        }
    }

    public static Map<SwitchBase, FlexAtahSwBaseVsans> getVsanList(List<Switch> sws, List<SnmpUserOpt> creds, Object channelOrQueue) throws Exception {
        try {
            List<SwitchBase> swBases = NPVUtil.getSwitchBases(sws);
            return ClientController.getInstance().assertFlexAtah().getVsanList(swBases, creds);
        }
        catch (Exception e) {
            _logger.error((Object)("error getVsanList for switch - " + sws), (Throwable)e);
            throw new Exception("Error getVsanList on switches : " + e.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        boolean ENABLE_NPIV = false;
        boolean SET_ENABLE_PORTS = false;
        boolean ENABLE_TEST_AUTH = false;
        boolean SET_NPV_VSAN = false;
        boolean ENABLE_NPV = false;
        boolean TEST_AUTO_PORT_SELECT = false;
        boolean SET_F_PORTS = false;
        boolean TEST_COPY_RS = false;
        boolean SET_NP_PORTS = false;
        boolean TEST_TRAFFIC_MAP = true;
        boolean _flexAttachTesting = true;
        Thread runner = new Thread(){

            @Override
            public void run() {
                try {
                    ArrayList<SnmpUserOpt> npvSwitchCreds = new ArrayList<SnmpUserOpt>();
                    List<Switch> npvSwitches = NPVUtil.getNPVCapableSwitches();
                    System.out.println("NPV Switches - " + npvSwitches);
                    List<Switch> npivSwitches = NPVUtil.getNPIVCapableCoreSwitches();
                    System.out.println("NPIV Core Switches - " + npivSwitches);
                    System.out.println("***************print out capable NPV switches");
                    for (int i = 0; i < npvSwitches.size(); ++i) {
                        Switch next = npvSwitches.get(i);
                        npvSwitchCreds.add(next.getFabric().getSnmpUserOpt());
                    }
                    ExListener listener = new ExListener();
                    System.out.println("getting PtoP factory");
                    PtoPEventFactory factory = PtoPEventFactory.getInstance();
                    System.out.println("getting PtoP Handler");
                    PtoPEventHandler ptopHandler = factory.getPtoPHandler("jms/queue/FlexAtah", listener);
                    System.out.println("\nCalling getFlexAtahCfg on NPV switches");
                    HashMap resultMap = new HashMap();
                    System.out.println("getFlexAtahCfg done - ");
                    System.out.println("\nCalling getFlexAtahIsAuto on NPV switches");
                    HashMap resultMap2 = new HashMap();
                    System.out.println("getFlexAtahIsAuto done - ");
                    System.out.println("\nCalling setFlexAtahCfg on NPV switches");
                    long requestId = NPVUtil.setFlexAtahCfg(npvSwitches, npvSwitchCreds, ptopHandler.getCommunicationObject());
                    System.out.println("setFlexAtahCfg done - ");
                    System.out.println("\nCalling getFlexAtahVPWWN on NPV switches");
                    HashMap resultMap1 = new HashMap();
                    System.out.println("getFlexAtahVPWWN done - ");
                    System.out.println("\nCalling setFlexAtahVPWWN on NPV switches");
                    System.out.println("setFlexAtahVPWWN done - ");
                    System.out.println("\nCalling verifyFlexAtahReplaceSamePort on NPV switches");
                    System.out.println("verifyFlexAtahReplaceSamePort done - ");
                    System.out.println("\nCalling replaceFlexAtahToSpare on NPV switches");
                    System.out.println("replaceFlexAtahToSpare done - ");
                    System.out.println("\nCalling moveFlexAttachToEmptyPort on NPV switches");
                    System.out.println("moveFlexAttachToEmptyPort done - ");
                    System.out.println("\nCalling verifyFlexAttachUp on NPV switches");
                    System.out.println("verifyFlexAttachUp done - ");
                    System.out.println("\nCalling getVsanList on NPV switches");
                    Map<Object, Object> resultMap3 = new HashMap();
                    resultMap3 = NPVUtil.getVsanList(npvSwitches, npvSwitchCreds, ptopHandler.getCommunicationObject());
                    for (SwitchBase switchBase : resultMap3.keySet()) {
                        System.out.println("getVsanList sw " + switchBase.toString());
                        FlexAtahSwBaseVsans list = (FlexAtahSwBaseVsans)resultMap3.get(switchBase);
                        if (list.getVSANList() != null) {
                            System.out.println(list.toString());
                            continue;
                        }
                        System.out.println("Exception " + list.getException());
                    }
                    System.out.println("getVsanList done - ");
                }
                catch (Exception e) {
                    System.out.println("received exception - " + e);
                }
            }
        };
        runner.start();
    }

    public static class ExListener
    implements QueueListener {
        @Override
        public void onMessage(Object msg) {
            try {
                System.out.println("ExListener::  -====== onMessage, recv obj=" + msg);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

