/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.controller;

import com.cisco.dcbu.lib.util.TimeWatch;
import com.cisco.dcbu.sm.client.npv.controller.SwitchActionTracker;
import com.cisco.dcbu.sm.client.npv.util.NpvClientHelper;
import com.cisco.dcbu.sm.common.event.PtoPEventFactory;
import com.cisco.dcbu.sm.common.event.PtoPEventHandler;
import com.cisco.dcbu.sm.common.event.QueueListener;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractAsyncSwitchTask
implements Runnable,
QueueListener {
    public static final Logger _Logger = Logger.getLogger(AbstractAsyncSwitchTask.class);
    public static final Type EnableNPV = Type.EnableNPV;
    public static final Type EnableNPIV = Type.EnableNPIV;
    public static final Type EnablePorts = Type.EnablePorts;
    public static final Type SetNpPorts = Type.SetNpPorts;
    public static final Type SetFPorts = Type.SetFPorts;
    public static final Type SetNpivPorts = Type.SetNpivPorts;
    public static final Type AddVSANSwitches = Type.AddVSANSwitches;
    public static final Type AddVSANPorts = Type.AddVSANPorts;
    public static final Type SaveConfig = Type.SaveConfig;
    public static final Type VerifyAccess = Type.VerifyAccess;
    public static final Type SetFlexAttach = Type.SetFlexAttach;
    public static final Type SetTrafficMap = Type.SetTrafficMap;
    public static final String Snmp_Timeout_Msg = "timeout";
    public static final String Snmp_Unauth_Msg = "Privacy unsupported for this user";
    public static final String Snmp_InvalidCredential_msg = "Invalid Credentials";
    protected List<SwitchBase> swbList = new ArrayList<SwitchBase>();
    protected List<SnmpUserOpt> swUserList = new ArrayList<SnmpUserOpt>();
    protected Type type;
    protected TimeWatch timer = new TimeWatch();
    protected long taskTimeout = 60000L;
    protected long messageTimeout = 30000L;
    protected State state = State.Init;
    protected Set<SwitchBase> allSet = Collections.synchronizedSet(new HashSet());
    protected Set<SwitchBase> succSet = Collections.synchronizedSet(new HashSet());
    protected Set<SwitchBase> failedSet = Collections.synchronizedSet(new HashSet());
    protected PtoPEventHandler p2pHandler;
    protected long requestId = -1L;

    public Type getType() {
        return this.type;
    }

    public long getTaskTimeout() {
        return this.taskTimeout;
    }

    public void setTaskTimeout(long taskTimeout) {
        this.taskTimeout = taskTimeout;
    }

    public long getMessageTimeout() {
        return this.messageTimeout;
    }

    public void setMessageTimeout(long messageTimeout) {
        this.messageTimeout = messageTimeout;
    }

    public void setNoTaskTimeout() {
        this.taskTimeout = -1L;
    }

    public boolean isTaskInit() {
        return this.getState() == State.Init;
    }

    public boolean isTaskRunning() {
        return this.getState() == State.Running;
    }

    public boolean isTaskEnd() {
        return this.getState() == State.End;
    }

    public boolean isTaskClosed() {
        return this.getState() == State.Close;
    }

    public boolean isTaskSuccess() {
        return this.isTaskEnd() && this.succSet.size() == this.allSet.size();
    }

    public boolean isTaskFailed() {
        return this.isTaskEnd() && this.failedSet.size() > 0;
    }

    public boolean isTaskInterrupted() {
        return this.isTaskEnd() && this.failedSet.size() + this.succSet.size() < this.allSet.size();
    }

    protected void setState(State state) {
        if (this.state != state) {
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)(this + " : state changed from " + (Object)((Object)this.state) + " to " + (Object)((Object)state)));
            }
            this.state = state;
        }
    }

    protected State getState() {
        return this.state;
    }

    public Set<SwitchBase> getFailedSet() {
        return this.failedSet;
    }

    public Set<SwitchBase> getSuccSet() {
        return this.succSet;
    }

    public Set<SwitchBase> getAllSet() {
        return this.allSet;
    }

    public List<SwitchBase> getSwbList() {
        return this.swbList;
    }

    public List<SnmpUserOpt> getSwUserList() {
        return this.swUserList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            AbstractAsyncSwitchTask abstractAsyncSwitchTask = this;
            synchronized (abstractAsyncSwitchTask) {
                this.timer.start();
                if (_Logger.isTraceEnabled()) {
                    _Logger.trace((Object)(this + " to run"));
                }
                this.startTask();
                while (this.isTaskRunning()) {
                    block17: {
                        try {
                            if (_Logger.isTraceEnabled()) {
                                _Logger.trace((Object)(this + " waited at time:" + this.timer.getTimeDisplay()));
                            }
                            if (this.messageTimeout > 0L) {
                                this.wait(this.messageTimeout);
                            } else {
                                this.wait();
                            }
                            if (_Logger.isTraceEnabled()) {
                                _Logger.trace((Object)(this + " woke up at time:" + this.timer.getTimeDisplay()));
                            }
                        }
                        catch (InterruptedException e) {
                            if (!_Logger.isTraceEnabled()) break block17;
                            _Logger.trace((Object)(this + " got interrupted at time:" + this.timer.getTimeDisplay()));
                        }
                    }
                    if (this.taskTimeout <= 0L || this.timer.getTime() <= this.taskTimeout) continue;
                    throw new Exception(this + " used time: " + this.timer.getTimeDisplay() + " passed maximum time" + TimeWatch.getDisplayedTime(this.taskTimeout) + "\nTask is timeout");
                }
            }
        }
        catch (Exception e) {
            _Logger.warn((Object)(this + " cannot complete with exception at time:" + this.timer.getTimeDisplay()));
            _Logger.warn((Object)e);
            this.handleException(e);
        }
        finally {
            this.timer.stop();
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)(this + " ended at time:" + this.timer.getTimeDisplay()));
            }
            this.endTask();
        }
    }

    protected void startTask() throws Exception {
        try {
            if (!this.isTaskInit()) {
                throw new IllegalStateException(this + " is in illegal state to start task:" + this.state.getName());
            }
            this.setState(State.Running);
            this.updateStartStatus();
            this.p2pHandler = PtoPEventFactory.getInstance().getPtoPHandler("jms/queue/NPV", this);
            if (this.p2pHandler == null) {
                throw new Exception(this + " cannot communicate to remote");
            }
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)(this + " got PtoEventHandler: " + this.p2pHandler + ", with QueueListener:" + this + ", with CommObj:" + this.p2pHandler.getCommunicationObject()));
            }
            this.requestId = this.sendRequest();
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)">>>>>>>>> AsyncSwitchTask started a request >>>>>>>>>");
                _Logger.trace((Object)(">>>>" + this + " with reqId->" + this.requestId + ", p2pHandler->" + this.p2pHandler + ", queueListener->" + this));
            }
        }
        catch (Exception e) {
            _Logger.warn((Object)(this + " failed to start: "), (Throwable)e);
            throw e;
        }
    }

    protected void endTask() {
        try {
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)(this + " reached to endTask"));
            }
            this.setState(State.End);
            if (this.p2pHandler != null) {
                try {
                    if (_Logger.isTraceEnabled()) {
                        _Logger.trace((Object)(this + " close P2P queue:" + this.p2pHandler));
                    }
                    try {
                        NpvClientHelper.getInstance().getNPVRif().destroyPtoPQueue(this.p2pHandler.getCommunicationObject());
                    }
                    catch (Exception re) {
                        _Logger.error((Object)"error cleaning up P to P Queue on Server", (Throwable)re);
                    }
                    this.p2pHandler.stop();
                }
                catch (Exception e) {
                    _Logger.debug((Object)"Exception from close P2P queue", (Throwable)e);
                }
            }
            this.p2pHandler = null;
            this.updataEndStatus();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void handleException(Exception e) {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(this + " failed task with exception:" + e));
        }
        this.setState(State.End);
        this.updateFailStatus(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTask() {
        AbstractAsyncSwitchTask abstractAsyncSwitchTask = this;
        synchronized (abstractAsyncSwitchTask) {
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)(this + " is cancelled with reqId: " + this.requestId));
            }
            if (this.isTaskRunning()) {
                this.setState(State.End);
                this.updateCancelStatus();
                this.notifyAll();
                if (_Logger.isTraceEnabled()) {
                    _Logger.trace((Object)(this + "- onMessage: state" + this.state.getName() + ", reqId->" + this.requestId + ", queueListener->" + this + ", p2pHandler->" + this.p2pHandler + ": notifyAll"));
                }
            }
        }
    }

    public void resetTask(boolean all) {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(this + " is reset"));
        }
        if (this.isTaskRunning() || this.isTaskClosed()) {
            throw new IllegalStateException(this + " cannot be reset: " + this.getState().getName());
        }
        if (this.p2pHandler != null) {
            try {
                if (_Logger.isTraceEnabled()) {
                    _Logger.trace((Object)(this + " close P2P queue:" + this.p2pHandler));
                }
                try {
                    NpvClientHelper.getInstance().getNPVRif().destroyPtoPQueue(this.p2pHandler.getCommunicationObject());
                }
                catch (Exception re) {
                    _Logger.error((Object)"error cleaning up P to P Queue on Server", (Throwable)re);
                }
                this.p2pHandler.stop();
            }
            catch (Exception e) {
                _Logger.debug((Object)"Exception from close P2P queue", (Throwable)e);
            }
        }
        this.p2pHandler = null;
        this.timer.reset();
        this.requestId = -1L;
        this.failedSet.clear();
        if (all) {
            this.succSet.clear();
        } else {
            this.adjustComponents();
        }
        this.setState(State.Init);
    }

    public void closeTask() {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(this + " is closed and cleaned up"));
        }
        if (this.isTaskRunning()) {
            throw new IllegalStateException(this + " cannot be reset: " + this.getState().getName());
        }
        this.setState(State.Close);
        if (this.p2pHandler != null) {
            try {
                if (_Logger.isTraceEnabled()) {
                    _Logger.trace((Object)(this + " close P2P queue:" + this.p2pHandler));
                }
                try {
                    NpvClientHelper.getInstance().getNPVRif().destroyPtoPQueue(this.p2pHandler.getCommunicationObject());
                }
                catch (Exception re) {
                    _Logger.error((Object)"error cleaning up P to P Queue on Server", (Throwable)re);
                }
                this.p2pHandler.stop();
            }
            catch (Exception e) {
                _Logger.debug((Object)"Exception from close P2P queue", (Throwable)e);
            }
        }
        this.p2pHandler = null;
        this.allSet.clear();
        this.succSet.clear();
        this.failedSet.clear();
        this.timer.reset();
        this.requestId = -1L;
        this.swbList.clear();
        this.swUserList.clear();
    }

    protected abstract long sendRequest() throws Exception;

    protected abstract void adjustComponents();

    protected abstract void updateStartStatus();

    protected abstract void updateFailStatus(Exception var1);

    protected abstract void updateSwitchTaskStatus(SwitchBase var1, SwitchActionTracker.Status var2, String var3, Exception var4);

    protected abstract void updataEndStatus();

    protected abstract void updateCancelStatus();

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("[type=");
        sb.append(this.getType().getName());
        sb.append("]");
        return sb.toString();
    }

    protected void finalize() throws Throwable {
        this.closeTask();
        super.finalize();
    }

    public static enum State {
        Init("Init"),
        Running("Running"),
        End("End"),
        Close("Close");

        private String name;

        private State(String typeName) {
            this.name = typeName;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum Type {
        EnableNPV("Enabling NPV feature"),
        EnableNPIV("Enabling NPIV feature"),
        EnablePorts("Enabling all ports"),
        SetNpPorts("Setting Np ports"),
        SetFPorts("Setting F ports"),
        SetNpivPorts("Setting Npiv ports "),
        AddVSANSwitches("Adding VSAN"),
        AddVSANPorts("Adding ports to VSAN"),
        SaveConfig("Saving switch configurations"),
        VerifyAccess("Verifying switch access and authentication"),
        SetFlexAttach("Setting WWNs"),
        SetTrafficMap("Setting traffic map");

        private String name;

        private Type(String typeName) {
            this.name = typeName;
        }

        public String getName() {
            return this.name;
        }
    }
}

