/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.controller;

import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.npv.controller.AbstractAsyncSwitchTask;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.util.ArrayList;
import java.util.List;

public class SwitchActionTracker {
    public static final Status SUCCESS = Status.SUCCESS;
    public static final Status FAILED = Status.FAILED;
    public static final Status STARTED = Status.STARTED;
    public static final Status INPROGRESS = Status.INPROGRESS;
    public static final Status WARNING = Status.WARNING;
    public static final Status ERROR = Status.ERROR;
    public static final Status NA = Status.NA;
    public static final Status BLANK = Status.BLANK;
    public static final Status UNKNOW = Status.UNKNOWN;
    private SnmpUserOpt swUser;
    private Switch swTarget;
    private Status status = BLANK;
    private String message = "";
    private String result = null;
    private String content = "";
    private AbstractAsyncSwitchTask.Type type;
    private List<Exception> errors = new ArrayList<Exception>();
    private List history = new ArrayList();
    private boolean success = false;

    public SwitchActionTracker(Switch swTarget, String content, AbstractAsyncSwitchTask.Type type) {
        if (swTarget == null || content == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        this.swTarget = swTarget;
        this.content = content;
        this.type = type;
        this.swUser = swTarget.getFabric().getSnmpUserOpt();
    }

    public SwitchBase getTarget() {
        return this.swTarget.getSwitchBase();
    }

    public String getContent() {
        return this.content;
    }

    public AbstractAsyncSwitchTask.Type getType() {
        return this.type;
    }

    public void addError(Exception error) {
        this.errors.add(error);
    }

    public List<Exception> getErrors() {
        return this.errors;
    }

    public Exception getLastError() {
        if (this.hasError()) {
            return this.errors.get(this.errors.size() - 1);
        }
        return null;
    }

    public boolean hasError() {
        return this.errors.size() > 0;
    }

    public List getHistory() {
        return this.history;
    }

    public String getLongMessage() {
        return this.status.getName() + ": " + this.getMessage();
    }

    public String getMessage() {
        return this.message;
    }

    public String getShortMessage() {
        return this.status.getName();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status, String message, Exception error) {
        this.status = status;
        this.message = message == null ? "" : message;
        if (error != null) {
            this.addError(error);
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void clear() {
        this.status = Status.NA;
        this.message = "";
        this.result = null;
        this.content = "";
        if (this.errors != null) {
            this.errors.clear();
        }
        if (this.history != null) {
            this.history.clear();
        }
        this.success = false;
    }

    public Switch getSwitchTarget() {
        return this.swTarget;
    }

    public SnmpUserOpt getSwitchUser() {
        return this.swUser;
    }

    public void setSwitchUser(SnmpUserOpt swUser) {
        this.swUser = swUser;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SwitchActionTracker[");
        sb.append("target=");
        sb.append(this.swTarget);
        sb.append(", content=");
        sb.append(this.content);
        sb.append(", type=");
        sb.append((Object)this.type);
        sb.append(", status=");
        sb.append(this.getLongMessage());
        sb.append("]");
        return sb.toString();
    }

    protected void addHistory(Status status, String message, Exception error) {
        Object[] entry = new Object[]{status, message, error};
        this.history.add(entry);
    }

    protected void finalize() throws Throwable {
        this.clear();
        super.finalize();
    }

    public static enum Status {
        SUCCESS("Success"),
        FAILED("Failed"),
        STARTED("Started"),
        INPROGRESS("In progress"),
        BLANK(""),
        WARNING("Warning"),
        ERROR("Error"),
        NA("N/A"),
        UNKNOWN("Unknown");

        private String statusName;

        private Status(String name) {
            this.statusName = name;
        }

        public String getName() {
            return this.statusName;
        }

        public Status getStatus(int value) {
            if (value >= 0 && value < Status.values().length) {
                return Status.values()[value];
            }
            return NA;
        }
    }
}

