/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.controller;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpTcpConnectionException;
import com.cisco.dcbu.lib.util.TimeWatch;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.npv.controller.AbstractAsyncSwitchTask;
import com.cisco.dcbu.sm.client.npv.controller.SwitchActionTracker;
import com.cisco.dcbu.sm.client.npv.util.NpvClientHelper;
import com.cisco.dcbu.sm.client.npv.view.BulkActionTableModel;
import com.cisco.dcbu.sm.client.npv.view.ProgressPanel;
import com.cisco.dcbu.sm.common.dto.QueueResponseObject;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class VerifyAccessTask
extends AbstractAsyncSwitchTask {
    public static final Logger _Logger = Logger.getLogger(VerifyAccessTask.class);
    private ProgressPanel progress;
    private BulkActionTableModel tm;
    private Set<SwitchBase> unauthSet = new HashSet<SwitchBase>();
    private boolean hasRebootRetry = false;
    private int baseRetries;
    private int totalRetries = this.baseRetries = 7;

    public VerifyAccessTask(List<Switch> swList, BulkActionTableModel tm, ProgressPanel progress) {
        this(swList, tm, progress, false);
    }

    public VerifyAccessTask(List<Switch> swList, BulkActionTableModel tm, ProgressPanel progress, boolean hasRebootRetry) {
        if (swList == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        if (swList.size() < 1) {
            throw new IllegalArgumentException("Switch list cannot be empty");
        }
        this.type = AbstractAsyncSwitchTask.Type.VerifyAccess;
        this.progress = progress;
        this.hasRebootRetry = hasRebootRetry;
        this.tm = tm;
        for (Switch sw : swList) {
            this.allSet.add(sw.getSwitchBase());
            this.swbList.add(sw.getSwitchBase());
            this.swUserList.add(sw.getFabric().getSnmpUserOpt());
        }
    }

    @Override
    public void run() {
        TimeWatch timer = new TimeWatch();
        timer.start();
        _Logger.trace((Object)("Verify Access task started " + timer.getTimeDisplay()));
        if (this.hasRebootRetry) {
            this.totalRetries = this.baseRetries + this.swbList.size() / 5;
            for (int i = 0; i < this.totalRetries; ++i) {
                _Logger.info((Object)(String.valueOf(i + 1) + " try to verify whether the switch(es) is(are) back online and authenticated"));
                this.runOnce();
                if (this.isAllAccessible() || this.isTaskClosed()) break;
                this.resetTask(false);
            }
            for (SwitchBase swb : this.allSet) {
                if (this.succSet.contains(swb) || this.unauthSet.contains(swb)) continue;
                this.updateSwitchTaskStatus(swb, SwitchActionTracker.FAILED, "Switch is not reachable", null);
            }
        } else {
            this.runOnce();
        }
        _Logger.trace((Object)("Verify Access task stopped " + timer.getTimeDisplay()));
        timer.stop();
    }

    public void runOnce() {
        super.run();
    }

    public Set<SwitchBase> getUnauthSet() {
        return this.unauthSet;
    }

    public boolean isAllAccessible() {
        return this.isTaskEnd() && this.succSet.size() + this.unauthSet.size() >= this.allSet.size();
    }

    @Override
    protected void updateStartStatus() {
        if (this.tm != null) {
            for (SwitchBase swb : this.swbList) {
                List<SwitchActionTracker> actions = this.tm.findActionByTarget(swb);
                if (actions == null) continue;
                for (SwitchActionTracker action : actions) {
                    if (action.getType() != AbstractAsyncSwitchTask.Type.VerifyAccess) continue;
                    action.setStatus(SwitchActionTracker.STARTED, null, null);
                }
            }
        }
        if (this.progress != null) {
            this.progress.setStatus(this.type.getName());
        }
    }

    @Override
    protected void updateFailStatus(Exception error) {
    }

    @Override
    protected void updateSwitchTaskStatus(SwitchBase sw, SwitchActionTracker.Status status, String message, Exception error) {
        if (this.tm != null) {
            List<SwitchActionTracker> actions = this.tm.findActionByTarget(sw);
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)("update status ==>" + sw + ", " + message + ", " + (Object)((Object)status) + ", " + actions));
            }
            if (actions != null) {
                for (int k = 0; k < actions.size(); ++k) {
                    final SwitchActionTracker action = actions.get(k);
                    if (action.getType() != AbstractAsyncSwitchTask.Type.VerifyAccess) continue;
                    if (_Logger.isTraceEnabled()) {
                        _Logger.trace((Object)("update action==>" + action + ", " + (Object)((Object)status)));
                    }
                    if (action.getStatus() == SwitchActionTracker.SUCCESS || action.getStatus() == SwitchActionTracker.FAILED) {
                        return;
                    }
                    action.setStatus(status, message, error);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VerifyAccessTask.this.tm.updateAction(action);
                        }
                    });
                }
            }
        }
        if (this.progress != null) {
            if (status == SwitchActionTracker.INPROGRESS || status == SwitchActionTracker.WARNING) {
                this.progress.setStatus(this.type.getName() + " on switch " + sw + " is in progress");
            } else if (status == SwitchActionTracker.ERROR) {
                this.progress.setStatus(this.type.getName() + " on switch " + sw + " got error");
            } else if (status == SwitchActionTracker.FAILED) {
                this.progress.setStatus(this.type.getName() + " on switch " + sw + " failed");
            } else if (status == SwitchActionTracker.SUCCESS) {
                this.progress.setStatus(this.type.getName() + " on switch " + sw + " is successful");
                this.progress.increaseProgress();
            }
        }
        if (status == SwitchActionTracker.ERROR || status == SwitchActionTracker.FAILED) {
            this.failedSet.add(sw);
        } else if (status == SwitchActionTracker.SUCCESS) {
            this.succSet.add(sw);
        }
        if (this.succSet.size() + this.failedSet.size() >= this.swbList.size()) {
            this.setState(AbstractAsyncSwitchTask.State.End);
            if (this.p2pHandler != null) {
                try {
                    if (_Logger.isTraceEnabled()) {
                        _Logger.trace((Object)(this + " close P2P queue:" + this.p2pHandler));
                    }
                    try {
                        NpvClientHelper.getInstance().getNPVRif().destroyPtoPQueue(this.p2pHandler.getCommunicationObject());
                    }
                    catch (Exception re) {
                        _Logger.error((Object)"error cleaning up P to P Queue on Server", (Throwable)re);
                    }
                    this.p2pHandler.stop();
                }
                catch (Exception e) {
                    _Logger.debug((Object)"Exception from close P2P queue", (Throwable)e);
                }
            }
            this.p2pHandler = null;
        }
    }

    @Override
    protected void updataEndStatus() {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)("Task Succ sw==>" + this.succSet.size() + "--" + this.succSet));
            _Logger.trace((Object)("Task Failed sw==>" + this.failedSet.size() + "--" + this.failedSet));
            _Logger.trace((Object)("Task Unauthen sw==>" + this.unauthSet.size() + "--" + this.unauthSet));
            _Logger.trace((Object)("Task All Sw==>" + this.swbList.size() + "--" + this.swbList));
        }
        if (this.progress != null) {
            if (this.isTaskSuccess()) {
                this.progress.setStatus(this.type.getName() + " finished");
            } else if (this.isTaskInterrupted()) {
                this.progress.setStatus(this.type.getName() + " did not complete");
            } else if (this.isTaskFailed()) {
                this.progress.setStatus(this.type.getName() + " failed");
            }
        }
    }

    @Override
    protected void updateCancelStatus() {
        if (this.progress != null) {
            this.progress.setStatus(this.type.getName() + " cancelled");
        }
    }

    @Override
    public void resetTask(boolean all) {
        super.resetTask(all);
        if (all) {
            this.unauthSet.clear();
        }
    }

    @Override
    protected void adjustComponents() {
        ArrayList oldSwbList = new ArrayList(this.swbList);
        ArrayList oldSwUserList = new ArrayList(this.swUserList);
        this.swbList.clear();
        this.swUserList.clear();
        int i = 0;
        for (SwitchBase swb : oldSwbList) {
            if (!this.succSet.contains(swb) && !this.unauthSet.contains(swb)) {
                this.swbList.add(swb);
                this.swUserList.add(oldSwUserList.get(i));
            }
            ++i;
        }
        oldSwbList.clear();
        oldSwUserList.clear();
    }

    @Override
    protected long sendRequest() throws Exception {
        return NpvClientHelper.getInstance().authenSwitchUsersAsync(this.swbList, this.swUserList, this.p2pHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Object event) {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            _Logger.trace((Object)(this + "- onMessage: state" + this.state.getName() + ", reqId->" + this.requestId + ", queueListener->" + this + ", p2pHandler->" + this.p2pHandler + ", message->" + event));
            _Logger.trace((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        }
        VerifyAccessTask verifyAccessTask = this;
        synchronized (verifyAccessTask) {
            if (event instanceof QueueResponseObject) {
                QueueResponseObject resp = (QueueResponseObject)event;
                if (resp.getRequestId() == this.requestId && this.isTaskRunning()) {
                    SwitchBase sw = resp.getSwitchBase();
                    int result = resp.getResultValue();
                    SwitchActionTracker.Status status = SwitchActionTracker.NA;
                    String message = resp.getStatusStr();
                    Exception error = resp.getException();
                    switch (result) {
                        case 3: {
                            status = SwitchActionTracker.INPROGRESS;
                            if (message != null) break;
                            message = "In progress";
                            break;
                        }
                        case 4: {
                            status = SwitchActionTracker.ERROR;
                            if (error instanceof SnmpException && error.getMessage() != null) {
                                if (error.getMessage().indexOf("Invalid Credentials") >= 0 || error.getMessage().indexOf("Privacy unsupported for this user") >= 0) {
                                    _Logger.warn((Object)(this + " got authentication error from " + sw.getIpAddress() + " SNMP"), (Throwable)error);
                                    status = SwitchActionTracker.FAILED;
                                    this.unauthSet.add(sw);
                                    if (message == null) {
                                        message = "Switch (" + sw.getIpAddress() + ") authentication failed.";
                                    }
                                } else if (error.getMessage().indexOf("timeout") >= 0) {
                                    status = this.hasRebootRetry ? SwitchActionTracker.INPROGRESS : SwitchActionTracker.FAILED;
                                    message = "Switch is not reachable";
                                }
                            } else if (error instanceof SnmpTcpConnectionException) {
                                status = this.hasRebootRetry ? SwitchActionTracker.INPROGRESS : SwitchActionTracker.FAILED;
                                message = "Switch is not reachable";
                            }
                            if (message != null) break;
                            message = "Got error";
                            break;
                        }
                        case 1: {
                            status = SwitchActionTracker.SUCCESS;
                            if (message != null) break;
                            message = "Successful";
                            break;
                        }
                        case 2: {
                            status = SwitchActionTracker.FAILED;
                            if (message != null) break;
                            message = "Failed";
                            break;
                        }
                        case 5: {
                            status = SwitchActionTracker.UNKNOW;
                            if (message != null) break;
                            message = "Unknown";
                        }
                    }
                    if (status != SwitchActionTracker.NA) {
                        this.updateSwitchTaskStatus(sw, status, message, error);
                    }
                    this.notifyAll();
                    if (_Logger.isDebugEnabled()) {
                        _Logger.debug((Object)(this + "- onMessage: state" + this.state.getName() + ", reqId->" + this.requestId + ", queueListener->" + this + ", p2pHandler->" + this.p2pHandler + ", message->" + event + ": notifyAll"));
                    }
                } else {
                    _Logger.debug((Object)(this + "- onMessage unexpected: state" + this.state.getName() + ", reqId->" + this.requestId + ", queueListener->" + this + ", p2pHandler->" + this.p2pHandler + " received wrong response:" + event));
                }
            } else {
                _Logger.warn((Object)(this + "- onMessage unexpected: state" + this.state.getName() + ", reqId->" + this.requestId + ", queueListener->" + this + ", p2pHandler->" + this.p2pHandler + " received unexpected object (" + event.getClass() + "): " + event));
            }
        }
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(this + " process onMessage at time:" + this.timer.getTimeDisplay()));
        }
    }

    @Override
    public void closeTask() {
        super.closeTask();
        this.unauthSet.clear();
    }
}

