/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.view;

import com.cisco.dcbu.lib.ui.table.BorderCellRenderer;
import com.cisco.dcbu.sm.client.npv.controller.SwitchActionTracker;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JTable;

public class ActionTrackerRenderer
extends BorderCellRenderer {
    @Override
    public void setText(String str) {
        super.setText(str);
        this.setHorizontalAlignment(0);
        if (str != null && str.endsWith("...")) {
            this.setBorder(BorderFactory.createBevelBorder(0));
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof SwitchActionTracker) {
            SwitchActionTracker tracker = (SwitchActionTracker)value;
            if (tracker.getStatus() == SwitchActionTracker.INPROGRESS) {
                this.setBackground(Color.yellow);
                this.setText(tracker.getShortMessage() + "...");
            } else if (tracker.getStatus() == SwitchActionTracker.SUCCESS) {
                this.setText(tracker.getShortMessage());
                this.setBackground(new Color(128, 255, 128));
            } else if (tracker.getStatus() == SwitchActionTracker.FAILED || tracker.getStatus() == SwitchActionTracker.ERROR || tracker.getStatus() == SwitchActionTracker.WARNING) {
                this.setText(tracker.getShortMessage() + "...");
                this.setBackground(Color.pink);
            } else if (tracker.getStatus() == SwitchActionTracker.UNKNOW) {
                this.setBackground(table.getBackground());
                this.setText(tracker.getShortMessage() + "...");
            } else {
                this.setText(tracker.getShortMessage());
                this.setBackground(table.getBackground());
            }
        } else if (value != null) {
            String status = value.toString().toLowerCase();
            if (status.indexOf("in progress") != -1 || status.indexOf("inprogress") != -1) {
                this.setBackground(Color.yellow);
            } else if (status.indexOf("fail") != -1) {
                this.setBackground(Color.pink);
            } else {
                this.setBackground(table.getBackground());
            }
        } else {
            this.setBackground(table.getBackground());
        }
        return comp;
    }
}

