/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.view;

import com.cisco.dcbu.sm.client.npv.view.CollapseTitlePanel;
import com.cisco.dcbu.sm.client.npv.view.Collapsible;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class CollapsiblePanel
extends JPanel
implements Collapsible {
    public static final Color Title_FE_Color = UIManager.getColor("Table.focusCelForeground");
    public static final Color Title_BE_Color = UIManager.getColor("Table.focusCellBackground");
    private boolean collapsed = false;
    private CollapseTitlePanel titlePanel;
    private JComponent content;

    public CollapsiblePanel(String title) {
        this(null, title);
    }

    public CollapsiblePanel(JComponent content, String title) {
        this.content = content;
        this.setLayout(new BorderLayout(2, 2));
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.titlePanel = new CollapseTitlePanel(this, true, title);
        this.titlePanel.setTitleForeground(Title_FE_Color);
        this.titlePanel.setTitleBackground(Title_BE_Color);
        this.expand();
    }

    public void setContent(JComponent c) {
        this.content = c;
        if (this.isCollapsed()) {
            this.collapse();
        } else {
            this.expand();
        }
        this.update();
    }

    @Override
    public boolean isCollapsed() {
        return this.collapsed;
    }

    @Override
    public void expand() {
        this.titlePanel.setExpanded(true);
        this.collapsed = false;
        this.removeAll();
        this.add("North", this.titlePanel);
        if (this.content != null) {
            this.add("Center", this.content);
        }
        this.revalidate();
    }

    @Override
    public void collapse() {
        this.titlePanel.setExpanded(false);
        this.collapsed = true;
        this.removeAll();
        this.add("North", this.titlePanel);
        this.revalidate();
    }

    @Override
    public void update() {
        int width = this.getWidth();
        int height = this.getHeight();
        Rectangle rect = new Rectangle(0, 0, width, height);
        this.paintImmediately(rect);
    }

    public CollapseTitlePanel getTitlePanel() {
        return this.titlePanel;
    }
}

