/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.view;

import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.npv.view.NPVCapableNode;
import com.cisco.dcbu.sm.client.npv.view.NPVTreeNode;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NPVCapableTopNode
extends NPVTreeNode {
    public static Map<Switch, Set<Switch>> pairList = new HashMap<Switch, Set<Switch>>();
    public static Map<Switch, List<FcPortBase>> swPortList = new HashMap<Switch, List<FcPortBase>>();
    public static Map<Switch, List<FcPortBase>> coreSwPortList = new HashMap<Switch, List<FcPortBase>>();

    public synchronized void updatePortPair(Map<Switch, Set<Switch>> newPairList, Map<Switch, List<FcPortBase>> newSwPortList) {
        pairList.clear();
        swPortList.clear();
        Set<Switch> pairKeySet = newPairList.keySet();
        for (Switch key : pairKeySet) {
            Set<Switch> values = newPairList.get(key);
            HashSet<Switch> newVal = new HashSet<Switch>(values);
            pairList.put(key, newVal);
        }
        Set<Switch> portKeySet = newSwPortList.keySet();
        for (Switch key : portKeySet) {
            List<FcPortBase> values = newSwPortList.get(key);
            ArrayList<FcPortBase> newVal = new ArrayList<FcPortBase>(values);
            swPortList.put(key, newVal);
        }
        this.removeAllChildren();
        this.insertInto(swPortList);
    }

    public NPVTreeNode insertSwitchPort(Switch sw, FcPortBase port) {
        NPVCapableNode swNode = null;
        int children = this.getChildCount();
        if (children < 1) {
            ArrayList<FcPortBase> list = new ArrayList<FcPortBase>();
            list.add(port);
            swNode = new NPVCapableNode(sw, list);
            this.insert(swNode, 0);
            return swNode;
        }
        for (int i = 0; i < children; ++i) {
            swNode = (NPVCapableNode)this.getChildAt(i);
            Switch thisSw = (Switch)swNode.getUserObject();
            if (!thisSw.getPK().equals(sw.getPK())) continue;
            swNode.insertPort(port);
            return swNode;
        }
        return swNode;
    }

    public void displayCoreSwitches(Switch npvSw) {
        HashMap<Switch, List<FcPortBase>> display = new HashMap<Switch, List<FcPortBase>>();
        Set<Switch> cores = pairList.get(npvSw);
        for (Switch core : cores) {
            List<FcPortBase> ports = coreSwPortList.get(core);
            display.put(core, ports);
        }
        this.removeAllChildren();
        this.insertInto(display);
    }

    public void insertInto(Map<Switch, List<FcPortBase>> allPorts) {
        if (allPorts == null) {
            return;
        }
        this.setUserObject(allPorts);
        for (Map.Entry<Switch, List<FcPortBase>> e : allPorts.entrySet()) {
            Switch sw = e.getKey();
            List<FcPortBase> ports = e.getValue();
            if (ports == null || ports.size() == 0) continue;
            NPVCapableNode nd = new NPVCapableNode(sw, ports);
            this.add(nd);
        }
    }

    @Override
    public boolean loadChildren() {
        Map allPorts = (Map)this.getUserObject();
        if (allPorts == null) {
            return false;
        }
        for (Map.Entry e : allPorts.entrySet()) {
            Switch sw = (Switch)e.getKey();
            List ports = (List)e.getValue();
            NPVCapableNode nd = new NPVCapableNode(sw, ports);
            this.insert(nd, 0);
        }
        return false;
    }

    @Override
    public String toString() {
        return "NPV Capable Switch";
    }
}

