/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.view;

import com.cisco.dcbu.lib.ui.tree.DynamicTreeNode;
import com.cisco.dcbu.sm.client.npv.util.NpvClientHelper;
import com.cisco.dcbu.sm.client.npv.view.NPVPortNode;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public abstract class NPVTreeNode
extends DynamicTreeNode {
    protected boolean visibleAsNP = false;
    protected boolean visibleAsAvailable = true;
    protected static Comparator comparator = new Comparator(){

        public int compare(Object obj1, Object obj2) {
            NPVTreeNode node1 = (NPVTreeNode)obj1;
            NPVTreeNode node2 = (NPVTreeNode)obj2;
            Object userObject1 = node1.getUserObject();
            Object userObject2 = node2.getUserObject();
            if (node1 instanceof NPVPortNode) {
                FcPortBase port1 = (FcPortBase)userObject1;
                FcPortBase port2 = (FcPortBase)userObject2;
                return NpvClientHelper.compare(port1, port2);
            }
            return obj1.toString().compareToIgnoreCase(obj2.toString());
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }
    };

    public TreeNode getChildAt(int idx, boolean isSelectedAsNP) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("This node does not have any children");
        }
        if (isSelectedAsNP) {
            int npcIdx = idx;
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                NPVTreeNode node = (NPVTreeNode)e.nextElement();
                if (!node.isVisible()) continue;
                if (npcIdx == 0) {
                    return node;
                }
                --npcIdx;
            }
        } else {
            int index = idx;
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                NPVTreeNode node = (NPVTreeNode)e.nextElement();
                if (!node.isAvailable()) continue;
                if (index == 0) {
                    return node;
                }
                --index;
            }
        }
        throw new ArrayIndexOutOfBoundsException("Cannot find child by index " + idx);
    }

    public synchronized int getChildCount(boolean isSelectedAsNP) {
        int totalChildren = super.getChildCount();
        if (this.children == null) {
            return 0;
        }
        int childCount = 0;
        if (isSelectedAsNP) {
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                if (!((NPVTreeNode)e.nextElement()).isVisible()) continue;
                ++childCount;
            }
            return childCount;
        }
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            if (!((NPVTreeNode)e.nextElement()).isAvailable()) continue;
            ++childCount;
        }
        return childCount;
    }

    public NPVTreeNode() {
    }

    public NPVTreeNode(Object o) {
        super(o);
    }

    @Override
    public void insert(MutableTreeNode node, int i) {
        super.insert(node, i);
        Collections.sort(this.children, comparator);
    }

    public void setVisibleAsNP(boolean b) {
        this.visibleAsNP = b;
    }

    public void setChildrenAsNP(boolean b) {
        if (!this.isLeaf()) {
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements()) {
                ((NPVTreeNode)e.nextElement()).setVisibleAsNP(b);
            }
        }
    }

    public boolean isVisible() {
        return this.visibleAsNP;
    }

    public void setVisibleAsAvailable(boolean b) {
        this.visibleAsAvailable = b;
    }

    public void setChildrenAsAvailable(boolean b) {
        if (!this.isLeaf()) {
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements()) {
                ((NPVTreeNode)e.nextElement()).setVisibleAsAvailable(b);
            }
        }
    }

    public boolean isAvailable() {
        return this.visibleAsAvailable;
    }
}

