/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.view;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.npv.util.NpvClientHelper;
import com.cisco.dcbu.sm.client.npv.view.AddNpvPeerDialog;
import com.cisco.dcbu.sm.client.npv.view.CFSStaticTable;
import com.cisco.dcbu.sm.client.npv.view.CFSStaticTableModel;
import com.cisco.dcbu.sm.client.npv.view.CfsStaticPeerDtoRenderer;
import com.cisco.dcbu.sm.common.dto.CfsStaticPeerDto;
import com.cisco.dcbu.sm.common.dto.QueueResponseObject;
import com.cisco.dcbu.sm.common.event.PtoPEventFactory;
import com.cisco.dcbu.sm.common.event.PtoPEventHandler;
import com.cisco.dcbu.sm.common.event.QueueListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class NpvCFSSetup
extends JDialog
implements ActionListener,
QueueListener {
    static final String TITLE = "NPV CFS Static Peer Setup";
    static final String SET_BUTTON_TEXT = "Apply";
    static final String DYNAMIC_WARNING_REMOVE = "The peer list does not include the local ip address. \nRemoving the local ip address will remove all existing peers \nin this device and start dynamic discovery for this device.";
    static final String DYNAMIC_WARNING_ADD = "The peer list does not include the local ip address. \nSetting the peer list without adding the local ip address will add these peers \nbut will fail to change the peer discovery method to static. \nThe CFS discovery on this device will remain dynamic.";
    static final String MODIFIED_WARNING = "You have modified the currently displayed CFS Peer list for switch: ";
    static final String MODIFIED_WARNING2 = " which have not been set or is still in the process.";
    static Logger _Logger = LogManager.getLogger((String)"fms.npv");
    JButton _setBtn;
    JButton _closeBtn;
    JButton _addBtn;
    JButton _deleteBtn;
    JButton _delAllBtn;
    JComboBox _devSwitches;
    List<CfsStaticPeerDto> _retrievedCfsPeeList = new ArrayList<CfsStaticPeerDto>();
    List<Switch> _npvDevices = null;
    Switch _tablePopulatedForSwitch = null;
    Dimension _preferredSize = new Dimension(520, 500);
    CFSStaticTableModel _cfsModel = null;
    CFSStaticTable _cfsTable = null;
    PtoPEventHandler _ptopHandler = null;
    long _requestId = -1L;

    public NpvCFSSetup(JFrame parent, List<Switch> npvDevices) throws Exception {
        super(parent, TITLE + ClientController.getInstance().getDialogFabricTitlePostfix(), true);
        this._npvDevices = npvDevices;
        this.init();
        this.setSize(this._preferredSize);
        this.setLocationRelativeTo(this.getParent());
    }

    protected void init() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                NpvCFSSetup.this.onClose();
            }
        });
        this.setupPanel();
        this.populateTable();
    }

    @Override
    public Dimension getPreferredSize() {
        return this._preferredSize;
    }

    private void onClose() {
        int response;
        if (this._cfsModel.wasModified() && (response = JOptionPane.showConfirmDialog(this, MODIFIED_WARNING + this._tablePopulatedForSwitch + MODIFIED_WARNING2 + "\nIf you close now you might lose these changes.  \nDo you want to continue?", "Warning: data will be lost", 0, 2)) == 1) {
            return;
        }
        if (this._ptopHandler != null) {
            try {
                ClientController.getInstance().assertNPV().destroyPtoPQueue(this._ptopHandler.getCommunicationObject());
            }
            catch (Exception re) {
                _Logger.error((Object)"error cleaning up P to P Queue on Server", (Throwable)re);
            }
            this._ptopHandler.stop();
        }
        this.setVisible(false);
        this.dispose();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.startsWith("Ad")) {
            ArrayList<Switch> switchesToAdd = new ArrayList<Switch>();
            List<Switch> cfsSwitchList = this._cfsModel.getSwitches();
            for (Switch next : this._npvDevices) {
                if (cfsSwitchList.contains(next)) continue;
                switchesToAdd.add(next);
            }
            AddNpvPeerDialog addDialog = new AddNpvPeerDialog(this, switchesToAdd);
            addDialog.setVisible(true);
            List<Switch> addedSwitches = addDialog.getSelectedSwitches();
            ArrayList<CfsStaticPeerDto> addedInetAddresses = new ArrayList<CfsStaticPeerDto>();
            for (Switch next : addedSwitches) {
                addedInetAddresses.add(new CfsStaticPeerDto(next.getInetAddress(), -1));
            }
            this._cfsModel.addData(addedInetAddresses);
            return;
        }
        if (cmd.startsWith("D")) {
            if (cmd.startsWith("Delete A")) {
                this._cfsModel.removeAll();
                return;
            }
            if (!cmd.equals("Delete")) return;
            int[] selectedRows = this._cfsTable.getSelectedRows();
            if (selectedRows != null && selectedRows.length > 0) {
                this._cfsModel.removeSelectedData(selectedRows);
                return;
            }
            Util.errorMessage((Component)this, "There are no selected rows.");
            return;
        }
        if (cmd.startsWith("C")) {
            this.onClose();
            return;
        }
        if (cmd.startsWith("sel")) {
            if (this._cfsModel.wasModified()) {
                int response = JOptionPane.showConfirmDialog(this, MODIFIED_WARNING + this._tablePopulatedForSwitch + MODIFIED_WARNING2 + "\nIf you change the device switch selection you might lose these changes.  \nDo you want to continue with the device switch selection change?", "Warning: data will be lost", 0, 2);
                if (response == 0) {
                    this.populateTable();
                    return;
                } else {
                    this._devSwitches.removeActionListener(this);
                    this._devSwitches.setSelectedItem(this._tablePopulatedForSwitch);
                    this._devSwitches.addActionListener(this);
                }
                return;
            } else {
                this.populateTable();
            }
            return;
        }
        if (!cmd.startsWith("App")) return;
        Switch sw = (Switch)this._devSwitches.getSelectedItem();
        List<Switch> switches = this._cfsModel.getSwitches();
        if (!switches.contains(sw)) {
            boolean includesLocal = false;
            for (CfsStaticPeerDto next : this._retrievedCfsPeeList) {
                InetAddress addr = next.getAddress();
                String nextIpAddress = null;
                nextIpAddress = addr != null ? addr.getHostAddress() : "N/A";
                if (!nextIpAddress.equals(sw.getIpAddress())) continue;
                includesLocal = true;
                break;
            }
            String msg = "";
            String title = "";
            if (includesLocal) {
                msg = "The peer list does not include the local ip address. \nRemoving the local ip address will remove all existing peers \nin this device and start dynamic discovery for this device.\nDo you want to continue with the 'Apply'?";
                title = "Warning: Peer setting will change to dynamic";
            } else {
                msg = "The peer list does not include the local ip address. \nSetting the peer list without adding the local ip address will add these peers \nbut will fail to change the peer discovery method to static. \nThe CFS discovery on this device will remain dynamic.\nDo you want to continue with the 'Apply'?";
                title = "Warning: Peer CFS discovery mode will remain dynamic";
            }
            int response = JOptionPane.showConfirmDialog(this, msg, title, 0, 2);
            if (response == 1) {
                return;
            }
        }
        this._setBtn.setEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        List<CfsStaticPeerDto> peers = this._cfsModel.getPeers();
        PtoPEventFactory factory = PtoPEventFactory.getInstance();
        try {
            this._ptopHandler = factory.getPtoPHandler("jms/queue/NPV", this);
            this._requestId = ClientController.getInstance().assertNPV().setCFSStaticPeerList(sw.getSwitchBase(), sw.getFabric().getSnmpUserOpt(), peers, this._ptopHandler.getCommunicationObject());
            return;
        }
        catch (Exception ex) {
            _Logger.error((Object)("Unable to set static peer list - received error: " + ex));
            StringBuilder errmsg = new StringBuilder("Unable to set CFS Static Peer List on switch, \nrecieved an error: ");
            errmsg.append(Util.getErrorMessage(ex));
            JOptionPane.showMessageDialog(this, errmsg, "Error setting CFS Static Peer List", 0);
            this._setBtn.setEnabled(true);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void onMessage(Object msg) {
        try {
            QueueResponseObject response;
            System.out.println("NPVCFSQueueListener::  -====== onMessage, recv obj=" + msg);
            if (msg instanceof QueueResponseObject && (response = (QueueResponseObject)msg).getRequestId() == this._requestId) {
                switch (response.getResultValue()) {
                    case 4: {
                        StringBuilder errmsg = new StringBuilder("Unable to set CFS Static Peer List on switch, \nrecieved an error: ");
                        errmsg.append(Util.getErrorMessage(response.getException()));
                        this.setCursor(Cursor.getDefaultCursor());
                        JOptionPane.showMessageDialog(this, errmsg, "Error setting CFS Static Peer List", 0);
                        this._setBtn.setEnabled(true);
                        break;
                    }
                    case 2: {
                        StringBuilder errmsg = new StringBuilder("Unable to set CFS Static Peer List on switch, \nrecieved an error: ");
                        errmsg.append(response.getStatusStr());
                        this.setCursor(Cursor.getDefaultCursor());
                        JOptionPane.showMessageDialog(this, errmsg, "Error setting CFS Static Peer List", 0);
                        this._setBtn.setEnabled(true);
                        break;
                    }
                    case 1: {
                        this.populateTable();
                        this._setBtn.setEnabled(true);
                        this.setCursor(Cursor.getDefaultCursor());
                        break;
                    }
                    default: {
                        StringBuilder errmsg = new StringBuilder("Recieved unknown response from setting CFS Static Peer List, please manually verify if your CFS list was set correctly.");
                        this.setCursor(Cursor.getDefaultCursor());
                        JOptionPane.showMessageDialog(this, errmsg, "Error setting CFS Static Peer List", 0);
                        this._setBtn.setEnabled(true);
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void setPeerList(List<CfsStaticPeerDto> cfspeers, Switch sw) {
        this._tablePopulatedForSwitch = sw;
        this._cfsModel.setData(cfspeers);
    }

    private void populateTable() {
        final Switch sw = (Switch)this._devSwitches.getSelectedItem();
        Thread runner = new Thread(){

            @Override
            public void run() {
                try {
                    if (sw == null) {
                        NpvCFSSetup.this._retrievedCfsPeeList = new ArrayList<CfsStaticPeerDto>();
                    } else {
                        NpvCFSSetup.this.setCursor(Cursor.getPredefinedCursor(3));
                        NpvCFSSetup.this._retrievedCfsPeeList = ClientController.getInstance().assertNPV().getCFSStaticPeerList(sw.getSwitchBase(), sw.getFabric().getSnmpUserOpt());
                        NpvCFSSetup.this.setPeerList(NpvCFSSetup.this._retrievedCfsPeeList, sw);
                        NpvCFSSetup.this.setCursor(Cursor.getDefaultCursor());
                    }
                }
                catch (Exception ex) {
                    StringBuilder errmsg = new StringBuilder("Unable to get CFS Static Peer List from switch, \nrecieved an error: ");
                    errmsg.append(Util.getErrorMessage(ex));
                    JOptionPane.showMessageDialog(NpvCFSSetup.this, errmsg, "Error Retrieving CFS Static Peer List", 0);
                    NpvCFSSetup.this._addBtn.setEnabled(false);
                    NpvCFSSetup.this._deleteBtn.setEnabled(false);
                    NpvCFSSetup.this._delAllBtn.setEnabled(false);
                }
            }
        };
        runner.run();
    }

    private void setupPanel() {
        this.setLayout(new BorderLayout());
        JPanel mainContentPanel = new JPanel(new BorderLayout());
        mainContentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        NpvClientHelper cHelper = NpvClientHelper.getInstance();
        Vector<Switch> npvDevices = cHelper.getSwitchListAsVector(this._npvDevices);
        this._devSwitches = new JComboBox<Switch>(npvDevices);
        this._devSwitches.setActionCommand("selectDevice");
        this._devSwitches.addActionListener(this);
        this._devSwitches.setPreferredSize(new Dimension(200, 20));
        JPanel topPanel = new JPanel(new FlowLayout(0));
        GridLayout gridLayout = new GridLayout(2, 1);
        gridLayout.setVgap(5);
        JPanel compPanel = new JPanel(gridLayout);
        compPanel.add(new JLabel("NPV Device to retrieve peer list from:"));
        compPanel.add(this._devSwitches);
        topPanel.add(compPanel);
        mainContentPanel.add((Component)topPanel, "North");
        JPanel selectionPanel = new JPanel(new BorderLayout());
        selectionPanel.setBorder(BorderFactory.createEtchedBorder());
        this._cfsModel = new CFSStaticTableModel(new ArrayList<CfsStaticPeerDto>());
        this._cfsTable = new CFSStaticTable(this._cfsModel);
        this._cfsTable.setColumnWidth(new int[]{20, 20, 20});
        this._cfsTable.getTableHeader().setReorderingAllowed(true);
        this._cfsTable.setSelectionMode(2);
        CfsStaticPeerDtoRenderer cfsPeerRenderer = new CfsStaticPeerDtoRenderer();
        this._cfsTable.setDefaultRenderer(CfsStaticPeerDto.class, cfsPeerRenderer);
        JScrollPane scrollPanel = new JScrollPane(this._cfsTable);
        selectionPanel.add((Component)scrollPanel, "Center");
        JPanel localActPanel = new JPanel(new FlowLayout(0, 6, 4));
        this._addBtn = new JButton("Add...");
        this._addBtn.addActionListener(this);
        localActPanel.add(this._addBtn);
        this._deleteBtn = new JButton("Delete");
        this._deleteBtn.addActionListener(this);
        this._deleteBtn.setEnabled(true);
        localActPanel.add(this._deleteBtn);
        this._delAllBtn = new JButton("Delete All");
        this._delAllBtn.addActionListener(this);
        localActPanel.add(this._delAllBtn);
        selectionPanel.add((Component)localActPanel, "South");
        mainContentPanel.add((Component)selectionPanel, "Center");
        JPanel btnPanel = new JPanel(new FlowLayout(2));
        gridLayout = new GridLayout(1, 2);
        gridLayout.setHgap(5);
        JPanel conPanel = new JPanel(gridLayout);
        this._setBtn = new JButton(SET_BUTTON_TEXT);
        this._setBtn.addActionListener(this);
        this._closeBtn = new JButton("Close");
        this._closeBtn.addActionListener(this);
        conPanel.add(this._setBtn);
        conPanel.add(this._closeBtn);
        btnPanel.add(conPanel);
        mainContentPanel.add((Component)btnPanel, "South");
        this.add((Component)mainContentPanel, "Center");
    }
}

