/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.view;

import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.mds.PortEditorCardAttribute;
import com.cisco.dcbu.lib.mds.PortSet;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.npv.util.NpvClientHelper;
import com.cisco.dcbu.sm.common.dto.TrafficMap;
import com.cisco.dcbu.sm.common.dto.TrafficMapElement;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class TETableModel
extends SnmpTableModel {
    List<TrafficMap> map;
    List<TrafficMap> origMap;
    Map<Switch, List<Integer>> ifs;
    Set<Switch> serverIfs;
    Set<Switch> choices;
    private ArrayList<SwitchBase> pSelection = new ArrayList();
    private Set<Switch> pNpvSws = new HashSet<Switch>();
    private Map<Switch, Map> serverIfToExternalIfUsageMap;

    public TETableModel(List<TrafficMap> map, Set<Switch> serverIfs, Map<Switch, Map> serverIfToExternalIfUsageMap) {
        this.setHeaders(new String[]{"NPV Device", "Server Interface", "External Interface", "External Interface In Use"});
        this.map = map;
        this.serverIfs = serverIfs;
        this.serverIfToExternalIfUsageMap = serverIfToExternalIfUsageMap;
        this.updateTEMap(map, serverIfs, serverIfToExternalIfUsageMap);
    }

    public void setIfs(Map<Switch, List<Integer>> interfaces) {
        this.ifs = interfaces;
    }

    public void updateTEMap(List<TrafficMap> map, Set<Switch> serverIfs, Map<Switch, Map> serverIfToExternalIfUsageMap) {
        if (map == null) {
            throw new IllegalArgumentException("Traffic map cannot be null");
        }
        this.origMap = map;
        this.map.addAll(map);
        this.serverIfs = serverIfs;
        this.serverIfToExternalIfUsageMap = serverIfToExternalIfUsageMap;
        HashMap<SwitchBase, Switch> switchCache = new HashMap<SwitchBase, Switch>();
        for (Switch sw : serverIfs) {
            switchCache.put(sw.getSwitchBase(), sw);
        }
        Array<Object[]> data = this.getData();
        if (data != null) {
            int _size = data.size();
            Vector<Integer> removeList = new Vector<Integer>();
            for (int i = 0; i < _size; ++i) {
                Object[] obj = (Object[])data.elementAt(i);
                try {
                    Switch sw = (Switch)obj[Column.NpvDevice.ordinal()];
                    Switch base = (Switch)switchCache.get(sw.getBaseModelObject());
                    if (base != null) continue;
                    removeList.add(i);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            Integer[] remove = removeList.toArray(new Integer[0]);
            Arrays.sort(remove, Collections.reverseOrder());
            for (Integer idx : remove) {
                data.removeElementAt(idx);
            }
        } else {
            data = new Array<Object[]>();
            this.setData(data);
        }
        int size = map.size();
        for (int i = 0; i < size; ++i) {
            TrafficMap item = map.get(i);
            if (switchCache.get(item.getSw()) == null) continue;
            Map<Integer, TrafficMapElement> element = item.getMap();
            for (Integer key : element.keySet()) {
                Integer inUseExIf;
                if (key == null) continue;
                TrafficMapElement tm = element.get(key);
                Object[] row = new Object[Column.values().length + 1];
                if (this.pSelection.contains(item.getSw())) continue;
                SwitchBase swBase = item.getSw();
                Switch sw = (Switch)switchCache.get(swBase);
                Integer serverIf = tm.getServerPort();
                row[Column.NpvDevice.ordinal()] = switchCache.get(swBase);
                row[Column.ServerIf.ordinal()] = swBase.ifIndexToName(serverIf);
                StringBuffer xternalIfs = new StringBuffer();
                StringBuffer xternalChannels = new StringBuffer();
                for (Integer xIf : tm.getExternalPorts()) {
                    if (xIf == null) continue;
                    String portName = swBase.ifIndexToName(xIf);
                    if (portName.contains("channel")) {
                        if (xternalChannels.length() > 0) {
                            xternalChannels.append(", ");
                        }
                        xternalChannels.append(portName);
                        continue;
                    }
                    if (xternalIfs.length() > 0) {
                        xternalIfs.append(", ");
                    }
                    xternalIfs.append(portName);
                }
                try {
                    Card[] cards = sw.getCards();
                    PortEditorCardAttribute[] slotMembers = new PortEditorCardAttribute[sw.getNumSlots()];
                    for (int s = 0; s < cards.length; ++s) {
                        if (cards[s] == null || cards[s].isFex()) continue;
                        int nOfPortonCard = cards[s].getNumPorts();
                        int[] ifTypes = new int[nOfPortonCard];
                        for (int j = 0; j < nOfPortonCard; ++j) {
                            ifTypes[j] = cards[s].getIfType(j + 1);
                        }
                        slotMembers[s] = new PortEditorCardAttribute(cards[s].getType(), nOfPortonCard, ifTypes, 0, Integer.toString(cards[i].getSlotId()), cards[i].getSlotId());
                    }
                    StringBuilder portString = new StringBuilder(PortSet.parse(xternalIfs.toString(), slotMembers).toString(slotMembers));
                    if (xternalChannels.length() > 0 && portString.length() > 0) {
                        portString.append(", ");
                    }
                    portString.append(xternalChannels.toString());
                    row[Column.ExternalIf.ordinal()] = portString.toString();
                }
                catch (Exception ex) {
                    StringBuilder portString = new StringBuilder(xternalIfs.toString());
                    if (xternalChannels.length() > 0 && portString.length() > 0) {
                        portString.append(", ");
                    }
                    portString.append(xternalChannels.toString());
                    row[Column.ExternalIf.ordinal()] = portString.toString();
                }
                Map usageMap = serverIfToExternalIfUsageMap.get(sw);
                row[Column.ExternalInUse.ordinal()] = usageMap == null || usageMap.isEmpty() ? "N/A" : ((inUseExIf = (Integer)usageMap.get(serverIf)) == null ? "N/A" : swBase.ifIndexToName(inUseExIf));
                data.addElement(row);
            }
        }
        this.pSelection.clear();
        for (SwitchBase base : switchCache.keySet()) {
            this.pSelection.add(base);
        }
        this.fireTableDataChanged();
    }

    @Override
    protected void assignCellValue(Object aValue, int row, int col, Object[] values) throws Exception {
        Class c = this.getColumnClass(row, col);
        this.markUndo(row, col, aValue);
        values[col] = aValue;
    }

    public String[] getValidNPVs() {
        return new String[]{"npv1", "npv2"};
    }

    public String[] getValidServerIfs() {
        return new String[]{"npv1", "npv2"};
    }

    public void addNewRow() {
        Object[] row = new Object[Column.values().length + 1];
        Switch npv = null;
        if (this.serverIfs.size() > 0) {
            npv = this.serverIfs.iterator().next();
        }
        row[Column.NpvDevice.ordinal()] = "";
        row[Column.ServerIf.ordinal()] = "";
        row[Column.ExternalIf.ordinal()] = "";
        row[Column.ExternalInUse.ordinal()] = "N/A";
        this.getData().addElement(row);
        this.fireTableDataChanged();
    }

    public boolean isTableEmpty() {
        Array data = this.getData();
        int length = data.size();
        return length == 0;
    }

    public boolean hasEmptyCell() {
        Array data = this.getData();
        int length = data.size();
        for (int i = 0; i < length; ++i) {
            Object[] elmt = (Object[])data.elementAt(i);
            String serverIf = (String)elmt[Column.ServerIf.ordinal()];
            String externalIf = (String)elmt[Column.ExternalIf.ordinal()];
            if (serverIf == null || "".equals(serverIf.trim())) {
                return true;
            }
            if (externalIf != null && !"".equals(externalIf.trim())) continue;
            return true;
        }
        return false;
    }

    public void deleteEmptyCell() {
        ArrayList<Integer> removeList = new ArrayList<Integer>();
        Array data = this.getData();
        int length = data.size();
        for (int i = 0; i < length; ++i) {
            Object[] element = (Object[])data.elementAt(i);
            String serverIf = (String)element[Column.ServerIf.ordinal()];
            String externalIf = (String)element[Column.ExternalIf.ordinal()];
            if (serverIf == null || "".equals(serverIf.trim())) {
                removeList.add(i);
                continue;
            }
            if (externalIf != null && !"".equals(externalIf.trim())) continue;
            removeList.add(i);
        }
        Integer[] remove = removeList.toArray(new Integer[0]);
        Arrays.sort(remove, Collections.reverseOrder());
        for (Integer rm : remove) {
            data.removeElementAt(rm);
        }
        this.fireTableDataChanged();
    }

    private boolean isLoadBalancingEnabled(SwitchBase base) {
        if (this.origMap != null) {
            for (TrafficMap map : this.origMap) {
                if (!map.getSw().getPK().equals(base.getPK())) continue;
                return map.isEnableDisruptiveLoadBalance();
            }
        }
        return false;
    }

    public String getInvalidServerIf() throws Exception {
        Array _data = this.getData();
        StringBuilder invalidSIfs = new StringBuilder();
        block0: for (int i = 0; i < _data.size(); ++i) {
            Object[] data = (Object[])_data.elementAt(i);
            Switch npv = (Switch)data[Column.NpvDevice.ordinal()];
            String ifName = (String)data[Column.ServerIf.ordinal()];
            Integer[] serverFc = NpvClientHelper.findPortIfIndexes(this.ifs.get(npv), npv, ifName, false);
            if (serverFc == null || serverFc.length != 1) {
                invalidSIfs.append(ifName + "\n");
                continue;
            }
            for (int sIdx = 0; sIdx < serverFc.length; ++sIdx) {
                if (serverFc[sIdx] != 0) continue;
                invalidSIfs.append(ifName + "\n");
                continue block0;
            }
        }
        return invalidSIfs.toString();
    }

    public List<TrafficMap> getTrafficMap() throws Exception {
        Array _data = this.getData();
        HashMap<SwitchBase, TrafficMap> hashMap = new HashMap<SwitchBase, TrafficMap>();
        ArrayList<TrafficMap> trafficMap = new ArrayList<TrafficMap>();
        for (int i = 0; i < _data.size(); ++i) {
            Object[] data = (Object[])_data.elementAt(i);
            Switch npv = (Switch)data[Column.NpvDevice.ordinal()];
            String ifName = (String)data[Column.ServerIf.ordinal()];
            Integer[] serverFc = NpvClientHelper.findPortIfIndexes(this.ifs.get(npv), npv, ifName, false);
            if (serverFc == null || serverFc.length != 1) continue;
            ifName = (String)data[Column.ExternalIf.ordinal()];
            Integer[] extFc = NpvClientHelper.findPortIfIndexes(this.ifs.get(npv), npv, ifName, true);
            ArrayList<Integer> ports = new ArrayList<Integer>();
            Integer[] arr$ = extFc;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int port = arr$[i$];
                ports.add(port);
            }
            TrafficMap map = (TrafficMap)hashMap.get(npv.getSwitchBase());
            if (map == null) {
                TrafficMapElement el = new TrafficMapElement(serverFc[0], ports, 0L);
                if (this.isNewOrUpdated(npv.getSwitchBase(), el)) {
                    el.setType(1);
                    HashMap<Integer, TrafficMapElement> mapEl = new HashMap<Integer, TrafficMapElement>();
                    mapEl.put(serverFc[0], el);
                    map = new TrafficMap(npv.getSwitchBase(), mapEl, false);
                    map.setEnableDisruptiveLoadBalance(this.isLoadBalancingEnabled(npv.getSwitchBase()));
                }
            } else {
                Map<Integer, TrafficMapElement> tMap = map.getMap();
                TrafficMapElement element = tMap.get(serverFc[0]);
                if (element == null) {
                    element = new TrafficMapElement(serverFc[0], ports, 0L);
                }
                element.setExternalPorts(ports);
                if (this.isNewOrUpdated(npv.getSwitchBase(), element)) {
                    element.setType(1);
                    tMap.put(serverFc[0], element);
                }
            }
            if (map == null) continue;
            hashMap.put(npv.getSwitchBase(), map);
        }
        for (TrafficMap tm : this.map) {
            SwitchBase sw = tm.getSw();
            Map<Integer, TrafficMapElement> origElements = tm.getMap();
            boolean found = false;
            for (Switch validSw : this.serverIfs) {
                if (!validSw.getSwitchBase().equals(sw)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            for (TrafficMapElement element : origElements.values()) {
                if (!this.isDeleted(sw, element, (TrafficMap)hashMap.get(sw))) continue;
                TrafficMap setMap = (TrafficMap)hashMap.get(sw);
                Map<Integer, TrafficMapElement> deletedElementHash = null;
                if (setMap == null) {
                    deletedElementHash = new HashMap<Integer, TrafficMapElement>();
                    setMap = new TrafficMap(sw, deletedElementHash, false);
                    setMap.setEnableDisruptiveLoadBalance(this.isLoadBalancingEnabled(sw));
                } else {
                    deletedElementHash = setMap.getMap();
                }
                TrafficMapElement deletedElement = setMap.getMap().get(element.getServerPort());
                if (deletedElement == null) {
                    TrafficMapElement copyElem = element.clone();
                    copyElem.setType(3);
                    deletedElementHash.put(copyElem.getServerPort(), copyElem);
                } else {
                    deletedElement.setType(3);
                }
                hashMap.put(sw, setMap);
            }
        }
        for (SwitchBase key : hashMap.keySet()) {
            trafficMap.add((TrafficMap)hashMap.get(key));
        }
        return trafficMap;
    }

    private boolean isDeleted(SwitchBase npv, TrafficMapElement element, TrafficMap switchTrafficMap) {
        if (switchTrafficMap == null) {
            Array _data = this.getData();
            for (int i = 0; i < _data.size(); ++i) {
                Object[] data = (Object[])_data.elementAt(i);
                SwitchBase base = ((Switch)data[Column.NpvDevice.ordinal()]).getSwitchBase();
                if (!base.getPK().equals(npv.getPK())) continue;
                String fc = (String)data[Column.ServerIf.ordinal()];
                try {
                    int[] serverFc = SnmpIntList.parse(fc, base);
                    if (serverFc == null || serverFc.length != 1 || serverFc[0] != element.getServerPort()) continue;
                    return false;
                }
                catch (SnmpException se) {
                    // empty catch block
                }
            }
            for (Switch sw : this.choices) {
                if (!sw.getSwitchBase().equals(npv)) continue;
                return true;
            }
            return false;
        }
        TrafficMapElement elementInNewMap = switchTrafficMap.getMap().get(element.getServerPort());
        if (elementInNewMap == null) {
            Array _data = this.getData();
            for (int i = 0; i < _data.size(); ++i) {
                Object[] data = (Object[])_data.elementAt(i);
                SwitchBase base = ((Switch)data[Column.NpvDevice.ordinal()]).getSwitchBase();
                if (!base.getPK().equals(npv.getPK())) continue;
                String fc = (String)data[Column.ServerIf.ordinal()];
                try {
                    int[] serverFc = SnmpIntList.parse(fc, base);
                    if (serverFc == null || serverFc.length != 1 || serverFc[0] != element.getServerPort()) continue;
                    return false;
                }
                catch (SnmpException se) {
                    // empty catch block
                }
            }
            for (Switch sw : this.choices) {
                if (!sw.getSwitchBase().equals(npv)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean isNewOrUpdated(SwitchBase npv, TrafficMapElement element) {
        Iterator<TrafficMap> itr = this.map.iterator();
        TrafficMapElement existElement = null;
        while (itr.hasNext()) {
            TrafficMap tm = itr.next();
            if (!tm.getSw().equals(npv)) continue;
            existElement = tm.getMap().get(element.getServerPort());
            break;
        }
        if (existElement == null) {
            return true;
        }
        return !existElement.equals(element);
    }

    public void remove(int[] rows) {
        if (rows == null) {
            return;
        }
        Array data = this.getData();
        Arrays.sort(rows);
        for (int i = rows.length - 1; i >= 0; --i) {
            data.removeElementAt(rows[i]);
        }
        this.fireTableDataChanged();
    }

    public void removeAll() {
        Array data = this.getData();
        data.clear();
        this.fireTableDataChanged();
    }

    public void setChoices(Set<Switch> sws) {
        this.choices = sws;
    }

    public void setPreviousNpv(Set<Switch> sws) {
        this.pNpvSws.clear();
        this.pNpvSws.addAll(sws);
    }

    public Switch getFirstSwitch() {
        return this.serverIfs.iterator().next();
    }

    public Switch getSwitch(String name) {
        for (Switch sw : this.serverIfs) {
            if (!sw.getName().equals(name.trim()) && !sw.getSysName().equals(name.trim())) continue;
            return sw;
        }
        return null;
    }

    public static enum Column {
        NpvDevice,
        ServerIf,
        ExternalIf,
        ExternalInUse;

    }
}

