/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.wizard;

import com.cisco.dcbu.lib.ui.AddRemovePanel;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.script.AbstractWorker;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.npv.controller.NpvSetupWizardController;
import com.cisco.dcbu.sm.client.npv.util.NpvClientHelper;
import com.cisco.dcbu.sm.client.npv.wizard.NpvSetupWizard;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class NpvPairCreationStep
extends WizardPanel {
    public static final Logger _Logger = Logger.getLogger(NpvPairCreationStep.class);
    public static final String StepTitle = "Create NPV Device/NPIV Core Pairs";
    public static final String StepDesp = "Select an NPV device and an NPIV core to create an NPV pair.  Use the Add and Remove buttons to create and delete a pair, respectively.  Use Add Connected Pairs to automatically pair connected switches.";
    private NpvPairAddRemovePanel mp;
    private ListPanel npvDeviceList;
    private ListPanel npvCoreList;
    private KTable npvPairTable;
    private NPVPairTableModel npvPairTm;
    private List<Switch> NPVSwList = new ArrayList<Switch>();
    private List<Switch> NPVCoreSwList = new ArrayList<Switch>();

    public NpvPairCreationStep() {
        super(StepTitle, StepDesp, NpvSetupWizard.NPV_ICON);
        this.initialize();
    }

    @Override
    public boolean refresh() {
        ((NpvSetupWizard)this.getWizard()).updateStepTitle(false);
        List<Switch> newNPVSwList = ((NpvSetupWizard)this.getWizard()).getController().getNpvSelecteSwList();
        List<Switch> newCoreSwList = ((NpvSetupWizard)this.getWizard()).getController().getNpivSelectedSwList();
        Map<Switch, Set<Switch>> npvPairs = this.npvPairTm.getNPVPairs();
        if (npvPairs != null && npvPairs.size() != 0) {
            boolean changeFound = false;
            if (!newNPVSwList.containsAll(this.NPVSwList)) {
                this.NPVSwList.removeAll(newNPVSwList);
                for (Switch nextSwitch : this.NPVSwList) {
                    this.npvPairTm.removeNPVDevice(nextSwitch);
                    changeFound = true;
                }
            }
            if (!newCoreSwList.containsAll(this.NPVCoreSwList)) {
                this.NPVCoreSwList.removeAll(newCoreSwList);
                for (Switch nextSwitch : this.NPVCoreSwList) {
                    this.npvPairTm.removeCoreSwitch(nextSwitch);
                    changeFound = true;
                }
            }
            if (changeFound) {
                this.npvPairTm.fireTableDataChanged();
            }
        }
        this.NPVSwList.clear();
        this.NPVCoreSwList.clear();
        this.NPVSwList.addAll(newNPVSwList);
        this.NPVCoreSwList.addAll(newCoreSwList);
        this.npvDeviceList.setItems(newNPVSwList);
        this.npvCoreList.setItems(newCoreSwList);
        return super.refresh();
    }

    @Override
    public String getTitle() {
        return StepTitle;
    }

    @Override
    public void doNext() {
        try {
            Map<Switch, Set<Switch>> npvPairs = this.npvPairTm.getNPVPairs();
            if (npvPairs.size() > 0) {
                ArrayList<Isl> pc = NpvClientHelper.getInstance().queryPortChannelFromIsl(npvPairs);
                if (pc.size() > 0) {
                    String errorMsg = "NPV Wizard detected port channels in your topology.  \nIt is necessary to exit the wizard, remove port channels and then purge\nthem from the topology before continuing.  \n\nPort channel options can be found under Physical Attributes -> ISLs -> Port Channels.  \nPurge option can be found on the topology map right-click menu of the port channel.\n\n";
                    StringBuffer pcList = new StringBuffer();
                    for (Isl pcIsl : pc) {
                        pcList.append(pcIsl.getName() + "\n");
                    }
                    JPanel errorPanel = new JPanel(new BorderLayout());
                    JScrollPane sc = new JScrollPane(new JTextArea(pcList.toString()), 20, 30);
                    sc.setPreferredSize(new Dimension(200, 100));
                    errorPanel.add((Component)new JLabel(NpvSetupWizardController.convertToHtml(errorMsg)), "North");
                    errorPanel.add((Component)sc, "Center");
                    Util.errorMessage((Component)this.getWizard(), "ERROR", null, errorPanel);
                    return;
                }
                if (((NpvSetupWizard)this.getWizard()).getController().validateSwPairSelection(this)) {
                    ((NpvSetupWizard)this.getWizard()).getController().setNpvSwPairs(npvPairs);
                    this.setDataValid(false);
                    super.doNext();
                } else {
                    this.getWizard().getNavigator().getNextBtn().setEnabled(true);
                    this.getWizard().getNavigator().getBackBtn().setEnabled(true);
                }
            } else {
                this.getWizard().getNavigator().getNextBtn().setEnabled(true);
                this.getWizard().getNavigator().getBackBtn().setEnabled(true);
                Util.errorMessage((Component)this.getWizard(), new Exception("There are no NPV switch pairs selected."));
            }
        }
        catch (Exception e) {
            this.getWizard().getNavigator().getNextBtn().setEnabled(true);
            this.getWizard().getNavigator().getBackBtn().setEnabled(true);
            Util.errorMessage((Component)this.getWizard(), e);
        }
    }

    public KTable getNPVPairTable() {
        return this.npvPairTable;
    }

    public KTableModel getNPVPairTableModel() {
        return this.npvPairTm;
    }

    public JList getNPVDeviceList() {
        return this.npvDeviceList.getList();
    }

    public JList getNPVCoreList() {
        return this.npvCoreList.getList();
    }

    public void setNPVDeviceList(List<Switch> npvDevices) {
        this.npvDeviceList.setItems(npvDevices);
    }

    public void setNPVCoreList(List<Switch> npvCores) {
        this.npvCoreList.setItems(npvCores);
    }

    public Map<Switch, Set<Switch>> getNPVPairs() {
        return this.npvPairTm.getNPVPairs();
    }

    private void initialize() {
        this.npvDeviceList = new ListPanel("NPV Devices");
        this.npvCoreList = new ListPanel("NPIV Core Switches");
        this.npvDeviceList.getList().setSelectionMode(2);
        this.npvCoreList.getList().setSelectionMode(0);
        final JSplitPane splitPane = new JSplitPane(1, this.npvDeviceList, this.npvCoreList);
        splitPane.setDividerLocation(NpvSetupWizard.Default_Wizard_Size.width / 2);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                splitPane.setDividerLocation(0.5);
                splitPane.updateUI();
            }
        });
        this.npvPairTm = new NPVPairTableModel();
        this.npvPairTm.setHeaders(new String[]{"NPV Device", "NPIV Core Switch"});
        this.npvPairTable = new KTable(this.npvPairTm);
        this.npvPairTable.setSelectionMode(2);
        this.npvPairTable.setAutoResizeMode(4);
        this.npvPairTable.getTableHeader().addMouseListener(new HeaderListener());
        this.npvPairTable.setSortable(true);
        this.npvPairTable.addPopupMenu();
        JScrollPane sc = new JScrollPane(this.npvPairTable);
        this.mp = new NpvPairAddRemovePanel();
        this.mp.setBorder(DialogUtil._Margin);
        this.mp.buildPanel(2, splitPane, sc);
        this.add((Component)this.mp, "Center");
    }

    private void addPair() {
        List<Switch> npvDevices = this.npvDeviceList.getSelectedItems();
        List<Switch> npvCores = this.npvCoreList.getSelectedItems();
        if (npvDevices.size() < 1) {
            Util.errorMessage((Component)this, "There are no NPV devices selected.");
            return;
        }
        if (npvCores.size() < 1) {
            Util.errorMessage((Component)this, "There are no NPIV core switches selected.");
            return;
        }
        Switch npvCore = npvCores.get(0);
        for (Switch dev : npvDevices) {
            this.npvPairTm.addPair(dev, npvCore);
        }
        this.npvPairTm.fireTableDataChanged();
        this.npvDeviceList.getList().clearSelection();
        this.npvCoreList.getList().clearSelection();
    }

    private void removePair() {
        int[] rows = this.npvPairTable.getSelectedRows();
        if (rows.length < 1) {
            Util.errorMessage((Component)this, "There are no pairs selected.");
            return;
        }
        for (int i = rows.length - 1; i >= 0; --i) {
            int row = rows[i];
            this.npvPairTm.deleteRow(row);
            this.npvPairTm.fireTableRowsDeleted(row - 1, row);
        }
    }

    private void addAllConnectedPairs() {
        ((NpvSetupWizard)this.getWizard()).setCursor(true);
        this.getWizard().getNavigator().getBackBtn().setEnabled(false);
        this.getWizard().getNavigator().getNextBtn().setEnabled(false);
        AbstractWorker worker = new AbstractWorker(){

            @Override
            public Object construct() {
                return ((NpvSetupWizard)NpvPairCreationStep.this.getWizard()).getController().getConnectedPairs();
            }

            @Override
            public void finished() {
                Object ret = this.getValue();
                if (ret != null && ret instanceof List) {
                    List pairList = (List)ret;
                    for (Switch[] pair : pairList) {
                        if (pair[0] == null || pair[1] == null) continue;
                        NpvPairCreationStep.this.npvPairTm.addPair(pair[0], pair[1]);
                    }
                    NpvPairCreationStep.this.npvPairTm.fireTableDataChanged();
                }
                NpvPairCreationStep.this.getWizard().getNavigator().getBackBtn().setEnabled(true);
                NpvPairCreationStep.this.getWizard().getNavigator().getNextBtn().setEnabled(true);
                ((NpvSetupWizard)NpvPairCreationStep.this.getWizard()).setCursor(false);
            }
        };
        worker.start();
    }

    class NpvPairAddRemovePanel
    extends AddRemovePanel {
        JButton _downAllBtn;

        NpvPairAddRemovePanel() {
        }

        @Override
        public void buildPanel(int mode, JComponent comp1, JComponent comp2) {
            super.buildPanel(mode, comp1, comp2);
            if (mode == 2) {
                this._downAllBtn = new JButton("Add Connected Pairs", HeaderListener.getDownImage());
                this._downAllBtn.addActionListener(this);
                this._downAllBtn.setActionCommand("P");
                JPanel p = this.getButtonPanel();
                Component[] comps = p.getComponents();
                p.removeAll();
                p.add(this._downAllBtn);
                for (Component c : comps) {
                    p.add(c);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals("P")) {
                NpvPairCreationStep.this.addAllConnectedPairs();
            } else {
                super.actionPerformed(e);
            }
        }

        @Override
        protected void addAction() {
            NpvPairCreationStep.this.addPair();
        }

        @Override
        protected void removeAction() {
            NpvPairCreationStep.this.removePair();
        }
    }

    class NPVPairTableModel
    extends KTableModel {
        private Map<Switch, Set<Switch>> npvPairs = new HashMap<Switch, Set<Switch>>();

        public NPVPairTableModel() {
            Array pairList = new Array();
            this.setData(pairList);
        }

        public synchronized void addPair(Switch npvDevice, Switch npvCore) {
            if (this.dupPair(npvDevice, npvCore)) {
                return;
            }
            Set<Switch> coreSet = this.npvPairs.get(npvDevice);
            if (coreSet == null) {
                coreSet = new HashSet<Switch>();
                coreSet.add(npvCore);
                this.npvPairs.put(npvDevice, coreSet);
                this.getData().addElement(new Switch[]{npvDevice, npvCore});
            } else if (coreSet.add(npvCore)) {
                this.getData().addElement(new Switch[]{npvDevice, npvCore});
            }
        }

        public synchronized void removeNPVDevice(Switch npvDevice) {
            Set<Switch> coreSet = this.npvPairs.get(npvDevice);
            if (coreSet != null) {
                ArrayList<Integer> elementsToRemove = new ArrayList<Integer>();
                for (Switch nextCore : coreSet) {
                    int elementIndex = this.getData().findEquals(new Switch[]{npvDevice, nextCore});
                    if (elementIndex < 0) continue;
                    elementsToRemove.add(elementIndex);
                }
                Integer[] eToRemove = elementsToRemove.toArray(new Integer[0]);
                Arrays.sort(eToRemove, Collections.reverseOrder());
                Integer[] arr$ = eToRemove;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    int next = arr$[i$];
                    this.deleteRow(next);
                }
            }
        }

        public synchronized void removeCoreSwitch(Switch coreSwitch) {
            HashSet<Switch> npvSet = new HashSet<Switch>(this.npvPairs.keySet());
            for (Switch nextNpv : npvSet) {
                int elementIndex;
                Set<Switch> coreSet = this.npvPairs.get(nextNpv);
                if (coreSet == null || !coreSet.contains(coreSwitch) || (elementIndex = this.getData().findEquals(new Switch[]{nextNpv, coreSwitch})) < 0) continue;
                this.deleteRow(elementIndex);
            }
        }

        public synchronized void deleteRow(int row) {
            Set<Switch> coreSet;
            Switch[] pair = (Switch[])this.getData().elementAt(row);
            if (pair != null && (coreSet = this.npvPairs.get(pair[0])) != null) {
                coreSet.remove(pair[1]);
                if (coreSet.size() == 0) {
                    this.npvPairs.remove(pair[0]);
                }
            }
            this.getData().removeElementAt(row);
        }

        public boolean dupPair(Switch npvDevice, Switch npvCore) {
            Set<Switch> coreSet = this.npvPairs.get(npvDevice);
            if (coreSet != null) {
                return coreSet.contains(npvCore);
            }
            return false;
        }

        public Map<Switch, Set<Switch>> getNPVPairs() {
            return this.npvPairs;
        }

        public void clearAll() {
            this.getData().clear();
            this.npvPairs.clear();
        }
    }

    class SwitchRenderer
    extends DefaultListCellRenderer {
        SwitchRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList arg0, Object arg1, int arg2, boolean arg3, boolean arg4) {
            Component comp = super.getListCellRendererComponent((JList<?>)arg0, arg1, arg2, arg3, arg4);
            if (comp instanceof JLabel) {
                JLabel l = (JLabel)comp;
                l.setText(this.getDisplayText(arg1));
                return l;
            }
            return comp;
        }

        protected String getDisplayText(Object arg1) {
            if (arg1 instanceof Switch) {
                Switch sw = (Switch)arg1;
                if (!sw.getName().equals(String.valueOf(sw.getIpAddress()))) {
                    return sw.getName() + " (" + sw.getIpAddress() + ")";
                }
                return sw.getName();
            }
            return String.valueOf(arg1);
        }
    }

    class ListPanel
    extends JPanel {
        public JList list;

        public ListPanel(String title) {
            this.setBorder(new TitledBorder(title));
            this.setLayout(new BorderLayout());
            this.list = new JList(new DefaultListModel());
            this.list.setCellRenderer(new SwitchRenderer());
            this.list.setVisibleRowCount(8);
            JScrollPane sc = new JScrollPane(this.list);
            this.add((Component)sc, "Center");
        }

        public JList getList() {
            return this.list;
        }

        public DefaultListModel getModel() {
            return (DefaultListModel)this.list.getModel();
        }

        public void setItems(List<Switch> items) {
            DefaultListModel m = (DefaultListModel)this.list.getModel();
            m.clear();
            for (int i = 0; i < items.size(); ++i) {
                m.addElement(items.get(i));
            }
            this.list.revalidate();
        }

        public List<Switch> getSelectedItems() {
            Object[] items;
            ArrayList<Switch> swList = new ArrayList<Switch>();
            for (Object obj : items = this.list.getSelectedValues()) {
                if (!(obj instanceof Switch)) continue;
                swList.add((Switch)obj);
            }
            return swList;
        }
    }
}

