/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.wizard;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.script.AbstractWorker;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.npv.controller.NpvSetupWizardController;
import com.cisco.dcbu.sm.client.npv.view.ProgressWindow;
import com.cisco.dcbu.sm.client.npv.wizard.NpvCompleteStep;
import com.cisco.dcbu.sm.client.npv.wizard.NpvCoreSwitchSelectionStep;
import com.cisco.dcbu.sm.client.npv.wizard.NpvDeviceSelectionStep;
import com.cisco.dcbu.sm.client.npv.wizard.NpvPairCreationStep;
import com.cisco.dcbu.sm.client.npv.wizard.NpvPortsCfgStep;
import com.cisco.dcbu.sm.client.npv.wizard.VsanSelectionStep;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class NpvSetupWizard
extends JWizard {
    public static final Logger _Logger = Logger.getLogger(NpvSetupWizard.class);
    public static final String Wizard_Title = "NPV Setup Wizard";
    public static final Dimension Default_Wizard_Size = new Dimension(750, 600);
    public static final ImageIcon NPV_ICON = Util.loadIcon("icons/NPV.gif");
    public static final String Card_Step1 = "Step1";
    public static final String Card_Step2 = "Step2";
    public static final String Card_Step3 = "Step3";
    public static final String Card_Step4 = "Step4";
    public static final String Card_Step5 = "Step5";
    public static final String Card_Step6 = "Step6";
    private static NpvSetupWizard _Instance = null;
    private JFrame parent;
    private NpvSetupWizardController controller;

    public static NpvSetupWizard getInstance() {
        return _Instance;
    }

    public static synchronized NpvSetupWizard createInstance(JFrame parent) throws Exception {
        block8: {
            if (_Instance == null) {
                try {
                    _Instance = new NpvSetupWizard(parent);
                }
                catch (Exception e) {
                    if (_Instance != null) {
                        _Instance.dispose();
                        _Instance = null;
                    }
                    break block8;
                }
            }
            int option = JOptionPane.showConfirmDialog(_Instance.getFrame(), _Instance.getTitle() + " is running. \n\nDo you want to dispose the current one and open a new one?", "NPV Setup Wizard Warning", 2, 0);
            if (option == 0) {
                _Instance.dispose();
                _Instance = null;
                try {
                    _Instance = new NpvSetupWizard(parent);
                }
                catch (Exception e) {
                    if (_Instance != null) {
                        _Instance.dispose();
                        _Instance = null;
                    }
                    throw e;
                }
            }
        }
        return _Instance;
    }

    public NpvSetupWizardController getController() {
        return this.controller;
    }

    public void setCursor(boolean busy) {
        this.setCursor(Cursor.getPredefinedCursor(busy ? 3 : 0));
    }

    public JFrame getFrame() {
        return this.parent;
    }

    @Override
    public void dispose() {
        AbstractWorker worker = new AbstractWorker(){

            @Override
            public Object construct() {
                NpvSetupWizard.this.getController().clear();
                return null;
            }

            @Override
            public void finished() {
            }
        };
        worker.start();
        if (this == NpvSetupWizard.getInstance()) {
            _Instance = null;
        }
        super.dispose();
    }

    public void startModule() {
        AbstractWorker worker = new AbstractWorker(){
            ProgressWindow progressWindow = null;

            @Override
            public Object construct() {
                this.progressWindow = new ProgressWindow(NpvSetupWizard.this.getFrame(), NpvSetupWizard.Wizard_Title, "Preload NPV related data");
                this.progressWindow.setMaximum(20);
                return NpvSetupWizard.this.controller.preloadData(this.progressWindow);
            }

            @Override
            public void finished() {
                Object retObj = this.getValue();
                if (retObj instanceof Exception) {
                    Exception loadError = (Exception)retObj;
                    _Logger.warn((Object)"Got exception from preloading data:", (Throwable)loadError);
                    JOptionPane.showMessageDialog(NpvSetupWizard.this.getFrame(), loadError.getMessage() + "\nNPV Setup cannot continue.", "Error NPV Setup Wizard", 0);
                    NpvSetupWizard.this.dispose();
                } else {
                    NpvSetupWizard.this.addWizardSteps();
                    NpvSetupWizard.this.updateStepTitle(true);
                    NpvSetupWizard.this.first();
                    NpvSetupWizard.this.setVisible(true);
                }
            }
        };
        worker.start();
    }

    public void updateStepTitle(boolean isFirst) {
        WizardPanel stepPanel;
        int currStep = this.getCurrentCardIndex();
        int step = isFirst ? currStep : currStep + 1;
        int totalSteps = this.getPanelCount();
        WizardPanel wizardPanel = stepPanel = isFirst ? this.getCurrent() : this.getNext();
        if (stepPanel != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("Step ");
            sb.append(String.valueOf(step));
            sb.append(" of ");
            sb.append(String.valueOf(totalSteps));
            sb.append(" ");
            sb.append(stepPanel.getTitle());
            stepPanel.setTitle(sb.toString());
            stepPanel.revalidate();
        }
    }

    protected NpvSetupWizard(JFrame parent) {
        super(parent);
        this.parent = parent;
        this.initialize();
        this.controller = new NpvSetupWizardController(this);
    }

    protected void initialize() {
        this.setSize(Default_Wizard_Size);
        this.setTitle(Wizard_Title + ClientController.getInstance().getDialogFabricTitlePostfix());
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    NpvSetupWizard.getInstance().getCurrent().doCancel();
                }
                catch (Exception ex) {
                    _Logger.error((Object)ex.getMessage());
                }
            }
        });
    }

    protected void addWizardSteps() {
        NpvDeviceSelectionStep step1 = new NpvDeviceSelectionStep();
        step1.setDataValid(false);
        this.addPanel(Card_Step1, step1);
        NpvCoreSwitchSelectionStep step2 = new NpvCoreSwitchSelectionStep();
        step2.setDataValid(false);
        this.addPanel(Card_Step2, step2);
        NpvPairCreationStep step3 = new NpvPairCreationStep();
        step3.setDataValid(false);
        this.addPanel(Card_Step3, step3);
        NpvPortsCfgStep step4 = new NpvPortsCfgStep();
        step4.setDataValid(false);
        this.addPanel(Card_Step4, step4);
        VsanSelectionStep step5 = new VsanSelectionStep();
        step5.setDataValid(false);
        this.addPanel(Card_Step5, step5);
        NpvCompleteStep step6 = new NpvCompleteStep();
        step6.setDataValid(false);
        this.addPanel(Card_Step6, step6);
    }
}

