/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.portchnl;

import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.AbstractModelObject;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.portchnl.PChnlWizard;
import com.cisco.dcbu.sm.client.portchnl.WizIslLink;
import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class AddPortChannelPanel
extends WizardPanel {
    static final String[] _headers = new String[]{"Available FC Port Channels"};
    SnmpPeer _sw1;
    SnmpPeer _sw2;
    JTable _avlPchnl;

    public AddPortChannelPanel(JWizard wiz) {
        super("2 of 3: Select Port Channel", "", wiz, PChnlWizard._ImagePc);
        KTableModel eModel = new KTableModel();
        eModel.setHeaders(_headers);
        this._avlPchnl = new KTable(eModel);
        this._avlPchnl.setSelectionMode(0);
        JScrollPane scrPn = new JScrollPane(this._avlPchnl);
        this.add((Component)scrPn, "Center");
    }

    @Override
    public boolean refresh() {
        this._sw1 = (SnmpPeer)this.getModelValue("PEER_A");
        this._sw2 = (SnmpPeer)this.getModelValue("PEER_B");
        if (this._sw1 == null || this._sw2 == null) {
            return false;
        }
        Fabric fa = ClientController.findFabricSwitchByIpAddress(this._sw1.getAddress()).getFabric();
        Boolean npvMode = (Boolean)this.getModelValue("PCHNL_NPV_MODE");
        Array<Isl> arLst = npvMode == false ? fa.getPcIsls(ClientController.findFabricSwitchByIpAddress(this._sw1.getAddress()), ClientController.findFabricSwitchByIpAddress(this._sw2.getAddress())) : fa.getPcNpvLinks(ClientController.findFabricSwitchByIpAddress(this._sw1.getAddress()), ClientController.findFabricSwitchByIpAddress(this._sw2.getAddress()));
        Array data = new Array();
        this.buildConnectedNpvList(arLst, data);
        this.setDescription("Select channel to edit between switches " + this._sw1 + " and " + this._sw2);
        ((KTableModel)this._avlPchnl.getModel()).setData(data);
        ((KTableModel)this._avlPchnl.getModel()).fireTableDataChanged();
        if (data.size() > 0) {
            this._avlPchnl.setRowSelectionInterval(0, 0);
        }
        this.getWizard().getNavigator().getNextBtn().setEnabled(this._avlPchnl.getSelectedRowCount() > 0);
        return true;
    }

    private void buildConnectedNpvList(Array arLst, Array data) {
        boolean isNpvLink = arLst.elementAt(0) instanceof NpvLink;
        int MAXI = arLst.size();
        for (int i = 0; i < MAXI; ++i) {
            int prtTo;
            int prtFrom;
            boolean isPortChnl;
            Object[] data1 = new Object[1];
            AbstractModelObject lnk = (AbstractModelObject)arLst.elementAt(i);
            Boolean npvMode = (Boolean)this.getModelValue("PCHNL_NPV_MODE");
            boolean bl = isPortChnl = npvMode != false ? ((NpvLink)lnk).isPortChannel() : ((Isl)lnk).isPortChannel();
            if (!isPortChnl || !lnk.isPresent()) continue;
            int n = prtFrom = npvMode != false ? ((NpvLink)lnk).getFPortIfIndex() : ((Isl)lnk).getIfIndex1();
            if (-1 == prtFrom) continue;
            int n2 = prtTo = npvMode != false ? ((NpvLink)lnk).getNpPortIfIndex() : ((Isl)lnk).getIfIndex2();
            if (prtTo == -1) continue;
            data1[0] = new WizIslLink(lnk);
            data.addElement(data1);
        }
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (vis && this._avlPchnl.getRowCount() == 0) {
            this.doPrevious();
            StringBuffer bf = new StringBuffer("No existing port channels are available between ");
            bf.append(this._sw1);
            bf.append(" and ");
            bf.append(this._sw2);
            JOptionPane.showMessageDialog(this, bf.toString());
        }
    }

    @Override
    public void doNext() {
        int[] rows = this._avlPchnl.getSelectedRows();
        if (rows == null || rows.length != 1) {
            JOptionPane.showMessageDialog(this, "Please select one Port Channel", "Invalid Isl", 0);
        } else {
            Boolean npvMode = (Boolean)this.getModelValue("PCHNL_NPV_MODE");
            AbstractModelObject pcLnk = ((WizIslLink)this._avlPchnl.getValueAt((int)rows[0], (int)0))._link;
            Object ob = this.getModelValue("SEL_PCHNL");
            if (null == ob || !pcLnk.equals((AbstractModelObject)ob)) {
                this.setDataValid(false);
            }
            if (!this.isDataValid()) {
                this.setModelValue("SEL_PCHNL", pcLnk);
            }
            super.doNext();
        }
    }
}

