/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.portchnl;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpNull;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.TableAddRemovePanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.AbstractModelObject;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.portchnl.PChnlWizard;
import com.cisco.dcbu.sm.client.portchnl.SwitchPair;
import com.cisco.dcbu.sm.client.portchnl.WizIslLink;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SelectPCISL
extends WizardPanel {
    static final String[] _Labels = new String[]{"Isl List:"};
    static final String _nonForceDescription = "Converting all ISL(s) simultaneously into a port channel may be disruptive.\nNOTE: the changes may take time to appear in map.";
    static final String _autoCreateDescription = "The selected ISL will be assigned the properties of the port channel to ensure automatic addition to Port Channel.\nNOTE: the changes may take time to appear in map.";
    boolean _panelCreated;
    SnmpPeer _sw1;
    SnmpPeer _sw2;
    VarBindList _sw1Pc;
    VarBindList _sw2Pc;
    IslAddRemovePanel _islPnl;
    private JCheckBox _autoPchnl;
    Array _initialSelData;
    boolean _editMode = false;
    Array _curPchnlMems;
    AbstractModelObject _pcLnk;
    JCheckBox _rmEmptyPchnl = new JCheckBox("Delete Port Channel if Empty");
    JCheckBox _useForce = new JCheckBox("Force admin, trunk, speed, VSAN attributes to be identical", true);

    private SelectPCISL() {
        this((JWizard)null);
    }

    public SelectPCISL(JWizard wiz) {
        super("2 of 3: Select ISLs ", "", wiz, PChnlWizard._ImagePc);
        this._autoPchnl = new JCheckBox("Dynamically form Port Channel Group from selected ISLs.");
    }

    public SelectPCISL(List<AbstractModelObject> selIsls, JWizard wiz) {
        this(wiz);
        this.buildIsls(selIsls);
    }

    private boolean areIslsOfSameType(Array selIsls) {
        if (selIsls != null) {
            int type = -1;
            Boolean npvMode = (Boolean)this.getModelValue("PCHNL_NPV_MODE");
            for (int i = 0; i < selIsls.size(); ++i) {
                int prtFrom;
                Object lnkOb = selIsls.elementAt(i);
                if (lnkOb == null) continue;
                boolean isPortChnl = npvMode != false ? ((NpvLink)lnkOb).isPortChannel() : ((Isl)lnkOb).isPortChannel();
                int n = prtFrom = npvMode != false ? ((NpvLink)lnkOb).getFPortIfIndex() : ((Isl)lnkOb).getIfIndex1();
                if (isPortChnl) continue;
                if (type == -1) {
                    type = IfIndexUtil.getType(prtFrom);
                    continue;
                }
                if (type == IfIndexUtil.getType(prtFrom)) continue;
                return false;
            }
        }
        return true;
    }

    void buildIsls(List<AbstractModelObject> selIsls) {
        this._curPchnlMems = new Array();
        Array<Object[]> data = new Array<Object[]>();
        if (selIsls != null && selIsls.size() > 0) {
            Boolean npvMode = (Boolean)this.getModelValue("PCHNL_NPV_MODE");
            for (AbstractModelObject lnk : selIsls) {
                int fromType;
                int prtTo;
                if (lnk == null) continue;
                Object[] data1 = new Object[1];
                boolean isPortChnl = npvMode != false ? ((NpvLink)lnk).isPortChannel() : ((Isl)lnk).isPortChannel();
                int prtFrom = npvMode != false ? ((NpvLink)lnk).getFPortIfIndex() : ((Isl)lnk).getIfIndex1();
                int n = prtTo = npvMode != false ? ((NpvLink)lnk).getNpPortIfIndex() : ((Isl)lnk).getIfIndex2();
                if (isPortChnl || !this._editMode && !lnk.isPresent() || 0 == prtFrom || 0 == prtTo || (fromType = IfIndexUtil.getType(prtFrom)) == 4 || IfIndexUtil.getType(prtTo) == 4) continue;
                data1[0] = new WizIslLink(lnk);
                this._curPchnlMems.addElement(data1[0]);
                data.addElement(data1);
            }
        }
        this._initialSelData = data;
    }

    public void setPcIsl(AbstractModelObject pchnlIsl) {
        this._pcLnk = pchnlIsl;
        this._rmEmptyPchnl.setHorizontalAlignment(2);
        this._rmEmptyPchnl.setEnabled(false);
        this._rmEmptyPchnl.setSelected(true);
        Boolean npvMode = (Boolean)this.getModelValue("PCHNL_NPV_MODE");
        ArrayList list = npvMode != false ? (ArrayList)((NpvLink)this._pcLnk).getPCMemberLinks() : (ArrayList)((Isl)this._pcLnk).getPCMemberLinks();
        this.buildIsls(list);
        this.setTitle("3 of 3: Edit Port Channel");
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (vis && this._islPnl.getSelRows() == 0 && this._islPnl.getAvlRows() == 0) {
            this.doPrevious();
            Boolean npvMode = (Boolean)this.getModelValue("PCHNL_NPV_MODE");
            JOptionPane.showMessageDialog(this, (npvMode != null && npvMode != false ? "No NP Links" : "No ISLs") + " available between " + this._sw1 + " and " + this._sw2);
        }
    }

    @Override
    public boolean refresh() {
        this._autoPchnl.setSelected(false);
        if (this.getModelValue("PCHNL_MODE") != null) {
            this._editMode = (Integer)this.getModelValue("PCHNL_MODE") == 1;
        }
        Boolean npvMode = (Boolean)this.getModelValue("PCHNL_NPV_MODE");
        if (this._editMode) {
            AbstractModelObject pchnlIsl = (AbstractModelObject)this.getModelValue("SEL_PCHNL");
            this.setPcIsl(pchnlIsl);
            this._rmEmptyPchnl.setVisible(npvMode != false ? true : !((Isl)pchnlIsl).isAutoCreated());
            this._useForce.setVisible(npvMode != false ? true : !((Isl)pchnlIsl).isAutoCreated());
            this._autoPchnl.setSelected(npvMode == false && ((Isl)pchnlIsl).isAutoCreated());
        }
        this._sw1 = (SnmpPeer)this.getModelValue("PEER_A");
        this._sw2 = (SnmpPeer)this.getModelValue("PEER_B");
        Switch swNm1 = ClientController.findFabricSwitchByIpAddress(this._sw1.getAddress());
        Switch swNm2 = ClientController.findFabricSwitchByIpAddress(this._sw2.getAddress());
        Fabric fa = swNm1.getFabric();
        Array<Object> arLst = new Array();
        if (npvMode.booleanValue()) {
            Switch edgeSw = swNm1.isNpvEnabled() ? swNm1 : swNm2;
            List<NpvLink> npvLinks = fa.findNpvLinksByCoreSwitchPK(swNm1.isNpvEnabled() ? swNm2.getSwitchPK() : swNm1.getSwitchPK());
            for (int i = 0; i < npvLinks.size(); ++i) {
                NpvLink npLnk = npvLinks.get(i);
                if (!npLnk.getEdgeSwitch().equals(edgeSw)) continue;
                arLst.addElement(npvLinks.get(i));
            }
        } else {
            arLst = fa.findIslsBySwitches(swNm1, swNm2);
        }
        this._autoPchnl.setEnabled(!this._editMode && npvMode == false && new SwitchPair(swNm1, swNm2).supportsAutoPchnl());
        Array<Object[]> data = new Array<Object[]>();
        Array<Object[]> data2 = new Array<Object[]>();
        boolean islTypeIdentical = this.areIslsOfSameType(arLst);
        int MAXI = arLst.size();
        for (int i = 0; i < MAXI; ++i) {
            boolean isPrtChnl;
            Object[] data1 = new Object[1];
            AbstractModelObject lnk = (AbstractModelObject)arLst.elementAt(i);
            boolean bl = isPrtChnl = npvMode != false ? ((NpvLink)lnk).isPortChannel() : ((Isl)lnk).isPortChannel();
            if (isPrtChnl || !lnk.isPresent()) continue;
            int prtFrom = npvMode != false ? ((NpvLink)lnk).getFPortIfIndex() : ((Isl)lnk).getIfIndex1();
            int prtTo = npvMode != false ? ((NpvLink)lnk).getNpPortIfIndex() : ((Isl)lnk).getIfIndex2();
            int fromType = IfIndexUtil.getType(prtFrom);
            if (fromType == 4 || fromType == 30 || IfIndexUtil.getType(prtTo) == 4 || IfIndexUtil.getType(prtTo) == 14 || IfIndexUtil.getType(prtTo) == 30) continue;
            data1[0] = new WizIslLink(lnk);
            if (this._initialSelData != null) {
                boolean bSel = false;
                int MAXJ = this._initialSelData.size();
                for (int j = 0; j < MAXJ; ++j) {
                    Object[] selIniDat = (Object[])this._initialSelData.elementAt(j);
                    if (!((WizIslLink)data1[0]).equals((WizIslLink)selIniDat[0])) continue;
                    bSel = true;
                    break;
                }
                if (bSel) {
                    continue;
                }
            } else if (!islTypeIdentical && fromType == 10) {
                data2.addElement(data1);
                continue;
            }
            if (data.size() >= 16) {
                data2.addElement(data1);
                continue;
            }
            data.addElement(data1);
        }
        try {
            Array<Object[]> autoData = new Array<Object[]>();
            autoData.append(data);
            if (this._initialSelData != null) {
                autoData.append(this._initialSelData);
            }
            this.updateIslLinks(autoData);
        }
        catch (SnmpException ex) {
            this.doPrevious();
            Util.errorMessage((Component)this.getWizard(), ex.getMessage());
            return false;
        }
        StringBuffer bf = new StringBuffer();
        if (this._editMode) {
            bf.append("Add or remove ISLs from ");
            bf.append(this._sw1 + " " + (npvMode != false ? ((NpvLink)this._pcLnk).getFPortIfname() : ((Isl)this._pcLnk).getIfIndex1Name()));
            bf.append(" and ");
            bf.append(this._sw2 + " " + (npvMode != false ? ((NpvLink)this._pcLnk).getNpPortIfname() : ((Isl)this._pcLnk).getIfIndex2Name()) + ". ");
            bf.append(npvMode == false && ((Isl)this._pcLnk).isAutoCreated() ? _autoCreateDescription : _nonForceDescription);
        } else {
            bf.append("Select one or more ISLs/Links to create a new Channel between " + this._sw1 + " and " + this._sw2 + ".");
        }
        this.setDescription(bf.toString());
        if (!this._panelCreated) {
            JPanel pnl = new JPanel(new BorderLayout());
            this._islPnl = new IslAddRemovePanel(data, this);
            if (this._editMode) {
                JComponent[] cmp = new JComponent[]{this._rmEmptyPchnl, this._useForce};
                JComponent[] lbl = new JComponent[2];
                JPanel chkpnl = new JPanel(new BorderLayout());
                JPanel inPnl = DialogUtil.buildPanel(lbl, cmp);
                chkpnl.add((Component)inPnl, "West");
                pnl.add((Component)chkpnl, "South");
            }
            JPanel autoPnl = new JPanel(new BorderLayout());
            autoPnl.add((Component)this._islPnl, "Center");
            autoPnl.add((Component)this._autoPchnl, "South");
            pnl.add((Component)autoPnl, "Center");
            this.add((Component)pnl, "Center");
            this._panelCreated = true;
        } else {
            this._islPnl.setAvlModelData(data);
        }
        if (null != this._initialSelData) {
            this._islPnl.setResModelData(this._initialSelData);
            this._initialSelData = null;
        } else {
            this._islPnl.setAvlModelData(data2.size() == 0 ? new Array<Object[]>() : data2);
            this._islPnl.setResModelData(data);
        }
        if (this._islPnl.getAvlRows() > 0 && this._islPnl.getSelRows() == 0) {
            this._islPnl.setAvlSelected(0);
        }
        this.getWizard().getNavigator().getNextBtn().setEnabled(this._islPnl.getSelectedMembers().size() > 0);
        return true;
    }

    private void updateIslLinks(Array data) throws SnmpException {
        if (data != null && data.size() > 0) {
            WizIslLink isl = (WizIslLink)((Object[])data.elementAt(0))[0];
            Switch sw1 = isl.getSwitch1();
            Switch sw2 = isl.getSwitch2();
            VarBindList vbL1 = new VarBindList();
            VarBindList vbL2 = new VarBindList();
            for (int k = 0; k < data.size(); ++k) {
                WizIslLink wizIsl = (WizIslLink)((Object[])data.elementAt(k))[0];
                vbL1.add(MibNode.get("portChannelGrpIfAutoCreation").getOid(), wizIsl.getIfIndex1());
                vbL2.add(MibNode.get("portChannelGrpIfAutoCreation").getOid(), wizIsl.getIfIndex2());
            }
            SnmpPeer peer1 = this.getSwitchPeer(sw1);
            SnmpPeer peer2 = this.getSwitchPeer(sw2);
            SnmpPDU[] pdu = new SnmpAggregrate().get(new SnmpPeer[]{peer1, peer2}, new VarBindList[]{vbL1, vbL2});
            SnmpPDU pdu1 = null;
            SnmpPDU pdu2 = null;
            if (pdu[0].getAddress().equals(peer1.getAddress())) {
                pdu1 = pdu[0];
                pdu2 = pdu[1];
            } else {
                pdu1 = pdu[1];
                pdu2 = pdu[0];
            }
            VarBindList vbl1 = pdu1.getVariables();
            VarBindList vbl2 = pdu2.getVariables();
            for (int k = 0; k < data.size(); ++k) {
                WizIslLink wizIsl = (WizIslLink)((Object[])data.elementAt(k))[0];
                if (vbl1 != null) {
                    boolean bl = wizIsl._autoPChnl1 = vbl1.intValue(k) == 1;
                }
                if (vbl2 == null) continue;
                wizIsl._autoPChnl2 = vbl2.intValue(k) == 1;
            }
        }
    }

    private SnmpPeer getSwitchPeer(Switch sw) throws SnmpException {
        if (sw.getPeer() == null) {
            throw new SnmpException("Switch " + sw + " is not manageble.");
        }
        return sw.getPeer();
    }

    void validateIsl() throws SnmpException {
        this.populatePortchlList();
        Array selMem = this._islPnl.getSelectedMembers();
        boolean flag = false;
        int MAXSL = selMem.size();
        for (int sl = 0; sl < MAXSL; ++sl) {
            int i;
            int MAX;
            int[] oid;
            int[] prtLstInt;
            byte[] prtList;
            SnmpVarBind vb;
            int pc;
            Switch swA;
            Object[] selDat = (Object[])selMem.elementAt(sl);
            WizIslLink lk = (WizIslLink)selDat[0];
            if (sl == 0 && (swA = lk.getSwitch1()).getPeer().getAddress().equals(this._sw1.getAddress())) {
                flag = true;
            }
            if (this._editMode) {
                boolean validateLnk = true;
                int MAXEPC = this._curPchnlMems.size();
                for (int epc = 0; epc < MAXEPC; ++epc) {
                    WizIslLink inilk = (WizIslLink)this._curPchnlMems.elementAt(epc);
                    if (!inilk.equals((WizIslLink)selDat[0])) continue;
                    validateLnk = false;
                    break;
                }
                if (!validateLnk) continue;
            }
            int srcPrt = lk.getIfIndex1();
            int prtTo = lk.getIfIndex2();
            if (!flag) {
                int temp = srcPrt;
                srcPrt = prtTo;
                prtTo = temp;
            }
            int MAXPC = this._sw1Pc.size();
            for (pc = 0; pc < MAXPC; ++pc) {
                vb = this._sw1Pc.getVb(pc);
                prtList = ((SnmpString)vb.getVar()).getValue();
                prtLstInt = SnmpIntList.valueOf(prtList);
                oid = vb.getOid().getValue();
                MAX = prtLstInt.length;
                for (i = 0; i < MAX; ++i) {
                    if (prtLstInt[i] != srcPrt) continue;
                    throw new SnmpException("The port " + this._sw1 + ":" + IfIndexUtil.ifIndexToName(prtLstInt[i]) + " is already a member of a port channel. (channel" + oid[oid.length - 1] + ")");
                }
            }
            MAXPC = this._sw2Pc.size();
            for (pc = 0; pc < MAXPC; ++pc) {
                vb = this._sw2Pc.getVb(pc);
                prtList = ((SnmpString)vb.getVar()).getValue();
                prtLstInt = SnmpIntList.valueOf(prtList);
                oid = vb.getOid().getValue();
                MAX = prtLstInt.length;
                for (i = 0; i < MAX; ++i) {
                    if (prtLstInt[i] != prtTo) continue;
                    throw new SnmpException("The port " + this._sw2 + ":" + IfIndexUtil.ifIndexToName(prtLstInt[i]) + " is already a member of a port channel. (channel" + oid[oid.length - 1] + ")");
                }
            }
        }
    }

    void populatePortchlList() throws SnmpException {
        VarBindList vbl = new VarBindList();
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("portChannelMemberList").getOid())));
        this._sw1Pc = SnmpFetch.getBulk(this._sw1, vbl).getVariables();
        this._sw2Pc = SnmpFetch.getBulk(this._sw2, vbl).getVariables();
        this.setModelValue("EXISTING_PCHNL_SW1", this._sw1Pc);
        this.setModelValue("EXISTING_PCHNL_SW2", this._sw2Pc);
    }

    @Override
    public void doNext() {
        block8: {
            Array selMem = this._islPnl.getSelectedMembers();
            if (this._autoPchnl.isSelected() && selMem.size() < 2) {
                Util.errorMessage((Component)this.getWizard(), "To create dynamic Port Channel please select at least 2 ISLs.");
                return;
            }
            if (selMem.size() > 16) {
                Util.errorMessage((Component)this.getWizard(), "A maximum of 16 ISLs can be added to a port channel.");
                return;
            }
            this.setModelValue("AVAILABLE_LINKS", this._islPnl.getAvailableMembers());
            if (selMem.size() == 0) {
                Util.errorMessage((Component)this, "Please select at least one ISL");
            } else {
                try {
                    this.validateIsl();
                    Boolean autoPchnl = (Boolean)this.getModelValue("DYNAMIC_PCHNL");
                    if (autoPchnl != Boolean.valueOf(this._autoPchnl.isSelected()) || this.isDirty(selMem)) {
                        this.setDataValid(false);
                    }
                    this.setModelValue("ISL_LINKS", selMem);
                    this.setModelValue("DYNAMIC_PCHNL", this._autoPchnl.isSelected());
                    super.doNext();
                }
                catch (SnmpException ex) {
                    Util.errorMessage((Component)this, ex);
                    if (!SnmpSession.isTrace()) break block8;
                    DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        if (this.getModelValue("DYNAMIC_PCHNL") != Boolean.valueOf(this._autoPchnl.isSelected())) {
            this.setDataValid(false);
        }
    }

    boolean isDirty(Array selMem) {
        Object ob = this.getModelValue("ISL_LINKS");
        if (null == ob) {
            return true;
        }
        Array selIsls = (Array)ob;
        if (selIsls.size() != selMem.size()) {
            return true;
        }
        int MAXI = selIsls.size();
        for (int i = 0; i < MAXI; ++i) {
            Object[] selDat = (Object[])selIsls.elementAt(i);
            WizIslLink lk = (WizIslLink)selDat[0];
            int prtFrom = lk.getIfIndex1();
            int prtTo = lk.getIfIndex2();
            int MAXJ = selMem.size();
            for (int j = 0; j < MAXJ; ++j) {
                Object[] selCm = (Object[])selMem.elementAt(i);
                WizIslLink lkCm = (WizIslLink)selCm[0];
                int prtFromCmp = lkCm.getIfIndex1();
                int prtToCmp = lkCm.getIfIndex2();
                if (prtFrom == prtFromCmp && prtTo == prtToCmp) continue;
                return true;
            }
        }
        return false;
    }

    boolean isEditPchnlIslMemChanged(Array selMem) {
        if (selMem.size() == this._curPchnlMems.size()) {
            boolean diffList = false;
            int MAXMEM = selMem.size();
            for (int mem = 0; mem < MAXMEM; ++mem) {
                Object[] selDat = (Object[])selMem.elementAt(mem);
                WizIslLink selLnk = (WizIslLink)selDat[0];
                diffList = true;
                int MAXMEMREF = this._curPchnlMems.size();
                for (int memRef = 0; memRef < MAXMEMREF; ++memRef) {
                    WizIslLink refLnk = (WizIslLink)this._curPchnlMems.elementAt(memRef);
                    if (!selLnk.equals(refLnk)) continue;
                    diffList = false;
                    break;
                }
                if (!diffList) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    @Override
    public void doFinish() {
        block22: {
            if (!this._editMode) {
                super.doFinish();
            }
            Array selMem = this._islPnl.getSelectedMembers();
            try {
                int i;
                int i2;
                int pcPortTo;
                if (selMem.size() > 0) {
                    if (selMem.size() > 16) {
                        Util.errorMessage((Component)this.getWizard(), "A maximum of 16 ISLs can be added to a port channel.");
                        return;
                    }
                    this.validateIsl();
                }
                if (!this.isEditPchnlIslMemChanged(selMem)) {
                    JOptionPane.showMessageDialog(this, "The port channel membership is not changed.");
                    return;
                }
                if (JOptionPane.showConfirmDialog(this.getWizard(), "Modification of a port channel may be disruptive.\nDo you want to continue?", this.getWizard().getTitle(), 0, 2) != 0) {
                    return;
                }
                Array<Integer> fromPortsLst = new Array<Integer>();
                Array<Integer> toPortsLst = new Array<Integer>();
                SnmpPeer swSrc = this._sw1;
                SnmpPeer swDes = this._sw2;
                Array<Integer> fromPorts = fromPortsLst;
                Array<Integer> toPorts = toPortsLst;
                boolean flag = false;
                for (int i3 = 0; i3 < selMem.size(); ++i3) {
                    Object[] selDat = (Object[])selMem.elementAt(i3);
                    WizIslLink lk = (WizIslLink)selDat[0];
                    if (i3 == 0) {
                        Switch swA = lk.getSwitch1();
                        if (!swA.getPeer().getAddress().equals(swSrc.getAddress())) {
                            swDes = this._sw1;
                            swSrc = this._sw2;
                            fromPorts = toPortsLst;
                            toPorts = fromPortsLst;
                        } else {
                            flag = true;
                        }
                    }
                    int prtFrom = lk.getIfIndex1();
                    int prtTo = lk.getIfIndex2();
                    if (flag) {
                        fromPortsLst.addElement(new Integer(prtFrom));
                        toPortsLst.addElement(new Integer(prtTo));
                        continue;
                    }
                    toPortsLst.addElement(new Integer(prtFrom));
                    fromPortsLst.addElement(new Integer(prtTo));
                }
                Boolean npvMode = (Boolean)this.getModelValue("PCHNL_NPV_MODE");
                Switch swtchSrc = npvMode != false ? ((NpvLink)this._pcLnk).getCoreSwitch() : ((Isl)this._pcLnk).getSwitch1();
                int pcPortFrom = npvMode != false ? ((NpvLink)this._pcLnk).getFPortIfIndex() : ((Isl)this._pcLnk).getIfIndex1();
                int n = pcPortTo = npvMode != false ? ((NpvLink)this._pcLnk).getNpPortIfIndex() : ((Isl)this._pcLnk).getIfIndex2();
                if (!swtchSrc.getPeer().getAddress().equals(swSrc.getAddress())) {
                    int tempPrt = pcPortFrom;
                    pcPortFrom = pcPortTo;
                    pcPortTo = tempPrt;
                }
                int[] memLst = null;
                int[] curMemLst = null;
                memLst = new int[fromPorts.size()];
                curMemLst = new int[this._curPchnlMems.size()];
                for (i2 = 0; i2 < fromPorts.size(); ++i2) {
                    memLst[i2] = (Integer)fromPorts.elementAt(i2);
                }
                for (i2 = 0; i2 < this._curPchnlMems.size(); ++i2) {
                    curMemLst[i2] = ((WizIslLink)this._curPchnlMems.elementAt(i2)).getIfIndex1();
                }
                VarBindList vbl1 = new VarBindList();
                VarBindList vbl2 = new VarBindList();
                VarBindList vblAutoCr1 = new VarBindList();
                VarBindList vblAutoCr2 = new VarBindList();
                if (!npvMode.booleanValue() && ((Isl)this._pcLnk).isAutoCreated()) {
                    Array nonSelectedIsl = this._islPnl.getAvailableMembers();
                    PChnlWizard.buidAutoPcModeVbl(nonSelectedIsl, vblAutoCr1, vblAutoCr2, false);
                }
                this.shut413Ports(swSrc, memLst, curMemLst);
                this.buildModifyPchnlVbl(swSrc, vbl1, vblAutoCr1, pcPortFrom, memLst, curMemLst, ClientController.findFabricSwitchByIpAddress(this._sw1.getAddress()));
                memLst = new int[toPorts.size()];
                int MAXI = toPorts.size();
                for (i = 0; i < MAXI; ++i) {
                    memLst[i] = (Integer)toPorts.elementAt(i);
                }
                for (i = 0; i < this._curPchnlMems.size(); ++i) {
                    curMemLst[i] = ((WizIslLink)this._curPchnlMems.elementAt(i)).getIfIndex2();
                }
                this.shut413Ports(swDes, memLst, curMemLst);
                this.buildModifyPchnlVbl(swDes, vbl2, vblAutoCr2, pcPortTo, memLst, curMemLst, ClientController.findFabricSwitchByIpAddress(this._sw2.getAddress()));
                if (vbl1.size() > 0) {
                    PChnlWizard.handleSnmpSetFragError(this._sw1, vbl1);
                }
                if (vbl2.size() > 0) {
                    PChnlWizard.handleSnmpSetFragError(this._sw2, vbl2);
                }
                if (vblAutoCr1.size() > 0) {
                    PChnlWizard.handleSnmpSetFragError(this._sw1, vblAutoCr1);
                }
                if (vblAutoCr2.size() > 0) {
                    PChnlWizard.handleSnmpSetFragError(this._sw2, vblAutoCr2);
                }
                super.doCancel();
            }
            catch (SnmpException ex) {
                Util.errorMessage((Component)this, ex);
                if (!SnmpSession.isTrace()) break block22;
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void shut413Ports(SnmpPeer peer, int[] memLst, int[] curMemLst) throws SnmpException {
        VarBindList vbl = new VarBindList();
        Switch swNm = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        Boolean npvMode = (Boolean)this.getModelValue("PCHNL_NPV_MODE");
        if (swNm.isVersionGreaterThanEqual("4.1(3)")) {
            int[] adminOid = MibNode.get("ifAdminStatus").getOid();
            if (curMemLst != null) {
                for (int j = 0; j < curMemLst.length; ++j) {
                    if (memLst == null) continue;
                    boolean removed = true;
                    int MAX = memLst.length;
                    for (int i = 0; i < MAX; ++i) {
                        if (memLst[i] != curMemLst[j]) continue;
                        removed = false;
                        break;
                    }
                    if (!removed) continue;
                    vbl.add(adminOid, curMemLst[j], (SnmpVar)new SnmpInt(2));
                }
            }
        }
        if (vbl.size() > 0) {
            PChnlWizard.handleSnmpSetFragError(peer, vbl);
        }
    }

    private void buildModifyPchnlVbl(SnmpPeer peer, VarBindList vbl, VarBindList vblAutoCr, int pchIfIndex, int[] memLst, int[] curMemLst, Switch sww) throws SnmpException {
        Boolean npvMode = (Boolean)this.getModelValue("PCHNL_NPV_MODE");
        if (!npvMode.booleanValue() && ((Isl)this._pcLnk).isAutoCreated()) {
            this.buildModifyAutoPchnlVbl(peer, vbl, vblAutoCr, pchIfIndex, memLst, curMemLst);
        } else {
            this.buildModifyStaticPchnlVbl(peer, vbl, pchIfIndex, memLst, sww);
        }
    }

    private void buildModifyAutoPchnlVbl(SnmpPeer peer, VarBindList vbl, VarBindList vblAutoCr, int chIfIndex, int[] memLst, int[] curMemLst) throws SnmpException {
        VarBindList vbl2 = new VarBindList();
        if (memLst.length > 0) {
            vbl2.add(MibNode.get("vsanIfVsan").getOid(), chIfIndex);
            vbl2.add(MibNode.get("fcIfAdminTrunkMode").getOid(), chIfIndex);
            vbl2.add(MibNode.get("fcIfAdminSpeed").getOid(), chIfIndex);
            vbl2.add(MibNode.get("fcIfAllowedVsanList2k").getOid(), chIfIndex);
            vbl2.add(MibNode.get("fcIfAllowedVsanList4k").getOid(), chIfIndex);
            vbl2.add(MibNode.get("fcIfAdminMode").getOid(), chIfIndex);
            VarBindList vblRes = peer.send(new SnmpPDU(-96, vbl2)).getVariables();
            for (int i = 0; i < memLst.length; ++i) {
                boolean inPchnl = false;
                if (curMemLst != null) {
                    for (int k = 0; k < curMemLst.length; ++k) {
                        if (curMemLst[k] != memLst[i]) continue;
                        inPchnl = true;
                        break;
                    }
                }
                if (inPchnl) continue;
                vbl.add(MibNode.get("vsanIfVsan").getOid(), memLst[i], vblRes.getVb(0).getVar());
                vbl.add(MibNode.get("fcIfAdminTrunkMode").getOid(), memLst[i], vblRes.getVb(1).getVar());
                if (IfIndexUtil.getType(memLst[i]) != 10) {
                    vbl.add(MibNode.get("fcIfAdminSpeed").getOid(), memLst[i], vblRes.getVb(2).getVar());
                }
                vbl.add(MibNode.get("fcIfAllowedVsanList2k").getOid(), memLst[i], vblRes.getVb(3).getVar());
                vbl.add(MibNode.get("fcIfAllowedVsanList4k").getOid(), memLst[i], vblRes.getVb(4).getVar());
                vbl.add(MibNode.get("fcIfAdminMode").getOid(), memLst[i], vblRes.getVb(5).getVar());
                vblAutoCr.add(MibNode.get("portChannelGrpIfAutoCreation").getOid(), memLst[i], (SnmpVar)new SnmpInt(1));
            }
        }
    }

    void buildModifyStaticPchnlVbl(SnmpPeer peer, VarBindList vbl, int pchIfIndex, int[] memLst, Switch sww) throws SnmpException {
        boolean isVer20OrHigher = sww.isVersionGreaterThanEqual("2.0(0)");
        boolean isVersionLessThanEqualTo411 = sww.isVersionLessThanEqual("4.1(1)");
        int prtChnl = pchIfIndex - 0x4000000 + 1;
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        pdu.addNull(new SnmpOID(MibNode.get("portChannelMemberList").getOid(), prtChnl));
        SnmpPDU resp = peer.send(pdu);
        SnmpVar theVar = resp.getVar(0);
        int[] prtLstInt = null;
        if (theVar instanceof SnmpNull) {
            return;
        }
        byte[] prtList = ((SnmpString)theVar).getValue();
        prtLstInt = SnmpIntList.valueOf(prtList);
        byte[] memLstByte = SnmpIntList.valueOf(memLst);
        int[] adminOid = MibNode.get("ifAdminStatus").getOid();
        if (memLst.length == 0 && this._rmEmptyPchnl.isSelected()) {
            vbl.add(MibNode.get("portChannelRowStatus").getOid(), prtChnl, (SnmpVar)new SnmpInt(6));
        } else {
            if (isVer20OrHigher && isVersionLessThanEqualTo411) {
                int[] autoMode = MibNode.get("portChannelGrpIfAutoCreation").getOid();
                int MAX = memLst.length;
                for (int i = 0; i < MAX; ++i) {
                    vbl.add(autoMode, memLst[i], (SnmpVar)new SnmpInt(2));
                }
            }
            int mode = this._useForce.isSelected() ? 2 : 1;
            vbl.add(MibNode.get("portChannelAddType").getOid(), prtChnl, (SnmpVar)new SnmpInt(mode));
            vbl.add(MibNode.get("portChannelMemberList").getOid(), prtChnl, (SnmpVar)new SnmpString(memLstByte));
            if (isVer20OrHigher) {
                VarBindList vblPch = new VarBindList();
                vblPch.add(MibNode.get("portChannelExtChannelGrpMode").getOid(), prtChnl);
                int curPrtChnlGrpMode = SnmpFetch.get(peer, vblPch).getVariables().intValue(0);
                vbl.add(MibNode.get("portChannelExtChannelGrpMode").getOid(), prtChnl, (SnmpVar)new SnmpInt(curPrtChnlGrpMode != 1 ? 2 : 1));
            }
        }
        int MAX = memLst.length;
        for (int i = 0; i < MAX; ++i) {
            vbl.add(adminOid, memLst[i], (SnmpVar)new SnmpInt(1));
        }
        Array<Integer> rmPrtLst = new Array<Integer>();
        int MAX2 = prtLstInt.length;
        for (int i = 0; i < MAX2; ++i) {
            boolean handled = false;
            int MAXMEM = memLst.length;
            for (int mem = 0; mem < MAXMEM; ++mem) {
                if (prtLstInt[i] != memLst[mem]) continue;
                handled = true;
                break;
            }
            if (handled) continue;
            vbl.add(adminOid, prtLstInt[i], (SnmpVar)new SnmpInt(1));
            rmPrtLst.addElement(new Integer(prtLstInt[i]));
        }
    }

    class IslAddRemovePanel
    extends TableAddRemovePanel {
        SelectPCISL _pnl;

        public IslAddRemovePanel(Array data1, SelectPCISL pnl) {
            this._pnl = pnl;
            ((KTableModel)this._eTable.getModel()).setData(data1);
            this.buildPanel(1);
        }

        void setSelectionMode(int mode) {
            this._eTable.setSelectionMode(mode);
            if (!SelectPCISL.this._editMode) {
                this._resultTable.setSelectionMode(mode);
            }
        }

        void setAvlSelected(int row) {
            this._eTable.setRowSelectionInterval(row, row);
        }

        void setResSelected(int row) {
            this._resultTable.setRowSelectionInterval(row, row);
        }

        @Override
        public void setHeaders() {
            String[] headers = new String[]{""};
            this._headers = headers;
        }

        @Override
        public void removeAction() {
            super.removeAction();
            if (SelectPCISL.this._editMode) {
                SelectPCISL.this._rmEmptyPchnl.setEnabled(this._resultTable.getRowCount() == 0);
                this._pnl.getWizard().getNavigator().getNextBtn().setEnabled(this._pnl.isEditPchnlIslMemChanged(this.getSelectedMembers()));
            } else {
                this._pnl.getWizard().getNavigator().getNextBtn().setEnabled(this._resultTable.getRowCount() > 0);
            }
        }

        @Override
        public void addAction() {
            super.addAction();
            if (SelectPCISL.this._editMode) {
                SelectPCISL.this._rmEmptyPchnl.setEnabled(this._resultTable.getRowCount() == 0);
                this._pnl.getWizard().getNavigator().getNextBtn().setEnabled(this._pnl.isEditPchnlIslMemChanged(this.getSelectedMembers()));
            } else {
                this._pnl.getWizard().getNavigator().getNextBtn().setEnabled(this._resultTable.getRowCount() > 0);
            }
        }

        public int getAvlRows() {
            return this._eTable.getRowCount();
        }

        public int getSelRows() {
            return this._resultTable.getRowCount();
        }
    }
}

