/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.pref;

import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.SwitchNode;
import com.cisco.dcbu.sm.client.map.actions.ExpandLoopMapAction;
import com.cisco.dcbu.sm.client.map.actions.ExpandMultipleLinksMapAction;
import com.cisco.dcbu.sm.client.map.actions.LayoutAction;
import com.cisco.dcbu.sm.client.map.actions.OverViewMapAction;
import com.cisco.dcbu.sm.client.map.actions.ShowEndDeviceLabelsMapAction;
import com.cisco.dcbu.sm.client.map.actions.ShowEndDevicesMapAction;
import com.cisco.dcbu.sm.client.map.actions.ShowNpvSwitchesMapAction;
import com.cisco.dcbu.sm.client.pref.PrefSm;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PrefSMMap
extends PrefSm {
    static final int NON_VSAN_DEVICES = 0;
    static final int NON_GROUP_DEVICES = 1;
    static final int DISPLAY_END_DEVICES = 2;
    static final int DISPLAY_NODE_LABELS = 3;
    static final int EXPAND_LOOPS = 4;
    static final int EXPAND_MULTI_LINKS = 5;
    static final int SELECT_DEVLINK_INMAP_FRM_TABLE = 6;
    static final int PERFORM_LAYOUT_ON_NEW = 7;
    static final int QUICK_LAYOUT_NODE_COUNT = 8;
    static final int OVERRIDE_PREFERENCES = 9;
    static final int AUTOMATICALLY_SAVE_LAYOUT = 10;
    static final int DETACH_OVERVIEW = 11;
    static final int DISPLAY_SWITCH_DOMAIN_ID = 12;
    static final int DISPLAY_SWITCH_DOMAIN_ID_CHOICE = 13;
    static final int SHOW_MINOR_ALARMS_ON_LINKS = 14;
    static final int USE_KUBRICK_ICONS = 15;
    static final int MAP_NODE_LIMIT = 16;
    static final int DISPLAY_NPV_SWITCHES = 17;
    static final int NEXT_GUI_ITEM = 18;
    JCheckBox _switchDomainIDCheckBox;
    RadioButtonPanel _switchDomainIDChoice;
    FieldPanel _mapNodeLimitPanel;
    FieldPanel _quickLayoutNodeCount;

    public PrefSMMap() {
        String[] labels = new String[18];
        this._values = new JComponent[labels.length];
        this._values[0] = new JCheckBox("Display Unselected VSAN Members");
        this._values[1] = new JCheckBox("Display Unselected Group Members");
        this._values[2] = new JCheckBox("Display End Devices");
        this._values[3] = new JCheckBox("Display End Device Labels");
        this._values[4] = new JCheckBox("Expand Loops");
        this._values[5] = new JCheckBox("Expand Multiple Links");
        this._values[6] = new JCheckBox("Select Switch or Link from Table");
        this._values[7] = new JCheckBox("Layout New Devices Automatically");
        this._values[8] = this.buildQuickLayoutNodePanel();
        this._values[9] = new JCheckBox("Override Preferences for Non-default Layout");
        this._values[10] = new JCheckBox("Automatically Save Layout");
        this._values[11] = new JCheckBox("Detach Overview Window");
        this._switchDomainIDCheckBox = this.createCheckBox("Show Switch Domain ID as:", SwitchNode.getDisplayDomainIdAs() > 0);
        this._values[12] = this._switchDomainIDCheckBox;
        this._values[13] = new JPanel(new FlowLayout(0, 2, 0));
        this._values[13].add(new JLabel("       "));
        this._switchDomainIDChoice = new RadioButtonPanel(new String[]{"Hex", "Decimal"});
        this._values[13].add(this._switchDomainIDChoice);
        this._switchDomainIDChoice.setSelected(0, SwitchNode.getDisplayDomainIdAs() == 1);
        this._switchDomainIDChoice.setEnabled(SwitchNode.getDisplayDomainIdAs() > 0);
        this._values[14] = new JCheckBox("Show Link Minor Alarms as Orange X");
        this._values[15] = new JCheckBox("Use Kubrick Icons");
        this._values[16] = this.buildMapNodeLimitPanel();
        this._values[17] = new JCheckBox("Display NPV Switches");
        DialogUtil.buildPanel(this, DialogUtil.buildLabels(labels), this._values);
        this.loadValues();
    }

    JCheckBox createCheckBox(String label, boolean enable) {
        JCheckBox cb = new JCheckBox(label, enable);
        cb.addActionListener(this);
        return cb;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        char ch = e.getActionCommand().charAt(0);
        if (e.getSource() == this._switchDomainIDCheckBox) {
            this._switchDomainIDChoice.setEnabled(this._switchDomainIDCheckBox.isSelected());
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    protected void loadValues() {
        ((JCheckBox)this._values[2]).setSelected(SmMap.isDisplayEndDevices());
        ((JCheckBox)this._values[3]).setSelected(SmMap.isDisplayNodeLabels());
        ((JCheckBox)this._values[0]).setSelected(SmMap.getDimNodeDisplayPolicy() == 1);
        ((JCheckBox)this._values[1]).setSelected(SmMap.getGroupDimNodeDisplayPolicy() == 1);
        ((JCheckBox)this._values[4]).setSelected(!SmMap.isClassLoopsCollapsed());
        ((JCheckBox)this._values[5]).setSelected(!SmMap.isClassMultiLinksCollapsed());
        ((JCheckBox)this._values[6]).setSelected(DataView._SelectMapFrmTable);
        ((JCheckBox)this._values[7]).setSelected(SmMap.isLayoutNewDevices());
        this._quickLayoutNodeCount.setText(Integer.toString(LayoutAction.getQuickLayoutNodeCount()));
        ((JCheckBox)this._values[9]).setSelected(SmMap.isOverridePreferences());
        ((JCheckBox)this._values[10]).setSelected(SmMap.isAutoSaveLayout());
        ((JCheckBox)this._values[11]).setSelected(OverViewMapAction.getInstance().isDetached());
        ((JCheckBox)this._values[12]).setSelected(SwitchNode.getDisplayDomainIdAs() > 0);
        this._switchDomainIDChoice.setSelected(0, SwitchNode.getDisplayDomainIdAs() == 1);
        this._switchDomainIDChoice.setSelected(1, SwitchNode.getDisplayDomainIdAs() == 2);
        this._switchDomainIDChoice.setEnabled(SwitchNode.getDisplayDomainIdAs() > 0);
        ((JCheckBox)this._values[14]).setSelected(SmMap.isDisplayMinorAlarmsOnLinks());
        ((JCheckBox)this._values[15]).setSelected(SmMap.isClassUseKubrickIcons());
        this._mapNodeLimitPanel.setText(Integer.toString(SmMap.getMapNodeLimit()));
        ((JCheckBox)this._values[17]).setSelected(SmMap.isClassDisplayNpvSwitches());
    }

    @Override
    protected void updateValue() throws NumberFormatException {
        if (((JCheckBox)this._values[0]).isSelected()) {
            SmMap.setDimNodeDisplayPolicy(1);
        } else {
            SmMap.setDimNodeDisplayPolicy(2);
        }
        if (((JCheckBox)this._values[1]).isSelected()) {
            SmMap.setGroupDimNodeDisplayPolicy(1);
        } else {
            SmMap.setGroupDimNodeDisplayPolicy(2);
        }
        ShowEndDevicesMapAction.displayEndDevices(true, ((JCheckBox)this._values[2]).isSelected());
        ShowEndDeviceLabelsMapAction.displayEndDeviceLabels(true, ((JCheckBox)this._values[3]).isSelected(), false);
        ExpandLoopMapAction.getInstance().expandLoops(true, ((JCheckBox)this._values[4]).isSelected(), false);
        ExpandMultipleLinksMapAction.getInstance().expandMultipleLinks(true, ((JCheckBox)this._values[5]).isSelected(), false);
        DataView._SelectMapFrmTable = ((JCheckBox)this._values[6]).isSelected();
        SmMap.setLayoutNewDevices(((JCheckBox)this._values[7]).isSelected());
        LayoutAction.setQuickLayoutNodeCount(this._quickLayoutNodeCount.getInt());
        SmMap.setOverridePreferences(((JCheckBox)this._values[9]).isSelected());
        SmMap.setAutoSaveLayout(((JCheckBox)this._values[10]).isSelected());
        SmMap.setOverViewDetached(((JCheckBox)this._values[11]).isSelected());
        if (this._switchDomainIDCheckBox.isSelected()) {
            SmMap.setDisplayDomainIdAsD(this._switchDomainIDChoice.getSelected() + 1);
        } else {
            SmMap.setDisplayDomainIdAsD(0);
        }
        SmMap.setDisplayMinorAlarmsOnLinks(((JCheckBox)this._values[14]).isSelected(), false);
        SmMap.setClassUseKubrickIcons(((JCheckBox)this._values[15]).isSelected(), false);
        SmMap.setMapNodeLimit(this._mapNodeLimitPanel.getInt());
        ShowNpvSwitchesMapAction.displayNpvSwitches(true, ((JCheckBox)this._values[17]).isSelected());
        SmMap.RepaintAll();
    }

    protected JPanel buildMapNodeLimitPanel() {
        JPanel p = new JPanel(new FlowLayout(0, 0, 0));
        JLabel l = new JLabel("Limit Map to ");
        this._mapNodeLimitPanel = new FieldPanel(5, (JComponent)new JLabel("Nodes (200-300)"));
        p.add(l);
        p.add(this._mapNodeLimitPanel);
        return p;
    }

    protected JPanel buildQuickLayoutNodePanel() {
        JPanel p = new JPanel(new FlowLayout(0, 0, 0));
        JLabel l = new JLabel("Use Quick Layout when Switch has >=");
        this._quickLayoutNodeCount = new FieldPanel(5, (JComponent)new JLabel("End Devices"));
        p.add(l);
        p.add(this._quickLayoutNodeCount);
        return p;
    }
}

