/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.qos;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EnforcedZone;
import com.cisco.dcbu.sm.client.model.EnforcedZoneMember;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.qos.ClassMapMatchStmt;
import com.cisco.dcbu.sm.client.qos.DataObject;
import com.cisco.dcbu.sm.client.qos.PolicyMapExistObject;
import com.cisco.dcbu.sm.client.qos.QoSSnmp;
import com.cisco.dcbu.sm.client.qos.QoSStatement;
import com.cisco.dcbu.sm.client.qos.QosConfigWizard;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class QoS
implements Runnable {
    public static final int SUCCESS = 1;
    public static final int FAIL = 2;
    public static final int ONLY_MODIFY = 3;
    protected static final String GOLD_CLASSMAP = "ClassMapAF1-VSAN";
    protected static final String SILVER_CLASSMAP = "ClassMapAF2-VSAN";
    public static final int SNMP_TRUE = 1;
    public static final int SNMP_FALSE = 2;
    public static final String MIN_QOS_VERSION = "1.3";
    public static final String ERROR_SNMP_EXCEPTION = "Snmp Exception: ";
    private final boolean DEBUG = false;
    DataObject _dObject = null;
    QosConfigWizard _wiz;
    Object _lockObject;
    int _vsanId;
    ArrayList _priority1Endports;
    ArrayList _priority2Endports;
    String _policyName = null;
    Fabric _fabric;
    ArrayList _swList = null;

    public void startAction() {
        Thread thr = new Thread(this);
        thr.start();
    }

    boolean modify(ArrayList priority1Endports, ArrayList priority2Endports) throws SnmpException {
        int pmElementIndex;
        int[] newOid;
        SnmpPDU pdu;
        ClassMapMatchStmt cms;
        int k;
        int j;
        DataObject dObject;
        String key;
        QoSStatement stmt;
        int i;
        HashMap policyExistsMap = this._wiz._review._policyExistsMap;
        ArrayList<String> deleteList = new ArrayList<String>();
        QoSSnmp qosSnmp = new QoSSnmp();
        boolean found = false;
        for (i = 0; i < priority1Endports.size(); ++i) {
            found = false;
            stmt = (QoSStatement)priority1Endports.get(i);
            key = null;
            key = stmt.getInitPort() != null && stmt.getTargetPort() != null ? stmt.getInitPort().getPortWwn() + ":" + stmt.getTargetPort().getPortWwn() : (stmt.getInitPort() == null && stmt.getTargetPort() == null ? stmt.getInitWWN() + ":" + stmt.getTargetWWN() : (stmt.getInitPort() == null ? stmt.getInitWWN() + ":" + stmt.getTargetPort().getPortWwn().toString() : stmt.getInitPort().getPortWwn().toString() + ":" + stmt.getTargetWWN()));
            dObject = (DataObject)policyExistsMap.get(key);
            if (dObject != null) {
                for (j = 0; j < dObject.pMapObject.length; ++j) {
                    if (dObject.pMapObject[j] == null || dObject.pMapObject[j].policyMapId == 0) continue;
                    for (k = 0; k < dObject.pMapObject[j].classMapMatchStmtList.size(); ++k) {
                        cms = (ClassMapMatchStmt)dObject.pMapObject[j].classMapMatchStmtList.get(k);
                        if (!cms.key.equals(key)) continue;
                        if (cms.priority != 2) {
                            pdu = new SnmpPDU(-93, new VarBindList());
                            if (cms.priorityIndex[0] != 0 && cms.priorityIndex[1] != 0) {
                                pdu.addVar(new SnmpVarBind(new SnmpOID(MibNode.get("diffServClfrElementStatus").getOid(), cms.priorityIndex), new SnmpInt(6)));
                                dObject.pMapObject[j].switchObject.getPeer().set(pdu);
                                pdu.reset();
                            } else {
                                qosSnmp.setSwitch(dObject.pMapObject[j].switchObject);
                                newOid = new int[qosSnmp.diffServClfrElementStatusOid.length + 1];
                                System.arraycopy(qosSnmp.diffServClfrElementStatusOid, 0, newOid, 0, qosSnmp.diffServClfrElementStatusOid.length);
                                newOid[newOid.length - 1] = dObject.pMapObject[j].policyMapId;
                                pmElementIndex = qosSnmp.getNextIndex1(newOid, QoSSnmp.MAX_POLICYMAP_CLASSMAP, false);
                                cms.priorityIndex[0] = dObject.pMapObject[j].policyMapId;
                                cms.priorityIndex[1] = pmElementIndex;
                            }
                            pdu.addVar(new SnmpVarBind(new SnmpOID(MibNode.get("diffServClfrElementStatus").getOid(), cms.priorityIndex), new SnmpInt(4)));
                            pdu.addVar(new SnmpVarBind(new SnmpOID(MibNode.get("diffServClfrElementSpecific").getOid(), cms.priorityIndex), new SnmpOID(MibNode.get("cdsmFCMultiFieldClfrStatus").getOid(), cms.classMapId)));
                            pdu.addVar(new SnmpVarBind(new SnmpOID(MibNode.get("diffServClfrElementNext").getOid(), cms.priorityIndex), QoSSnmp.getDscpOid(QoSSnmp.DSCPAF1)));
                            dObject.pMapObject[j].switchObject.getPeer().set(pdu);
                            found = true;
                            continue;
                        }
                        found = true;
                    }
                    if (found) break;
                }
            }
            if (!found) continue;
            deleteList.add(Integer.toString(i));
        }
        for (i = deleteList.size() - 1; i >= 0; --i) {
            priority1Endports.remove(Integer.parseInt((String)deleteList.get(i)));
        }
        deleteList.clear();
        for (i = 0; i < priority2Endports.size(); ++i) {
            found = false;
            stmt = (QoSStatement)priority2Endports.get(i);
            key = null;
            key = stmt.getInitPort() != null && stmt.getTargetPort() != null ? stmt.getInitPort().getPortWwn() + ":" + stmt.getTargetPort().getPortWwn() : (stmt.getInitPort() == null && stmt.getTargetPort() == null ? stmt.getInitWWN() + ":" + stmt.getTargetWWN() : (stmt.getInitPort() == null ? stmt.getInitWWN() + ":" + stmt.getTargetPort().getPortWwn().toString() : stmt.getInitPort().getPortWwn().toString() + ":" + stmt.getTargetWWN()));
            dObject = (DataObject)policyExistsMap.get(key);
            if (dObject == null) continue;
            for (j = 0; j < dObject.pMapObject.length; ++j) {
                if (dObject.pMapObject[j] == null || dObject.pMapObject[j].policyMapId == 0) continue;
                for (k = 0; k < dObject.pMapObject[j].classMapMatchStmtList.size(); ++k) {
                    cms = (ClassMapMatchStmt)dObject.pMapObject[j].classMapMatchStmtList.get(k);
                    if (!cms.key.equals(key)) continue;
                    if (cms.priority != 1) {
                        pdu = new SnmpPDU(-93, new VarBindList());
                        if (cms.priorityIndex[0] != 0 && cms.priorityIndex[1] != 0) {
                            pdu.addVar(new SnmpVarBind(new SnmpOID(MibNode.get("diffServClfrElementStatus").getOid(), cms.priorityIndex), new SnmpInt(6)));
                            dObject.pMapObject[j].switchObject.getPeer().set(pdu);
                            pdu.reset();
                        } else {
                            qosSnmp.setSwitch(dObject.pMapObject[j].switchObject);
                            newOid = new int[qosSnmp.diffServClfrElementStatusOid.length + 1];
                            System.arraycopy(qosSnmp.diffServClfrElementStatusOid, 0, newOid, 0, qosSnmp.diffServClfrElementStatusOid.length);
                            newOid[newOid.length - 1] = dObject.pMapObject[j].policyMapId;
                            pmElementIndex = qosSnmp.getNextIndex1(newOid, QoSSnmp.MAX_POLICYMAP_CLASSMAP, false);
                            cms.priorityIndex[0] = dObject.pMapObject[j].policyMapId;
                            cms.priorityIndex[1] = pmElementIndex;
                        }
                        pdu.addVar(new SnmpVarBind(new SnmpOID(MibNode.get("diffServClfrElementStatus").getOid(), cms.priorityIndex), new SnmpInt(4)));
                        pdu.addVar(new SnmpVarBind(new SnmpOID(MibNode.get("diffServClfrElementSpecific").getOid(), cms.priorityIndex), new SnmpOID(MibNode.get("cdsmFCMultiFieldClfrStatus").getOid(), cms.classMapId)));
                        pdu.addVar(new SnmpVarBind(new SnmpOID(MibNode.get("diffServClfrElementNext").getOid(), cms.priorityIndex), QoSSnmp.getDscpOid(QoSSnmp.DSCPAF2)));
                        dObject.pMapObject[j].switchObject.getPeer().set(pdu);
                        found = true;
                        continue;
                    }
                    found = true;
                }
                if (found) break;
            }
            if (!found) continue;
            deleteList.add(Integer.toString(i));
        }
        for (i = deleteList.size() - 1; i >= 0; --i) {
            if (deleteList.get(i) == null) continue;
            priority2Endports.remove(Integer.parseInt((String)deleteList.get(i)));
        }
        priority1Endports.trimToSize();
        priority2Endports.trimToSize();
        return priority1Endports.size() > 0 || priority2Endports.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int build(int vsanId, ArrayList priority1Endports, ArrayList priority2Endports, QosConfigWizard wiz, Object lockObject, DataObject dObject, int removListSize) throws SnmpException {
        try {
            boolean newExists;
            this._vsanId = vsanId;
            this._priority1Endports = priority1Endports;
            this._priority2Endports = priority2Endports;
            this._lockObject = lockObject;
            this._wiz = wiz;
            this._dObject = dObject;
            if (this._priority1Endports != null && this._priority1Endports.size() == 0 && this._priority2Endports != null && this._priority2Endports.size() == 0) {
                if (removListSize == 0) {
                    throw new SnmpException(" There is nothing to configure since all items have  \"low\" priority. Please read help text in the first step.");
                }
                return 3;
            }
            if (this._dObject.pMapObject.length > 0 && !(newExists = this.modify(priority1Endports, priority2Endports))) {
                return 3;
            }
            int priority1Size = this._priority1Endports.size();
            for (int i = 0; i < priority1Size; ++i) {
                QoSStatement stmt = (QoSStatement)this._priority1Endports.get(i);
                QoSStatement newStmt = new QoSStatement(stmt.getTargetPort(), stmt.getInitPort());
                this._priority1Endports.add(newStmt);
            }
            int priority2Size = this._priority2Endports.size();
            for (int i = 0; i < priority2Size; ++i) {
                QoSStatement stmt = (QoSStatement)this._priority2Endports.get(i);
                QoSStatement newStmt = new QoSStatement(stmt.getTargetPort(), stmt.getInitPort());
                this._priority2Endports.add(newStmt);
            }
            this._wiz.setStatus("QoS Configuration - started ");
            this.startAction();
            return 1;
        }
        catch (Exception e) {
            DefaultLogger._ExLogger.warn((Object)e.getMessage(), (Throwable)e);
            Object object = this._lockObject;
            synchronized (object) {
                this._lockObject.notifyAll();
            }
            throw new SnmpException(e.getMessage());
        }
    }

    public void performInconsistencyCheck() {
    }

    public void validateQoS(int vsanId, QoSSnmp qsnmp) throws SnmpException {
        try {
            this._fabric = ClientController.getInstance().getFabric();
            Vsan vsanObject = this._fabric.findVsanById(vsanId);
            Switch[] swListTemp = vsanObject.getSwitches();
            if (swListTemp != null && swListTemp.length > 0) {
                for (int i = 0; i < swListTemp.length; ++i) {
                    Switch sw = swListTemp[i];
                    if (!sw.isVersionGreaterThanEqual("1.3(0)") || !sw.isMDS() || sw.isNpvEnabled() || sw.isN5K()) continue;
                    qsnmp.setSwitch(sw);
                    qsnmp.checkAndEnableQoS();
                    this._swList.add(sw);
                }
            }
        }
        catch (Exception e) {
            this.printDbg("validateQoS", e.getMessage());
            SnmpException snex = new SnmpException(e.getMessage());
            throw snex;
        }
    }

    public void createClassMapController(QoSSnmp qsnmp, int vsanId) throws SnmpException {
        try {
            String classMapName1 = GOLD_CLASSMAP + vsanId;
            String classMapName2 = SILVER_CLASSMAP + vsanId;
            int[] cmIndexGold = qsnmp.createClassMapHeader(this._priority1Endports, classMapName1, 1, vsanId, true);
            int[] cmIndexSilver = qsnmp.createClassMapHeader(this._priority2Endports, classMapName2, 1, vsanId, false);
            qsnmp.createClassMapStatement(this._priority1Endports, cmIndexGold);
            qsnmp.createClassMapStatement(this._priority2Endports, cmIndexSilver);
        }
        catch (SnmpException sne) {
            this.printStatusMsg("Snmp Exception: in creating ClassMaps");
            throw sne;
        }
        catch (Exception e) {
            DefaultLogger._ExLogger.warn((Object)e.getMessage(), (Throwable)e);
            this.printDbg("createClassMapController()", "Error - exception");
            SnmpException snex = new SnmpException(e.getMessage());
            throw snex;
        }
    }

    public void createPolicyMapController(QoSSnmp qsnmp, int vsanId, Switch sw) throws SnmpException {
        try {
            String policyMapName1 = "";
            int pmIndex = 0;
            policyMapName1 = this._policyName == null ? "PolicyMap-VSAN" + vsanId : this._policyName;
            for (int i = 0; i < this._dObject.pMapObject.length; ++i) {
                if (this._dObject.pMapObject[i] == null || this._dObject.pMapObject[i].switchObject == null || !this._dObject.pMapObject[i].switchObject.equals(sw)) continue;
                pmIndex = this._dObject.pMapObject[i].policyMapId;
                qsnmp._policyMapOid = new SnmpOID(MibNode.get("diffServClfrStatus").getOid(), pmIndex);
                break;
            }
            if (pmIndex == 0) {
                pmIndex = qsnmp.createPolicyMapHeader(policyMapName1);
            }
            if (pmIndex == 0) {
                throw new SnmpException("Policy Map Index is zero");
            }
            qsnmp.assocPolicyMapVsan(vsanId, pmIndex);
            qsnmp.assocPolicyMapToClassMap(pmIndex, QoSSnmp.DSCPAF1, true);
            qsnmp.assocPolicyMapToClassMap(pmIndex, QoSSnmp.DSCPAF2, false);
        }
        catch (SnmpException sne) {
            this.printStatusMsg("Snmp Exception: in creating PolicyMaps");
            throw sne;
        }
        catch (Exception e) {
            DefaultLogger._ExLogger.warn((Object)e.getMessage(), (Throwable)e);
            this.printDbg("createClassMapController()", "Error - exception");
            SnmpException snex = new SnmpException(e.getMessage());
            throw snex;
        }
    }

    private Vsan[] getFabricVsans() {
        HashMap<String, Vsan> vsans = new HashMap<String, Vsan>();
        Switch[] switches = ClientController.getInstance().getSelectedDomain().getSwitches();
        for (int i = 0; i < switches.length; ++i) {
            if (switches[i].isN5K()) continue;
            Vsan[] vsanInSwitch = switches[i].getVsans();
            for (int j = 0; j < vsanInSwitch.length; ++j) {
                vsans.put(Integer.toString(vsanInSwitch[j].getId()), vsanInSwitch[j]);
            }
        }
        ArrayList vsanList = new ArrayList(vsans.values());
        return vsanList.toArray(new Vsan[vsanList.size()]);
    }

    public HashMap getVsans() throws Exception {
        int i;
        HashMap<Vsan, DataObject> map = new HashMap<Vsan, DataObject>();
        HashMap<String, String> vsanmap = new HashMap<String, String>();
        Vsan[] vsans = this.getFabricVsans();
        Switch[] switches = ClientController.getInstance().getSelectedDomain().getSwitches();
        VarBindList vbList = new VarBindList();
        SnmpOID interestOid = new SnmpOID(MibNode.get("cdsmDataPathClfrStart").getOid());
        vbList.add(new SnmpVarBind(interestOid));
        for (i = 0; i < switches.length; ++i) {
            SnmpPDU respPDU;
            Switch sw = switches[i];
            if (!sw.isMDS() || !sw.isVersionGreaterThanEqual("1.3(0)") || !sw.isManageable() || sw.getPeer() == null || (respPDU = SnmpFetch.getBulk(sw.getPeer(), vbList)).getVariables().size() == 0) continue;
            VarBindList vbRespList = respPDU.getVariables();
            for (int k = 0; k < vbRespList.size(); ++k) {
                SnmpVarBind vb = vbRespList.getVb(k);
                int[] oidArr = vb.getOid().getValue();
                int thisVsan = oidArr[oidArr.length - 2];
                int[] policyMapRowPtr = ((SnmpOID)vb.getVar()).getValue();
                if (policyMapRowPtr.length <= 0 || policyMapRowPtr[policyMapRowPtr.length - 1] <= 0) continue;
                Vsan vsanObject = null;
                for (int vsanIdInt = 0; vsanIdInt < vsans.length; ++vsanIdInt) {
                    if (vsans[vsanIdInt].getId() != thisVsan) continue;
                    vsanObject = vsans[vsanIdInt];
                    break;
                }
                if (vsanObject == null) continue;
                DataObject myObject = (DataObject)map.get(vsanObject);
                if (myObject == null) {
                    DataObject dObject = new DataObject();
                    dObject.vsan = vsanObject;
                    Switch[] sws = vsanObject.getSwitches();
                    dObject.pMapObject = new PolicyMapExistObject[sws == null ? 1 : sws.length];
                    dObject.pMapObject[0] = new PolicyMapExistObject();
                    dObject.pMapObject[0].switchObject = sw;
                    dObject.pMapObject[0].policyMapId = policyMapRowPtr[policyMapRowPtr.length - 1];
                    map.put(vsanObject, dObject);
                } else {
                    int freeInt = 0;
                    for (int dObjInt = 0; dObjInt < myObject.pMapObject.length; ++dObjInt) {
                        if (myObject.pMapObject[dObjInt] != null) continue;
                        freeInt = dObjInt;
                        break;
                    }
                    myObject.pMapObject[freeInt] = new PolicyMapExistObject();
                    myObject.pMapObject[freeInt].switchObject = sw;
                    myObject.pMapObject[freeInt].policyMapId = policyMapRowPtr[policyMapRowPtr.length - 1];
                    map.put(vsanObject, myObject);
                }
                vsanmap.put(Integer.toString(thisVsan), Integer.toString(thisVsan));
            }
        }
        for (i = 0; i < vsans.length; ++i) {
            DataObject dObject = (DataObject)map.get(vsans[i]);
            if (dObject == null) {
                dObject = new DataObject();
                dObject.vsan = vsans[i];
            }
            map.put(vsans[i], dObject);
        }
        return map;
    }

    void add(Vsan vsanElement, HashMap map) throws Exception {
        EnforcedZone[] ez = vsanElement.getEnforcedZones();
        boolean exists = false;
        if (ez != null) {
            for (int i = 0; i < ez.length; ++i) {
                if (ez[i] == null || ez[i].getMembers().size() <= 0) continue;
                boolean atleastOneHostexists = false;
                boolean atleastOneTargetexists = false;
                for (int j = 0; j < ez[i].getMembers().size(); ++j) {
                    EnforcedZoneMember ezm = (EnforcedZoneMember)ez[i].getMembers().elementAt(j);
                    EndPort ep = ezm.getEndPort(vsanElement.getFabric());
                    if (ep == null || !ep.getSwitch().isMDS() || !ep.getSwitch().isManageable() || ep.isVirtualized()) continue;
                    if ((ezm.getType() == 4 || ezm.getType() == 6 || ezm.getType() == 7) && ezm.getAttachedEndPorts().size() > 0) {
                        atleastOneTargetexists = true;
                        if (atleastOneHostexists) break;
                    }
                    if (ep.isTarget()) {
                        atleastOneTargetexists = true;
                        if (!atleastOneHostexists) continue;
                        break;
                    }
                    atleastOneHostexists = true;
                    if (atleastOneTargetexists) break;
                }
                if (!atleastOneHostexists || !atleastOneTargetexists) continue;
                exists = true;
                break;
            }
        }
        DataObject dObject = (DataObject)map.get(vsanElement);
        dObject.enforcedZoneObtained = true;
        if (dObject != null) {
            if (exists) {
                dObject.enfZone = ez;
            }
        } else {
            DataObject d = new DataObject();
            d.vsan = vsanElement;
            if (exists) {
                d.enfZone = ez;
            }
            map.put(vsanElement, d);
        }
    }

    public void qosWizardAction() throws SnmpException {
        try {
            this._swList = new ArrayList();
            int vsanId = this._vsanId;
            QoSSnmp qsnmp = new QoSSnmp();
            this.validateQoS(vsanId, qsnmp);
            ArrayList<Switch> failedList = new ArrayList<Switch>();
            for (int i = 0; i < this._swList.size(); ++i) {
                Switch sw = (Switch)this._swList.get(i);
                if (sw.isNpvEnabled()) continue;
                qsnmp.setSwitch(sw);
                try {
                    Object returnObject = qsnmp.isQosEnabled();
                    if (!(returnObject instanceof Boolean)) {
                        JOptionPane.showMessageDialog(null, "qos-feature Not Enabled on " + sw.getIpAddress() + " Reason: " + (String)returnObject, "Error", 0);
                        SnmpException ex = new SnmpException("qos-feature Not Enabled ( " + (String)returnObject + ")");
                        throw ex;
                    }
                    this.createClassMapController(qsnmp, vsanId);
                    this.createPolicyMapController(qsnmp, vsanId, sw);
                    qsnmp.enableFCC();
                }
                catch (SnmpException snmpEx) {
                    failedList.add(sw);
                    this.printStatusMsg("QoS config failed on switch " + sw.getIpAddress() + " - " + (i + 1) + " of " + this._swList.size());
                    DefaultLogger._ExLogger.warn((Object)snmpEx.getMessage(), (Throwable)snmpEx);
                    continue;
                }
                this.printStatusMsg("QoS config applied to switch " + sw.getIpAddress() + " - " + (i + 1) + " of " + this._swList.size());
            }
            if (failedList.size() > 0) {
                StringBuffer buffer = new StringBuffer("Failed for switches: ");
                buffer.append(((Switch)failedList.get(0)).getName());
                for (int i = 1; i < failedList.size(); ++i) {
                    buffer.append(" ," + ((Switch)failedList.get(i)).getName());
                }
                throw new Exception(buffer.toString());
            }
        }
        catch (Exception e) {
            SnmpException snex = new SnmpException(e.getMessage());
            throw snex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void startRun() {
        try {
            this.qosWizardAction();
            Object object = this._lockObject;
            synchronized (object) {
                this._lockObject.notifyAll();
            }
        }
        catch (SnmpException sne) {
            Object object = this._lockObject;
            synchronized (object) {
                this._lockObject.notifyAll();
            }
            Util.errorMessage((Component)BrowserFrame.getInstance(), sne.getMessage());
        }
        catch (Exception e) {
            Object object = this._lockObject;
            synchronized (object) {
                this._lockObject.notifyAll();
            }
            Util.errorMessage((Component)BrowserFrame.getInstance(), "Unknown error in QoS configuration");
        }
    }

    @Override
    public void run() {
        this.startRun();
    }

    public void printStatusMsg(String msg) {
        this._wiz.setStatus(msg);
    }

    public void printDbg(String fn, String str) {
    }
}

