/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.sanexttuner;

import com.cisco.dcbu.lib.mds.flash.FlashUtil;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.sanexttuner.SanExtTunerBasePanel;
import com.cisco.dcbu.sm.client.sanexttuner.SanExtTunerWizard;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class SanExtTunerConfigPanel
extends SanExtTunerBasePanel
implements ItemListener {
    FieldPanel _transferSize;
    FieldPanel _readIO;
    FieldPanel _writeIO;
    JCheckBox _usePatternFile;
    FieldPanel _patternFile;
    String[] _flashPatternFiles = null;
    static String[] _Labels = new String[]{"Transfer Size:", "Read I/O:", "Write I/O:", null, null};
    static int TRANSFER_SIZE = 0;
    static int READ_IO = 1;
    static int WRITE_IO = 2;
    static int USE_PATTERN = 3;
    private static final int OUTSTANDING_IO = 262144;

    public SanExtTunerConfigPanel(JWizard wizard) {
        super("2 of 3: Specify Parameters", "Provide the following configuration parameters.", wizard, SanExtTunerWizard._Image);
        JComponent[] comps = new JComponent[5];
        this._transferSize = new FieldPanel(10, 1, 16384, "(Multiple of 512 bytes)");
        comps[0] = this._transferSize;
        this._transferSize.setText("64");
        this._readIO = new FieldPanel(10, 0, 1024, "(0 - No Read I/O)");
        comps[1] = this._readIO;
        this._readIO.setText("16");
        this._writeIO = new FieldPanel(10, 0, 1024, "(0 - No Write I/O)");
        comps[2] = this._writeIO;
        this._writeIO.setText("16");
        this._usePatternFile = new JCheckBox("Use Pattern File:", false);
        comps[3] = this._usePatternFile;
        this._usePatternFile.addItemListener(this);
        KTextField tf = new KTextField(30);
        Dimension d = tf.getPreferredSize();
        tf.setColumns(0);
        tf.setPreferredSize(d);
        tf.setEditable(false);
        this._patternFile = new FieldPanel(tf, (JComponent)new PatternFileButton(null));
        comps[4] = this._patternFile;
        this._patternFile.setEnabled(false);
        JPanel p = DialogUtil.buildPanel(DialogUtil.buildLabels(_Labels), comps);
        this.add((Component)p, "Center");
    }

    @Override
    public void doNext() {
        String swio;
        String srio;
        String sts;
        try {
            sts = this._transferSize.getText();
            if (sts.trim().length() == 0) {
                throw new Exception(" Can not be blank.");
            }
        }
        catch (NumberFormatException nfe) {
            Util.errorMessage((Component)this, _Labels[TRANSFER_SIZE] + " Invalid input, " + nfe.getMessage());
            return;
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this, _Labels[TRANSFER_SIZE] + ex.getMessage());
            return;
        }
        int ts = FieldPanel.getNumber(sts);
        try {
            srio = this._readIO.getText();
            if (srio.trim().length() == 0) {
                throw new Exception(" Can not be blank.");
            }
        }
        catch (NumberFormatException nfe) {
            Util.errorMessage((Component)this, _Labels[READ_IO] + " Invalid input, " + nfe.getMessage());
            return;
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this, _Labels[READ_IO] + ex.getMessage());
            return;
        }
        int rio = FieldPanel.getNumber(srio);
        try {
            swio = this._writeIO.getText();
            if (swio.trim().length() == 0) {
                throw new Exception(" Can not be blank.");
            }
        }
        catch (NumberFormatException nfe) {
            Util.errorMessage((Component)this, _Labels[WRITE_IO] + " Invalid input, " + nfe.getMessage());
            return;
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this, _Labels[WRITE_IO] + ex.getMessage());
            return;
        }
        int wio = FieldPanel.getNumber(swio);
        if (rio == 0 && wio == 0) {
            Util.errorMessage((Component)this, "Both Read I/O and Write I/O have 0 size.");
            return;
        }
        if (this._usePatternFile.isSelected() && this._patternFile.getText().equals("")) {
            Util.errorMessage((Component)this, "Please provide Pattern File.");
            return;
        }
        this.setModelValue("Transfer Size", this._transferSize);
        this.setModelValue("Read I/O", this._readIO);
        this.setModelValue("Write I/O", this._writeIO);
        this.setModelValue("Use Pattern File", this._usePatternFile);
        this.setModelValue("Pattern File", this._patternFile);
        this.getWizard().getNavigator().getNextBtn().setVisible(false);
        super.doNext();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this._usePatternFile) {
            boolean isSelected = e.getStateChange() == 1;
            this._patternFile.setEnabled(isSelected);
        }
    }

    class PatternFileButton
    extends MenuButton {
        public PatternFileButton(JMenu menu) {
            super(menu);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JMenuItem) {
                String source = "bootflash:/" + ((JMenuItem)e.getSource()).getText();
                ((FieldPanel)this.getParent()).setText(source);
                ((FieldPanel)this.getParent()).getField().setCaretPosition(0);
                return;
            }
            if (SanExtTunerConfigPanel.this._flashPatternFiles == null) {
                try {
                    Switch initSw = (Switch)SanExtTunerConfigPanel.this.getModelValue("Initiator Switch");
                    SanExtTunerConfigPanel.this._flashPatternFiles = FlashUtil.getFiles(initSw.getSnmpPeer());
                }
                catch (SnmpException snmpException) {
                    // empty catch block
                }
                this.buildMenu(SanExtTunerConfigPanel.this._flashPatternFiles);
            }
            super.actionPerformed(e);
        }
    }
}

