/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.sanexttuner;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.JnmMibEnum;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.CliCommandHandler;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.mds.PortInterfaceUtil;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpNull;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.gui.UIActions;
import com.cisco.dcbu.sm.client.model.EnforcedZone;
import com.cisco.dcbu.sm.client.model.EnforcedZoneMember;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.sanexttuner.SanExtTunerBasePanel;
import com.cisco.dcbu.sm.client.sanexttuner.SanExtTunerWizard;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZoneDialog;
import com.cisco.dcbu.sm.common.model.Card;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SanExtTunerPortPanel
extends SanExtTunerBasePanel {
    Isl _selectedFcipLink;
    JComponent[] _values;
    Switch _initiatorSw;
    Switch _targetSw;
    SnmpKTable _initiatorTable;
    SnmpKTable _targetTable;
    SmTableModel _initiatorTableModel;
    SmTableModel _targetTableModel;
    JLabel _initiator;
    JLabel _target;
    CliCommandHandler _initiatorSmlCmd;
    CliCommandHandler _targetSmlCmd;
    boolean _queryInProgress = false;
    getSwitchInfoThread _getSwitchInfoThreadInit = null;
    getSwitchInfoThread _getSwitchInfoThreadTarget = null;
    int _vsanIdInit = 0;
    String _retZoneName = null;
    String _activeVsanStr = null;
    static final String[] _ColLabels = new String[]{"Interface", "Status", "NPort"};
    static final String _ifAdminStatusMib = "ifAdminStatus";
    static final int[] _ifAdminStatusOid = MibNode.get("ifAdminStatus").getOid();
    static final int FC_OPERMODE_E = 4;

    public SanExtTunerPortPanel(JWizard wizard, Isl selectedFcipLink) {
        super("1 of 3: Select Ethernet Port Pair", "Select physical ethernet interfaces - preferrably administratively down - for both switches.", wizard, SanExtTunerWizard._Image);
        this._selectedFcipLink = selectedFcipLink;
        this._initiatorSw = selectedFcipLink.getSwitch1();
        this._initiatorTableModel = new SmTableModel();
        this._initiatorTableModel.setHeaders(_ColLabels);
        this._initiatorTable = new SnmpKTable(this._initiatorTableModel);
        this._initiatorTable.setSelectionMode(1);
        this._initiatorTable.setAutoResizeMode(3);
        this._initiatorTable.getTableHeader().addMouseListener(new HeaderListener());
        this._initiatorTable.setSortable(true);
        ((JLabel)((Object)this._initiatorTable.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(2);
        this._initiator = new JLabel(this._initiatorSw.getName() + ":");
        this._targetSw = selectedFcipLink.getSwitch2();
        this._targetTableModel = new SmTableModel();
        this._targetTableModel.setHeaders(_ColLabels);
        this._targetTable = new SnmpKTable(this._targetTableModel);
        this._targetTable.setSelectionMode(1);
        this._targetTable.getTableHeader().addMouseListener(new HeaderListener());
        this._targetTable.setSortable(true);
        ((JLabel)((Object)this._targetTable.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(2);
        this._target = new JLabel(this._targetSw.getName() + ":");
    }

    @Override
    public boolean refresh() {
        JScrollPane sp1 = new JScrollPane(this._initiatorTable);
        sp1.setPreferredSize(new Dimension(200, 180));
        JComponent[] initComps = new JComponent[]{this._initiator, sp1};
        JPanel p1 = DialogUtil.buildPanel(DialogUtil.buildLabels(new String[]{null, null}), initComps);
        JScrollPane sp2 = new JScrollPane(this._targetTable);
        sp2.setPreferredSize(new Dimension(200, 180));
        JComponent[] targetComps = new JComponent[]{this._target, sp2};
        JPanel p2 = DialogUtil.buildPanel(DialogUtil.buildLabels(new String[]{null, null}), targetComps);
        this.add((Component)p1, "West");
        this.add((Component)p2, "East");
        this._queryInProgress = true;
        this.getWizard().setStatus("Gathering switch information...");
        ((SanExtTunerWizard)this.getWizard()).setCursor(true);
        JWizard wizard = this.getWizard();
        wizard.getNavigator().getNextBtn().setEnabled(false);
        this._getSwitchInfoThreadInit = new getSwitchInfoThread(this._initiatorSw, this._initiatorTableModel, this._initiatorTable, true);
        this._getSwitchInfoThreadInit.start();
        this._getSwitchInfoThreadInit = new getSwitchInfoThread(this._targetSw, this._targetTableModel, this._targetTable, false);
        this._getSwitchInfoThreadInit.start();
        return true;
    }

    void preselectPortPair(SmTableModel tableModel, SnmpKTable table) {
        Array data = tableModel.getData();
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            int portState = ((JnmMibEnum)row[1]).getValue();
            if (portState != 2 || !((String)row[2]).equals("false")) continue;
            table.setRowSelectionInterval(i, i);
            break;
        }
    }

    void getSwitchInfo(Switch sw, SmTableModel model, SnmpKTable table, CliCommandHandler smlCmd, int fcipIfIndex, boolean isInitiator) throws Exception {
        String vsan = "1";
        SnmpFetch f = new SnmpFetch();
        VarBindList vbl = new VarBindList();
        Card[] cards = sw.getCards();
        ArrayList<Integer> downIfIndexes = new ArrayList<Integer>();
        for (int i = 0; i < cards.length; ++i) {
            if (cards[i].getType() == 44 || !cards[i].hasGigEPorts()) continue;
            int cardType = cards[i].getType();
            int portEndNum = cards[i].getNumPorts();
            if (cardType == 22 || cardType == 27) {
                portEndNum = 2;
            } else if (cardType == 39 || cardType == 41) {
                portEndNum = 4;
            } else if (cardType == 68) {
                portEndNum = 2;
            }
            for (int j = 0; j < portEndNum; ++j) {
                int ifIndex = IfIndexUtil.name2IfIndex("gigE" + cards[i].getSlotId() + '/' + Integer.toString(j + 1));
                vbl.add(new SnmpVarBind(new SnmpOID(_ifAdminStatusOid, ifIndex)));
                int operStatus = cards[i].getPowerOperStatus();
                if (operStatus != 1 && operStatus != 3 && operStatus != 4 && operStatus != 5 && operStatus != 6 && operStatus != 7) continue;
                downIfIndexes.add(new Integer(ifIndex));
            }
        }
        if (vbl.size() == 0) {
            throw new Exception(sw + ": no valid gigE port available to run San Extension Tuner!");
        }
        VarBindList getBackVbl = SnmpFetch.get(sw.getSnmpPeer(), vbl).getVariables();
        Array<Object[]> data = new Array<Object[]>();
        model.setData(data);
        MibNode adminMibNode = MibNode.get(_ifAdminStatusMib);
        MibEnum[] enums = adminMibNode.getEnums();
        HashMap<Object, Object[]> ifName2RowData = new HashMap<Object, Object[]>();
        for (int i = 0; i < getBackVbl.size(); ++i) {
            int admin = getBackVbl.intValue(i);
            int[] oid = getBackVbl.getVb(i).getOid().getValue();
            int ifIndex = oid[oid.length - 1];
            Object[] row = new Object[]{sw.ifIndexToName(ifIndex), downIfIndexes.contains(new Integer(ifIndex)) ? "down" : model.toCell(adminMibNode, getBackVbl.getVb(i).getVar(), _ifAdminStatusMib, i), "false"};
            data.addElement(row);
            ifName2RowData.put(row[0], row);
        }
        short operMode = this._selectedFcipLink.getOperMode();
        if (operMode == 4) {
            vsan = this._selectedFcipLink.getVsansAsString();
        } else {
            VarBindList vblVsan = new VarBindList(2);
            vblVsan.add(new SnmpVarBind(new SnmpOID(MibNode.get("fcIfActiveVsanUpList2k").getOid(), fcipIfIndex)));
            vblVsan.add(new SnmpVarBind(new SnmpOID(MibNode.get("fcIfActiveVsanUpList4k").getOid(), fcipIfIndex)));
            SnmpPDU resp = SnmpFetch.get(sw.getSnmpPeer(), vblVsan);
            vbl = resp.getVariables();
            if (vbl.size() != 0) {
                StringTokenizer st;
                SnmpVar var2k = vbl.getVb(0).getVar();
                SnmpVar var4k = vbl.getVb(1).getVar();
                if (var2k instanceof SnmpNull || var4k instanceof SnmpNull) {
                    throw new Exception(sw + ": unable to get Up VSANs for " + sw.ifIndexToName(fcipIfIndex) + "!");
                }
                SnmpString active2k = (SnmpString)vbl.getVb(0).getVar();
                SnmpString active4k = (SnmpString)vbl.getVb(1).getVar();
                SnmpString activeVsan = PortInterfaceUtil.getInstance(1).getVsan(active2k, active4k, true);
                byte[] b = activeVsan.getValue();
                if (b.length == 0) {
                    throw new Exception(sw + ": " + sw.ifIndexToName(fcipIfIndex) + " does not have Up VSANs, it could be either down or in the process of coming up. \nPlease exit and restart the wizard when the FCIP link is up and running again.");
                }
                String activeVsanStr = (String)MibVariableFormat.fcIfAllowedVsanList2k(activeVsan);
                if (this._activeVsanStr == null) {
                    this._activeVsanStr = activeVsanStr;
                }
                vsan = (st = new StringTokenizer(activeVsanStr, "-,")).hasMoreTokens() ? st.nextToken().trim() : activeVsanStr;
            }
        }
        if (isInitiator) {
            this.setModelValue("Initiator VSAN", vsan);
        } else {
            this.setModelValue("Target VSAN", vsan);
        }
        String baseasePrompt = this.getPromptLessDelimitor(smlCmd.getCurrentPrompt(), "#");
        if (sw.isVersionGreaterThanEqual("4.1(0)")) {
            smlCmd.executeCLICommandCheckEOLStatus("debug cli eol filter 0xFFFFFFFF", null, false);
        } else {
            smlCmd.executeCLICommandCheckEOLStatus("debug system internal vsh eol filter 0xffffffff", null, false);
        }
        smlCmd.executeCLICommandPromptError("conf t", baseasePrompt + "(config)#", false);
        smlCmd.executeCLICommandPromptError("iscsi enable", (String)null, false);
        smlCmd.executeCLICommandPromptError("san-ext-tuner enable", (String)null, false);
        smlCmd.executeCLICommandPromptError("end", baseasePrompt + "#", false);
        String nports = smlCmd.executeCLICommandPromptError("show san-ext-tuner nports", (String)null, false);
        if (null != nports && nports.length() > 0) {
            StringReader reader = new StringReader(nports);
            InputSource source = new InputSource(reader);
            ArrayList nportIfNameList = new ArrayList();
            NPortXml handler = new NPortXml(nportIfNameList);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(source, (DefaultHandler)handler);
            for (int i = 0; i < nportIfNameList.size(); ++i) {
                String ifName = (String)nportIfNameList.get(i);
                Object[] row = (Object[])ifName2RowData.get(ifName);
                if (row == null) continue;
                row[2] = "true";
            }
        }
        table.colWidthToWidest();
        this.actionFinished(true);
    }

    @Override
    public void doNext() {
        int vsanForZone = 0;
        int initRow = this._initiatorTable.getSelectedRow();
        int targetRow = this._targetTable.getSelectedRow();
        if (initRow == -1 || targetRow == -1) {
            Util.errorMessage((Component)this.getWizard(), "Please select a pair port!");
            return;
        }
        Object[] rowInit = (Object[])this._initiatorTableModel.getData().elementAt(initRow);
        String ifNameInit = (String)rowInit[0];
        int ifIndexInit = IfIndexUtil.name2IfIndex(ifNameInit);
        byte[] pWwnByteInit = new byte[8];
        SanExtTunerPortPanel.getWwns(this._initiatorSw, ifIndexInit, null, pWwnByteInit);
        Object[] rowTarget = (Object[])this._targetTableModel.getData().elementAt(targetRow);
        String ifNameTarget = (String)rowTarget[0];
        int ifIndexTarget = IfIndexUtil.name2IfIndex(ifNameTarget);
        byte[] pWwnByteTarget = new byte[8];
        SanExtTunerPortPanel.getWwns(this._targetSw, ifIndexTarget, null, pWwnByteTarget);
        Vsan[] vsans = this._selectedFcipLink.getVsans();
        boolean pwwnsInZone = false;
        for (int i = 0; i < vsans.length; ++i) {
            Vsan vsan = vsans[i];
            EnforcedZone[] ez = vsan.getEnforcedZones();
            if (ez != null) {
                for (int j = 0; j < ez.length; ++j) {
                    Array members = ez[j].getMembers();
                    if (members == null) continue;
                    boolean initInZone = false;
                    boolean targetInZone = false;
                    for (int k = 0; k < members.size(); ++k) {
                        EnforcedZoneMember ezm = (EnforcedZoneMember)members.elementAt(k);
                        if (ezm.equals(pWwnByteInit)) {
                            initInZone = true;
                            if (targetInZone) break;
                        }
                        if (!ezm.equals(pWwnByteTarget)) continue;
                        targetInZone = true;
                        if (initInZone) break;
                    }
                    if (!initInZone || !targetInZone) continue;
                    pwwnsInZone = true;
                    vsanForZone = vsan.getId();
                    break;
                }
            }
            if (pwwnsInZone) break;
        }
        if (!pwwnsInZone) {
            String zoneName = "SanExtTuner-" + this._selectedFcipLink.getIfIndex1Name() + "-" + this._initiatorSw.getName();
            zoneName = zoneName.replace('.', '-');
            zoneName = zoneName.replace(':', '-');
            zoneName = zoneName.replace(' ', '-');
            int chooseZone = JOptionPane.showConfirmDialog(this.getWizard(), "Nports need to be zoned together to enable the Tuner.\n(Note: If both switches default zone policy is permit, you don't need to create a zone)\n\nDo you want to create and activate a zone?", "SAN Extension Tuner Wizard" + ClientController.getInstance().getDialogFabricTitlePostfix(), 0);
            if (chooseZone == 0) {
                block14: {
                    this.setVsan(-1);
                    ZoneVsanNameDialog zoneVsanDlg = new ZoneVsanNameDialog(this.getWizard(), "SAN Extension Tuner Wizard" + ClientController.getInstance().getDialogFabricTitlePostfix(), zoneName, this._activeVsanStr);
                    if (this._retZoneName != null && this._vsanIdInit > 0) {
                        try {
                            Vsan v = null;
                            for (Vsan vsan : vsans) {
                                if (vsan.getVsanId() != this._vsanIdInit) continue;
                                v = vsan;
                                break;
                            }
                            if (v == null && (v = ClientController.getInstance().getFabric().findVsanById(this._vsanIdInit)).isSegmented()) {
                                Util.errorMessage((Component)this.getWizard(), "VSAN is segmented. Please pick another VSAN.");
                                return;
                            }
                            this.setModelValue("Initiator VSAN", this._vsanIdInit + "");
                            ArrayList<byte[]> pWwnList = new ArrayList<byte[]>();
                            pWwnList.add(pWwnByteInit);
                            pWwnList.add(pWwnByteTarget);
                            ZoneDialog dlg = UIActions.getInstance().invokeZoneMgr(v, false);
                            dlg.refreshAndCalcSize();
                            dlg.runcreateAndShoZone(pWwnList, this._retZoneName);
                            dlg.setVisible(true);
                        }
                        catch (Exception ex) {
                            Util.errorMessage((Component)this.getWizard(), ex.getMessage());
                            if (!SnmpSession.isTrace()) break block14;
                            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                        }
                    }
                }
                return;
            }
        }
        this.setModelValue("Initiator PORT", this._initiatorTableModel.getData().elementAt(initRow));
        this.setModelValue("Target PORT", this._targetTableModel.getData().elementAt(targetRow));
        this.setModelValue("Initiator Switch", this._initiatorSw);
        this.setModelValue("Target Switch", this._targetSw);
        this.setModelValue("FCIP Link", this._selectedFcipLink);
        if (vsanForZone > 0) {
            this.setModelValue("Initiator VSAN", vsanForZone + "");
        }
        super.doNext();
    }

    public void setZoneName(String name) {
        this._retZoneName = name;
    }

    public void setVsan(int vsanInt) {
        this._vsanIdInit = vsanInt;
    }

    @Override
    public void actionFinished(boolean success) {
        if (!success || !this._queryInProgress) {
            ((SanExtTunerWizard)this.getWizard()).setCursor(false);
            this.getWizard().setStatus("");
            JWizard wizard = this.getWizard();
            if (wizard != null && wizard.getNavigator() != null && wizard.getNavigator().getNextBtn() != null) {
                wizard.getNavigator().getNextBtn().setEnabled(true);
            }
        } else {
            this._queryInProgress = false;
        }
    }

    public static void getWwns(Switch sw, int ifIndex, byte[] nWwnByte, byte[] pWwnByte) {
        int card = IfIndexUtil.ifIndex2Card(ifIndex) + 1;
        int port = IfIndexUtil.ifIndex2Port(ifIndex) + 1;
        byte[] sWwnByte = sw.getWwn().getValue();
        for (int i = 2; i < 8; ++i) {
            if (nWwnByte != null) {
                nWwnByte[i] = sWwnByte[i];
            }
            if (pWwnByte == null) continue;
            pWwnByte[i] = sWwnByte[i];
        }
        if (nWwnByte != null) {
            nWwnByte[0] = 0;
            nWwnByte[1] = 0;
        }
        if (pWwnByte != null) {
            pWwnByte[0] = (byte)card;
            pWwnByte[1] = (byte)port;
        }
    }

    class ZoneVsanNameDialog
    extends JDialog {
        JDialog _parent;
        JTextField zoneTF;
        JTextField vsanTF;
        JPanel _main;

        public ZoneVsanNameDialog(JDialog parent, String title, String zoneName, String vsanList) {
            super(parent, "SAN Extension Tuner Wizard" + ClientController.getInstance().getDialogFabricTitlePostfix(), true);
            this._main = null;
            this._parent = parent;
            JPanel pnl = new JPanel();
            JLabel zoneLB = new JLabel("Select Zone Name:");
            this.zoneTF = new JTextField(30);
            JLabel vsanLB = new JLabel("Select a VSAN from Range:");
            this.vsanTF = new JTextField(30);
            this.zoneTF.setText(zoneName);
            this.vsanTF.setText(vsanList);
            SpringLayout layout = new SpringLayout();
            pnl.setLayout(layout);
            pnl.add(zoneLB);
            pnl.add(this.zoneTF);
            pnl.add(vsanLB);
            pnl.add(this.vsanTF);
            layout.putConstraint("West", (Component)zoneLB, 30, "West", (Component)pnl);
            layout.putConstraint("North", (Component)zoneLB, 20, "North", (Component)pnl);
            layout.putConstraint("West", (Component)this.zoneTF, 30, "West", (Component)pnl);
            layout.putConstraint("North", (Component)this.zoneTF, 20, "North", (Component)zoneLB);
            layout.putConstraint("West", (Component)vsanLB, 30, "West", (Component)pnl);
            layout.putConstraint("North", (Component)vsanLB, 35, "North", (Component)this.zoneTF);
            layout.putConstraint("West", (Component)this.vsanTF, 30, "West", (Component)pnl);
            layout.putConstraint("North", (Component)this.vsanTF, 20, "North", (Component)vsanLB);
            JButton btnOk = new JButton("OK");
            btnOk.addActionListener(new ActionListener(){
                int vsanInt = 0;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SanExtTunerPortPanel.this.setZoneName(ZoneVsanNameDialog.this.zoneTF.getText());
                    try {
                        this.vsanInt = Integer.parseInt(ZoneVsanNameDialog.this.vsanTF.getText());
                    }
                    catch (Exception ex) {
                        Util.errorMessage((Component)ZoneVsanNameDialog.this._parent, "Please select a VSAN from the given range.");
                        SanExtTunerPortPanel.this.setVsan(-1);
                        return;
                    }
                    SanExtTunerPortPanel.this.setVsan(this.vsanInt);
                    ZoneVsanNameDialog.this.dispose();
                }
            });
            JButton btnCancel = new JButton("Cancel");
            btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ZoneVsanNameDialog.this.dispose();
                }
            });
            JPanel bpnl = new JPanel();
            bpnl.add(btnOk);
            bpnl.add(btnCancel);
            this._main = new JPanel(new BorderLayout());
            this._main.add((Component)pnl, "Center");
            this._main.add((Component)bpnl, "South");
            this.getContentPane().add(this._main);
            this.setSize(320, 240);
            this.setLocationRelativeTo(this._parent);
            this.setVisible(true);
        }
    }

    public class NPortXml
    extends DefaultHandler {
        ArrayList _nportIfNameList;

        public NPortXml(ArrayList nportIfNameList) {
            this._nportIfNameList = nportIfNameList;
        }

        @Override
        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
            String eName = sName;
            if ("".equals(eName)) {
                eName = qName;
            }
            if (eName.equals("INTERFACE") && attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String aName = attrs.getLocalName(i);
                    if ("".equals(aName)) {
                        aName = attrs.getQName(i);
                    }
                    if (!aName.equals("name")) continue;
                    String gigEPort = attrs.getValue(i);
                    int ifIndex = IfIndexUtil.name2IfIndex(gigEPort);
                    this._nportIfNameList.add(IfIndexUtil.ifIndexToName(ifIndex));
                }
            }
        }
    }

    class getSwitchInfoThread
    extends Thread {
        Switch _sw;
        SmTableModel _model;
        SnmpKTable _table;
        boolean _isInitiator;

        public getSwitchInfoThread(Switch sw, SmTableModel model, SnmpKTable table, boolean isInitiator) {
            super("SET:getSwitchInfoThread");
            this._sw = sw;
            this._model = model;
            this._table = table;
            this._isInitiator = isInitiator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AtomicInteger numThreadWaiting;
            try {
                CliCommandHandler smlCmd;
                int fcipIfIndex;
                if (this._isInitiator) {
                    fcipIfIndex = SanExtTunerPortPanel.this._selectedFcipLink.getIfIndex1();
                    smlCmd = SanExtTunerPortPanel.this._initiatorSmlCmd = new CliCommandHandler(BrowserFrame.getInstance(), this._sw.getPeer(), true);
                    SanExtTunerPortPanel.this.setModelValue("Initiator SmlHandler", SanExtTunerPortPanel.this._initiatorSmlCmd);
                } else {
                    fcipIfIndex = SanExtTunerPortPanel.this._selectedFcipLink.getIfIndex2();
                    smlCmd = SanExtTunerPortPanel.this._targetSmlCmd = new CliCommandHandler(BrowserFrame.getInstance(), this._sw.getPeer(), true);
                    SanExtTunerPortPanel.this.setModelValue("Target SmlHandler", SanExtTunerPortPanel.this._targetSmlCmd);
                }
                SanExtTunerPortPanel.this.getSwitchInfo(this._sw, this._model, this._table, smlCmd, fcipIfIndex, this._isInitiator);
            }
            catch (Exception ex) {
                Util.errorMessage((Component)SanExtTunerPortPanel.this.getWizard(), ex.getMessage());
                if (SnmpSession.isTrace()) {
                    DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
                SanExtTunerPortPanel.this.actionFinished(false);
            }
            SanExtTunerWizard wizard = (SanExtTunerWizard)SanExtTunerPortPanel.this.getWizard();
            AtomicInteger atomicInteger = numThreadWaiting = wizard._numThreadWaiting;
            synchronized (atomicInteger) {
                numThreadWaiting.getAndIncrement();
            }
            while (numThreadWaiting.get() > 0) {
                try {
                    atomicInteger = numThreadWaiting;
                    synchronized (atomicInteger) {
                        numThreadWaiting.wait(3000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

