/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.upgrade.u3_0_3;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.mds.SmlCommandsHandler;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.KFilePanel;
import com.cisco.dcbu.lib.ui.table.BorderCellRenderer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.Upgrade;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.UpgradePanel;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.UpgradeWizard;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;

class QuailPanel
extends UpgradePanel
implements ActionListener {
    JComponent[] _values;
    protected SnmpKTable _table;
    JScrollPane _sp;
    Switch[] _sws;
    final String[] _tableLabels = new String[]{"Switch", "Status"};
    static final int IPADDRESS = 0;
    static final int FILENAME = 1;
    static final int SWITCHNAME = 0;
    static final int STATUS = 1;
    protected Timer _statusTimer;
    static final int POLL_INTERVAL = 3000;
    int _elapsedSecs;
    SnmpPeer _peer;
    InetAddress _address;
    HashMap _sw2Row;
    Array _data;
    UpgradeThread _thread;

    public QuailPanel(JFrame parent, UpgradeWizard wiz, Upgrade upgrade) {
        super("2 of 2 - Specify 9020 Software Image", "Please specify TFTP Server and filename.", parent, wiz, upgrade);
        JPanel p = new JPanel(new BorderLayout());
        Box box = new Box(1);
        String[] labels = new String[]{"Address:", "Filename:"};
        this._values = new JComponent[labels.length];
        this._values[0] = new JTextField(25);
        this._values[1] = new KFilePanel(null, 25, "Select Image", "");
        JPanel serverPanel = DialogUtil.buildPanel(DialogUtil.buildLabels(labels), this._values);
        box.add(serverPanel);
        JPanel emptyPanel = new JPanel(new FlowLayout(0, 2, 0));
        emptyPanel.add(new JLabel(" "));
        box.add(emptyPanel);
        box.add(new DialogSeparator("Status(s)"));
        p.add("North", box);
        this._table = this.buildTable(this._tableLabels, new boolean[]{false, false}, new Array());
        this._table.setRowSelectionAllowed(true);
        this._table.setRowHeight(20);
        this._table.getColumnModel().getColumn(1).setCellRenderer(new ProgressRenderer());
        this._sp = new JScrollPane(this._table);
        this._sp.setPreferredSize(this._table.calcPreferredSize());
        p.add("Center", this._sp);
        JPanel bottom = new JPanel(new BorderLayout());
        bottom.setBorder(new EmptyBorder(new Insets(4, 0, 0, 0)));
        p.add((Component)bottom, "South");
        this.add(p);
    }

    @Override
    public void dispose() {
        if (this._statusTimer != null) {
            this._statusTimer.stop();
        }
        if (this._thread != null) {
            this._thread.setContinueFalse();
        }
        super.dispose();
    }

    private void statusTableGet(int len) {
        this._data = QuailPanel.getData(this._table);
        this._sws = this.getSwitches();
        if (this._sws == null) {
            return;
        }
        this._data.clear();
        this._sw2Row = new HashMap();
        for (int i = 0; i < this._sws.length; ++i) {
            Object[] row = new Object[len];
            row[0] = this._sws[i].getName();
            row[1] = "";
            this._data.addElement(row);
            this._sw2Row.put(this._sws[i].getPeer(), row);
        }
    }

    @Override
    public void setVisible(boolean isVisible) {
        if (isVisible) {
            this.statusTableGet(this._tableLabels.length);
            try {
                String localVPNAddr = null;
                if (this._sws != null && this._sws.length > 1) {
                    localVPNAddr = this.getLocalVPNAddr(this._sws[0]);
                }
                ((JTextField)this._values[0]).setText(localVPNAddr != null ? localVPNAddr : InetAddress.getLocalHost().getHostAddress());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._values[0].setVisible(isVisible);
        this._values[1].setVisible(isVisible);
        super.setVisible(isVisible);
    }

    @Override
    public void doPrevious() {
        this.getWizard().first();
    }

    @Override
    public void doNext() {
    }

    @Override
    public void doFinish() {
        if (this._statusTimer != null) {
            this._statusTimer.stop();
        }
        this._thread = new UpgradeThread(this._sws, QuailPanel.getModel(this._table), this);
        this._thread.start();
    }

    private String copyImage(SmlCommandsHandler smlCmd, String filename, String localFilename) {
        try {
            byte[] b = SnmpIpAddress.parse(((JTextField)this._values[0]).getText());
            String ipAddress = SnmpString.toHexString(b, 0, b.length, false);
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add("Cmd.Switch.TFTPSetup.LocalFileName.volatile:" + localFilename);
            cmds.add("Cmd.Switch.TFTPSetup.RemoteFileName." + filename);
            cmds.add("Cmd.Switch.TFTPSetup.RemoteIPAddress." + ipAddress);
            cmds.add("Cmd.Switch.TFTPSetup.RemotePort.69");
            cmds.add("Cmd.Switch.TFTPGet");
            String[] arCmd = cmds.toArray(new String[cmds.size()]);
            smlCmd.executeSmlCommandsAdv("smlsetb", arCmd, new String[][]{{"0"}, {"0"}, {"0"}, {"0"}, {"0"}}, null, true, false);
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
        return "";
    }

    private String unpackImage(SmlCommandsHandler smlCmd, String localFilename) {
        try {
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add("Cmd.Switch.UnpackImage." + localFilename);
            String[] arCmd = cmds.toArray(new String[cmds.size()]);
            smlCmd.executeSmlCommandsAdv("smlsetb", arCmd, new String[][]{{"0"}}, null);
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollSwitch(SnmpPeer peer) {
        block26: {
            Object arCmd;
            if (!this._peer.getAddress().equals(this._address)) {
                this._statusTimer.stop();
                return;
            }
            Object[] row = (Object[])this._sw2Row.get(peer);
            SmlCommandsHandler smlCmd = null;
            try {
                smlCmd = new SmlCommandsHandler(BrowserFrame.getInstance(), peer);
            }
            catch (Exception ex) {
                row[1] = "unpackImage ..." + ex.getMessage();
                QuailPanel.getModel(this._table).fireTableDataChanged();
                this._statusTimer.stop();
                try {
                    SnmpKTable snmpKTable = this._table;
                    synchronized (snmpKTable) {
                        this._table.notifyAll();
                    }
                }
                catch (IllegalMonitorStateException ex1) {
                    // empty catch block
                }
            }
            try {
                Object syncConfigout;
                block27: {
                    ArrayList<String> cmds = new ArrayList<String>();
                    cmds.add("Oper.Switch.UnpackStatus");
                    arCmd = cmds.toArray(new String[cmds.size()]);
                    String[] out = smlCmd.executeSmlCommandsAdv("smlgetb", (String[])arCmd, new String[][]{{"0"}}, null);
                    if (out[0].equals("InProgress")) {
                        row[1] = "unpackImage... [" + this._elapsedSecs + " secs]";
                        QuailPanel.getModel(this._table).fireTableDataChanged();
                        break block26;
                    }
                    this._statusTimer.stop();
                    if (out[0].equals("Complete")) {
                        row[1] = "Copy running-config to startup-config...";
                        QuailPanel.getModel(this._table).fireTableDataChanged();
                        syncConfigout = null;
                        try {
                            syncConfigout = smlCmd.executeCLICommand("copy running-config startup-config", (String)null, false);
                            if (syncConfigout != null && ((String)syncConfigout).indexOf("100%") != -1) {
                                row[1] = "start switch...";
                                QuailPanel.getModel(this._table).fireTableDataChanged();
                                new ResetSwitchThread(smlCmd, row, this._table).start();
                                row[1] = "Installed, coming online...";
                                break block27;
                            }
                            row[1] = "Copy running-config to startup-config failed: " + (String)syncConfigout;
                        }
                        catch (Exception ex) {
                            row[1] = "Copy running-config to startup-config failed: " + ex.getMessage();
                        }
                    } else {
                        row[1] = "unpackImage failed - " + out[0];
                    }
                }
                QuailPanel.getModel(this._table).fireTableDataChanged();
                try {
                    syncConfigout = this._table;
                    synchronized (syncConfigout) {
                        this._table.notifyAll();
                    }
                }
                catch (IllegalMonitorStateException ex1) {}
            }
            catch (Exception ex) {
                row[1] = "unpackImage failed - " + ex.getMessage();
                QuailPanel.getModel(this._table).fireTableDataChanged();
                this._statusTimer.stop();
                try {
                    arCmd = this._table;
                    synchronized (arCmd) {
                        this._table.notifyAll();
                    }
                }
                catch (IllegalMonitorStateException ex1) {
                    // empty catch block
                }
            }
        }
    }

    private String resetSwitch(SmlCommandsHandler smlCmd) {
        try {
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add("Cmd.Switch.HotStart");
            String[] arCmd = cmds.toArray(new String[cmds.size()]);
            smlCmd.executeSmlCommandsAdv("smlsetb", arCmd, new String[][]{{"0"}}, null);
        }
        catch (Exception ex) {
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add("Cmd.Switch.Reset");
            String[] arCmd = cmds.toArray(new String[cmds.size()]);
            try {
                smlCmd.executeSmlCommandsAdv("smlsetb", arCmd, new String[][]{{"0"}}, null);
            }
            catch (Exception ex1) {
                return "reset fails: " + ex1.getMessage();
            }
        }
        smlCmd.closeVsh();
        return "";
    }

    private String getLocalVPNAddr(Switch sw) {
        String localVPNAddr = sw.getPeer().getSession().getLocalVPNAddress();
        if (localVPNAddr == null && sw.getFabric().isQuailOnlyFabric(true)) {
            String userSpecifiedVPN = System.getProperty("vpn.ipaddress");
            try {
                if (userSpecifiedVPN != null && userSpecifiedVPN.trim().length() > 0) {
                    SnmpIpAddress.parse(userSpecifiedVPN.trim());
                    localVPNAddr = userSpecifiedVPN.trim();
                }
            }
            catch (SnmpException ex) {
                this._upgrade._upgradeLogger.error((Object)("Invalid User specified VPN Address " + userSpecifiedVPN), (Throwable)ex);
            }
            return localVPNAddr;
        }
        return localVPNAddr;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this._elapsedSecs += 3;
        this.pollSwitch(this._peer);
    }

    class ProgressRenderer
    extends BorderCellRenderer {
        ProgressRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                String status = value.toString();
                if (status.indexOf("failed") != -1) {
                    this.setBackground(Color.pink);
                } else {
                    this.setBackground(table.getBackground());
                }
            } else {
                this.setBackground(table.getBackground());
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class ResetSwitchThread
    extends Thread {
        SmlCommandsHandler _smlCmd;
        Object[] _row;
        SnmpKTable _table;

        ResetSwitchThread(SmlCommandsHandler smlCmd, Object[] row, SnmpKTable table) {
            this._smlCmd = smlCmd;
            this._row = row;
            this._table = table;
        }

        @Override
        public void run() {
            try {
                QuailPanel.this.resetSwitch(this._smlCmd);
            }
            catch (Exception ex) {
                this._row[1] = "start switch failed - " + ex.getMessage();
                UpgradePanel.getModel(this._table).fireTableDataChanged();
            }
        }
    }

    class UpgradeThread
    extends Thread {
        Switch[] _sws;
        SnmpTableModel _model;
        QuailPanel _panel;
        boolean _continue = true;

        UpgradeThread(Switch[] sws, SnmpTableModel model, QuailPanel panel) {
            this._sws = sws;
            this._model = model;
            this._panel = panel;
        }

        public void setContinueFalse() {
            this._continue = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object[] row;
            int i;
            for (i = 0; i < this._sws.length && this._continue; ++i) {
                row = (Object[])QuailPanel.this._sw2Row.get(this._sws[i].getPeer());
                row[1] = "";
            }
            this._model.fireTableDataChanged();
            if (!this._continue) {
                return;
            }
            for (i = 0; i < this._sws.length && this._continue; ++i) {
                String filename;
                SmlCommandsHandler smlCmd;
                QuailPanel.this._elapsedSecs = 0;
                row = (Object[])QuailPanel.this._sw2Row.get(this._sws[i].getPeer());
                QuailPanel.this._peer = this._sws[i].getPeer();
                QuailPanel.this._address = QuailPanel.this._peer.getAddress();
                row[1] = "connecting, please wait...";
                this._model.fireTableDataChanged();
                try {
                    smlCmd = new SmlCommandsHandler(BrowserFrame.getInstance(), QuailPanel.this._peer);
                }
                catch (Exception ex) {
                    row[1] = "connecting failed: " + ex.getMessage();
                    this._model.fireTableDataChanged();
                    continue;
                }
                String localFilename = filename = ((KFilePanel)QuailPanel.this._values[1]).getText().trim();
                int slash = localFilename.lastIndexOf(47);
                if (slash == -1) {
                    slash = localFilename.lastIndexOf(92);
                }
                if (slash != -1) {
                    localFilename = localFilename.substring(slash + 1);
                }
                row[1] = "copy image...";
                this._model.fireTableDataChanged();
                String out = QuailPanel.this.copyImage(smlCmd, filename, localFilename);
                if (!out.equals("")) {
                    row[1] = "copy image failed: " + out;
                    this._model.fireTableDataChanged();
                    continue;
                }
                row[1] = "finish copy image, unpack image...";
                this._model.fireTableDataChanged();
                out = QuailPanel.this.unpackImage(smlCmd, localFilename);
                if (!out.equals("")) {
                    row[1] = "unpack image failed: " + out;
                    this._model.fireTableDataChanged();
                    continue;
                }
                row[1] = "unpackImage ...";
                this._model.fireTableDataChanged();
                QuailPanel.this._statusTimer = new Timer(3000, this._panel);
                QuailPanel.this._statusTimer.start();
                QuailPanel.this.pollSwitch(QuailPanel.this._peer);
                try {
                    SnmpKTable snmpKTable = QuailPanel.this._table;
                    synchronized (snmpKTable) {
                        QuailPanel.this._table.wait(300000L);
                        if (QuailPanel.this._statusTimer.isRunning()) {
                            QuailPanel.this._statusTimer.stop();
                            row[1] = "unpackImage timeout...";
                            this._model.fireTableDataChanged();
                        }
                        continue;
                    }
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
        }
    }
}

