/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.upgrade.u3_0_3;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.State;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.Upgrade;

class State11
extends State {
    static final int INSTALL_ALL_FIRE_STATE = 200;
    static final int INSTALL_ALL_POLL_STATE = 201;
    static final String INSTALL_ALL_ACTION = "Start software install";
    static final String POLL_INSTALL_ALL_ACTION = "Upgrading switch";
    static final String UNSURE_SUCCESS__STATUS = "Success (new version does not support installAll)";
    static final String POLL_NO_STATUS = "InProgress polling - no status available";
    static final String GO_DISRUPT_MSG = " - Do we proceed with disruptive install of the switch?";
    static int[] _upRowStatusOid = State11.getOids("cseUpgradeOpEntryStatus");
    static int[] _upStatusOid = State11.getOids("cseUpgradeOpStatus");

    State11(Switch sw, Upgrade up) {
        super(sw, up);
    }

    @Override
    boolean abortOccurred() {
        if (this._abortState == 1) {
            this._abortState = 2;
            if (this._state == 201) {
                this.abortInstallAll();
            }
            this._abortState = 3;
            return true;
        }
        return false;
    }

    @Override
    void tick() {
        if (this.isCommonState()) {
            super.tick();
            return;
        }
        if (this._snmpTimeouts == 0 && (this.isSnmpPending() || this.genErrOccurred() || this.abortOccurred() || !this.isUp())) {
            return;
        }
        switch (this._state) {
            case 8: {
                this._state = 200;
            }
            case 200: {
                this.startInstallAll(false);
                this._state = 201;
                break;
            }
            case 201: {
                if (!this.doneInstallAll()) {
                    this.pollInstallAll();
                    break;
                }
                if (this.disruptiveInstallAll()) {
                    this.startInstallAll(true);
                    break;
                }
                this._state = 100;
            }
        }
    }

    @Override
    void handleCb(VarBindList vbl) {
        int[] firstOid = vbl.getVb(0).getOid().getValue();
        if (SnmpOID.startsWith(firstOid, _upRowStatusOid)) {
            this.startInstallAllCb(vbl);
        } else if (SnmpOID.startsWith(firstOid, _upStatusOid)) {
            this.pollInstallAllCb(vbl);
        } else {
            super.handleCb(vbl);
        }
    }

    void startInstallAll(boolean disruptive) {
        String[] vars = this.getSysAndKick();
        String sys = vars[0];
        String kick = vars[1];
        int[] index = new int[]{State11.random()};
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setLogger(this.getLogger());
        pdu.setIgnoreSetCount(true);
        pdu.addVar(new SnmpOID(_upRowStatusOid, index), new SnmpInt(4));
        pdu.addVar(new SnmpOID(State11.getOids("cseUpgradeOpCommand"), index), new SnmpInt(4));
        if (sys != null) {
            pdu.addVar(new SnmpOID(State11.getOids("cseUpgradeOpSysImageLocation"), index), new SnmpString(sys));
        }
        if (kick != null) {
            pdu.addVar(new SnmpOID(State11.getOids("cseUpgradeOpKickstartLocation"), index), new SnmpString(kick));
        }
        pdu.addVar(new SnmpOID(State11.getOids("cseUpgradeOpDisruptive"), index), new SnmpInt(disruptive ? 1 : 2));
        try {
            this.sentSnmpReq();
            this.setAction(INSTALL_ALL_ACTION);
            this.setStatus("");
            this.setObj1(this.buildPollPdu(index));
            this.setObj2(disruptive ? Boolean.TRUE : Boolean.FALSE);
            this._sw.getPeer().send(pdu, this);
        }
        catch (SnmpException ex) {
            // empty catch block
        }
    }

    SnmpPDU buildPollPdu(int[] index) {
        SnmpPDU pollPdu = new SnmpPDU(-96, new VarBindList());
        pollPdu.setLogger(this.getLogger());
        pollPdu.addVar(new SnmpOID(_upStatusOid, index));
        pollPdu.addVar(new SnmpOID(State11.getOids("cseUpgradeOpTimeCompleted"), index));
        pollPdu.addVar(new SnmpOID(State11.getOids("cseUpgradeOpInfo"), index));
        pollPdu.addVar(new SnmpOID(State11.getOids("ciuUpgradeOpCommand"), ZEROINDEX));
        this.buildGenericSwitch(pollPdu);
        return pollPdu;
    }

    boolean doneInstallAll() {
        return this.getObj1() == null;
    }

    boolean disruptiveInstallAll() {
        return this.getObj2() != null;
    }

    void pollInstallAll() {
        try {
            this.setAction(POLL_INSTALL_ALL_ACTION);
            this.sentSnmpReq(true);
            this._sw.getPeer().send((SnmpPDU)this.getObj1(), this);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    void abortInstallAll() {
        try {
            SnmpPDU pollPdu = (SnmpPDU)this.getObj1();
            int[] index = pollPdu.getVariables().getVb(0).getOid().getValue();
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
            pdu.setLogger(this.getLogger());
            pdu.addVar(new SnmpOID(State11.getOids("cseUpgradeOpAbort"), index), new SnmpInt(1));
            pdu.setIgnoreSetCount(true);
            this._sw.getPeer().send(pdu, DUMMY_CB);
            this.setStatus("Cancelled ");
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    void startInstallAllCb(VarBindList vbl) {
        this.setStatus("InProgress ");
    }

    void pollInstallAllCb(VarBindList vbl) {
        if (this.abortOccurred()) {
            return;
        }
        if (!vbl.isNull(3)) {
            this._up.changeSwitchState12(this._sw, this._action, this._status);
            return;
        }
        if (vbl.isNull(0)) {
            this.setObj2(null);
            this.genericSwitchCb(vbl, 4);
            return;
        }
        int opStatus = vbl.intValue(0);
        long opCompletedTime = vbl.longValue(1);
        String info = vbl.stringValue(2);
        this.setStatus(State11.getEnum("cseUpgradeOpStatus", opStatus) + " " + info);
        if (opCompletedTime > 0L) {
            if (opStatus == 32 && !((Boolean)this.getObj2()).booleanValue()) {
                if (!this._up.askUser(this._sw + GO_DISRUPT_MSG, this._sw.toString())) {
                    this.setStatus("Cancelled ");
                    this.setObj1(null);
                    this.setObj2(null);
                } else {
                    this.setObj1(null);
                }
            } else if (opStatus == 4 || opStatus == 34) {
                this.setObj2(null);
                if (opStatus != 34) {
                    this.setStatus("Success ");
                    this.genericSwitchCb(vbl, 4);
                }
                this.setObj1(null);
            } else {
                this.err(State11.getEnum("cseUpgradeOpStatus", opStatus));
            }
        }
    }
}

