/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.upgrade.u3_0_3;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.ImageSpec;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.State11;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.Upgrade;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.UpgradeImpactRenderer;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.UIManager;

class State12
extends State11 {
    static final int CHECK_UPGRADE_STATE = 300;
    static final int CHECK_IMAGE_STATE = 301;
    static final int CLEAN_IMAGE_STATE = 302;
    static final int SET_IMAGE_STATE = 303;
    static final int CHECK_VER_STATE = 304;
    static final int POLL_VER_STATE = 305;
    static final int READ_VER_STATE = 306;
    static final int START_INCOMPAT_STATE = 307;
    static final int POLL_INCOMPAT_STATE = 308;
    static final int READ_INCOMPAT_STATE = 309;
    static final int FIRE_UPGRADE_STATE = 310;
    static final int POLL_UPGRADE_STATE = 311;
    static final int CHECK_11_STATE = 312;
    static final int CHECK_10_STATE = 313;
    static final int CLEANUP_STATE = 314;
    static final int CMD_DONE_STATE = 315;
    static final int CMD_ERR_STATE = 316;
    static final int POLL_DONE_STATE = 317;
    static final int CHECK_AUTOSYNC_STATE = 318;
    private static final int TABLE_HEIGHT = 150;
    static final String READ_AUTOSYNC_ACTION = "Reading autosync value";
    static final String SET_AUTOSYNC_ACTION = "Disable autosync";
    static final String READ_ACTION = "Checking if we can start install";
    static final String READ_IMAGE_ACTION = "Checking old image locations";
    static final String CLEAN_IMAGE_ACTION = "Cleaning old image locations";
    static final String IMAGE_ACTION = "Setting the new image locations";
    static final String VER_ACTION = "Version compatibility check";
    static final String READ_VER_ACTION = "Reading version compatibility check results";
    static final String START_INCOMPAT_ACTION = "Starting HA incompatibility check";
    static final String READ_INCOMPAT_ACTION = "Reading HA incompatibility check results";
    static final String UP_ACTION = "Install ";
    static final String ABORT_ACTION = "Aborting hitless install";
    static final String ABORT_FAILED_STATUS = "Abort Failure";
    static final String CHECK11_STATUS = "InProgress Checking 1.1(x) status";
    static final String CHECK10_STATUS = "InProgress Checking 1.0(x) status";
    static final String SUCCESS_RESET_STATUS = "Success Reset ";
    static final String CANCEL_TIMEDOUT_STATUS = "Cancelled  timedout waiting for input";
    static final String FINISH_READ_VER_ACTION = "Finished reading version compatibility check results";
    static final String[] VER_VARS = new String[]{"ciuVersionCompImageSame", "ciuVersionCompUpgradable", "ciuVersionCompUpgradeAction", "ciuVersionCompUpgradeBios", "ciuVersionCompUpgradeBootrom", "ciuVersionCompUpgradeLoader", "ciuVersionCompUpgradeImpact", "ciuVersionCompUpgradeReason"};
    static final String[] VER_COLS = new String[]{"Module", "Bootable", "UpgradeRequired", "Impact", "InstallType"};
    static final String[] STATUS_VARS = new String[]{"ciuUpgradeOpStatusOperation", "ciuUpgradeOpStatusModule", "ciuUpgradeOpStatusSrcImageLoc", "ciuUpgradeOpStatusDestImageLoc", "ciuUpgradeOpStatusJobStatus", "ciuUpgradeOpStatusPercentCompl", "ciuUpgradeOpStatusJobStatusReas"};
    static final String[] STATUS_COLS = new String[]{"Operation", "Module", "SourceImageLocation/Addtional Info", "DestImageLocation", "JobStatus", "Complete %", "FailureCause"};
    static final String[] CHECK_VARS = new String[]{"ciscoImgChkFeatureName", "ciscoImgChkCapabilityName", "ciscoImgChkCapabilityReq", "ciscoImgChkInCompDesr"};
    static final String[] CHECK_COLS = new String[]{"Feature", "Capability", "IncompatibilityType", "Description"};
    static final String[] MISC_VARS = new String[]{"ciuUpgradeMiscInfoModule", "ciuUpgradeMiscInfoDescr"};
    static final String[] MISC_COLS = new String[]{"Module", "Description"};
    static int[] _autoSyncOid = State12.getOids("cseSysAutoSync");
    static int[] _cmdOid = State12.getOids("ciuUpgradeOpCommand");
    static int[] _cmdStatusOid = State12.getOids("ciuUpgradeOpStatus");
    static int[] _imageRowStatusOid = State12.getOids("ciuImageLocInputEntryStatus");
    static int[] _imageUriOid = State12.getOids("ciuImageLocInputURI");
    static int[] _statusOid = State12.getOids("ciuUpgradeOpStatusOperation");
    static int[] _verOid = State12.getOids("ciuVersionCompImageSame");
    static int[] _checkRowOid = State12.getOids("ciscoImageCheckEntryStatus");
    static int[] _checkStatusOid = State12.getOids("ciscoImageCheckStatus");
    static int[] _checkResultsOid = State12.getOids("ciscoImgChkFeatureName");
    static int[] _miscInfoOid = State12.getOids("ciuUpgradeMiscInfoModule");
    static int[] _partUpgradeTargetOid = State12.getOids("ciuUpgradeTargetAction");
    static int[] _partUpgradeStatusOid = State12.getOids("ciuUpgradeTargetEntryStatus");
    Array _moreStatus;
    Array _vercheckData = new Array();
    Array _incompatData = new Array();
    Array _miscInfoData = new Array();
    int _prevState;
    int _nextState;
    String _errMsg;
    int _installTime;
    long _responseTime;
    int _pardise_restart_polling_count;
    boolean _NOOP4NONE = false;

    static int[] varNameToIndex(String name) {
        int[] index = new int[name.length() + 1];
        index[0] = name.length();
        for (int i = 0; i < name.length(); ++i) {
            index[i + 1] = name.charAt(i);
        }
        return index;
    }

    @Override
    Array getMoreStatus() {
        return this._moreStatus;
    }

    @Override
    void buildMiscInfoAllData() {
        this.getLogger().debug((Object)(this.getSwName() + ", State 12 buildMiscInfoAllData ..."));
        if (this._miscInfoData != null && this._miscInfoData.size() != 0) {
            Object[] rowHeader = new Object[MISC_COLS.length];
            rowHeader[0] = this.getSwName() + " - Additional Information\n";
            this.getLogger().debug((Object)(this.getSwName() + ", buildMiscInfoAllData log to _miscInfoAllData, header: " + rowHeader));
            this._up._miscInfoAllData.addElement(rowHeader);
            for (int i = 0; i < this._miscInfoData.size(); ++i) {
                this._up._miscInfoAllData.addElement(this._miscInfoData.elementAt(i));
                this.getLogger().debug((Object)(this.getSwName() + ", buildMiscInfoAllData log to _miscInfoAllData: " + this._miscInfoData.elementAt(i)));
            }
        }
    }

    @Override
    void buildIncompatInfoAllData() {
        this.getLogger().debug((Object)(this.getSwName() + ", State 12 buildIncompatInfoAllData ..."));
        if (this._incompatData != null && this._incompatData.size() != 0) {
            Object[] rowHeader = new Object[CHECK_COLS.length];
            rowHeader[0] = this.getSwName() + " - Incompatiblity Results\n";
            this.getLogger().debug((Object)(this.getSwName() + ", buildIncompatInfoAllData log to _incompatAllData, header: " + rowHeader));
            this._up._incompatAllData.addElement(rowHeader);
            for (int i = 0; i < this._incompatData.size(); ++i) {
                this._up._incompatAllData.addElement(this._incompatData.elementAt(i));
                this.getLogger().debug((Object)(this.getSwName() + ", buildIncompatInfoAllData log to _incompatAllData: " + this._incompatData.elementAt(i)));
            }
        }
    }

    State12(Switch sw, Upgrade up) {
        super(sw, up);
    }

    @Override
    void setInitState() {
        this._moreStatus = null;
        this._vercheckData = new Array();
        this._incompatData = new Array();
        this._miscInfoData = new Array();
        this._errMsg = null;
        this._pardise_restart_polling_count = 0;
        this._NOOP4NONE = false;
        super.setInitState();
    }

    @Override
    void err(String msg) {
        this._prevState = this._state;
        this._state = 316;
        this._errMsg = "Failure " + msg;
        this.setStatus(this._errMsg);
    }

    @Override
    void genErr(SnmpSession session, SnmpPDU pdu) {
        this._prevState = this._state;
        super.genErr(session, pdu);
    }

    @Override
    void getGenErrorCb(VarBindList vbl) {
        this._NOOP = false;
        this.getLogger().debug((Object)(this.getSwName() + ", State 12 getGenErrorCb setShowStatus true,  _NOOP = " + this._NOOP));
        this.setShowStatus(this._nextState != 317);
        this._state = 316;
        this._errMsg = !vbl.isNull(0) ? "Failure " + vbl.stringValue(0) : "Failure " + GENERR;
        this.setStatus(this._errMsg);
    }

    @Override
    void tick() {
        try {
            this._installTime += 3000;
            if (this.isCommonState() || this._state == 100) {
                if (this._state == 100) {
                    this.getLogger().debug((Object)(this.getSwName() + "State12 tick() _state/_prevState : " + this._state + "/" + this._prevState + "    ignore snmp response, maybe delay response"));
                }
                super.tick();
                return;
            }
            if (this._snmpTimeouts == 0 && (this.genErrOccurred() || this.abortOccurred() || !this.isUp())) {
                return;
            }
            this.getLogger().debug((Object)(this.getSwName() + "State12 tick() _state/_prevState : " + this._state + "/" + this._prevState + "    _NOOP = " + this._NOOP));
            if (this._NOOP) {
                return;
            }
            this.getLogger().debug((Object)("State12 tick() _state : " + this._state));
            long snmpTimeoutElapse = this._snmpTimeoutStamp == 0L ? 0L : System.currentTimeMillis() - this._snmpTimeoutStamp;
            this.getLogger().debug((Object)("State12 timeouts " + this._snmpTimeouts + "/timeout elapse " + snmpTimeoutElapse + "    (" + snmpTimeoutElapse / 1000L + " sec )"));
            long snmpUnknownUserElapse = this._snmpUnknownUserTimeStamp == 0L ? 0L : System.currentTimeMillis() - this._snmpUnknownUserTimeStamp;
            this.getLogger().debug((Object)("State12 unknownUser elapse " + this._snmpUnknownUserTimeStamp + "    (" + snmpUnknownUserElapse / 1000L + " sec )"));
            if (snmpTimeoutElapse > 900000L || snmpUnknownUserElapse > 120000L) {
                String msg;
                String title = this._state == 311 ? "Install Error" : "Error";
                this.getLogger().debug((Object)"State12 tick()  timeout!  prompt user");
                String string = msg = snmpUnknownUserElapse > 90000L ? "UnknownUser snmp error, please make sure snmp user config or AAA config is ready.\nDo you want to abort this install?" : "Install is timing out, please make sure the management interface on the supervisor is connected.\nDo you want to abort this install?";
                if (this._up.getParallelInstall() || this._up.askUser(msg, title)) {
                    if (this._up.getParallelInstall()) {
                        this.getLogger().debug((Object)(this.getSwName() + " " + title + ": no User Prompt, msg = " + msg));
                    }
                    this.getLogger().debug((Object)("state " + this._state + " timeout  user input : abort"));
                    this._errMsg = this._up.getParallelInstall() ? (msg.startsWith("UnknownUser") ? "UnknownUser snmp error" : "Timedout") : "aborted";
                    this._abortState = 1;
                    this._snmpTimeouts = 0;
                    this._snmpTimeoutStamp = 0L;
                    this._snmpUnknownUserTimeStamp = 0L;
                    return;
                }
                this.getLogger().debug((Object)("state " + this._state + " timeout   user input : continue"));
                this._snmpTimeouts = 0;
                this._snmpTimeoutStamp = 0L;
                this._snmpUnknownUserTimeStamp = 0L;
            }
            switch (this._state) {
                case 8: {
                    if (this._hotStandby && this.getSwitch().getVersion().startsWith("1.2(0)")) {
                        this.readAutoSync();
                        this._nextState = 318;
                        break;
                    }
                    this._state = 300;
                }
                case 300: {
                    this.readUpgradeOpCmd();
                    this._nextState = 301;
                    break;
                }
                case 318: {
                    int autoSync = (Integer)this.getObj1();
                    if (autoSync == 1) {
                        if (this._up.getParallelInstall() || this._up.askUser(this.getSwName() + ": Disable auto-sync?", this.getSwName() + " - AutoSync On")) {
                            if (this._up.getParallelInstall()) {
                                this.getLogger().debug((Object)(this.getSwName() + "AutoSync On: no User Prompt, msg = Disable auto-sync?"));
                            }
                            this.disableAutoSync();
                            this._nextState = 300;
                            break;
                        }
                        this.setStatus("cancelled");
                        this._state = 100;
                        break;
                    }
                    this._state = 300;
                    this.tick();
                    break;
                }
                case 301: {
                    this.readImageLocTable();
                    this._nextState = 302;
                    break;
                }
                case 302: {
                    if (this.oldImageTableExists()) {
                        this.cleanImageLocTable();
                        this._nextState = 303;
                        break;
                    }
                    this._state = 303;
                    break;
                }
                case 303: {
                    this.setImageLocTable();
                    this._nextState = 304;
                    break;
                }
                case 304: {
                    this.startVersionCheck();
                    this._nextState = 305;
                    break;
                }
                case 305: {
                    if (!this.doneUpgradeOpCmd()) {
                        this.pollUpgradeOpStatus();
                        this.readUpgradeStatus();
                        break;
                    }
                    this._state = 306;
                }
                case 306: {
                    this.readVersionCheckTable();
                    if (this.getSwitch().isVersionGreaterThanEqual("1.3(0)")) {
                        this.readMiscInfoTable();
                    }
                    this._nextState = 307;
                    this._responseTime = System.currentTimeMillis();
                    break;
                }
                case 307: {
                    this.startIncompatibilityCheck();
                    if (this.getObj2() != null) {
                        this._nextState = 308;
                        break;
                    }
                    this._state = 308;
                    break;
                }
                case 308: {
                    if (!this.doneIncompatibilityCheck()) {
                        this.pollIncompatibilityCheck();
                        break;
                    }
                    this._state = 309;
                }
                case 309: {
                    if (this.getObj2() != null) {
                        this.readIncompatibilityCheckResults((int[])this.getObj2());
                        this._nextState = 310;
                    } else {
                        this._state = 310;
                    }
                    this._responseTime = System.currentTimeMillis();
                    break;
                }
                case 310: {
                    if (this.okVersion()) {
                        this._installTime = 0;
                        this.startUpgrade();
                        this._nextState = 311;
                        break;
                    }
                    if (this._up.getIgnoreInstall()) {
                        this.setAction(FINISH_READ_VER_ACTION);
                        this.setStatus("");
                        this._errMsg = null;
                        this._state = 315;
                        this.tick();
                        break;
                    }
                    this._errMsg = "cancelled";
                    if (this._bootable) {
                        this._state = 315;
                    } else {
                        this._prevState = this._state;
                        this._state = 316;
                    }
                    this.tick();
                    break;
                }
                case 311: {
                    if (!this.doneUpgradeOpCmd()) {
                        this.getLogger().debug((Object)("State12 POLL_UPGRADE_STATE timeouts/timeout elapse/_hotStandby/_installTime " + this._snmpTimeouts + "/" + snmpTimeoutElapse + "    (" + snmpTimeoutElapse / 1000L + " sec )/" + this._hotStandby + "/" + this._installTime));
                        if (this._hotStandby && this._installTime > 600 && snmpTimeoutElapse > 600000L && this._snmpTimeouts > 100) {
                            boolean reboot;
                            String actMsg = this.getAction();
                            this.getLogger().debug((Object)(this.getSwName() + ": POLL_UPGRADE_STATE, hardstandby timeout " + actMsg + "  ,timeoutElapse " + snmpTimeoutElapse));
                            boolean bl = reboot = actMsg.indexOf("switchover") != -1 || actMsg.indexOf("rebooting") != -1;
                            if (reboot) {
                                this.getLogger().debug((Object)(this.getSwName() + ": POLL_UPGRADE_STATE, hardstandby timeout " + actMsg + ", switchover/rebooting, prompt user"));
                                String msg = "Install is timing out, please make sure the management interface on the supervisor is connected.\nDo you want to abort this install?";
                                if (this._up.getParallelInstall() || this._up.askUser(msg, "Install Error")) {
                                    if (this._up.getParallelInstall()) {
                                        this.getLogger().debug((Object)(this.getSwName() + " Install Error: no User Prompt, msg = " + msg));
                                    }
                                    this.getLogger().debug((Object)(this.getSwName() + ": install timeout  user input : abort"));
                                    this._errMsg = this._up.getParallelInstall() ? "Timedout" : "aborted";
                                    this._abortState = 1;
                                    return;
                                }
                                this.getLogger().debug((Object)(this.getSwName() + ": install timeout  user input : continue"));
                                this._installTime = 0;
                                this._snmpTimeouts = 0;
                            }
                        }
                        this.pollUpgradeOpStatus();
                        this.readUpgradeStatus();
                        break;
                    }
                    this._state = 315;
                    this.tick();
                    break;
                }
                case 312: {
                    this.check11UpgradeStatus();
                    this._nextState = 313;
                    break;
                }
                case 313: {
                    this.check10UpgradeStatus();
                    this._nextState = 100;
                    break;
                }
                case 315: 
                case 316: {
                    if (this._state == 316) {
                        if (this._prevState <= 304 || this._prevState > 311) {
                            this._state = 314;
                            this.tick();
                            break;
                        }
                        this._state = 315;
                    }
                    this.getLogger().debug((Object)(this.getSwName() + ": CMD_ERR_STATE setShowStatus false"));
                    this.setShowStatus(false);
                    this.writeUpgradeOpCmd(2);
                    this._NOOP4NONE = false;
                    this._nextState = 317;
                    break;
                }
                case 317: {
                    if (!this.doneUpgradeOpCmd()) {
                        this.pollUpgradeOpStatus();
                        this.readUpgradeStatus();
                        break;
                    }
                    this._state = 314;
                }
                case 314: {
                    if (this._errMsg != null) {
                        this.setStatus(this._errMsg);
                    } else {
                        this.setStatus("Success ");
                    }
                    if (this._abortState == 1) {
                        this._abortState = 3;
                    }
                    this.cleanup();
                    this._state = 100;
                    try {
                        if (this._errMsg == null) {
                            ClientController.getInstance().rediscover();
                        }
                        break;
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error((Object)"State12 tick(), Exception ", (Throwable)ex);
        }
    }

    @Override
    String snmpRequestOtherErr(SnmpPeer peer, int reqid, SnmpPDU pdu, String errMsg) {
        this.getLogger().debug((Object)(this.getSwName() + ": snmpRequestOtherErr reqid/errMsg/_NOOP/command = " + reqid + "/" + errMsg + "/" + this._NOOP + "/" + pdu.getCommand()));
        if (pdu.getCommand() == -93) {
            int[] firstOid = pdu.getVariables().getVb(0).getOid().getValue();
            this._NOOP = false;
            this.getLogger().debug((Object)(this.getSwName() + ": snmpRequestOtherErr " + firstOid));
            this._errMsg = "cmd " + errMsg + ".";
            this.getLogger().debug((Object)(this.getSwName() + ": cmd snmp error, posted err, go cleanup !"));
            this._state = 314;
            this.tick();
        }
        if (this._state == 7 && pdu.getError() == 20) {
            this._errMsg = "Failed FlashCopy. Please try to run again at a later time.";
            this.getLogger().debug((Object)(this.getSwName() + ": snmpRequestOtherErr, flashCopy entry NoSuchInstance, maybe due to earlier SET failed, posted err, go cleanup !"));
            super.err(this._errMsg);
        }
        if (this._NOOP) {
            this.getLogger().debug((Object)(this.getSwName() + ": snmpRequestOtherErr, reset _NOOP, state : " + this._state + ", reset _NOOP, continue"));
            this._NOOP = false;
            this.tick();
        }
        return errMsg;
    }

    @Override
    String snmpRequestTimedOut(SnmpPeer peer, int reqid, SnmpPDU pdu) {
        block11: {
            this.getLogger().debug((Object)(this.getSwName() + "pdu/NOOP " + reqid + "/" + this._NOOP + ": State 12 snmpRequestTimedOut ---------"));
            int[] firstOid = pdu.getVariables().getVb(0).getOid().getValue();
            try {
                if (pdu.getCommand() == -93) {
                    this.getLogger().debug((Object)(this.getSwName() + "  timeout cmd: " + MibNode.oidToName(firstOid) + "(" + SnmpOID.toString(firstOid) + ")"));
                    if (SnmpOID.startsWith(firstOid, _flashRowStatusOid)) {
                        this.startFlashCopyCb(null);
                        this.getLogger().debug((Object)(this.getSwName() + ", flashCopy rowStatus SET timedout, ignore !"));
                        this._NOOP = false;
                    } else {
                        this._errMsg = "cmd Timeout . Please try to run again at a later time.";
                        this.getLogger().debug((Object)(this.getSwName() + ", cmd timed out, posted err, go cleanup !"));
                        this._state = 314;
                        this._NOOP = false;
                        this.tick();
                    }
                }
                if (this._state == 7 && SnmpOID.startsWith(firstOid, _flashStatusOid)) {
                    if (this._snmpTimeoutsFlashCopy > 3) {
                        String errMsg = "flashCopy Timeout ";
                        this.getLogger().debug((Object)(this.getSwName() + ", flashCopy timed out, posted err, go cleanup !"));
                        super.err(errMsg);
                    }
                    ++this._snmpTimeoutsFlashCopy;
                    this.getLogger().debug((Object)(this.getSwName() + ": " + reqid + ", State 12 snmpRequestTimedOut flashCopy timeout  _snmpTimeoutsFlashCopy " + this._snmpTimeoutsFlashCopy));
                    this._NOOP = false;
                }
                if (this.abortOccurred(false)) {
                    this.getLogger().debug((Object)(this.getSwName() + ", State 12 snmpRequestTimedOut, _abortState == INITIATE_ABORT"));
                    this._NOOP = false;
                    this.tick();
                }
                if (this._NOOP) {
                    this.getLogger().debug((Object)(this.getSwName() + ": State 12 snmpRequestTimedOut _NOOP true, state : " + this._state + ", reset _NOOP, continue"));
                    this._NOOP = false;
                    this.tick();
                }
            }
            catch (Exception ex) {
                this.getLogger().error((Object)(this.getSwName() + ", State 12 snmpRequestTimedOut ex " + ex.toString()));
                if (pdu == null) {
                    this.getLogger().error((Object)(this.getSwName() + ", State 12 snmpRequestTimedOut pdu == null"));
                }
                this.getLogger().error((Object)(this.getSwName() + ", State 12 snmpRequestTimedOut reqid = " + pdu.getReqid()));
                if (pdu.getVariables() == null) {
                    this.getLogger().error((Object)(this.getSwName() + ", State 12 snmpRequestTimedOut pdu vbl == null"));
                }
                if (pdu.getVariables().size() != 0) break block11;
                this.getLogger().error((Object)(this.getSwName() + ", State 12 snmpRequestTimedOut pdu vbl size 0 !"));
            }
        }
        peer.checkSnmpConnection();
        return "Timeout ";
    }

    @Override
    synchronized void handleCb(VarBindList vbl) {
        this.getLogger().debug((Object)(this.getSwName() + ", State 12 handlCb --------- State/nextState = " + this._state + "/" + this._nextState));
        if (vbl.size() != 0) {
            SnmpVarBind firstVb = vbl.getVb(0);
            int[] firstOid = firstVb.getOid().getValue();
            MibNode.oidToName(firstOid);
            this.getLogger().debug((Object)(this.getSwName() + ", State 12 handlCb firstOid = " + MibNode.oidToName(firstOid) + "  " + SnmpOID.toString(firstOid)));
            if (SnmpOID.startsWith(firstOid, _autoSyncOid)) {
                this.autoSyncCb(vbl);
            } else if (SnmpOID.startsWith(firstOid, _cmdOid)) {
                this._NOOP = false;
                this.getLogger().debug((Object)(this.getSwName() + ", upgradeOpCmdCb reset _NOOP = " + this._NOOP));
                this.upgradeOpCmdCb(vbl);
            } else if (SnmpOID.startsWith(firstOid, _imageRowStatusOid)) {
                this._NOOP = false;
                this.getLogger().debug((Object)(this.getSwName() + ", upgradeOpCmdCb reset _NOOP = " + this._NOOP));
                this.setImageLocTableCb(vbl);
            } else if (SnmpOID.startsWith(firstOid, _cmdStatusOid)) {
                this.pollUpgradeOpStatusCb(vbl);
            } else if (SnmpOID.startsWith(firstOid, _statusOid)) {
                this.readUpgradeStatusCb(vbl);
            } else if (SnmpOID.startsWith(firstOid, _verOid)) {
                this.readVersionCheckCb(vbl);
            } else if (SnmpOID.startsWith(firstOid, _checkRowOid)) {
                this.startIncompatibilityCheckCb(vbl);
            } else if (SnmpOID.startsWith(firstOid, _checkStatusOid)) {
                this.pollIncompatibilityCheckCb(vbl);
            } else if (SnmpOID.startsWith(firstOid, _checkResultsOid)) {
                this._NOOP = false;
                this.getLogger().debug((Object)(this.getSwName() + ", upgradeOpCmdCb reset _NOOP = " + this._NOOP));
                this.readIncompatiblityCheckResultsCb(vbl);
            } else if (SnmpOID.startsWith(firstOid, _imageUriOid)) {
                this.readImageLocTableCb(vbl);
            } else if (SnmpOID.startsWith(firstOid, _upStatusOid)) {
                this.check11UpgradeStatusCb(vbl);
            } else if (SnmpOID.startsWith(firstOid, _miscInfoOid)) {
                this.readMiscInfoTableCb(vbl);
            } else {
                super.handleCb(vbl);
            }
        }
        if (this._state == 309 && this._NOOP) {
            this._NOOP = false;
            this.getLogger().debug((Object)(this.getSwName() + ",State12 end handlCb callback for _state READ_INCOMPAT_STATE, reset _NOOP"));
        }
        if (this._nextState != 0 && this.isUp() && this._state != 102 && this._state != 316) {
            this.getLogger().debug((Object)(this.getSwName() + "State 12 handlCb  moving _state " + this._state + " to _nextState " + this._nextState));
            this._state = this._nextState;
            this._nextState = 0;
        }
    }

    void readAutoSync() {
        try {
            SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
            pdu.setLogger(this.getLogger());
            pdu.addVar(new SnmpOID(_autoSyncOid, ZEROINDEX));
            pdu.setRetries(0);
            this.setAction(READ_AUTOSYNC_ACTION);
            this.setStatus("");
            this.setObj1(null);
            this.getLogger().debug((Object)(this.getSwName() + ", readAutoSync sending pdu..."));
            this.getSwitch().getPeer().send(pdu, this);
            this.sentSnmpReq(false);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    void disableAutoSync() {
        try {
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
            pdu.setLogger(this.getLogger());
            pdu.addVar(new SnmpOID(_autoSyncOid, ZEROINDEX), new SnmpInt(2));
            pdu.setIgnoreSetCount(true);
            this.setAction(SET_AUTOSYNC_ACTION);
            this.setStatus("");
            this.getLogger().debug((Object)(this.getSwName() + ", disableAutoSync sending pdu..."));
            this.getSwitch().getPeer().send(pdu, this);
            this.sentSnmpReq(false);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    void autoSyncCb(VarBindList vbl) {
        if (this.getObj1() == null) {
            this.setObj1(new Integer(vbl.intValue(0)));
        } else {
            this.setObj1(null);
        }
    }

    void readUpgradeOpCmd() {
        try {
            SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
            pdu.setLogger(this.getLogger());
            pdu.addVar(new SnmpOID(_cmdOid, ZEROINDEX));
            pdu.setRetries(0);
            this.setAction(READ_ACTION);
            this.setStatus("");
            this.getLogger().debug((Object)(this.getSwName() + ", readUpgradeOpCmd sending pdu..."));
            this.getSwitch().getPeer().send(pdu, this);
            this.sentSnmpReq(false);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    void writeUpgradeOpCmd(int cmd) {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setLogger(this.getLogger());
        pdu.addVar(new SnmpOID(_cmdOid, ZEROINDEX), new SnmpInt(cmd));
        pdu.addVar(new SnmpOID(State12.getOids("ciuUpgradeOpNotifyOnCompletion"), ZEROINDEX), new SnmpInt(1));
        pdu.setIgnoreSetCount(true);
        try {
            this.setObj1(this.buildPollPdu());
            this.getLogger().debug((Object)(this.getSwName() + ", writeUpgradeOpCmd sending pdu..."));
            this._NOOP = true;
            this.getLogger().debug((Object)(this.getSwName() + ", cmd " + cmd + " _NOOP = " + this._NOOP));
            this.getSwitch().getPeer().send(pdu, this);
            this.sentSnmpReq(false);
        }
        catch (SnmpException ex) {
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    SnmpPDU buildPollPdu() {
        SnmpPDU pollPdu = new SnmpPDU(-96, new VarBindList());
        pollPdu.setLogger(this.getLogger());
        pollPdu.addVar(new SnmpOID(_cmdStatusOid, ZEROINDEX));
        pollPdu.addVar(new SnmpOID(State12.getOids("ciuUpgradeOpStatusReason"), ZEROINDEX));
        pollPdu.addVar(new SnmpOID(State12.getOids("ciuUpgradeOpLastCommand"), ZEROINDEX));
        pollPdu.addVar(new SnmpOID(State12.getOids("ciuUpgradeOpLastStatus"), ZEROINDEX));
        pollPdu.addVar(new SnmpOID(State12.getOids("ciuUpgradeOpLastStatusReason"), ZEROINDEX));
        pollPdu.setRetries(0);
        this.buildGenericSwitch(pollPdu);
        return pollPdu;
    }

    boolean doneUpgradeOpCmd() {
        return this.getObj1() == null;
    }

    void startUpgrade() {
        this.setAction(UP_ACTION);
        this.setStatus("");
        this.writeUpgradeOpCmd(3);
        this._NOOP4NONE = this.getSwitch().getModelType() == 587 || this.getSwitch().getModelType() == 651 || this.getSwitch().getModelType() == 616 || this.getSwitch().getModelType() == 601 || this.getSwitch().getModelType() == 606 || this.getSwitch().getModelType() == 773 || this.getSwitch().getModelType() == 843 || this.getSwitch().getModelType() == 841;
    }

    void upgradeOpCmdCb(VarBindList vbl) {
        boolean preCheck;
        boolean bl = preCheck = this.getObj1() == null && this.getObj2() == null;
        if (preCheck) {
            int cmd = vbl.intValue(0);
            if (cmd != 1) {
                this.err("InProgress ");
            } else {
                this.setStatus("Success ");
            }
        } else {
            this.setStatus("Success ");
        }
    }

    void delImageLocTable() {
        ImageSpec spec = this._up.getImage(this._sw, this.getSwitch());
        String[] vars = spec.getVars();
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setLogger(this.getLogger());
        pdu.setIgnoreSetCount(true);
        for (int i = 0; i < vars.length; ++i) {
            int[] index = State12.varNameToIndex(vars[i]);
            pdu.addVar(new SnmpOID(_imageRowStatusOid, index), new SnmpInt(6));
        }
        try {
            this.setAction(IMAGE_ACTION);
            this.setStatus("");
            this.getLogger().debug((Object)(this.getSwName() + ", delImageLocTable sending pdu..."));
            this.getSwitch().getPeer().send(pdu, DUMMY_CB);
        }
        catch (SnmpException ex) {
            // empty catch block
        }
    }

    void readImageLocTable() {
        VarBindList vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(new SnmpOID(_imageUriOid)));
        this.setAction(READ_IMAGE_ACTION);
        this.setStatus("");
        this.setObj1(null);
        try {
            this.getLogger().debug((Object)(this.getSwName() + ", readImageLocTable sending pdu..."));
            new SnmpFetch(this.getLogger()).getBulk(this.getSwitch().getPeer(), vbl, this, 0);
            this.sentSnmpReq(false);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    void readImageLocTableCb(VarBindList vbl) {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setLogger(this.getLogger());
        pdu.setIgnoreSetCount(true);
        pdu.setRetries(0);
        for (int i = 0; i < vbl.size(); ++i) {
            int[] oids = vbl.getVb(i).getOid().getValue();
            int[] index = new int[oids.length - _imageUriOid.length];
            System.arraycopy(oids, _imageUriOid.length, index, 0, index.length);
            pdu.addVar(new SnmpOID(_imageRowStatusOid, index), new SnmpInt(6));
        }
        this.setObj1(pdu);
    }

    boolean oldImageTableExists() {
        return this.getObj1() != null;
    }

    void cleanImageLocTable() {
        SnmpPDU pdu = (SnmpPDU)this.getObj1();
        this.setObj1(null);
        try {
            this.setAction(CLEAN_IMAGE_ACTION);
            this.setStatus("");
            this.getLogger().debug((Object)(this.getSwName() + ", cleanImageLocTable sending pdu..."));
            this.getSwitch().getPeer().send(pdu, this);
            this.sentSnmpReq(false);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    void setImageLocTable() {
        ImageSpec spec = this._up.getImage(this._sw, this.getSwitch());
        String[] vars = spec.getVars();
        String[] vals = spec.getVals();
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setLogger(this.getLogger());
        pdu.setIgnoreSetCount(true);
        for (int i = 0; i < vars.length; ++i) {
            int[] index = State12.varNameToIndex(vars[i]);
            if (vals[i] == null || vals[i].length() == 0) continue;
            pdu.addVar(new SnmpOID(_imageRowStatusOid, index), new SnmpInt(4));
            pdu.addVar(new SnmpOID(State12.getOids("ciuImageLocInputURI"), index), new SnmpString(spec.getFlashUri(this.getSwitch(), i, this._up.skipDownload())));
        }
        try {
            this.setAction(IMAGE_ACTION);
            this.setStatus("");
            this.getLogger().debug((Object)(this.getSwName() + ", setImageLocTable sending pdu..."));
            this.getLogger().debug((Object)(this.getSwName() + ", setImageLocTable sending pdu..."));
            this._NOOP = true;
            this.getLogger().debug((Object)(this.getSwName() + ", setImageLocTable _NOOP = " + this._NOOP));
            this.getSwitch().getPeer().send(pdu, this);
            this.sentSnmpReq(false);
        }
        catch (SnmpException ex) {
            // empty catch block
        }
    }

    void setImageLocTableCb(VarBindList vbl) {
        this.setStatus("Success ");
    }

    void startVersionCheck() {
        this.setAction(VER_ACTION);
        this.setStatus("");
        this.writeUpgradeOpCmd(4);
        this._NOOP4NONE = this.getSwitch().getModelType() == 587 || this.getSwitch().getModelType() == 651 || this.getSwitch().getModelType() == 616 || this.getSwitch().getModelType() == 601 || this.getSwitch().getModelType() == 606 || this.getSwitch().getModelType() == 773 || this.getSwitch().getModelType() == 843 || this.getSwitch().getModelType() == 841;
    }

    void readVersionCheckTable() {
        VarBindList vbl = new VarBindList(VER_VARS.length);
        for (int i = 0; i < VER_VARS.length; ++i) {
            vbl.add(new SnmpVarBind(State12.getOid(VER_VARS[i])));
        }
        try {
            this.setAction(READ_VER_ACTION);
            this.setStatus("");
            this.getLogger().debug((Object)(this.getSwName() + ", readVersionCheckTable sending pdu..."));
            new SnmpFetch(this.getLogger()).getBulk(this.getSwitch().getPeer(), vbl, this, 0);
            this.sentSnmpReq(false);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    void printData(String title, Array data) {
        if (data.size() > 0) {
            this.getLogger().error((Object)(this.getSwName() + " " + title));
            for (int i = 0; i < data.size(); ++i) {
                Object[] row = (Object[])data.elementAt(i);
                for (int j = 0; j < row.length; ++j) {
                    this.getLogger().debug((Object)(this.getSwName() + ": " + row[j]));
                    this.getLogger().debug((Object)(this.getSwName() + ": \t  "));
                }
                this.getLogger().debug((Object)"");
            }
        }
    }

    boolean okVersion() {
        this._isDoneVersionCheck = true;
        if (this._up.getIgnoreVersion() || this._up.getIgnoreInstall()) {
            this.printData("Version Check", this._vercheckData);
            this.printData("HA InCompatibilty Check", this._incompatData);
            this.printData("Misc Info", this._miscInfoData);
            return !this._up.getIgnoreInstall();
        }
        JPanel panel = new JPanel(new BorderLayout());
        SnmpKTable table = this.buildTable(VER_COLS, this._vercheckData);
        table.getColumnModel().getColumn(3).setCellRenderer(new UpgradeImpactRenderer());
        JScrollPane sp = new JScrollPane(table);
        Dimension prefSize = table.calcPreferredSize();
        prefSize.height = 150;
        sp.setPreferredSize(new Dimension(prefSize.width, prefSize.height));
        JPanel topPanel = new JPanel(new BorderLayout());
        String time = DateFormat.getInstance().format(new Date());
        int waitTime = this.getSwitch().isVersionGreaterThanEqual("3.2(2)") ? 15 : 3;
        int waitSec = waitTime * 60;
        JLabel label = new JLabel("Please respond within " + waitTime + " minutes. " + "Time left " + waitSec + " seconds");
        Font normalFont = (Font)UIManager.getDefaults().get("Table.font");
        Font boldFont = new Font(normalFont.getName(), 1, normalFont.getSize());
        label.setFont(boldFont);
        topPanel.add("North", label);
        JLabel label2 = new JLabel(time);
        topPanel.add("Center", label2);
        topPanel.add("South", sp);
        panel.add("North", topPanel);
        if (this._incompatData.size() != 0) {
            JPanel iPanel = new JPanel(new BorderLayout());
            iPanel.add("North", new DialogSeparator("Incompatibilities"));
            table = this.buildTable(CHECK_COLS, this._incompatData);
            table.setAutoResizeMode(0);
            sp = new JScrollPane(table);
            table.colWidthToWidest();
            sp.setPreferredSize(new Dimension(prefSize.width, prefSize.height));
            iPanel.add("Center", sp);
            panel.add("Center", iPanel);
        }
        if (this._miscInfoData.size() != 0) {
            JPanel mPanel = new JPanel(new BorderLayout());
            mPanel.add("North", new DialogSeparator("Additional Information"));
            table = this.buildTable(MISC_COLS, this._miscInfoData);
            table.setAutoResizeMode(0);
            sp = new JScrollPane(table);
            table.colWidthToWidest();
            sp.setPreferredSize(new Dimension(prefSize.width, prefSize.height));
            mPanel.add("Center", sp);
            panel.add("South", mPanel);
        }
        this.getLogger().debug((Object)(this.getSwName() + ", VersionCheck dialog show, bootable " + this._bootable));
        String title = this.getSwName() + " - Version Check Results - " + (this._bootable ? "Upgrade?" : "Upgrade Wizard Restart Required");
        VersionDialog vd = new VersionDialog(title, label, panel, this._bootable);
        vd.show();
        if (vd.getAnswer()) {
            if (this._bootable) {
                this.getLogger().debug((Object)(this.getSwName() + ", VersionCheck user input YES & _bootble==true"));
                return true;
            }
            this.getLogger().debug((Object)(this.getSwName() + ", VersionCheck user input YES & _bootble==false"));
            this.setStatus("Failure ");
            JOptionPane.showMessageDialog(this._up._parent, "Cannot continue upgrading/downgrading, please restart the wizard", "UpgradeWizard Close", 0);
            return false;
        }
        if (vd.timedOut()) {
            this.getLogger().debug((Object)(this.getSwName() + ", VersionCheck user input timeout"));
            this.getLogger().debug((Object)(this.getSwName() + ", Timeout:  version check prompt"));
            this.setStatus(CANCEL_TIMEDOUT_STATUS);
            return false;
        }
        if (this._bootable) {
            this.getLogger().debug((Object)(this.getSwName() + ", VersionCheck user input NO"));
        } else {
            this.getLogger().debug((Object)(this.getSwName() + ", VersionCheck user input ok - not bootable"));
        }
        this.setStatus("Cancelled ");
        return false;
    }

    private SnmpKTable buildTable(String[] cols, Array data) {
        SnmpTableModel model = new SnmpTableModel();
        model.setData(data);
        model.setHeaders(cols);
        SnmpKTable table = new SnmpKTable(model);
        table.getTableHeader().addMouseListener(new HeaderListener());
        table.setSortable(true);
        table.addPopupMenu();
        return table;
    }

    void readVersionCheckCb(VarBindList vbl) {
        this._vercheckData.clear();
        Object[] rowHeader = new Object[VER_COLS.length];
        rowHeader[0] = this.getSwName() + " - Version Check Results\n";
        this._up._vercheckAllData.addElement(rowHeader);
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind vb = vbl.getVb(i);
            int[] oids = vb.getOid().getValue();
            int module = State12.moduleToSlot(oids[oids.length - 1]);
            boolean imageSame = vbl.intValue(i++) == 1;
            boolean bootable = vbl.intValue(i++) == 1;
            int action = vbl.intValue(i++);
            boolean bios = vbl.intValue(i++) == 1;
            boolean bootrom = vbl.intValue(i++) == 1;
            boolean loader = vbl.intValue(i++) == 1;
            int impact = vbl.intValue(i++);
            String reason = vbl.stringValue(i);
            Object[] row = new Object[VER_COLS.length];
            row[0] = new Integer(module);
            if (this._bootable) {
                this._bootable = bootable;
            }
            if (!bootable) {
                row[1] = "no";
                if (reason.length() != 0) {
                    row[1] = (String)row[1] + ", " + reason;
                }
                row[2] = "Upgrade Wizard Restart Required";
                row[3] = "n/a";
                row[4] = "n/a";
            } else {
                row[1] = "yes";
                Object object = row[2] = imageSame ? "no" : "yes";
                if (!imageSame && (bios || bootrom || loader)) {
                    row[2] = (String)row[2] + "(new";
                    if (bios) {
                        row[2] = (String)row[2] + " bios";
                    }
                    if (bootrom) {
                        row[2] = (String)row[2] + " bootrom";
                    }
                    if (loader) {
                        row[2] = (String)row[2] + " loader";
                    }
                    row[2] = (String)row[2] + ")";
                }
                row[3] = State12.getEnum("ciuVersionCompUpgradeImpact", impact);
                row[4] = State12.getEnum("ciuVersionCompUpgradeAction", action);
                if (action == 4 || action == 5) {
                    if (reason.length() != 0) {
                        row[4] = (String)row[4] + " " + reason;
                    }
                } else if (impact == 3 && reason.length() != 0) {
                    row[3] = (String)row[3] + " " + reason;
                }
            }
            this._vercheckData.addElement(row);
            this._up._vercheckAllData.addElement(row);
        }
    }

    void startIncompatibilityCheck() {
        ImageSpec spec = this._up.getImage(this._sw, this.getSwitch());
        String[] vars = spec.getVars();
        for (int i = 0; i < vars.length; ++i) {
            if (!vars[i].equals("system")) continue;
            SnmpString flashString = null;
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
            pdu.setLogger(this.getLogger());
            int[] index = new int[]{State12.random()};
            pdu.addVar(new SnmpOID(_checkRowOid, index), new SnmpInt(4));
            String specURIString = spec.getFlashUri(this.getSwitch(), i, this._up.skipDownload());
            try {
                if (specURIString == null || specURIString.trim().length() <= 0) {
                    this.setObj2(null);
                    return;
                }
                flashString = new SnmpString(specURIString);
            }
            catch (Exception possibleNumberFormatException) {
                this.getLogger().error((Object)(this.getSwName() + ", startIncompatibilityCheck: " + possibleNumberFormatException));
                if (SnmpSession.isTrace()) {
                    DefaultLogger._ExLogger.warn((Object)possibleNumberFormatException.getMessage(), (Throwable)possibleNumberFormatException);
                }
                this.setObj2(null);
                return;
            }
            pdu.addVar(new SnmpOID(State12.getOids("ciscoImageCheckImageName"), index), flashString);
            pdu.setIgnoreSetCount(true);
            SnmpPDU pollPdu = new SnmpPDU(-96, new VarBindList());
            pollPdu.setLogger(this.getLogger());
            pollPdu.addVar(new SnmpOID(_checkStatusOid, index));
            pollPdu.setRetries(0);
            try {
                if (flashString != null && flashString.toString().length() > 0) {
                    this.setAction(START_INCOMPAT_ACTION);
                    this.setStatus("");
                    this.setObj2(pollPdu);
                    this.getLogger().debug((Object)(this.getSwName() + ", startIncompatibilityCheck sending pdu..."));
                    this.getSwitch().getPeer().send(pdu, this);
                    this.sentSnmpReq(false);
                    continue;
                }
                this.setObj2(null);
                continue;
            }
            catch (SnmpException ex) {
                // empty catch block
            }
        }
    }

    boolean doneIncompatibilityCheck() {
        return this.getObj2() == null || !(this.getObj2() instanceof SnmpPDU);
    }

    void startIncompatibilityCheckCb(VarBindList vbl) {
        this._incompatData.clear();
    }

    void pollIncompatibilityCheck() {
        SnmpPDU pdu = (SnmpPDU)this.getObj2();
        try {
            pdu.setReqid(0);
            this.setStatus("InProgress Polling ");
            this.getLogger().debug((Object)(this.getSwName() + ", pollIncompatibilityCheck sending pdu..."));
            this.getSwitch().getPeer().send(pdu, this);
            this.sentSnmpReq(true);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    void pollIncompatibilityCheckCb(VarBindList vbl) {
        int status = vbl.intValue(0);
        if (status != 2) {
            int[] oids = vbl.getVb(0).getOid().getValue();
            int[] index = new int[]{oids[oids.length - 1]};
            this.setObj2(index);
        }
    }

    void readIncompatibilityCheckResults(int[] index) {
        VarBindList vbl = new VarBindList(CHECK_VARS.length);
        for (int i = 0; i < CHECK_VARS.length; ++i) {
            int[] oid = State12.getOids(CHECK_VARS[i]);
            vbl.add(new SnmpVarBind(new SnmpOID(oid, index)));
        }
        try {
            this.setAction(READ_INCOMPAT_ACTION);
            this.setStatus("");
            this._NOOP = true;
            this.getLogger().debug((Object)(this.getSwName() + ", readIncompatibilityCheckResults sending pdu...  _NOOP = " + this._NOOP + "  with tiemout " + this.getSwitch().getPeer().getTimeout() + " * 4"));
            new SnmpFetch(this.getLogger()).getBulk(this.getSwitch().getPeer(), vbl, this, 0, this.getSwitch().getPeer().getTimeout() * 4);
            this.sentSnmpReq(false);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    void readIncompatiblityCheckResultsCb(VarBindList vbl) {
        for (int i = 0; i < vbl.size(); ++i) {
            String feature = vbl.stringValue(i++);
            String cap = vbl.stringValue(i++);
            String type = State12.getEnum("ciscoImgChkCapabilityReq", vbl.intValue(i++));
            String descr = vbl.stringValue(i);
            this._incompatData.addElement(new Object[]{feature, cap, type, descr});
        }
    }

    void readMiscInfoTable() {
        VarBindList vbl = new VarBindList(MISC_VARS.length);
        for (int i = 0; i < MISC_VARS.length; ++i) {
            vbl.add(new SnmpVarBind(new SnmpOID(State12.getOids(MISC_VARS[i]))));
        }
        try {
            this._miscInfoData.clear();
            this.getLogger().debug((Object)(this.getSwName() + ", readMiscInfoTable sending pdu..."));
            new SnmpFetch(this.getLogger()).getBulk(this.getSwitch().getPeer(), vbl, this, 0);
            this.sentSnmpReq(false);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    void readMiscInfoTableCb(VarBindList vbl) {
        for (int i = 0; i < vbl.size(); ++i) {
            int module = State12.moduleToSlot(vbl.intValue(i++));
            String descr = vbl.stringValue(i);
            Object[] row = new Object[]{new Integer(module), descr};
            this.getLogger().debug((Object)(this.getSwName() + ", readMiscInfoTableCb log to _miscInfoData: " + row));
            this._miscInfoData.addElement(row);
        }
    }

    void pollUpgradeOpStatus() {
        SnmpPDU pdu = null;
        if (this.getObj1() != null && this.getObj1() instanceof SnmpPDU) {
            pdu = (SnmpPDU)this.getObj1();
        } else if (this.getObj2() != null) {
            pdu = (SnmpPDU)this.getObj2();
        }
        try {
            this.setStatus("InProgress Polling ");
            pdu.setReqid(0);
            pdu.setTimeout(2000);
            pdu.setRetries(0);
            this.getLogger().debug((Object)(this.getSwName() + ", pollUpgradeOpStatus sending pdu..."));
            this.getSwitch().getPeer().send(pdu, this);
            this.sentSnmpReq(true);
        }
        catch (Exception ex) {
            this.getLogger().debug((Object)(this.getSwName() + ", State12 pollUpgradeOpStatus ex=" + ex.getMessage()));
        }
    }

    /*
     * Unable to fully structure code
     */
    void pollUpgradeOpStatusCb(VarBindList vbl) {
        if (vbl.isNull(0)) {
            this.setStatus("InProgress polling - no status available");
            this._nextState = 0;
            this._state = 312;
            this.setObj1(null);
            this.getLogger().error((Object)(this.getSwName() + ", pollUpgradeOpStatusCb vbl.isNull(0), _nextState = 0, vbl = " + vbl));
            return;
        }
        status = vbl.intValue(0);
        msg = State12.getEnum("ciuUpgradeOpStatus", status);
        if (status != 1) {
            this._pardise_restart_polling_count = 0;
        }
        switch (status) {
            case 2: {
                this.err(msg);
                break;
            }
            case 3: {
                this.err(vbl.stringValue(1));
                if (this._moreStatus == null) break;
                for (i = 0; i < State12.STATUS_COLS.length; ++i) {
                    this.getLogger().error((Object)(this.getSwName() + "ciuUpgradeOpstatus failure, status: " + State12.STATUS_COLS[i] + " "));
                }
                this.getLogger().error((Object)"");
                for (i = 0; i < this._moreStatus.size(); ++i) {
                    row = (Object[])this._moreStatus.elementAt(i);
                    for (j = 0; j < row.length; ++j) {
                        this.getLogger().error((Object)(this.getSwName() + "ciuUpgradeOpStatus failure, moreStatus: " + row[j] + " "));
                    }
                    this.getLogger().error((Object)"");
                }
                break;
            }
            case 7: {
                this.setObj2(null);
            }
            case 1: {
                v0 = is9124Family = this.getSwitch().getModelType() == 587 || this.getSwitch().getModelType() == 651 || this.getSwitch().getModelType() == 616 || this.getSwitch().getModelType() == 601 || this.getSwitch().getModelType() == 606 || this.getSwitch().getModelType() == 773 || this.getSwitch().getModelType() == 843 || this.getSwitch().getModelType() == 841;
                if (!is9124Family || !this._NOOP4NONE) ** GOTO lbl65
                ++this._pardise_restart_polling_count;
                if (this._pardise_restart_polling_count < 80) {
                    this.getLogger().debug((Object)(this.getSwName() + ",   !!  9124, ignore upgradeOpstate NONE (count " + this._pardise_restart_polling_count + "), check lastCommand/Status/Reason"));
                    if (vbl.getVb(2).getVar().getType() == 5 || vbl.intValue(2) == 1 || vbl.getVb(3).getVar().getType() == 5 || vbl.getVb(4).getVar().getType() == 5) break;
                    lastStatus = this.lastOpStatusCb(vbl);
                    this.getLogger().debug((Object)(this.getSwName() + ", !!  9124, ciuUpgradeOpCommand NONE, use lastCmd/Status: " + vbl.intValue(2) + "/" + vbl.intValue(3) + "/" + vbl.stringValue(4)));
                    if (!lastStatus.getResult()) {
                        this.getLogger().debug((Object)(this.getSwName() + ", !!  9124, ciuUpgradeOpCommand NONE, use lastCmd/Status - faled"));
                        this.err(lastStatus.getMessage());
                        break;
                    }
                    this.getLogger().debug((Object)(this.getSwName() + ", !!  9124, ciuUpgradeOpCommand NONE, use lastCmd/Status - success"));
                    msg = lastStatus.getMessage();
                    this.genericSwitchCb(vbl, 5);
                } else {
                    this.getLogger().debug((Object)(this.getSwName() + ",  !!  9124, ciuUpgradeOpCommand NONE polling timeout  (cout " + this._pardise_restart_polling_count + "), check if lastCommand/Status from varbinds 2/3 applied..."));
                    if (vbl.getVb(2).getVar().getType() != 5 && vbl.getVb(3).getVar().getType() != 5) {
                        lastStatus = this.lastOpStatusCb(vbl);
                        this.getLogger().debug((Object)(this.getSwName() + ", !!  9124, ciuUpgradeOpCommand NONE polling timeout, check lastCmd/Status: " + vbl.intValue(2) + "/" + vbl.intValue(3)));
                        if (!lastStatus.getResult()) {
                            this.getLogger().debug((Object)(this.getSwName() + ", !!  9124, ciuUpgradeOpCommand NONE polling timeout, check lastCmd/Status - faled"));
                            this.err(lastStatus.getMessage());
                            break;
                        }
                        this.getLogger().debug((Object)(this.getSwName() + ", !!  9124, ciuUpgradeOpCommand NONE polling timeout, check lastCmd/Status - success"));
                        msg = lastStatus.getMessage();
                        this.genericSwitchCb(vbl, 5);
                    } else {
                        this.getLogger().debug((Object)(this.getSwName() + ", !!  9124, ciuUpgradeOpCommand NONE polling timeout, failed"));
                        this.err(" polling timed out");
                        break;
lbl65:
                        // 1 sources

                        this.getLogger().debug((Object)(this.getSwName() + ", ciuUpgradeOpCommand NONE : success"));
                        msg = "Success";
                    }
                }
                this._NOOP4NONE = false;
            }
            case 5: 
            case 9: {
                this.setObj1(null);
                this.getLogger().debug((Object)(this.getSwName() + ", setting _obj1 null, _obj1=" + this.getObj1()));
                this.setStatus(msg);
                this.genericSwitchCb(vbl, 5);
                break;
            }
            default: {
                this.setStatus(msg);
            }
        }
    }

    LastUpStatus lastOpStatusCb(VarBindList vbl) {
        this.getLogger().debug((Object)(this.getSwName() + ", lastOpStatusCb....  check varbind vbl.intValue(2) and vbl.intValue(3) and vbl.StringValue(4) if available"));
        int lastCommand = vbl.intValue(2);
        int lastUpgradeStatus = vbl.intValue(3);
        String lastUpgradeReason = vbl.getVb(4).getVar().getType() != 5 ? vbl.stringValue(4) : "";
        this.getLogger().debug((Object)(this.getSwName() + ", lastOpStatusCb, check lastCmd/Status/Reason: " + lastCommand + "/" + lastUpgradeStatus + "/" + lastUpgradeReason));
        if (lastCommand != 3) {
            return new LastUpStatus(false, State12.getEnum("ciuUpgradeOpLastStatus", lastUpgradeStatus));
        }
        switch (lastUpgradeStatus) {
            case 1: {
                return new LastUpStatus(false, "(last status none " + lastUpgradeReason + ")");
            }
            case 4: {
                return new LastUpStatus(false, "(last status InProgress " + lastUpgradeReason + ")");
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                return new LastUpStatus(false, "(last status " + State12.getEnum("ciuUpgradeOpLastStatus", lastUpgradeStatus) + " " + lastUpgradeReason + ")");
            }
            case 5: 
            case 7: 
            case 9: {
                return new LastUpStatus(true, State12.getEnum("ciuUpgradeOpLastStatus", lastUpgradeStatus));
            }
        }
        return new LastUpStatus(false, "(last status " + State12.getEnum("ciuUpgradeOpLastStatus", lastUpgradeStatus) + " " + lastUpgradeReason + ")");
    }

    boolean done11UpgradeStatus() {
        return this.getObj1() == null;
    }

    void check11UpgradeStatus() {
        VarBindList vbl = new VarBindList(3);
        vbl.add(new SnmpVarBind(new SnmpOID(_upStatusOid)));
        vbl.add(new SnmpVarBind(new SnmpOID(State12.getOids("cseUpgradeOpTimeCompleted"))));
        vbl.add(new SnmpVarBind(new SnmpOID(State12.getOids("cseUpgradeOpInfo"))));
        this.setStatus(CHECK11_STATUS);
        try {
            this.getLogger().debug((Object)(this.getSwName() + ", check11UpgradeStatus sending pdu..."));
            new SnmpFetch(this.getLogger()).getBulk(this.getSwitch().getPeer(), vbl, this, 0);
            this.sentSnmpReq(false);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    void check11UpgradeStatusCb(VarBindList vbl) {
        if (vbl.isNull(0)) {
            return;
        }
        for (int i = 0; i < vbl.size(); ++i) {
            long opCompletedTime;
            SnmpVarBind vb = vbl.getVb(i++);
            if ((opCompletedTime = (long)vbl.intValue(i++)) > 0L) continue;
            int[] oids = vb.getOid().getValue();
            int[] index = new int[]{oids[oids.length - 1]};
            this._up.changeSwitchState11(this._sw, this._action, this._status, index);
            return;
        }
    }

    void check10UpgradeStatus() {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        pdu.setLogger(this.getLogger());
        this.buildGenericSwitch(pdu);
        try {
            this.setStatus(CHECK10_STATUS);
            this.getLogger().debug((Object)(this.getSwName() + ", check10UpgradeStatus sending pdu..."));
            this.getSwitch().getPeer().send(pdu, this);
            this.sentSnmpReq(false);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    void readUpgradeStatus() {
        VarBindList vbl = new VarBindList(STATUS_VARS.length);
        for (int i = 0; i < STATUS_VARS.length; ++i) {
            vbl.add(new SnmpVarBind(State12.getOid(STATUS_VARS[i])));
        }
        try {
            this.getLogger().debug((Object)(this.getSwName() + ", readUpgradeStatus sending pdu..."));
            new SnmpFetch(this.getLogger()).getBulk(this.getSwitch().getPeer(), vbl, this, 0);
            this.sentSnmpReq(true);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    void readUpgradeStatusCb(VarBindList vbl) {
        if (vbl.size() == 0) {
            return;
        }
        Array<Object[]> data = new Array<Object[]>();
        int len = STATUS_VARS.length;
        Object[] row = new Object[len];
        int oper = 0;
        for (int i = 0; i < vbl.size(); ++i) {
            Comparable<Integer> val;
            if (i % len == 0 || i % len == 4) {
                val = State12.getEnum(STATUS_VARS[i % len], vbl.intValue(i));
                if (i % len == 0) {
                    oper = vbl.intValue(i);
                }
            } else {
                val = i % len == 1 ? new Integer(State12.moduleToSlot(vbl.intValue(i))) : vbl.getVb(i).getVar();
            }
            row[i % len] = val;
            if (i % len != len - 1) continue;
            switch (oper) {
                case 3: 
                case 15: 
                case 34: {
                    row[1] = "n/a";
                    break;
                }
                case 4: {
                    row[1] = "n/a";
                    break;
                }
                case 6: {
                    row[3] = "n/a";
                    break;
                }
                case 13: 
                case 16: 
                case 17: {
                    row[4] = "n/a";
                    row[5] = "n/a";
                }
                case 7: 
                case 14: 
                case 22: {
                    row[1] = "n/a";
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    row[2] = "n/a";
                    row[3] = "n/a";
                    break;
                }
                case 18: 
                case 19: 
                case 20: {
                    row[6] = row[2];
                    row[1] = "n/a";
                    row[2] = "n/a";
                    row[3] = "n/a";
                    row[4] = "n/a";
                    row[5] = "n/a";
                    break;
                }
                case 21: {
                    row[1] = "n/a";
                    row[3] = "n/a";
                    row[4] = "n/a";
                    row[5] = "n/a";
                    break;
                }
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    row[1] = "n/a";
                    row[3] = "n/a";
                }
            }
            if (row[5].toString().equals("-1")) {
                row[5] = "n/a";
            }
            data.addElement(row);
            String info = row[2].toString().toLowerCase().trim();
            if (this._abortable && info.indexOf(this._up.NOLONGER_ABORT) != -1) {
                this.getLogger().debug((Object)(this.getSwName() + ", found NOLONGER_ABORT"));
                this._abortable = false;
            }
            if (i == vbl.size() - 1 && this._state == 311) {
                String actMsg = UP_ACTION;
                String mod = row[1].toString();
                switch (oper) {
                    case 10: {
                        if (vbl.size() == len) {
                            actMsg = actMsg + "(switchover in progress)";
                            break;
                        }
                        actMsg = actMsg + "(rebooting standby)";
                        break;
                    }
                    case 11: {
                        actMsg = actMsg + "(hitless LC upgrade " + mod + ")";
                        break;
                    }
                    case 12: {
                        actMsg = actMsg + "(hitful LC upgrade " + mod + ")";
                    }
                }
                this.setAction(actMsg);
            }
            row = new Object[len];
        }
        if (data.size() > 0) {
            this._moreStatus = data;
        }
    }

    void cleanup() {
        if (this._state < 304 || this._state > 314) {
            return;
        }
        try {
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
            pdu.setLogger(this.getLogger());
            pdu.setIgnoreSetCount(true);
            ImageSpec spec = this._up.getImage(this._sw, this.getSwitch());
            if (spec == null) {
                this.getLogger().warn((Object)"State12 cleanup getImage, spec null, ignore clean up Image entry");
                return;
            }
            String[] vars = spec.getVars();
            String[] vals = spec.getVals();
            for (int i = 0; i < vars.length; ++i) {
                if (vals[i] == null || vals[i].length() == 0) continue;
                int[] index = State12.varNameToIndex(vars[i]);
                pdu.addVar(new SnmpOID(_imageRowStatusOid, index), new SnmpInt(6));
            }
            this.getLogger().debug((Object)(this.getSwName() + ", cleanup sending pdu..."));
            this.getSwitch().getPeer().send(pdu, DUMMY_CB);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    boolean abortOccurred() {
        return this.abortOccurred(true);
    }

    boolean abortOccurred(boolean isReset) {
        boolean retCode;
        this.getLogger().debug((Object)(this.getSwName() + ", State 12 abortOccurred() _abortState/_state = " + this._abortState + "/" + this._state));
        boolean bl = isReset ? false : (retCode = this._abortState == 1);
        if (this._abortState == 1) {
            this.setAction(ABORT_ACTION);
            this.setStatus("");
            if (this._errMsg != null) {
                this._errMsg = "aborted (" + this._errMsg + ")";
            }
            this._errMsg = "aborted";
            this.setStatus(this._errMsg);
            this._state = this._state >= 304 && this._state < 314 ? 315 : 314;
        }
        return retCode;
    }

    @Override
    void genericSwitchCb(VarBindList vbl, int start) {
        int activeUnit = vbl.intValue(start);
        int activeState = vbl.intValue(start + 1);
        int peerUnit = vbl.intValue(start + 2);
        if (activeUnit != 0 && activeState == 14) {
            String activeVer = "";
            String standbyVer = "";
            for (int i = 4; i < vbl.size() - start; ++i) {
                SnmpVarBind vb = vbl.getVb(start + i);
                int[] oids = vb.getOid().getValue();
                if (oids[oids.length - 1] == activeUnit) {
                    activeVer = vbl.stringValue(start + i);
                    continue;
                }
                if (peerUnit == 0) continue;
                standbyVer = vbl.stringValue(start + i);
            }
            String verStr = activeVer;
            if (standbyVer != null && standbyVer.length() != 0) {
                verStr = verStr + " [standby " + standbyVer + "]";
            }
            if (this._errMsg == null) {
                String msg = this.getStatus();
                if (msg.indexOf("Reset") != -1) {
                    this.setStatus(SUCCESS_RESET_STATUS + verStr);
                } else {
                    this.setStatus("Success " + verStr);
                }
            }
            this.setObj1(null);
        } else {
            this.setStatus(this.getStatus());
            this.getLogger().error((Object)(this.getSwName() + ", Install can't obtain version, activeUnit " + activeUnit + " state " + activeState));
        }
    }

    class LastUpStatus {
        boolean _isSuccess;
        String _message;

        LastUpStatus(boolean isSuccess, String message) {
            this._isSuccess = isSuccess;
            this._message = message;
        }

        boolean getResult() {
            return this._isSuccess;
        }

        String getMessage() {
            return this._message;
        }
    }

    class VersionDialog
    implements ActionListener {
        JOptionPane _pane;
        JDialog _dlg;
        Timer _vTimer;
        int _timeLeft;
        boolean _timedOut;
        boolean _answer;
        JLabel _label;
        int _waitTime;
        boolean _bootable;

        VersionDialog(String title, JLabel label, JPanel panel, boolean bootable) {
            this._label = label;
            this._pane = bootable ? new JOptionPane(panel, 3, 0) : new JOptionPane(panel, 1);
            this._dlg = this._pane.createDialog(State12.this._up._parent, title);
            this._dlg.setModal(true);
            this._dlg.setResizable(true);
            this._waitTime = State12.this.getSwitch().isVersionGreaterThanEqual("3.2(2)") ? 15 : 3;
            this._bootable = bootable;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this._timeLeft -= 3;
            if (this._timeLeft <= 0) {
                this._dlg.dispose();
                this._timedOut = true;
            } else {
                this._label.setText("Please respond within " + this._waitTime + " minutes. " + "Time left " + this._timeLeft + " seconds");
            }
        }

        void show() {
            Object value;
            this._timeLeft = State12.this.getSwitch().isVersionGreaterThanEqual("3.2(2)") ? 900 : 150;
            this._vTimer = new Timer(3000, this);
            this._vTimer.start();
            this._dlg.setVisible(true);
            if (!this._timedOut && (value = this._pane.getValue()) != null && value instanceof Integer) {
                this._answer = (Integer)value == 0;
            }
        }

        boolean getAnswer() {
            return this._bootable ? this._answer : false;
        }

        boolean timedOut() {
            return this._timedOut;
        }
    }
}

