/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.upgrade.u3_0_3;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.ImageSpec;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.Upgrade;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.UpgradeWizard;
import com.cisco.dcbu.sm.common.model.Card;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

abstract class UpgradePanel
extends WizardPanel {
    static final ImageIcon ICON = Util.loadIcon("icons/software.gif");
    JFrame _parent;
    Upgrade _upgrade;
    static SwitchVersion CUT_OFF_VER = new SwitchVersion("1.2(1)");

    UpgradePanel(String title, String desc, JFrame parent, UpgradeWizard wiz, Upgrade upgrade) {
        super(title, desc, wiz, ICON);
        this._parent = parent;
        this._upgrade = upgrade;
    }

    @Override
    public void dispose() {
        this._upgrade = null;
    }

    void show(String panel) {
        this.getWizard().show(panel);
    }

    void showSwitchPanel() {
        this.show("switchPanel");
    }

    void showImagePanel() {
        this.show("imagePanel");
    }

    void showBootVarPanel() {
        this.show("bootVarPanel");
    }

    void showFlashFilePanel() {
        this.show("flashFilePanel");
    }

    void showAttrPanel() {
        this.show("attrPanel");
    }

    void showFinalPanel() {
        this.show("finalPanel");
    }

    void error(String msg) {
        Util.errorMessage((Component)this._parent, msg);
    }

    void error(Exception ex) {
        Util.errorMessage((Component)this._parent, ex);
    }

    void info(String msg) {
        this.info(msg, false);
    }

    void info(String msg, boolean scrollPane) {
        if (scrollPane) {
            MessageScrollPaneDlg dlg = new MessageScrollPaneDlg(msg);
            dlg.setVisible(true);
        } else {
            Util.infoMessage(this._parent, msg, false);
        }
    }

    protected SnmpKTable buildTable(String[] cols, boolean[] attrs, Array data) {
        SnmpTableModel model = this.buildTableModel();
        model.setData(data);
        model.setHeaders(cols);
        if (attrs != null) {
            model.setEditable(attrs);
        }
        SnmpKTable table = this.createTable(model);
        table.getTableHeader().addMouseListener(new HeaderListener());
        table.setSortable(true);
        table.addPopupMenu();
        return table;
    }

    protected SnmpKTable buildTable(String[] cols, boolean[] attrs, Array data, boolean sortStatus) {
        SnmpTableModel model = this.buildTableModel();
        model.setData(data);
        model.setHeaders(cols);
        if (attrs != null) {
            model.setEditable(attrs);
        }
        SnmpKTable table = this.createTable(model);
        if (sortStatus) {
            table.getTableHeader().addMouseListener(new HeaderListener());
        }
        table.setSortable(sortStatus);
        table.addPopupMenu();
        return table;
    }

    protected SnmpTableModel buildTableModel() {
        return new SnmpTableModel();
    }

    protected SnmpKTable buildMibTable(String[] vars) {
        SnmpTableModel model = this.buildTableModel();
        model.build(vars, new String[0], 0);
        SnmpKTable table = this.createTable(model);
        table.getTableHeader().addMouseListener(new HeaderListener());
        table.setSortable(true);
        table.addPopupMenu();
        return table;
    }

    protected SnmpKTable createTable(SnmpTableModel model) {
        return new SnmpKTable(model);
    }

    static SnmpTableModel getModel(SnmpKTable table) {
        return (SnmpTableModel)table.getModel();
    }

    static Array getData(SnmpKTable table) {
        return UpgradePanel.getModel(table).getData();
    }

    void setSwitches(Switch[] sws) {
        this._upgrade.setSwitches(sws);
    }

    boolean isLocal() {
        return this._upgrade.isLocal();
    }

    void setLocal(boolean local) {
        this._upgrade.setLocal(local);
    }

    void setImages(ImageSpec[] specs) {
        this._upgrade.setImages(specs);
    }

    void setBootVars(ImageSpec[] specs) {
        this._upgrade.setBootVars(specs);
    }

    void setIgnoreVersion(boolean b) {
        this._upgrade.setIgnoreVersion(b);
    }

    void setIgnoreInstall(boolean b) {
        this._upgrade.setIgnoreInstall(b);
    }

    void setCopyImageOnly(boolean b) {
        this._upgrade.setCopyImageOnly(b);
    }

    void setParallelInstall(boolean b) {
        this._upgrade.setParallelInstall(b);
    }

    Switch[] getSwitches() {
        return this._upgrade.getSwitches();
    }

    ImageSpec[] getImages() {
        return this._upgrade.getImages();
    }

    boolean getIgnoreVersion() {
        return this._upgrade.getIgnoreVersion();
    }

    boolean skipImageDownload() {
        return this._upgrade.skipDownload();
    }

    static boolean isOlderThan12(Switch sw) {
        return new SwitchVersion(sw.getVersion()).lessThan(CUT_OFF_VER);
    }

    static boolean isActiveSup2(Switch sw) {
        int active;
        int standby = active = sw.getActiveSupSlot();
        Card[] cards = sw.getCards();
        if (cards != null) {
            for (int i = 0; i < cards.length; ++i) {
                if (cards[i] == null || cards[i].getSlotId() == active || cards[i].getIfType() != 5) continue;
                standby = cards[i].getSlotId();
                break;
            }
        }
        return active > standby;
    }

    static String getStandbyVersion(Switch sw) {
        int active = sw.getActiveSupSlot();
        Card[] cards = sw.getCards();
        if (cards != null) {
            for (int i = 0; i < cards.length; ++i) {
                if (cards[i] == null || cards[i].getSlotId() == active || cards[i].getIfType() != 5) continue;
                return cards[i].getSoftwareRevision();
            }
        }
        return null;
    }

    static boolean sameImage(String model1, String model2) {
        return model1.equals(model2);
    }

    static String getBareModel(Switch sw) {
        return sw.getSwImgModel();
    }

    String[] getBootVars(Switch sw) {
        String[] OLD_VALS = new String[]{"system", "kickstart", "asm-sfn", "ssi"};
        return OLD_VALS;
    }

    void setAllowedAddRemoveColumn(SnmpKTable table, boolean allow) {
        MouseListener[] listeners = table.getTableHeader().getMouseListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof HeaderListener)) continue;
            ((HeaderListener)listeners[i]).setAllowAddRemoveColumn(allow);
        }
    }

    class MessageScrollPaneDlg
    extends JDialog
    implements ActionListener {
        public MessageScrollPaneDlg(String message) {
            super(UpgradePanel.this._parent);
            JTextArea content = new JTextArea(message);
            content.setEditable(false);
            String title = null;
            Window w = (Window)SwingUtilities.getRoot(UpgradePanel.this._parent);
            if (w != null) {
                if (w instanceof JFrame) {
                    title = ((JFrame)w).getTitle();
                } else if (w instanceof JDialog) {
                    title = ((JDialog)w).getTitle();
                }
            }
            this.setTitle(title);
            JScrollPane sp = new JScrollPane(content);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add("Center", sp);
            String[] btns = new String[]{"Close"};
            DialogUtil.buildDialog((JDialog)this, (Container)UpgradePanel.this._parent, (Container)panel, (AbstractButton[])DialogUtil.buildButtons(btns, (ActionListener)this));
            this.setDefaultCloseOperation(2);
            this.setResizable(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = ((JButton)e.getSource()).getText();
            try {
                switch (cmd.charAt(0)) {
                    case 'C': {
                        this.dispose();
                        break;
                    }
                    default: {
                        this.dispose();
                        break;
                    }
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)BrowserFrame.getDataView(), ex);
            }
        }
    }
}

