/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.wizardTask;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class TextAreaRenderer
extends JTextArea
implements TableCellRenderer {
    private final DefaultTableCellRenderer adaptee = new DefaultTableCellRenderer();
    private static Border NonFocusBorder = new EmptyBorder(1, 2, 1, 2);

    public static int estimateRowHeight(String str, int columns) {
        TextAreaRenderer r = new TextAreaRenderer();
        r.setColumns(columns);
        r.setText(str);
        int lines = Math.max(str.length() / columns + 1, r.getLineCount());
        int fontH = r.getFontMetrics(r.getFont()).getHeight();
        int rowHeight = lines * fontH;
        return rowHeight;
    }

    public TextAreaRenderer() {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setBorder(NonFocusBorder);
        this.setEditable(false);
        this.setOpaque(true);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.adaptee.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
        this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        this.setEditable(false);
        this.setBorder(this.adaptee.getBorder());
        this.setFont(this.adaptee.getFont());
        this.setValue(value);
        this.setSize(table.getColumnModel().getColumn(column).getWidth(), this.getPreferredSize().height);
        if (table.getRowHeight(row) != this.getPreferredSize().height) {
            table.setRowHeight(row, this.getPreferredSize().height);
        }
        return this;
    }

    protected void setValue(Object value) {
        this.setText(value == null ? "" : String.valueOf(value));
    }
}

