/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.common;

import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.UIManager;

public class SaveZnConfigPnl
extends JPanel
implements ActionListener,
ItemListener,
FocusListener {
    RadioButtonPanel serverLoc;
    RadioButtonPanel remoteProto;
    RadioButtonPanel action;
    JLabel[] remoteLabels;
    KTextField server;
    KTextField user;
    FieldPanel fileName;
    JPasswordField pass;
    JButton fileEllipsis;
    int vsanId;
    String remoteSrvrAddress;
    private Switch _sw;
    public static final int USE_TFTP = 0;
    public static final int USE_SFTP = 1;
    public static final int USE_SCP = 2;
    public static final int USE_FTP = 3;
    public static final int LOCAL_SERVER = 0;
    public static final int REMOTE_SERVER = 1;
    static final String[] LOCS = new String[]{"TFTP", "SFTP", "SCP", "FTP"};
    static final String[] IMGLOCS = new String[]{"Local", "Remote"};
    static final String[] ACTION = new String[]{"Backup", "Restore"};

    public SaveZnConfigPnl(Switch sw, int vsan, boolean restoreConfig) {
        this.buildSaveConfigPnl(sw, vsan, restoreConfig);
    }

    private void buildSaveConfigPnl(Switch sw, int vId, boolean restoreConfig) {
        this._sw = sw;
        this.vsanId = vId;
        this.remoteLabels = DialogUtil.buildLabels(new String[]{"Zone Configuration", "Server Location: ", null, "Using:", "Server IP Address:", "UserName:", "Password:", "File Name (Root Path):"});
        this.remoteLabels[0].setVisible(false);
        this.action = new RadioButtonPanel(ACTION, ACTION.length, this);
        this.action.setSelected(restoreConfig ? 1 : 0);
        this.action.setVisible(false);
        this.serverLoc = new RadioButtonPanel(IMGLOCS, IMGLOCS.length, this);
        this.remoteProto = new RadioButtonPanel(LOCS, LOCS.length, this);
        this.server = new KTextField(20);
        this.user = new KTextField(20);
        this.fileEllipsis = new JButton("...");
        this.fileEllipsis.setToolTipText("Select End Device");
        this.fileEllipsis.setActionCommand("EndPorts");
        this.fileEllipsis.setMargin(Util.getNoBorder());
        this.fileEllipsis.addActionListener(this);
        this.fileName = new FieldPanel(20, (JComponent)this.fileEllipsis);
        this.pass = new JPasswordField(20);
        this.remoteProto.setSelected(0);
        this.serverLoc.setSelected(1);
        this.serverLoc.addChangeListener(this);
        this.server.addFocusListener(this);
        this.add((Component)DialogUtil.buildPanel(this.remoteLabels, new JComponent[]{this.action, this.serverLoc, new DialogSeparator("Remote Options"), this.remoteProto, this.server, this.user, this.pass, this.fileName}), "Center");
        try {
            this.remoteSrvrAddress = ClientController.getInstance().assertSession().getServerProperty("server.FileServerAddress");
        }
        catch (Exception exx) {
            // empty catch block
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        String userTypedText;
        if (this.serverLoc.getSelected() == 1 && (userTypedText = this.server.getText()).trim().length() > 0 && !userTypedText.trim().equals("0.0.0.0")) {
            this.remoteSrvrAddress = userTypedText.trim();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String fName;
        if (e.getSource() == this.fileEllipsis && (fName = Util.getFileName(Util.getFrameAncestor(this), this.vsanId == 0 ? "Backup All VSAN Zones" : (this.vsanId != -1 ? "Backup " + this.vsanId + " Zones" : "Backup IVR Zones"), this._sw + (this._sw.isQuail() ? "_9020_" : "_") + (this.vsanId == 0 ? "" : (this.vsanId != -1 ? "VSAN" + this.vsanId + "_" : "ivr_")) + "zones_cfg.txt", this.action != null && this.action.getSelected() == 0 ? 1 : 0, ClientCache.getLocation(), true)) != null && fName.trim().length() > 0) {
            this.fileName.setText(fName);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        if (e.getSource() == this.action.getComponent(0) || e.getSource() == this.action.getComponent(1)) {
            this.actionChanged(this.action.getSelected() == 0 ? ACTION[0].charAt(0) : ACTION[1].charAt(0));
        } else {
            if (e.getSource() == this.serverLoc.getComponent(0)) {
                this.fileEllipsis.setVisible(true);
                this.remoteProto.setSelected(0);
            } else if (e.getSource() == this.serverLoc.getComponent(1)) {
                this.fileEllipsis.setVisible(false);
            }
            boolean remote = this.serverLoc.getSelected() == 1;
            this.remoteProto.setEnabled(remote);
            this.user.setEnabled(remote);
            this.pass.setEnabled(remote);
            for (int i = 3; i < this.remoteLabels.length - 1; ++i) {
                if (this.remoteLabels[i] == null) continue;
                this.remoteLabels[i].setEnabled(remote);
            }
            int proto = this.remoteProto.getSelected();
            if (remote) {
                this.user.setEnabled(proto > 0);
                this.pass.setEnabled(proto > 0);
            }
            this.user.setBackground(remote && proto > 0 ? UIManager.getColor("TextField.background") : UIManager.getColor("Label.background"));
            if (this.remoteProto.isEnabled()) {
                this.remoteLabels[5].setEnabled(proto > 0);
                this.remoteLabels[6].setEnabled(proto > 0);
            }
            if (!remote) {
                this.server.setText("");
                try {
                    String localTftpServerAddr = NetUtil.detectSourceAddress(this._sw.getSnmpPeer().getAddress()).getHostAddress();
                    this.server.setText(localTftpServerAddr);
                }
                catch (Exception ex) {}
            } else {
                this.server.setText(this.remoteSrvrAddress != null ? this.remoteSrvrAddress : "");
            }
        }
    }

    public String getPass() {
        return new String(this.pass.getPassword()).trim();
    }

    public String getServer() {
        return this.server.getText().trim();
    }

    public int getServerLoc() {
        return this.serverLoc.getSelected();
    }

    public String getUser() {
        return this.user.getText().trim();
    }

    public int getRemoteProto() {
        return this.remoteProto.getSelected();
    }

    public String getFileName() {
        return this.fileName.getText().trim();
    }

    protected void actionChanged(char action) {
    }
}

