/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.common;

import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.mds.zm.CommandHandler;
import com.cisco.dcbu.lib.mds.zm.MdsCommandHandler;
import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.mds.zm.VersionPeer;
import com.cisco.dcbu.lib.mds.zm.ZoneCapability;
import com.cisco.dcbu.lib.mds.zm.ZoneMode;
import com.cisco.dcbu.lib.mds.zm.ZoneUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.SmMdsCommandHandler;
import com.cisco.dcbu.sm.client.zm.common.SmQlogicCommandHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class SmZoneUtil
extends ZoneUtil {
    public static final int[] SMART_ZONING_VSAN_OID = MibNode.get("czsszSmartZoningOpStatus").getOid();

    public static SnmpPeer getSwitchPeer(Object obSel, StringBuffer version) throws SnmpException {
        if (obSel instanceof SnmpPeer) {
            if (version != null) {
                Switch sw = ClientController.getInstance().getFabric().findSwitchByIpAddress(((SnmpPeer)obSel).getAddress());
                version.append(sw.getVersion());
            }
            return (SnmpPeer)obSel;
        }
        if (obSel instanceof String) {
            InetAddress inetAdd;
            String strIp = ((String)obSel).trim();
            SnmpIpAddress.parse(strIp);
            try {
                inetAdd = InetAddress.getByName(strIp);
            }
            catch (UnknownHostException ex) {
                throw new SnmpException("Switch " + strIp + " unreachable.");
            }
            SnmpPeer peer = SnmpPeer.findPeer(inetAdd);
            ClientController.getInstance();
            Switch sw = ClientController.findFabricSwitchByIpAddress(inetAdd);
            if (peer == null || sw == null) {
                String vers;
                String verNew;
                int verIndex;
                SnmpPDU resp;
                try {
                    SnmpPeer fabricPeer = ClientController.getInstance().getFabric().getASnmpPeer();
                    if (fabricPeer == null) {
                        throw new SnmpException("No snmp peer for" + strIp);
                    }
                    peer = fabricPeer.clone(inetAdd);
                    SnmpPeer.addPeer(peer);
                    int[] sysObjectIdOid = MibNode.get("sysObjectID").getOid();
                    int[] sysDescOid = new int[]{1, 3, 6, 1, 2, 1, 1, 1, 0};
                    VarBindList vbList = new VarBindList();
                    vbList.add(sysObjectIdOid, 0);
                    if (version != null) {
                        vbList.add(sysDescOid);
                    }
                    resp = SnmpFetch.get(peer, vbList);
                }
                catch (SnmpException ex) {
                    if (null != peer) {
                        SnmpPeer.removePeer(peer);
                    }
                    throw new SnmpException("Switch " + strIp + " unreachable.");
                }
                SnmpVar theVar = resp.getVar(0);
                if (theVar.getType() != 6 || !((SnmpOID)theVar).startsWith(Switch.MDS_OBJECT_ID)) {
                    throw new SnmpException("Switch " + strIp + " is not a Cisco MDS 9000");
                }
                if (version != null && (verIndex = (verNew = resp.getVariables().stringValue(1)).indexOf("Version")) != -1 && (verIndex = (vers = verNew.substring(verIndex + 7)).indexOf(",")) != -1) {
                    version.append(vers.substring(0, verIndex).trim());
                }
            } else if (version != null) {
                version.append(sw.getVersion());
            }
            return peer;
        }
        throw new SnmpException("Invalid switch address:" + obSel + ".");
    }

    public static ArrayList getIvrCapableVersionPeers(Fabric f) {
        ArrayList switches = SmZoneUtil.getIvrCapableSwitchesViaSnmp(f);
        ArrayList<VersionPeer> peers = new ArrayList<VersionPeer>();
        for (int i = 0; i < switches.size(); ++i) {
            Switch sw = (Switch)switches.get(i);
            if (sw.getPeer() == null) continue;
            peers.add(new VersionPeer(sw.getPeer(), new SwitchVersion(sw.getVersion()), sw, sw.getName(), sw.isManageable()));
        }
        Collections.sort(peers);
        return peers;
    }

    public static ArrayList getIvrCapableSwitches(Fabric f) {
        Switch[] sws = f.getSwitches();
        ArrayList<Switch> switches = new ArrayList<Switch>();
        for (int i = 0; i < sws.length; ++i) {
            if (!sws[i].isMDS() || sws[i].isN5K() || !sws[i].isManageable() || sws[i].getPeer() == null || !sws[i].isIvrCapable() || switches.contains(sws[i])) continue;
            switches.add(sws[i]);
        }
        Collections.sort(switches);
        return switches;
    }

    public static ArrayList getIvrCapableSwitchesViaSnmp(Fabric f) {
        Switch[] sws = f.getSwitches();
        ArrayList switches = new ArrayList();
        ArrayList<SnmpPeer> peersLst = new ArrayList<SnmpPeer>();
        HashMap<SnmpPeer, Switch> pr2swMap = new HashMap<SnmpPeer, Switch>();
        for (int i = 0; i < sws.length; ++i) {
            if (!sws[i].isMDS() || sws[i].getPeer() == null) continue;
            peersLst.add(sws[i].getPeer());
            pr2swMap.put(sws[i].getPeer(), sws[i]);
        }
        try {
            VarBindList featr = new VarBindList();
            featr.add(MibNode.get("cfcFeatureCtrlName").getOid(), 1);
            SnmpPDU[] pdus = new SnmpAggregrate().get(peersLst.toArray(new SnmpPeer[peersLst.size()]), featr);
            for (int k = 0; k < pdus.length; ++k) {
                if (pdus[k] == null || pdus[k].getError() != 0 || !pdus[k].getVariables().stringValue(0).equalsIgnoreCase("ivr")) continue;
                switches.add(pr2swMap.get(pdus[k].getPeer()));
            }
        }
        catch (SnmpException ex) {
            // empty catch block
        }
        Collections.sort(switches);
        return switches;
    }

    public static SnmpPeer getSwitchPeer(Switch sw) throws SnmpException {
        if (sw == null) {
            throw new SnmpException("The selected switch is unreachable");
        }
        if (sw.getPeer() == null) {
            throw new SnmpException("The selected switch " + sw + " is unreachable");
        }
        return sw.getPeer();
    }

    public static Switch getSwitch(SnmpPeer peer) {
        ClientController.getInstance();
        return ClientController.findFabricSwitchByIpAddress(peer.getAddress());
    }

    public static ArrayList buildVerPeerLFromSwitchList(ArrayList swList) {
        ArrayList<VersionPeer> verList = new ArrayList<VersionPeer>();
        for (int i = 0; i < swList.size(); ++i) {
            verList.add(SmZoneUtil.buildVersionnPeer((Switch)swList.get(i)));
        }
        return verList;
    }

    public static ArrayList buildSwitchLFromVerPeerList(ArrayList verList) {
        ArrayList<Switch> swList = new ArrayList<Switch>();
        for (int i = 0; i < verList.size(); ++i) {
            ClientController.getInstance();
            swList.add(ClientController.findFabricSwitchByIpAddress(((VersionPeer)verList.get(i)).getSwitchPeer().getAddress()));
        }
        return swList;
    }

    public static ArrayList getIVRCfsLockSw(ArrayList swList, ArrayList cfsEnabledSws, ArrayList cfsDisabledSws) throws SnmpException {
        ArrayList<SnmpPeer> peerLst = new ArrayList<SnmpPeer>();
        ArrayList<Switch> pendingSwitches = new ArrayList<Switch>();
        for (int i = 0; i < swList.size(); ++i) {
            Switch sw = (Switch)swList.get(i);
            if (!sw.isVersionGreaterThanEqual("2.0(0)")) continue;
            peerLst.add(SmZoneUtil.getSwitchPeer(sw));
        }
        ArrayList zoneModeInfo = MdsCommandHandler.getZoneModeInfo(peerLst.toArray(new SnmpPeer[0]), -1);
        if (peerLst.size() > 0 && zoneModeInfo != null) {
            for (int i = 0; i < zoneModeInfo.size(); ++i) {
                Object[] zoneModeOb = (Object[])zoneModeInfo.get(i);
                if (zoneModeOb[2] != null) {
                    throw new SnmpException(zoneModeOb[0] + ": " + SnmpException.toError((Integer)zoneModeOb[2]));
                }
                ZoneMode zMode = (ZoneMode)zoneModeOb[1];
                ClientController.getInstance();
                Switch sw = ClientController.findFabricSwitchByIpAddress((InetAddress)zoneModeOb[0]);
                if (zMode.isCommitPending()) {
                    pendingSwitches.add(sw);
                }
                if (!zMode.isEnhanced()) continue;
                cfsDisabledSws.remove(sw);
                cfsEnabledSws.add(sw);
            }
        }
        return pendingSwitches;
    }

    public static VersionPeer buildVersionnPeer(Switch sw) {
        return new VersionPeer(sw.getPeer(), new SwitchVersion(sw.getVersion()), sw, sw.getName(), sw.isManageable());
    }

    public static CommandHandler getCommandHandler(ZoneCapability cap, Vsan vsan, VersionPeer vPeer, StatusIf statusIf) throws SnmpException {
        if (vPeer.isMds()) {
            return new SmMdsCommandHandler(cap, vsan, vPeer, statusIf);
        }
        if (vPeer.isQuail()) {
            try {
                return new SmQlogicCommandHandler(cap, vsan, vPeer, statusIf);
            }
            catch (IOException ex) {
                throw new SnmpException(ex.getMessage());
            }
        }
        throw new SnmpException("No Command Handler available.");
    }

    public static CommandHandler getCommandHandler(ZoneCapability cap, int vsan, VersionPeer vPeer, StatusIf statusIf) throws SnmpException {
        Vsan vsan2;
        if (vsan == -1) {
            vsan2 = null;
        } else {
            ClientController.getInstance();
            vsan2 = ClientController.findFabricSwitchByIpAddress(vPeer.getSwitchPeer().getAddress()).getVsan((short)vsan);
        }
        Vsan v = vsan2;
        return SmZoneUtil.getCommandHandler(cap, v, vPeer, statusIf);
    }

    public static boolean isSmartZoningActivated(SnmpPeer peer, int vsanId) throws SnmpException {
        VarBindList szList = new VarBindList();
        szList.add(SMART_ZONING_VSAN_OID, new int[]{vsanId});
        VarBindList vList = SnmpFetch.get(peer, szList).getVariables();
        if (vList.byteValue(0) == null) {
            throw new SnmpException("VSAN Smart Zoning status is not available");
        }
        int value = vList.intValue(0);
        return value == 2;
    }

    public static boolean isSmartZoningSupported(Switch sw) {
        if (sw != null) {
            if (!sw.isMDS() || sw.isNuovaFamily()) {
                return false;
            }
            return sw.isVersionGreaterThanEqual("5.2(6)");
        }
        return false;
    }
}

