/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.common;

import com.cisco.dcbu.lib.ui.UITransferHandler;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.ui.table.MultiRowTable;
import com.cisco.dcbu.sm.client.zm.common.DragTableModel;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;

public class ZoneDragTable
extends MultiRowTable
implements DragGestureListener {
    private DragSourceListener _dragListener;
    private boolean _drag = true;
    private UITransferHandler _dndTransferData;

    public ZoneDragTable(KTableModel dataModel, UITransferHandler dndTransferData) {
        super(dataModel);
        this.addPopupMenu();
        this._dndTransferData = dndTransferData;
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        this.setDragEnabled(true);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, this);
    }

    public void enableDrag(boolean b) {
        this._drag = b;
        this.setDragEnabled(b);
    }

    public void setDragListener(DragSourceListener listener) {
        this._dragListener = listener;
    }

    public Object[] getDataTransferObject() {
        return this._dndTransferData.getTransferObject();
    }

    @Override
    public synchronized void dragGestureRecognized(DragGestureEvent e) {
        try {
            int[] rows;
            if (this._drag && this._dndTransferData != null && (rows = this.getSelectedRows()) != null && rows.length > 0) {
                Object[] transfer = new Object[rows.length];
                for (int i = 0; i < rows.length; ++i) {
                    transfer[i] = ((DragTableModel)this.getModel()).getDragObject(rows[i]);
                }
                this._dndTransferData.setTransferObject(transfer, this);
                e.startDrag(DragSource.DefaultCopyDrop, new StringSelection("Rows"), this._dragListener);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

