/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.merge;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.ui.Util;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

class RadioGroupButtonPanel
extends JPanel {
    static final ImageIcon LEFT_ARROW = Util.loadIcon("icons/leftselect.gif");
    static final ImageIcon RIGHT_ARROW = Util.loadIcon("icons/rightselect.gif");
    static final ImageIcon PLUS_ARROW = Util.loadIcon("icons/plus.gif");
    private ButtonGroup _group = new ButtonGroup();
    private String[] _choice = new String[]{"<", "+", ">"};
    private JToggleButton[] _buttons = new JToggleButton[this._choice.length];

    public RadioGroupButtonPanel() {
        try {
            FlowLayout layout = new FlowLayout(1, 0, 0);
            this.setLayout(layout);
            for (int i = 0; i < this._choice.length; ++i) {
                this._buttons[i] = new JToggleButton();
                this._group.add(this._buttons[i]);
                this.add(this._buttons[i]);
            }
            this.normalizePanel();
        }
        catch (Exception ex) {
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public JToggleButton getButton(int i) {
        if (i >= 0 && i < this._buttons.length) {
            return this._buttons[i];
        }
        return null;
    }

    public void normalizePanel() {
        JToggleButton left = this.getButton(0);
        JToggleButton action = this.getButton(1);
        JToggleButton right = this.getButton(2);
        left.setIcon(LEFT_ARROW);
        right.setIcon(RIGHT_ARROW);
        action.setIcon(PLUS_ARROW);
        Dimension d = new Dimension(PLUS_ARROW.getIconWidth(), PLUS_ARROW.getIconHeight());
        left.setPreferredSize(d);
        right.setPreferredSize(d);
        action.setPreferredSize(d);
        Dimension total = new Dimension();
        total.setSize(d.getWidth() * 3.0 + 5.0, d.getHeight() + 5.0);
        this.setPreferredSize(total);
    }
}

